/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubCommit;
import org.jetbrains.plugins.github.api.GithubCommitDetailed;
import org.jetbrains.plugins.github.api.GithubCommitSha;
import org.jetbrains.plugins.github.api.GithubFile;
import org.jetbrains.plugins.github.api.GithubFileRaw;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserRaw;

class GithubCommitRaw
implements DataConstructor {
    public String url;
    public String sha;
    public GithubUserRaw author;
    public GithubUserRaw committer;
    public GitCommitRaw commit;
    public CommitStatsRaw stats;
    public List<GithubFileRaw> files;
    public List<GithubCommitRaw> parents;

    GithubCommitRaw() {
    }

    public GithubCommitSha createCommitSha() {
        return new GithubCommitSha(this.url, this.sha);
    }

    public GithubCommit createCommit() {
        GithubUser author = this.author == null ? null : this.author.createUser();
        GithubUser committer = this.committer == null ? null : this.committer.createUser();
        ArrayList<GithubCommitSha> parents = new ArrayList<GithubCommitSha>();
        for (GithubCommitRaw raw : this.parents) {
            parents.add(raw.createCommitSha());
        }
        return new GithubCommit(this.url, this.sha, author, committer, parents, this.commit.create());
    }

    public GithubCommitDetailed createCommitDetailed() {
        GithubCommit commit = this.createCommit();
        ArrayList<GithubFile> files = new ArrayList<GithubFile>();
        for (GithubFileRaw raw : this.files) {
            files.add(raw.createFile());
        }
        return new GithubCommitDetailed(commit.getUrl(), commit.getSha(), commit.getAuthor(), commit.getCommitter(), commit.getParents(), commit.getCommit(), this.stats.create(), files);
    }

    @Override
    public <T> T create(Class<T> resultClass) {
        if (resultClass == GithubCommitSha.class) {
            return (T)this.createCommitSha();
        }
        if (resultClass == GithubCommit.class) {
            return (T)this.createCommit();
        }
        if (resultClass == GithubCommitDetailed.class) {
            return (T)this.createCommitDetailed();
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class CommitStatsRaw {
        public Integer additions;
        public Integer deletions;
        public Integer total;

        public GithubCommitDetailed.CommitStats create() {
            return new GithubCommitDetailed.CommitStats(this.additions, this.deletions, this.total);
        }
    }

    public static class GitUserRaw {
        public String name;
        public String email;
        public Date date;

        public GithubCommit.GitUser create() {
            return new GithubCommit.GitUser(this.name, this.email, this.date);
        }
    }

    public static class GitCommitRaw {
        public String url;
        public String message;
        public GitUserRaw author;
        public GitUserRaw committer;

        public GithubCommit.GitCommit create() {
            return new GithubCommit.GitCommit(this.message, this.author.create(), this.committer.create());
        }
    }
}

