/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.util.List;
import org.jetbrains.plugins.github.GithubShowCommitInBrowserAction;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShowCommitInBrowserFromLogAction
extends GithubShowCommitInBrowserAction {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = log.getSelectedDetails();
        if (commits.size() != 1) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(((VcsFullCommitDetails)commits.get(0)).getRoot());
        e.getPresentation().setEnabledAndVisible(repository != null && GithubUtil.isRepositoryOnGitHub(repository));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsFullCommitDetails commit = (VcsFullCommitDetails)((VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG)).getSelectedDetails().get(0);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        GithubShowCommitInBrowserFromLogAction.openInBrowser(project, repository, ((Hash)commit.getId()).asString());
    }
}

