// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.keyboard');
goog.require('cljs.core');
goog.require('lt.util.js');
goog.require('lt.objs.app');
goog.require('lt.util.js');
goog.require('lt.objs.context');
goog.require('lt.objs.platform');
goog.require('lt.objs.metrics');
goog.require('lt.objs.context');
goog.require('clojure.string');
goog.require('lt.util.events');
goog.require('lt.objs.command');
goog.require('lt.objs.platform');
goog.require('lt.objs.app');
goog.require('clojure.string');
goog.require('lt.object');
goog.require('lt.object');
goog.require('lt.objs.metrics');
goog.require('lt.objs.command');
goog.require('lt.util.events');
lt.objs.keyboard.capturing_QMARK_ = true;
lt.objs.keyboard.keys = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
lt.objs.keyboard.key_map = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
lt.objs.keyboard.chords = (function (){var obj7146 = {"current":null,"chords":cljs.core.PersistentHashSet.EMPTY};return obj7146;
})();
lt.objs.keyboard.chord_timeout = 1000;
lt.objs.keyboard.activity = (function activity(){return lt.objs.metrics.used_BANG_.call(null);
});
lt.objs.keyboard.chord_variants = (function chord_variants(k){var splits = cljs.core.butlast.call(null,clojure.string.split.call(null,k," "));return cljs.core.reduce.call(null,(function (res,cur){return cljs.core.conj.call(null,res,[cljs.core.str(cljs.core.last.call(null,res)),cljs.core.str(" "),cljs.core.str(cur)].join(''));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,splits)], null),cljs.core.rest.call(null,splits));
});
lt.objs.keyboard.extract_chords = (function extract_chords(ks){return cljs.core.reduce.call(null,(function (chords,p__7149){var vec__7150 = p__7149;var k = cljs.core.nth.call(null,vec__7150,0,null);var _ = cljs.core.nth.call(null,vec__7150,1,null);if(!((k.indexOf(" ") > -1)))
{return chords;
} else
{return cljs.core.apply.call(null,cljs.core.conj,chords,lt.objs.keyboard.chord_variants.call(null,k));
}
}),cljs.core.PersistentHashSet.EMPTY,ks);
});
lt.objs.keyboard.merge_keys = (function merge_keys(ctx){var ctx_set = lt.object.specificity_sort.call(null,ctx,new cljs.core.Keyword(null,"down","down",1016993812));var ks = cljs.core.deref.call(null,lt.objs.keyboard.keys);var neue = cljs.core.apply.call(null,cljs.core.merge,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,ks,ctx_set));lt.objs.keyboard.chords = (function (){var obj7154 = {"current":null,"chords":lt.objs.keyboard.extract_chords.call(null,neue)};return obj7154;
})();
cljs.core.reset_BANG_.call(null,lt.objs.keyboard.key_map,neue);
return lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"app.keys.change","app.keys.change",1612622863));
});
lt.objs.keyboard.refresh = (function refresh(){return lt.objs.keyboard.merge_keys.call(null,lt.objs.context.current.call(null));
});
cljs.core.add_watch.call(null,lt.objs.context.contexts,new cljs.core.Keyword(null,"commands2","commands2",3810146844),(function (_,___$1,___$2,ctx){return lt.objs.keyboard.merge_keys.call(null,ctx);
}));
lt.objs.keyboard.refresh.call(null);
lt.objs.keyboard.__GT_keystr = (function __GT_keystr(key,ev){return [cljs.core.str((cljs.core.truth_(ev.ctrlKey)?"ctrl-":null)),cljs.core.str((cljs.core.truth_(ev.metaKey)?((lt.objs.platform.mac_QMARK_.call(null))?"cmd-":"meta-"):null)),cljs.core.str((cljs.core.truth_(ev.altKey)?"alt-":null)),cljs.core.str((cljs.core.truth_(ev.altGraphKey)?"altgr-":null)),cljs.core.str((cljs.core.truth_(ev.shiftKey)?"shift-":null)),cljs.core.str((function (){var or__3520__auto__ = key;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return "";
}
})().toLowerCase())].join('');
});
lt.objs.keyboard.chord_BAR_mapping = (function chord_BAR_mapping(key,char$,ev){var current = (lt.objs.keyboard.chords["current"]);var cur_chords = (lt.objs.keyboard.chords["chords"]);var vec__7156 = (cljs.core.truth_(current)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(current),cljs.core.str(" "),cljs.core.str(lt.objs.keyboard.__GT_keystr.call(null,key,ev))].join(''),[cljs.core.str(current),cljs.core.str(" "),cljs.core.str(char$)].join('')], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lt.objs.keyboard.__GT_keystr.call(null,key,ev),char$], null));var ks = cljs.core.nth.call(null,vec__7156,0,null);var ch = cljs.core.nth.call(null,vec__7156,1,null);var temp__4090__auto__ = (function (){var or__3520__auto__ = cur_chords.call(null,ch);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cur_chords.call(null,ks);
}
})();if(cljs.core.truth_(temp__4090__auto__))
{var chord = temp__4090__auto__;(lt.objs.keyboard.chords["current"] = chord);
if(cljs.core.truth_(lt.objs.keyboard.chord_timeout))
{lt.util.js.wait.call(null,lt.objs.keyboard.chord_timeout,(function (){return (lt.objs.keyboard.chords["current"] = null);
}));
} else
{}
return cljs.core.PersistentVector.EMPTY;
} else
{(lt.objs.keyboard.chords["current"] = null);
var or__3520__auto__ = cljs.core.deref.call(null,lt.objs.keyboard.key_map).call(null,ch);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{var or__3520__auto____$1 = cljs.core.deref.call(null,lt.objs.keyboard.key_map).call(null,ks);if(cljs.core.truth_(or__3520__auto____$1))
{return or__3520__auto____$1;
} else
{if(cljs.core.truth_(current))
{return cljs.core.PersistentVector.EMPTY;
} else
{return null;
}
}
}
}
});
lt.objs.keyboard._STAR_capture_STAR_ = true;
lt.objs.keyboard._STAR_stop_STAR_ = false;
lt.objs.keyboard.passthrough = (function passthrough(){return lt.objs.keyboard._STAR_capture_STAR_ = false;
});
/**
* Called to prevent commands after the current one from firing
*/
lt.objs.keyboard.stop_commands_BANG_ = (function stop_commands_BANG_(){return lt.objs.keyboard._STAR_stop_STAR_ = true;
});
lt.objs.keyboard.disable = (function disable(){return lt.objs.keyboard.capturing_QMARK_ = false;
});
lt.objs.keyboard.enable = (function enable(){return lt.objs.keyboard.capturing_QMARK_ = true;
});
lt.objs.keyboard.all_mappings = (function all_mappings(key){return cljs.core.reduce.call(null,(function (res,p__7159){var vec__7160 = p__7159;var ctx = cljs.core.nth.call(null,vec__7160,0,null);var keys = cljs.core.nth.call(null,vec__7160,1,null);if(cljs.core.not.call(null,keys.call(null,key)))
{return res;
} else
{return cljs.core.conj.call(null,res,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx,keys.call(null,key)], null));
}
}),cljs.core.PersistentVector.EMPTY,cljs.core.deref.call(null,lt.objs.keyboard.keys));
});
lt.objs.keyboard.trigger = (function trigger(cmd){lt.objs.keyboard.activity.call(null);
if(cljs.core.coll_QMARK_.call(null,cmd))
{cljs.core.apply.call(null,lt.objs.command.exec_BANG_,cmd);
} else
{lt.objs.command.exec_BANG_.call(null,cmd);
}
return lt.objs.keyboard._STAR_capture_STAR_;
});
lt.objs.keyboard.capture = (function capture(key,char$,ev){lt.objs.keyboard.activity.call(null);
var _STAR_capture_STAR_7167 = lt.objs.keyboard._STAR_capture_STAR_;var _STAR_stop_STAR_7168 = lt.objs.keyboard._STAR_stop_STAR_;try{lt.objs.keyboard._STAR_capture_STAR_ = true;
lt.objs.keyboard._STAR_stop_STAR_ = false;
var temp__4092__auto__ = lt.objs.keyboard.chord_BAR_mapping.call(null,key,char$,ev);if(cljs.core.truth_(temp__4092__auto__))
{var cs = temp__4092__auto__;var seq__7169_7173 = cljs.core.seq.call(null,cs);var chunk__7170_7174 = null;var count__7171_7175 = 0;var i__7172_7176 = 0;while(true){
if((i__7172_7176 < count__7171_7175))
{var c_7177 = cljs.core._nth.call(null,chunk__7170_7174,i__7172_7176);if(cljs.core.truth_(lt.objs.keyboard._STAR_stop_STAR_))
{} else
{lt.objs.keyboard._STAR_capture_STAR_ = true;
lt.objs.keyboard.trigger.call(null,c_7177);
}
{
var G__7178 = seq__7169_7173;
var G__7179 = chunk__7170_7174;
var G__7180 = count__7171_7175;
var G__7181 = (i__7172_7176 + 1);
seq__7169_7173 = G__7178;
chunk__7170_7174 = G__7179;
count__7171_7175 = G__7180;
i__7172_7176 = G__7181;
continue;
}
} else
{var temp__4092__auto___7182__$1 = cljs.core.seq.call(null,seq__7169_7173);if(temp__4092__auto___7182__$1)
{var seq__7169_7183__$1 = temp__4092__auto___7182__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__7169_7183__$1))
{var c__4262__auto___7184 = cljs.core.chunk_first.call(null,seq__7169_7183__$1);{
var G__7185 = cljs.core.chunk_rest.call(null,seq__7169_7183__$1);
var G__7186 = c__4262__auto___7184;
var G__7187 = cljs.core.count.call(null,c__4262__auto___7184);
var G__7188 = 0;
seq__7169_7173 = G__7185;
chunk__7170_7174 = G__7186;
count__7171_7175 = G__7187;
i__7172_7176 = G__7188;
continue;
}
} else
{var c_7189 = cljs.core.first.call(null,seq__7169_7183__$1);if(cljs.core.truth_(lt.objs.keyboard._STAR_stop_STAR_))
{} else
{lt.objs.keyboard._STAR_capture_STAR_ = true;
lt.objs.keyboard.trigger.call(null,c_7189);
}
{
var G__7190 = cljs.core.next.call(null,seq__7169_7183__$1);
var G__7191 = null;
var G__7192 = 0;
var G__7193 = 0;
seq__7169_7173 = G__7190;
chunk__7170_7174 = G__7191;
count__7171_7175 = G__7192;
i__7172_7176 = G__7193;
continue;
}
}
} else
{}
}
break;
}
return lt.objs.keyboard._STAR_capture_STAR_;
} else
{return null;
}
}finally {lt.objs.keyboard._STAR_stop_STAR_ = _STAR_stop_STAR_7168;
lt.objs.keyboard._STAR_capture_STAR_ = _STAR_capture_STAR_7167;
}});
lt.objs.keyboard.capture_up = (function capture_up(key,char$,ev){var or__3520__auto__ = cljs.core.deref.call(null,lt.objs.keyboard.key_map).call(null,char$);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.deref.call(null,lt.objs.keyboard.key_map).call(null,lt.objs.keyboard.__GT_keystr.call(null,key,ev));
}
});
lt.objs.keyboard.meta = ((lt.objs.platform.mac_QMARK_.call(null))?"cmd":"ctrl");
lt.objs.keyboard.cmd__GT_bindings = (function cmd__GT_bindings(cmd){return cljs.core.filter.call(null,(function (p1__7194_SHARP_){return cljs.core.seq.call(null,cljs.core.second.call(null,p1__7194_SHARP_));
}),(function (){var iter__4231__auto__ = (function iter__7204(s__7205){return (new cljs.core.LazySeq(null,(function (){var s__7205__$1 = s__7205;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__7205__$1);if(temp__4092__auto__)
{var s__7205__$2 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__7205__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__7205__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__7207 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__7206 = 0;while(true){
if((i__7206 < size__4230__auto__))
{var vec__7210 = cljs.core._nth.call(null,c__4229__auto__,i__7206);var ctx = cljs.core.nth.call(null,vec__7210,0,null);var ms = cljs.core.nth.call(null,vec__7210,1,null);cljs.core.chunk_append.call(null,b__7207,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx,cljs.core.first.call(null,cljs.core.first.call(null,cljs.core.filter.call(null,((function (i__7206,vec__7210,ctx,ms,c__4229__auto__,size__4230__auto__,b__7207,s__7205__$2,temp__4092__auto__){
return (function (p1__7195_SHARP_){return cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.second.call(null,p1__7195_SHARP_)),cmd);
});})(i__7206,vec__7210,ctx,ms,c__4229__auto__,size__4230__auto__,b__7207,s__7205__$2,temp__4092__auto__))
,ms)))], null));
{
var G__7212 = (i__7206 + 1);
i__7206 = G__7212;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__7207),iter__7204.call(null,cljs.core.chunk_rest.call(null,s__7205__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__7207),null);
}
} else
{var vec__7211 = cljs.core.first.call(null,s__7205__$2);var ctx = cljs.core.nth.call(null,vec__7211,0,null);var ms = cljs.core.nth.call(null,vec__7211,1,null);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx,cljs.core.first.call(null,cljs.core.first.call(null,cljs.core.filter.call(null,((function (vec__7211,ctx,ms,s__7205__$2,temp__4092__auto__){
return (function (p1__7195_SHARP_){return cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.second.call(null,p1__7195_SHARP_)),cmd);
});})(vec__7211,ctx,ms,s__7205__$2,temp__4092__auto__))
,ms)))], null),iter__7204.call(null,cljs.core.rest.call(null,s__7205__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__4231__auto__.call(null,cljs.core.deref.call(null,lt.objs.keyboard.keys));
})());
});
lt.objs.keyboard.cmd__GT_current_binding = (function cmd__GT_current_binding(cmd){return cljs.core.first.call(null,cljs.core.filter.call(null,(function (p1__7213_SHARP_){return cljs.core.set.call(null,cljs.core.second.call(null,p1__7213_SHARP_)).call(null,cmd);
}),cljs.core.deref.call(null,lt.objs.keyboard.key_map)));
});
Mousetrap.handleKey = (function (key,char$,ev){if(cljs.core.truth_((function (){var and__3508__auto__ = lt.objs.keyboard.capturing_QMARK_;if(cljs.core.truth_(and__3508__auto__))
{var and__3508__auto____$1 = typeof key === 'string';if(and__3508__auto____$1)
{return lt.objs.keyboard.capture.call(null,key,char$,ev);
} else
{return and__3508__auto____$1;
}
} else
{return and__3508__auto__;
}
})()))
{ev.preventDefault();
return ev.stopPropagation();
} else
{return null;
}
});
Mousetrap.handleKeyUp = (function (key,char$,ev){if(cljs.core.truth_((function (){var and__3508__auto__ = lt.objs.keyboard.capturing_QMARK_;if(cljs.core.truth_(and__3508__auto__))
{var and__3508__auto____$1 = typeof key === 'string';if(and__3508__auto____$1)
{return lt.objs.keyboard.capture_up.call(null,key,char$,ev);
} else
{return and__3508__auto____$1;
}
} else
{return and__3508__auto__;
}
})()))
{ev.preventDefault();
return ev.stopPropagation();
} else
{return null;
}
});
lt.objs.keyboard.__BEH__chord_timeout = (function __BEH__chord_timeout(this$,timeout){return lt.objs.keyboard.chord_timeout = timeout;
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.keyboard","chord-timeout","lt.objs.keyboard/chord-timeout",4274129831),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.keyboard.__BEH__chord_timeout,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Set the timeout for chorded shortcuts",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
