// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.editor');
goog.require('cljs.core');
goog.require('lt.util.dom');
goog.require('lt.object');
goog.require('lt.objs.menu');
goog.require('lt.objs.files');
goog.require('lt.util.dom');
goog.require('lt.objs.platform');
goog.require('crate.core');
goog.require('lt.objs.context');
goog.require('lt.util.dom');
goog.require('lt.objs.command');
goog.require('lt.objs.platform');
goog.require('lt.objs.menu');
goog.require('lt.objs.files');
goog.require('lt.util.load');
goog.require('lt.util.events');
goog.require('lt.object');
goog.require('lt.object');
goog.require('lt.util.load');
goog.require('crate.core');
goog.require('lt.objs.context');
goog.require('lt.objs.command');
goog.require('lt.util.events');
/**
* Return editor's CodeMirror object
*/
lt.objs.editor.__GT_cm_ed = (function __GT_cm_ed(e){if((function (){var G__12952 = e;if(G__12952)
{var bit__4164__auto__ = (G__12952.cljs$lang$protocol_mask$partition0$ & 32768);if((bit__4164__auto__) || (G__12952.cljs$core$IDeref$))
{return true;
} else
{if((!G__12952.cljs$lang$protocol_mask$partition0$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,G__12952);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,G__12952);
}
})())
{return new cljs.core.Keyword(null,"ed","ed",1013907473).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,e));
} else
{return e;
}
});
/**
* Return DOM element of editor's CodeMirror object
*/
lt.objs.editor.__GT_elem = (function __GT_elem(e){return lt.objs.editor.__GT_cm_ed.call(null,e).getScrollerElement().parentElement;
});
/**
* Set content value of editor's CodeMirror object. Cursor position is lost
*/
lt.objs.editor.set_val = (function set_val(e,v){lt.objs.editor.__GT_cm_ed.call(null,e).setValue((function (){var or__3520__auto__ = v;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return "";
}
})());
return e;
});
/**
* Same as set-val but current cursor position is kept
*/
lt.objs.editor.set_val_and_keep_cursor = (function set_val_and_keep_cursor(e,v){var cursor = lt.objs.editor.__GT_cm_ed.call(null,e).getCursor();lt.objs.editor.set_val.call(null,e,v);
return lt.objs.editor.__GT_cm_ed.call(null,e).setCursor(cursor);
});
/**
* Given a map of options, set each pair as an option on editor's
* CodeMirror object
*/
lt.objs.editor.set_options = (function set_options(e,m){var seq__12959_12965 = cljs.core.seq.call(null,m);var chunk__12960_12966 = null;var count__12961_12967 = 0;var i__12962_12968 = 0;while(true){
if((i__12962_12968 < count__12961_12967))
{var vec__12963_12969 = cljs.core._nth.call(null,chunk__12960_12966,i__12962_12968);var k_12970 = cljs.core.nth.call(null,vec__12963_12969,0,null);var v_12971 = cljs.core.nth.call(null,vec__12963_12969,1,null);lt.objs.editor.__GT_cm_ed.call(null,e).setOption(cljs.core.name.call(null,k_12970),v_12971);
{
var G__12972 = seq__12959_12965;
var G__12973 = chunk__12960_12966;
var G__12974 = count__12961_12967;
var G__12975 = (i__12962_12968 + 1);
seq__12959_12965 = G__12972;
chunk__12960_12966 = G__12973;
count__12961_12967 = G__12974;
i__12962_12968 = G__12975;
continue;
}
} else
{var temp__4092__auto___12976 = cljs.core.seq.call(null,seq__12959_12965);if(temp__4092__auto___12976)
{var seq__12959_12977__$1 = temp__4092__auto___12976;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12959_12977__$1))
{var c__4262__auto___12978 = cljs.core.chunk_first.call(null,seq__12959_12977__$1);{
var G__12979 = cljs.core.chunk_rest.call(null,seq__12959_12977__$1);
var G__12980 = c__4262__auto___12978;
var G__12981 = cljs.core.count.call(null,c__4262__auto___12978);
var G__12982 = 0;
seq__12959_12965 = G__12979;
chunk__12960_12966 = G__12980;
count__12961_12967 = G__12981;
i__12962_12968 = G__12982;
continue;
}
} else
{var vec__12964_12983 = cljs.core.first.call(null,seq__12959_12977__$1);var k_12984 = cljs.core.nth.call(null,vec__12964_12983,0,null);var v_12985 = cljs.core.nth.call(null,vec__12964_12983,1,null);lt.objs.editor.__GT_cm_ed.call(null,e).setOption(cljs.core.name.call(null,k_12984),v_12985);
{
var G__12986 = cljs.core.next.call(null,seq__12959_12977__$1);
var G__12987 = null;
var G__12988 = 0;
var G__12989 = 0;
seq__12959_12965 = G__12986;
chunk__12960_12966 = G__12987;
count__12961_12967 = G__12988;
i__12962_12968 = G__12989;
continue;
}
}
} else
{}
}
break;
}
return e;
});
lt.objs.editor.clear_history = (function clear_history(e){lt.objs.editor.__GT_cm_ed.call(null,e).clearHistory();
return e;
});
lt.objs.editor.get_history = (function get_history(e){return lt.objs.editor.__GT_cm_ed.call(null,e).getHistory();
});
lt.objs.editor.set_history = (function set_history(e,v){lt.objs.editor.__GT_cm_ed.call(null,e).setHistory(v);
return e;
});
lt.objs.editor.expand_tab = (function expand_tab(cm){if(cljs.core.truth_(cm.somethingSelected()))
{return cm.indentSelection("add");
} else
{if(cljs.core.truth_(cm.getOption("indentWithTabs")))
{return cm.replaceSelection("\t","end","+input");
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{var spaces = Array((cm.getOption("indentUnit") + 1)).join(" ");return cm.replaceSelection(spaces,"end","+input");
} else
{return null;
}
}
}
});
lt.objs.editor.headless = (function headless(opts){return lt.objs.editor.set_options.call(null,(new CodeMirror((function (){return null;
}))),opts);
});
lt.objs.editor.make = (function make(context){var e = lt.objs.editor.headless.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"mode","mode",1017261333),(cljs.core.truth_(new cljs.core.Keyword(null,"mime","mime",1017255846).cljs$core$IFn$_invoke$arity$1(context))?cljs.core.name.call(null,new cljs.core.Keyword(null,"mime","mime",1017255846).cljs$core$IFn$_invoke$arity$1(context)):"plaintext"),new cljs.core.Keyword(null,"autoClearEmptyLines","autoClearEmptyLines",2992165282),true,new cljs.core.Keyword(null,"dragDrop","dragDrop",4466739637),false,new cljs.core.Keyword(null,"undoDepth","undoDepth",4525515697),10000,new cljs.core.Keyword(null,"matchBrackets","matchBrackets",3793519906),true,new cljs.core.Keyword(null,"singleCursorHeightPerLine","singleCursorHeightPerLine",644904414),false,new cljs.core.Keyword(null,"showCursorWhenSelecting","showCursorWhenSelecting",3298041035),true], null));var temp__4092__auto___12990 = new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(context);if(cljs.core.truth_(temp__4092__auto___12990))
{var c_12991 = temp__4092__auto___12990;lt.objs.editor.set_val.call(null,e,c_12991);
lt.objs.editor.clear_history.call(null,e);
} else
{}
if(cljs.core.truth_(new cljs.core.Keyword(null,"doc","doc",1014003882).cljs$core$IFn$_invoke$arity$1(context)))
{e.swapDoc(new cljs.core.Keyword(null,"doc","doc",1014003882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"doc","doc",1014003882).cljs$core$IFn$_invoke$arity$1(context))));
} else
{}
return e;
});
/**
* Register event handler on editor's CodeMirror object
*/
lt.objs.editor.on = (function on(ed,ev,func){return lt.objs.editor.__GT_cm_ed.call(null,ed).on(cljs.core.name.call(null,ev),func);
});
/**
* Remove event handler on editor's CodeMirror object
*/
lt.objs.editor.off = (function off(ed,ev,func){return lt.objs.editor.__GT_cm_ed.call(null,ed).off(cljs.core.name.call(null,ev),func);
});
lt.objs.editor.wrap_object_events = (function wrap_object_events(ed,obj){lt.util.dom.on.call(null,lt.objs.editor.__GT_elem.call(null,ed),new cljs.core.Keyword(null,"contextmenu","contextmenu",911789824),(function (p1__12992_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"menu!","menu!",1117686292),p1__12992_SHARP_);
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"dragstart","dragstart",721070880),(function (p1__12994_SHARP_,p2__12993_SHARP_){return p2__12993_SHARP_.preventDefault();
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"dragenter","dragenter",707980694),(function (p1__12996_SHARP_,p2__12995_SHARP_){return p2__12995_SHARP_.preventDefault();
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"dragover","dragover",4468024186),(function (p1__12998_SHARP_,p2__12997_SHARP_){return p2__12997_SHARP_.preventDefault();
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"drop","drop",1016996449),(function (p1__13000_SHARP_,p2__12999_SHARP_){return p2__12999_SHARP_.preventDefault();
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"scroll","scroll",4401191487),(function (p1__13001_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"scroll","scroll",4401191487),p1__13001_SHARP_);
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"update","update",4470025275),(function (p1__13002_SHARP_,p2__13003_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"update","update",4470025275),p1__13002_SHARP_,p2__13003_SHARP_);
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"change","change",3947235106),(function (p1__13004_SHARP_,p2__13005_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"change","change",3947235106),p1__13004_SHARP_,p2__13005_SHARP_);
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"inputRead","inputRead",2720801778),(function (p1__13006_SHARP_,p2__13007_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"input","input",1114262332),p1__13006_SHARP_,p2__13007_SHARP_);
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"cursorActivity","cursorActivity",2053482487),(function (p1__13008_SHARP_,p2__13009_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"move","move",1017261891),p1__13008_SHARP_,p2__13009_SHARP_);
}));
lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"focus","focus",1111509066),(function (p1__13010_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"focus","focus",1111509066),p1__13010_SHARP_);
}));
return lt.objs.editor.on.call(null,ed,new cljs.core.Keyword(null,"blur","blur",1016931289),(function (p1__13011_SHARP_){return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"blur","blur",1016931289),p1__13011_SHARP_);
}));
});
/**
* Return editor's CodeMirror object buffer contents
*/
lt.objs.editor.__GT_val = (function __GT_val(e){return lt.objs.editor.__GT_cm_ed.call(null,e).getValue();
});
lt.objs.editor.__GT_token = (function __GT_token(e,pos){return cljs.core.js__GT_clj.call(null,lt.objs.editor.__GT_cm_ed.call(null,e).getTokenAt(cljs.core.clj__GT_js.call(null,pos)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",4191781672),true);
});
lt.objs.editor.__GT_token_js = (function __GT_token_js(e,pos){return lt.objs.editor.__GT_cm_ed.call(null,e).getTokenAt(cljs.core.clj__GT_js.call(null,pos));
});
lt.objs.editor.__GT_token_type = (function __GT_token_type(e,pos){return lt.objs.editor.__GT_cm_ed.call(null,e).getTokenTypeAt(cljs.core.clj__GT_js.call(null,pos));
});
lt.objs.editor.__GT_coords = (function __GT_coords(e){return cljs.core.js__GT_clj.call(null,lt.objs.editor.__GT_cm_ed.call(null,e).cursorCoords(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",4191781672),true,new cljs.core.Keyword(null,"force-obj","force-obj",2540778119),true);
});
lt.objs.editor._PLUS_class = (function _PLUS_class(e,klass){lt.util.dom.add_class.call(null,lt.objs.editor.__GT_elem.call(null,e),cljs.core.name.call(null,klass));
return e;
});
lt.objs.editor._class = (function _class(e,klass){lt.util.dom.remove_class.call(null,lt.objs.editor.__GT_elem.call(null,e),cljs.core.name.call(null,klass));
return e;
});
/**
* Return cursor of editor's CodeMirror object as js object.
* Example: #js {:line 144, :ch 9}
*/
lt.objs.editor.cursor = (function() {
var cursor = null;
var cursor__1 = (function (e){return cursor.call(null,e,null);
});
var cursor__2 = (function (e,side){return lt.objs.editor.__GT_cm_ed.call(null,e).getCursor(side);
});
cursor = function(e,side){
switch(arguments.length){
case 1:
return cursor__1.call(this,e);
case 2:
return cursor__2.call(this,e,side);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cursor.cljs$core$IFn$_invoke$arity$1 = cursor__1;
cursor.cljs$core$IFn$_invoke$arity$2 = cursor__2;
return cursor;
})()
;
/**
* Same as cursor but returned as cljs map
* @param {...*} var_args
*/
lt.objs.editor.__GT_cursor = (function() { 
var __GT_cursor__delegate = function (e,p__13012){var vec__13014 = p__13012;var side = cljs.core.nth.call(null,vec__13014,0,null);var pos = lt.objs.editor.cursor.call(null,e,side);return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",1017226086),pos.line,new cljs.core.Keyword(null,"ch","ch",1013907415),pos.ch], null);
};
var __GT_cursor = function (e,var_args){
var p__13012 = null;if (arguments.length > 1) {
  p__13012 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return __GT_cursor__delegate.call(this,e,p__13012);};
__GT_cursor.cljs$lang$maxFixedArity = 1;
__GT_cursor.cljs$lang$applyTo = (function (arglist__13015){
var e = cljs.core.first(arglist__13015);
var p__13012 = cljs.core.rest(arglist__13015);
return __GT_cursor__delegate(e,p__13012);
});
__GT_cursor.cljs$core$IFn$_invoke$arity$variadic = __GT_cursor__delegate;
return __GT_cursor;
})()
;
lt.objs.editor.pos__GT_index = (function pos__GT_index(e,pos){return lt.objs.editor.__GT_cm_ed.call(null,e).indexFromPos(cljs.core.clj__GT_js.call(null,pos));
});
lt.objs.editor.mark = (function mark(e,from,to,opts){return lt.objs.editor.__GT_cm_ed.call(null,e).markText(cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to),cljs.core.clj__GT_js.call(null,opts));
});
lt.objs.editor.find_marks = (function find_marks(e,pos){return lt.objs.editor.__GT_cm_ed.call(null,e).findMarksAt(cljs.core.clj__GT_js.call(null,pos));
});
lt.objs.editor.bookmark = (function bookmark(e,from,widg){return lt.objs.editor.__GT_cm_ed.call(null,e).setBookmark(cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,widg));
});
/**
* Return value for option name on editor's CodeMirror object
*/
lt.objs.editor.option = (function option(e,o){return lt.objs.editor.__GT_cm_ed.call(null,e).getOption(cljs.core.name.call(null,o));
});
lt.objs.editor.set_mode = (function set_mode(e,m){lt.objs.editor.__GT_cm_ed.call(null,e).setOption("mode",m);
return e;
});
lt.objs.editor.__GT_mode = (function __GT_mode(e){return lt.objs.editor.__GT_cm_ed.call(null,e).getMode();
});
lt.objs.editor.focus = (function focus(e){lt.objs.editor.__GT_cm_ed.call(null,e).focus();
return e;
});
lt.objs.editor.input_field = (function input_field(e){return e.getInputField();
});
lt.objs.editor.blur = (function blur(e){lt.objs.editor.input_field.call(null,e).blur();
return e;
});
lt.objs.editor.refresh = (function refresh(e){lt.objs.editor.__GT_cm_ed.call(null,e).refresh();
return e;
});
lt.objs.editor.on_move = (function on_move(e,func){e.on("onCursorActivity",(function (ed,delta){return func.call(null,ed,delta);
}));
return e;
});
lt.objs.editor.on_change = (function on_change(e,func){e.on("onChange",(function (ed,delta){return func.call(null,ed,delta);
}));
return e;
});
lt.objs.editor.on_update = (function on_update(e,func){e.on("onUpdate",(function (ed,delta){return func.call(null,ed,delta);
}));
return e;
});
lt.objs.editor.on_scroll = (function on_scroll(e,func){e.on("onScroll",(function (ed){return func.call(null,ed);
}));
return e;
});
lt.objs.editor.replace = (function() {
var replace = null;
var replace__3 = (function (e,from,v){return lt.objs.editor.__GT_cm_ed.call(null,e).replaceRange(v,cljs.core.clj__GT_js.call(null,from));
});
var replace__4 = (function (e,from,to,v){return lt.objs.editor.__GT_cm_ed.call(null,e).replaceRange(v,cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to));
});
replace = function(e,from,to,v){
switch(arguments.length){
case 3:
return replace__3.call(this,e,from,to);
case 4:
return replace__4.call(this,e,from,to,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
replace.cljs$core$IFn$_invoke$arity$3 = replace__3;
replace.cljs$core$IFn$_invoke$arity$4 = replace__4;
return replace;
})()
;
lt.objs.editor.range = (function range(e,from,to){return lt.objs.editor.__GT_cm_ed.call(null,e).getRange(cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to));
});
lt.objs.editor.line_count = (function line_count(e){return lt.objs.editor.__GT_cm_ed.call(null,e).lineCount();
});
lt.objs.editor.insert_at_cursor = (function insert_at_cursor(ed,s){lt.objs.editor.replace.call(null,lt.objs.editor.__GT_cm_ed.call(null,ed),lt.objs.editor.__GT_cursor.call(null,ed),s);
return ed;
});
lt.objs.editor.move_cursor = (function move_cursor(ed,pos){return lt.objs.editor.__GT_cm_ed.call(null,ed).setCursor(cljs.core.clj__GT_js.call(null,(function (){var or__3520__auto__ = pos;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",1017226086),0,new cljs.core.Keyword(null,"ch","ch",1013907415),0], null);
}
})()));
});
lt.objs.editor.scroll_to = (function scroll_to(ed,x,y){return lt.objs.editor.__GT_cm_ed.call(null,ed).scrollTo(x,y);
});
lt.objs.editor.center_cursor = (function center_cursor(ed){var l = new cljs.core.Keyword(null,"line","line",1017226086).cljs$core$IFn$_invoke$arity$1(lt.objs.editor.__GT_cursor.call(null,ed));var y = lt.objs.editor.__GT_cm_ed.call(null,ed).charCoords(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",1017226086),l,new cljs.core.Keyword(null,"ch","ch",1013907415),0], null)),"local").top;var half_h = (lt.objs.editor.__GT_cm_ed.call(null,ed).getScrollerElement().offsetHeight / 2);return lt.objs.editor.scroll_to.call(null,ed,null,((y - half_h) - -55));
});
lt.objs.editor.selection_QMARK_ = (function selection_QMARK_(e){return lt.objs.editor.__GT_cm_ed.call(null,e).somethingSelected();
});
lt.objs.editor.selection_bounds = (function selection_bounds(e){if(cljs.core.truth_(lt.objs.editor.selection_QMARK_.call(null,e)))
{return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1017056028),lt.objs.editor.__GT_cursor.call(null,e,"start"),new cljs.core.Keyword(null,"to","to",1013907949),lt.objs.editor.__GT_cursor.call(null,e,"end")], null);
} else
{return null;
}
});
lt.objs.editor.selection = (function selection(e){return lt.objs.editor.__GT_cm_ed.call(null,e).getSelection();
});
lt.objs.editor.set_selection = (function set_selection(e,start,end){return lt.objs.editor.__GT_cm_ed.call(null,e).setSelection(cljs.core.clj__GT_js.call(null,start),cljs.core.clj__GT_js.call(null,end));
});
lt.objs.editor.set_extending = (function set_extending(e,ext_QMARK_){return lt.objs.editor.__GT_cm_ed.call(null,e).setExtending(ext_QMARK_);
});
/**
* @param {...*} var_args
*/
lt.objs.editor.replace_selection = (function() { 
var replace_selection__delegate = function (e,neue,p__13016){var vec__13018 = p__13016;var after = cljs.core.nth.call(null,vec__13018,0,null);return lt.objs.editor.__GT_cm_ed.call(null,e).replaceSelection(neue,cljs.core.name.call(null,(function (){var or__3520__auto__ = after;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return new cljs.core.Keyword(null,"end","end",1014004813);
}
})()),"+input");
};
var replace_selection = function (e,neue,var_args){
var p__13016 = null;if (arguments.length > 2) {
  p__13016 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return replace_selection__delegate.call(this,e,neue,p__13016);};
replace_selection.cljs$lang$maxFixedArity = 2;
replace_selection.cljs$lang$applyTo = (function (arglist__13019){
var e = cljs.core.first(arglist__13019);
arglist__13019 = cljs.core.next(arglist__13019);
var neue = cljs.core.first(arglist__13019);
var p__13016 = cljs.core.rest(arglist__13019);
return replace_selection__delegate(e,neue,p__13016);
});
replace_selection.cljs$core$IFn$_invoke$arity$variadic = replace_selection__delegate;
return replace_selection;
})()
;
lt.objs.editor.undo = (function undo(e){return lt.objs.editor.__GT_cm_ed.call(null,e).undo();
});
lt.objs.editor.redo = (function redo(e){return lt.objs.editor.__GT_cm_ed.call(null,e).redo();
});
lt.objs.editor.copy = (function copy(e){return lt.objs.platform.copy.call(null,lt.objs.editor.selection.call(null,e));
});
lt.objs.editor.cut = (function cut(e){lt.objs.editor.copy.call(null,e);
return lt.objs.editor.replace_selection.call(null,e,"");
});
lt.objs.editor.paste = (function paste(e){return lt.objs.editor.replace_selection.call(null,e,lt.objs.platform.paste.call(null));
});
lt.objs.editor.char_coords = (function char_coords(e,pos){return cljs.core.js__GT_clj.call(null,lt.objs.editor.__GT_cm_ed.call(null,e).charCoords(cljs.core.clj__GT_js.call(null,pos)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",4191781672),true,new cljs.core.Keyword(null,"force-obj","force-obj",2540778119),true);
});
lt.objs.editor.operation = (function operation(e,func){lt.objs.editor.__GT_cm_ed.call(null,e).operation(func);
return e;
});
lt.objs.editor.on_click = (function on_click(e,func){var elem = lt.objs.editor.__GT_elem.call(null,e);lt.util.events.capture.call(null,elem,new cljs.core.Keyword(null,"mousedown","mousedown",1600748089),func);
return e;
});
lt.objs.editor.extension = (function extension(name,func){return CodeMirror.defineExtension(name,func);
});
/**
* @param {...*} var_args
*/
lt.objs.editor.line_widget = (function() { 
var line_widget__delegate = function (e,line,elem,p__13020){var vec__13022 = p__13020;var opts = cljs.core.nth.call(null,vec__13022,0,null);return lt.objs.editor.__GT_cm_ed.call(null,e).addLineWidget(line,elem,cljs.core.clj__GT_js.call(null,opts));
};
var line_widget = function (e,line,elem,var_args){
var p__13020 = null;if (arguments.length > 3) {
  p__13020 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return line_widget__delegate.call(this,e,line,elem,p__13020);};
line_widget.cljs$lang$maxFixedArity = 3;
line_widget.cljs$lang$applyTo = (function (arglist__13023){
var e = cljs.core.first(arglist__13023);
arglist__13023 = cljs.core.next(arglist__13023);
var line = cljs.core.first(arglist__13023);
arglist__13023 = cljs.core.next(arglist__13023);
var elem = cljs.core.first(arglist__13023);
var p__13020 = cljs.core.rest(arglist__13023);
return line_widget__delegate(e,line,elem,p__13020);
});
line_widget.cljs$core$IFn$_invoke$arity$variadic = line_widget__delegate;
return line_widget;
})()
;
lt.objs.editor.remove_line_widget = (function remove_line_widget(e,widg){return lt.objs.editor.__GT_cm_ed.call(null,e).removeLineWidget(widg);
});
lt.objs.editor.line = (function line(e,l){return lt.objs.editor.__GT_cm_ed.call(null,e).getLine(l);
});
lt.objs.editor.first_line = (function first_line(e){return lt.objs.editor.__GT_cm_ed.call(null,e).firstLine();
});
lt.objs.editor.last_line = (function last_line(e){return lt.objs.editor.__GT_cm_ed.call(null,e).lastLine();
});
lt.objs.editor.line_handle = (function line_handle(e,l){return lt.objs.editor.__GT_cm_ed.call(null,e).getLineHandle(l);
});
lt.objs.editor.lh__GT_line = (function lh__GT_line(e,lh){return lt.objs.editor.__GT_cm_ed.call(null,e).getLineNumber(lh);
});
lt.objs.editor.line_length = (function line_length(e,l){return cljs.core.count.call(null,lt.objs.editor.line.call(null,e,l));
});
lt.objs.editor.select_all = (function select_all(e){return lt.objs.editor.set_selection.call(null,e,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",1017226086),lt.objs.editor.first_line.call(null,e),new cljs.core.Keyword(null,"ch","ch",1013907415),0], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"line","line",1017226086),lt.objs.editor.last_line.call(null,e)], null));
});
lt.objs.editor.set_line = (function set_line(e,l,text){var length = lt.objs.editor.line_length.call(null,e,l);return lt.objs.editor.replace.call(null,e,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",1017226086),l,new cljs.core.Keyword(null,"ch","ch",1013907415),0], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",1017226086),l,new cljs.core.Keyword(null,"ch","ch",1013907415),length], null),text);
});
lt.objs.editor._PLUS_line_class = (function _PLUS_line_class(e,lh,plane,class$){return lt.objs.editor.__GT_cm_ed.call(null,e).addLineClass(lh,cljs.core.name.call(null,plane),cljs.core.name.call(null,class$));
});
lt.objs.editor._line_class = (function _line_class(e,lh,plane,class$){return lt.objs.editor.__GT_cm_ed.call(null,e).removeLineClass(lh,cljs.core.name.call(null,plane),cljs.core.name.call(null,class$));
});
lt.objs.editor.show_hints = (function show_hints(e,hint_fn,options){CodeMirror.showHint(lt.objs.editor.__GT_cm_ed.call(null,e),hint_fn,cljs.core.clj__GT_js.call(null,options));
return e;
});
lt.objs.editor.inner_mode = (function() {
var inner_mode = null;
var inner_mode__1 = (function (e){return inner_mode.call(null,e,null);
});
var inner_mode__2 = (function (e,state){var state__$1 = (function (){var or__3520__auto__ = state;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.objs.editor.__GT_token_js.call(null,e,lt.objs.editor.cursor.call(null,e)).state;
}
})();return CodeMirror.innerMode(lt.objs.editor.__GT_cm_ed.call(null,e).getMode(),state__$1).mode;
});
inner_mode = function(e,state){
switch(arguments.length){
case 1:
return inner_mode__1.call(this,e);
case 2:
return inner_mode__2.call(this,e,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
inner_mode.cljs$core$IFn$_invoke$arity$1 = inner_mode__1;
inner_mode.cljs$core$IFn$_invoke$arity$2 = inner_mode__2;
return inner_mode;
})()
;
lt.objs.editor.adjust_loc = (function() {
var adjust_loc = null;
var adjust_loc__2 = (function (loc,dir){return adjust_loc.call(null,loc,dir,new cljs.core.Keyword(null,"ch","ch",1013907415));
});
var adjust_loc__3 = (function (loc,dir,axis){if(cljs.core.truth_(loc))
{return cljs.core.update_in.call(null,loc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [axis], null),cljs.core._PLUS_,dir);
} else
{return null;
}
});
adjust_loc = function(loc,dir,axis){
switch(arguments.length){
case 2:
return adjust_loc__2.call(this,loc,dir);
case 3:
return adjust_loc__3.call(this,loc,dir,axis);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
adjust_loc.cljs$core$IFn$_invoke$arity$2 = adjust_loc__2;
adjust_loc.cljs$core$IFn$_invoke$arity$3 = adjust_loc__3;
return adjust_loc;
})()
;
lt.objs.editor.get_char = (function get_char(ed,dir){var loc = lt.objs.editor.__GT_cursor.call(null,ed);if((dir > 0))
{return lt.objs.editor.range.call(null,ed,loc,lt.objs.editor.adjust_loc.call(null,loc,dir));
} else
{return lt.objs.editor.range.call(null,ed,lt.objs.editor.adjust_loc.call(null,loc,dir),loc);
}
});
lt.objs.editor.indent_line = (function indent_line(e,l,dir){return lt.objs.editor.__GT_cm_ed.call(null,e).indentLine(l,dir);
});
lt.objs.editor.indent_lines = (function indent_lines(e,from,to,dir){var ed = lt.objs.editor.__GT_cm_ed.call(null,e);var diff = (new cljs.core.Keyword(null,"line","line",1017226086).cljs$core$IFn$_invoke$arity$1(to) - new cljs.core.Keyword(null,"line","line",1017226086).cljs$core$IFn$_invoke$arity$1(from));if((diff === 0))
{return ed.indentLine(new cljs.core.Keyword(null,"line","line",1017226086).cljs$core$IFn$_invoke$arity$1(to),dir);
} else
{var n__4362__auto__ = (diff + 1);var x = 0;while(true){
if((x < n__4362__auto__))
{ed.indentLine((new cljs.core.Keyword(null,"line","line",1017226086).cljs$core$IFn$_invoke$arity$1(from) + x));
{
var G__13024 = (x + 1);
x = G__13024;
continue;
}
} else
{return null;
}
break;
}
}
});
lt.objs.editor.indent_selection = (function indent_selection(e,dir){return lt.objs.editor.__GT_cm_ed.call(null,e).indentSelection(dir);
});
lt.objs.editor.line_comment = (function line_comment(e,from,to,opts){return lt.objs.editor.__GT_cm_ed.call(null,e).lineComment(cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to),cljs.core.clj__GT_js.call(null,opts));
});
lt.objs.editor.uncomment = (function uncomment(e,from,to,opts){return lt.objs.editor.__GT_cm_ed.call(null,e).uncomment(cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to),cljs.core.clj__GT_js.call(null,opts));
});
lt.objs.editor.block_comment = (function block_comment(e,from,to,opts){return lt.objs.editor.__GT_cm_ed.call(null,e).blockComment(cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to),cljs.core.clj__GT_js.call(null,opts));
});
/**
* Toggle comment and if multiline toggle apply block comment
*/
lt.objs.editor.toggle_comment = (function toggle_comment(e,from,to,opts){if(cljs.core.truth_(lt.objs.editor.uncomment.call(null,e,from,to,opts)))
{return null;
} else
{if(!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"line","line",1017226086).cljs$core$IFn$_invoke$arity$1(from),new cljs.core.Keyword(null,"line","line",1017226086).cljs$core$IFn$_invoke$arity$1(to))))
{return lt.objs.editor.block_comment.call(null,e,from,to,opts);
} else
{return lt.objs.editor.line_comment.call(null,e,from,lt.objs.editor.__GT_cursor.call(null,e,"end"),opts);
}
}
});
lt.objs.editor.__GT_generation = (function __GT_generation(e){return lt.objs.editor.__GT_cm_ed.call(null,e).changeGeneration();
});
lt.objs.editor.dirty_QMARK_ = (function dirty_QMARK_(e,gen){return cljs.core.not.call(null,lt.objs.editor.__GT_cm_ed.call(null,e).isClean(gen));
});
lt.objs.editor.get_doc = (function get_doc(e){return lt.objs.editor.__GT_cm_ed.call(null,e).getDoc();
});
lt.objs.editor.set_doc_BANG_ = (function set_doc_BANG_(e,doc){lt.object.merge_BANG_.call(null,e,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1014003882),doc], null));
return lt.objs.editor.__GT_cm_ed.call(null,e).swapDoc(new cljs.core.Keyword(null,"doc","doc",1014003882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,doc)));
});
lt.objs.editor.fold_code = (function() {
var fold_code = null;
var fold_code__1 = (function (e){return fold_code.call(null,e,lt.objs.editor.__GT_cursor.call(null,e));
});
var fold_code__2 = (function (e,loc){return lt.objs.editor.__GT_cm_ed.call(null,e).foldCode(cljs.core.clj__GT_js.call(null,loc));
});
fold_code = function(e,loc){
switch(arguments.length){
case 1:
return fold_code__1.call(this,e);
case 2:
return fold_code__2.call(this,e,loc);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fold_code.cljs$core$IFn$_invoke$arity$1 = fold_code__1;
fold_code.cljs$core$IFn$_invoke$arity$2 = fold_code__2;
return fold_code;
})()
;
lt.objs.editor.gutter_widths = (function gutter_widths(e){var gutter_div = lt.util.dom.$.call(null,new cljs.core.Keyword(null,"div.CodeMirror-gutters","div.CodeMirror-gutters",1932435974),lt.object.__GT_content.call(null,e));var gutter_divs = lt.util.dom.$$.call(null,new cljs.core.Keyword(null,"div.CodeMirror-gutter","div.CodeMirror-gutter",4091575601),gutter_div);var current_widths = cljs.core.reduce.call(null,((function (gutter_div,gutter_divs){
return (function (res,gutter){var gutter_class = clojure.string.replace_first.call(null,lt.util.dom.attr.call(null,gutter,"class"),"CodeMirror-gutter ","");return cljs.core.assoc.call(null,res,gutter_class,lt.util.dom.width.call(null,gutter));
});})(gutter_div,gutter_divs))
,cljs.core.PersistentArrayMap.EMPTY,gutter_divs);return current_widths;
});
lt.objs.editor.update_gutters = (function update_gutters(e,class_names,class_widths){var gutter_div = lt.util.dom.$.call(null,new cljs.core.Keyword(null,"div.CodeMirror-gutters","div.CodeMirror-gutters",1932435974),lt.object.__GT_content.call(null,e));return lt.objs.editor.operation.call(null,e,(function (){lt.objs.editor.set_options.call(null,e,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"gutters","gutters",1397798442),cljs.core.clj__GT_js.call(null,class_names)], null));
var seq__13031 = cljs.core.seq.call(null,class_widths);var chunk__13032 = null;var count__13033 = 0;var i__13034 = 0;while(true){
if((i__13034 < count__13033))
{var vec__13035 = cljs.core._nth.call(null,chunk__13032,i__13034);var k = cljs.core.nth.call(null,vec__13035,0,null);var v = cljs.core.nth.call(null,vec__13035,1,null);var temp__4090__auto___13037 = lt.util.dom.$.call(null,[cljs.core.str("div."),cljs.core.str(k)].join(''),gutter_div);if(cljs.core.truth_(temp__4090__auto___13037))
{var gutter_13038 = temp__4090__auto___13037;lt.util.dom.set_css.call(null,gutter_13038,new cljs.core.PersistentArrayMap(null, 1, ["width",[cljs.core.str(v),cljs.core.str("px")].join('')], null));
} else
{}
{
var G__13039 = seq__13031;
var G__13040 = chunk__13032;
var G__13041 = count__13033;
var G__13042 = (i__13034 + 1);
seq__13031 = G__13039;
chunk__13032 = G__13040;
count__13033 = G__13041;
i__13034 = G__13042;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__13031);if(temp__4092__auto__)
{var seq__13031__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13031__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__13031__$1);{
var G__13043 = cljs.core.chunk_rest.call(null,seq__13031__$1);
var G__13044 = c__4262__auto__;
var G__13045 = cljs.core.count.call(null,c__4262__auto__);
var G__13046 = 0;
seq__13031 = G__13043;
chunk__13032 = G__13044;
count__13033 = G__13045;
i__13034 = G__13046;
continue;
}
} else
{var vec__13036 = cljs.core.first.call(null,seq__13031__$1);var k = cljs.core.nth.call(null,vec__13036,0,null);var v = cljs.core.nth.call(null,vec__13036,1,null);var temp__4090__auto___13047 = lt.util.dom.$.call(null,[cljs.core.str("div."),cljs.core.str(k)].join(''),gutter_div);if(cljs.core.truth_(temp__4090__auto___13047))
{var gutter_13048 = temp__4090__auto___13047;lt.util.dom.set_css.call(null,gutter_13048,new cljs.core.PersistentArrayMap(null, 1, ["width",[cljs.core.str(v),cljs.core.str("px")].join('')], null));
} else
{}
{
var G__13049 = cljs.core.next.call(null,seq__13031__$1);
var G__13050 = null;
var G__13051 = 0;
var G__13052 = 0;
seq__13031 = G__13049;
chunk__13032 = G__13050;
count__13033 = G__13051;
i__13034 = G__13052;
continue;
}
}
} else
{return null;
}
}
break;
}
}));
});
lt.objs.editor.add_gutter = (function add_gutter(e,class_name,width){var gutter_classes = cljs.core.set.call(null,cljs.core.conj.call(null,cljs.core.js__GT_clj.call(null,lt.objs.editor.option.call(null,e,"gutters")),class_name));var current_widths = lt.objs.editor.gutter_widths.call(null,e);var new_gutter_widths = cljs.core.assoc.call(null,current_widths,class_name,width);return lt.objs.editor.update_gutters.call(null,e,gutter_classes,new_gutter_widths);
});
lt.objs.editor.remove_gutter = (function remove_gutter(e,class_name){var gutter_classes = cljs.core.remove.call(null,cljs.core.PersistentHashSet.fromArray([class_name], true),cljs.core.js__GT_clj.call(null,lt.objs.editor.option.call(null,e,"gutters")));var current_widths = lt.objs.editor.gutter_widths.call(null,e);return lt.objs.editor.update_gutters.call(null,e,gutter_classes,current_widths);
});
lt.util.load.js.call(null,"core/node_modules/codemirror/lib/codemirror.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","editor","lt.objs.editor/editor",3793959614),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"editor.inline-result","editor.inline-result",1965420162),null,new cljs.core.Keyword(null,"editor","editor",4001043679),null,new cljs.core.Keyword(null,"editor.keys.normal","editor.keys.normal",2927389330),null], null), null),new cljs.core.Keyword(null,"init","init",1017141378),(function (obj,info){var ed = lt.objs.editor.make.call(null,info);lt.object.merge_BANG_.call(null,obj,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ed","ed",1013907473),ed,new cljs.core.Keyword(null,"doc","doc",1014003882),new cljs.core.Keyword(null,"doc","doc",1014003882).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Keyword(null,"info","info",1017141280),cljs.core.dissoc.call(null,info,new cljs.core.Keyword(null,"content","content",1965434859),new cljs.core.Keyword(null,"doc","doc",1014003882))], null));
lt.objs.editor.wrap_object_events.call(null,ed,obj);
return lt.objs.editor.__GT_elem.call(null,ed);
}));
lt.objs.editor.__BEH__wrap = (function __BEH__wrap(obj){return lt.objs.editor.set_options.call(null,obj,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lineWrapping","lineWrapping",2343432258),true], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","wrap","lt.objs.editor/wrap",1346285593),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__wrap,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Wrap lines",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","no-wrap","lt.objs.editor/no-wrap",3540780885)], null));
lt.objs.editor.__BEH__no_wrap = (function __BEH__no_wrap(obj){return lt.objs.editor.set_options.call(null,obj,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lineWrapping","lineWrapping",2343432258),false], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","no-wrap","lt.objs.editor/no-wrap",3540780885),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__no_wrap,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Unwrap lines",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","wrap","lt.objs.editor/wrap",1346285593)], null));
lt.objs.editor.__BEH__line_numbers = (function __BEH__line_numbers(this$){return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lineNumbers","lineNumbers",3695398696),true], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","line-numbers","lt.objs.editor/line-numbers",3399978738),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__line_numbers,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Show line numbers",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","hide-line-numbers","lt.objs.editor/hide-line-numbers",1337733131)], null));
lt.objs.editor.__BEH__hide_line_numbers = (function __BEH__hide_line_numbers(this$){return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"lineNumbers","lineNumbers",3695398696),false], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","hide-line-numbers","lt.objs.editor/hide-line-numbers",1337733131),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__hide_line_numbers,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Hide line numbers",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","line-numbers","lt.objs.editor/line-numbers",3399978738)], null));
lt.objs.editor.__BEH__fold_gutter = (function __BEH__fold_gutter(this$){return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"foldGutter","foldGutter",3625682926),true,new cljs.core.Keyword(null,"gutters","gutters",1397798442),cljs.core.clj__GT_js.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["CodeMirror-foldgutter"], null))], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","fold-gutter","lt.objs.editor/fold-gutter",3133215688),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__fold_gutter,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Show fold gutter",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","hide-fold-gutter","lt.objs.editor/hide-fold-gutter",3213948875)], null));
lt.objs.editor.__BEH__hide_fold_gutter = (function __BEH__hide_fold_gutter(this$){return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"foldGutter","foldGutter",3625682926),false], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","hide-fold-gutter","lt.objs.editor/hide-fold-gutter",3213948875),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__hide_fold_gutter,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Hide fold gutter",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","fold-gutter","lt.objs.editor/fold-gutter",3133215688)], null));
lt.objs.editor.__BEH__scroll_past_end = (function __BEH__scroll_past_end(this$){return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"scrollPastEnd","scrollPastEnd",680406862),true], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","scroll-past-end","lt.objs.editor/scroll-past-end",3534578831),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__scroll_past_end,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Allow scrolling past the end of the file",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),true);
lt.objs.editor.__BEH__tab_settings = (function __BEH__tab_settings(obj,use_tabs_QMARK_,tab_size,indent_unit){return lt.objs.editor.set_options.call(null,obj,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tabSize","tabSize",3755226280),tab_size,new cljs.core.Keyword(null,"indentWithTabs","indentWithTabs",4541079970),use_tabs_QMARK_,new cljs.core.Keyword(null,"indentUnit","indentUnit",1493236674),indent_unit], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","tab-settings","lt.objs.editor/tab-settings",4309723340),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__tab_settings,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: indent settings (tab size, etc)",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Use tabs?",new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"boolean","boolean",1078615962)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Tab size in spaces",new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"number","number",4274507451)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Spaces per indent",new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"number","number",4274507451)], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),true);
lt.objs.editor.__BEH__set_codemirror_flags = (function __BEH__set_codemirror_flags(this$,flags){return lt.objs.editor.set_options.call(null,this$,flags);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","set-codemirror-flags","lt.objs.editor/set-codemirror-flags",1126863090),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__set_codemirror_flags,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Set CodeMirror flags",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Flags map",new cljs.core.Keyword(null,"ex","ex",1013907493),"{:undoDepth 1000}"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.editor.__BEH__read_only = (function __BEH__read_only(this$){lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",1017141280),new cljs.core.Keyword(null,"name","name",1017277949)], null),cljs.core.str," (read-only)");
return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"readOnly","readOnly",4441187796),true], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","read-only","lt.objs.editor/read-only",4613138148),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__read_only,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: make editor read-only",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","not-read-only","lt.objs.editor/not-read-only",768575834)], null));
lt.objs.editor.__BEH__not_read_only = (function __BEH__not_read_only(this$){return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"readOnly","readOnly",4441187796),false], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","not-read-only","lt.objs.editor/not-read-only",768575834),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__not_read_only,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: make editor writable",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.editor","read-only","lt.objs.editor/read-only",4613138148)], null));
lt.objs.editor.__BEH__blink_rate = (function __BEH__blink_rate(this$,rate){if(cljs.core.truth_(rate))
{return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursorBlinkRate","cursorBlinkRate",3128673048),rate], null));
} else
{return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cursorBlinkRate","cursorBlinkRate",3128673048),0], null));
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","blink-rate","lt.objs.editor/blink-rate",1889690546),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__blink_rate,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: set cursor blink rate",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),true);
lt.objs.editor.__BEH__active_on_focus = (function __BEH__active_on_focus(obj){lt.object.add_tags.call(null,obj,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editor.active","editor.active",3541692953)], null));
return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"active","active",3885920888));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","active-on-focus","lt.objs.editor/active-on-focus",4342250962),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__active_on_focus,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"focus","focus",1111509066),null], null), null));
lt.objs.editor.__BEH__inactive_on_blur = (function __BEH__inactive_on_blur(obj){lt.object.remove_tags.call(null,obj,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editor.active","editor.active",3541692953)], null));
return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"inactive","inactive",1038569437));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","inactive-on-blur","lt.objs.editor/inactive-on-blur",3268387892),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__inactive_on_blur,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"blur","blur",1016931289),null], null), null));
lt.objs.editor.__BEH__refresh_BANG_ = (function __BEH__refresh_BANG_(this$){return lt.objs.editor.refresh.call(null,this$);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","refresh!","lt.objs.editor/refresh!",4525044613),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__refresh_BANG_,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh!","refresh!",4597922840),null], null), null));
lt.objs.editor.__BEH__on_tags_added = (function __BEH__on_tags_added(this$,added){var seq__13059 = cljs.core.seq.call(null,added);var chunk__13061 = null;var count__13062 = 0;var i__13063 = 0;while(true){
if((i__13063 < count__13062))
{var a = cljs.core._nth.call(null,chunk__13061,i__13063);if(cljs.core.truth_(a))
{lt.objs.context.in_BANG_.call(null,a,this$);
{
var G__13065 = seq__13059;
var G__13066 = chunk__13061;
var G__13067 = count__13062;
var G__13068 = (i__13063 + 1);
seq__13059 = G__13065;
chunk__13061 = G__13066;
count__13062 = G__13067;
i__13063 = G__13068;
continue;
}
} else
{{
var G__13069 = seq__13059;
var G__13070 = chunk__13061;
var G__13071 = count__13062;
var G__13072 = (i__13063 + 1);
seq__13059 = G__13069;
chunk__13061 = G__13070;
count__13062 = G__13071;
i__13063 = G__13072;
continue;
}
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__13059);if(temp__4092__auto__)
{var seq__13059__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13059__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__13059__$1);{
var G__13073 = cljs.core.chunk_rest.call(null,seq__13059__$1);
var G__13074 = c__4262__auto__;
var G__13075 = cljs.core.count.call(null,c__4262__auto__);
var G__13076 = 0;
seq__13059 = G__13073;
chunk__13061 = G__13074;
count__13062 = G__13075;
i__13063 = G__13076;
continue;
}
} else
{var a = cljs.core.first.call(null,seq__13059__$1);if(cljs.core.truth_(a))
{lt.objs.context.in_BANG_.call(null,a,this$);
{
var G__13077 = cljs.core.next.call(null,seq__13059__$1);
var G__13078 = null;
var G__13079 = 0;
var G__13080 = 0;
seq__13059 = G__13077;
chunk__13061 = G__13078;
count__13062 = G__13079;
i__13063 = G__13080;
continue;
}
} else
{{
var G__13081 = cljs.core.next.call(null,seq__13059__$1);
var G__13082 = null;
var G__13083 = 0;
var G__13084 = 0;
seq__13059 = G__13081;
chunk__13061 = G__13082;
count__13062 = G__13083;
i__13063 = G__13084;
continue;
}
}
}
} else
{return null;
}
}
break;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","on-tags-added","lt.objs.editor/on-tags-added",4259979625),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__on_tags_added,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("lt.object","tags-added","lt.object/tags-added",1756253556),null], null), null));
lt.objs.editor.__BEH__on_tags_removed = (function __BEH__on_tags_removed(this$,removed){var seq__13091 = cljs.core.seq.call(null,removed);var chunk__13093 = null;var count__13094 = 0;var i__13095 = 0;while(true){
if((i__13095 < count__13094))
{var r = cljs.core._nth.call(null,chunk__13093,i__13095);if(cljs.core.truth_(r))
{lt.objs.context.out_BANG_.call(null,r,this$);
{
var G__13097 = seq__13091;
var G__13098 = chunk__13093;
var G__13099 = count__13094;
var G__13100 = (i__13095 + 1);
seq__13091 = G__13097;
chunk__13093 = G__13098;
count__13094 = G__13099;
i__13095 = G__13100;
continue;
}
} else
{{
var G__13101 = seq__13091;
var G__13102 = chunk__13093;
var G__13103 = count__13094;
var G__13104 = (i__13095 + 1);
seq__13091 = G__13101;
chunk__13093 = G__13102;
count__13094 = G__13103;
i__13095 = G__13104;
continue;
}
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__13091);if(temp__4092__auto__)
{var seq__13091__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13091__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__13091__$1);{
var G__13105 = cljs.core.chunk_rest.call(null,seq__13091__$1);
var G__13106 = c__4262__auto__;
var G__13107 = cljs.core.count.call(null,c__4262__auto__);
var G__13108 = 0;
seq__13091 = G__13105;
chunk__13093 = G__13106;
count__13094 = G__13107;
i__13095 = G__13108;
continue;
}
} else
{var r = cljs.core.first.call(null,seq__13091__$1);if(cljs.core.truth_(r))
{lt.objs.context.out_BANG_.call(null,r,this$);
{
var G__13109 = cljs.core.next.call(null,seq__13091__$1);
var G__13110 = null;
var G__13111 = 0;
var G__13112 = 0;
seq__13091 = G__13109;
chunk__13093 = G__13110;
count__13094 = G__13111;
i__13095 = G__13112;
continue;
}
} else
{{
var G__13113 = cljs.core.next.call(null,seq__13091__$1);
var G__13114 = null;
var G__13115 = 0;
var G__13116 = 0;
seq__13091 = G__13113;
chunk__13093 = G__13114;
count__13094 = G__13115;
i__13095 = G__13116;
continue;
}
}
}
} else
{return null;
}
}
break;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","on-tags-removed","lt.objs.editor/on-tags-removed",2409922633),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__on_tags_removed,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null));
lt.objs.editor.__BEH__context_on_active = (function __BEH__context_on_active(obj){return lt.objs.context.in_BANG_.call(null,new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj)),obj);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","context-on-active","lt.objs.editor/context-on-active",643826709),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__context_on_active,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"active","active",3885920888),null], null), null));
lt.objs.editor.__BEH__context_on_inactive = (function __BEH__context_on_inactive(obj){var tags = new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj));var cur_editor = lt.objs.context.__GT_obj.call(null,new cljs.core.Keyword(null,"editor","editor",4001043679));lt.objs.context.out_BANG_.call(null,tags);
if(cljs.core.truth_((function (){var and__3508__auto__ = cur_editor;if(cljs.core.truth_(and__3508__auto__))
{return cljs.core.not_EQ_.call(null,cur_editor,obj);
} else
{return and__3508__auto__;
}
})()))
{lt.objs.context.in_BANG_.call(null,new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cur_editor)),cur_editor);
} else
{}
return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"deactivated","deactivated",3538760162));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","context-on-inactive","lt.objs.editor/context-on-inactive",1419388652),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__context_on_inactive,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"inactive","inactive",1038569437),null], null), null));
lt.objs.editor.__BEH__refresh_on_show = (function __BEH__refresh_on_show(obj){lt.objs.editor.refresh.call(null,new cljs.core.Keyword(null,"ed","ed",1013907473).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj)));
return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"focus!","focus!",4039653819));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","refresh-on-show","lt.objs.editor/refresh-on-show",2505854762),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__refresh_on_show,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"show","show",1017433711),null], null), null));
lt.objs.editor.__BEH__focus = (function __BEH__focus(obj){return lt.objs.editor.focus.call(null,new cljs.core.Keyword(null,"ed","ed",1013907473).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj)));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","focus","lt.objs.editor/focus",1575225175),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__focus,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"focus!","focus!",4039653819),null], null), null));
lt.objs.editor.__BEH__destroy_on_close = (function __BEH__destroy_on_close(obj){lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"closed","closed",3951351006));
return lt.object.destroy_BANG_.call(null,obj);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","destroy-on-close","lt.objs.editor/destroy-on-close",3987096430),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__destroy_on_close,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"close.force","close.force",4409585383),null], null), null));
lt.objs.editor.__BEH__highlight_current_line = (function __BEH__highlight_current_line(this$){return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"styleActiveLine","styleActiveLine",2621174813),true], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","highlight-current-line","lt.objs.editor/highlight-current-line",2698251298),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__highlight_current_line,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Highlight the current line",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),true);
/**
* @param {...*} var_args
*/
lt.objs.editor.__BEH__on_change = (function() { 
var __BEH__on_change__delegate = function (this$,cmd,args){return cljs.core.apply.call(null,lt.objs.command.exec_BANG_,cmd,args);
};
var __BEH__on_change = function (this$,cmd,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return __BEH__on_change__delegate.call(this,this$,cmd,args);};
__BEH__on_change.cljs$lang$maxFixedArity = 2;
__BEH__on_change.cljs$lang$applyTo = (function (arglist__13117){
var this$ = cljs.core.first(arglist__13117);
arglist__13117 = cljs.core.next(arglist__13117);
var cmd = cljs.core.first(arglist__13117);
var args = cljs.core.rest(arglist__13117);
return __BEH__on_change__delegate(this$,cmd,args);
});
__BEH__on_change.cljs$core$IFn$_invoke$arity$variadic = __BEH__on_change__delegate;
return __BEH__on_change;
})()
;
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","on-change","lt.objs.editor/on-change",936351949),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__on_change,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: On change execute command",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"command"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"change","change",3947235106),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"debounce","debounce",1556599227),300);
lt.objs.editor.__BEH__menu_BANG_ = (function __BEH__menu_BANG_(this$,e){var items_13118 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"order","order",1119910592),lt.object.raise_reduce.call(null,this$,new cljs.core.Keyword(null,"menu+","menu+",1117686302),cljs.core.PersistentVector.EMPTY));lt.objs.menu.show_menu.call(null,lt.objs.menu.menu.call(null,items_13118));
lt.util.dom.prevent.call(null,e);
return lt.util.dom.stop_propagation.call(null,e);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","menu!","lt.objs.editor/menu!",1447479681),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__menu_BANG_,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"menu!","menu!",1117686292),null], null), null));
lt.objs.editor.__BEH__copy_paste_menu_PLUS_ = (function __BEH__copy_paste_menu_PLUS_(this$,items){return cljs.core.conj.call(null,items,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"label","label",1116631654),"Copy",new cljs.core.Keyword(null,"order","order",1119910592),1,new cljs.core.Keyword(null,"enabled","enabled",3699277491),cljs.core.boolean$.call(null,lt.objs.editor.selection_QMARK_.call(null,this$)),new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.objs.editor.copy.call(null,this$);
})], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"label","label",1116631654),"Cut",new cljs.core.Keyword(null,"order","order",1119910592),2,new cljs.core.Keyword(null,"enabled","enabled",3699277491),cljs.core.boolean$.call(null,lt.objs.editor.selection_QMARK_.call(null,this$)),new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.objs.editor.cut.call(null,this$);
})], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"label","label",1116631654),"Paste",new cljs.core.Keyword(null,"order","order",1119910592),3,new cljs.core.Keyword(null,"enabled","enabled",3699277491),cljs.core.boolean$.call(null,!(cljs.core.empty_QMARK_.call(null,lt.objs.platform.paste.call(null)))),new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.objs.editor.paste.call(null,this$);
})], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1017479852),"separator",new cljs.core.Keyword(null,"order","order",1119910592),4], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"Select all",new cljs.core.Keyword(null,"order","order",1119910592),5,new cljs.core.Keyword(null,"click","click",1108654330),(function (){return lt.objs.editor.select_all.call(null,this$);
})], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","copy-paste-menu+","lt.objs.editor/copy-paste-menu+",3812291465),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__copy_paste_menu_PLUS_,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"menu+","menu+",1117686302),null], null), null));
/**
* Modes to not load on startup
*/
lt.objs.editor.mode_blacklist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["css",null,"clojure",null,"javascript",null,"htmlmixed",null,"htmlembedded",null,"python",null], null), null);
lt.objs.editor.__BEH__init_codemirror = (function __BEH__init_codemirror(this$){lt.util.load.js.call(null,"core/node_modules/codemirror/addon/edit/matchbrackets.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
lt.util.load.js.call(null,"core/node_modules/codemirror/addon/edit/closebrackets.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
lt.util.load.js.call(null,"core/node_modules/codemirror/addon/comment/comment.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
lt.util.load.js.call(null,"core/node_modules/codemirror/addon/selection/active-line.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
lt.util.load.js.call(null,"core/node_modules/codemirror_addons/overlay.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
lt.util.load.js.call(null,"core/node_modules/codemirror/addon/scroll/scrollpastend.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
var seq__13130_13140 = cljs.core.seq.call(null,lt.objs.files.ls.call(null,lt.objs.files.lt_home.call(null,"core/node_modules/codemirror/addon/fold")));var chunk__13132_13141 = null;var count__13133_13142 = 0;var i__13134_13143 = 0;while(true){
if((i__13134_13143 < count__13133_13142))
{var file_13144 = cljs.core._nth.call(null,chunk__13132_13141,i__13134_13143);if(cljs.core._EQ_.call(null,lt.objs.files.ext.call(null,file_13144),"js"))
{lt.util.load.js.call(null,[cljs.core.str("core/node_modules/codemirror/addon/fold/"),cljs.core.str(file_13144)].join(''),new cljs.core.Keyword(null,"sync","sync",1017449997));
{
var G__13145 = seq__13130_13140;
var G__13146 = chunk__13132_13141;
var G__13147 = count__13133_13142;
var G__13148 = (i__13134_13143 + 1);
seq__13130_13140 = G__13145;
chunk__13132_13141 = G__13146;
count__13133_13142 = G__13147;
i__13134_13143 = G__13148;
continue;
}
} else
{{
var G__13149 = seq__13130_13140;
var G__13150 = chunk__13132_13141;
var G__13151 = count__13133_13142;
var G__13152 = (i__13134_13143 + 1);
seq__13130_13140 = G__13149;
chunk__13132_13141 = G__13150;
count__13133_13142 = G__13151;
i__13134_13143 = G__13152;
continue;
}
}
} else
{var temp__4092__auto___13153 = cljs.core.seq.call(null,seq__13130_13140);if(temp__4092__auto___13153)
{var seq__13130_13154__$1 = temp__4092__auto___13153;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13130_13154__$1))
{var c__4262__auto___13155 = cljs.core.chunk_first.call(null,seq__13130_13154__$1);{
var G__13156 = cljs.core.chunk_rest.call(null,seq__13130_13154__$1);
var G__13157 = c__4262__auto___13155;
var G__13158 = cljs.core.count.call(null,c__4262__auto___13155);
var G__13159 = 0;
seq__13130_13140 = G__13156;
chunk__13132_13141 = G__13157;
count__13133_13142 = G__13158;
i__13134_13143 = G__13159;
continue;
}
} else
{var file_13160 = cljs.core.first.call(null,seq__13130_13154__$1);if(cljs.core._EQ_.call(null,lt.objs.files.ext.call(null,file_13160),"js"))
{lt.util.load.js.call(null,[cljs.core.str("core/node_modules/codemirror/addon/fold/"),cljs.core.str(file_13160)].join(''),new cljs.core.Keyword(null,"sync","sync",1017449997));
{
var G__13161 = cljs.core.next.call(null,seq__13130_13154__$1);
var G__13162 = null;
var G__13163 = 0;
var G__13164 = 0;
seq__13130_13140 = G__13161;
chunk__13132_13141 = G__13162;
count__13133_13142 = G__13163;
i__13134_13143 = G__13164;
continue;
}
} else
{{
var G__13165 = cljs.core.next.call(null,seq__13130_13154__$1);
var G__13166 = null;
var G__13167 = 0;
var G__13168 = 0;
seq__13130_13140 = G__13165;
chunk__13132_13141 = G__13166;
count__13133_13142 = G__13167;
i__13134_13143 = G__13168;
continue;
}
}
}
} else
{}
}
break;
}
lt.util.load.css.call(null,"node_modules/codemirror/addon/fold/foldgutter.css");
lt.util.load.js.call(null,"core/node_modules/codemirror/keymap/sublime.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
var seq__13136_13169 = cljs.core.seq.call(null,lt.objs.files.filter_walk.call(null,(function (p1__13119_SHARP_){return (cljs.core._EQ_.call(null,lt.objs.files.ext.call(null,p1__13119_SHARP_),"js")) && (cljs.core.not.call(null,cljs.core.some.call(null,(function (m){return (p1__13119_SHARP_.indexOf([cljs.core.str("core/node_modules/codemirror/mode/"),cljs.core.str(m),cljs.core.str("/")].join('')) > -1);
}),lt.objs.editor.mode_blacklist))) && (cljs.core.not.call(null,p1__13119_SHARP_.endsWith("test.js")));
}),lt.objs.files.lt_home.call(null,"core/node_modules/codemirror/mode")));var chunk__13137_13170 = null;var count__13138_13171 = 0;var i__13139_13172 = 0;while(true){
if((i__13139_13172 < count__13138_13171))
{var path_13173 = cljs.core._nth.call(null,chunk__13137_13170,i__13139_13172);lt.util.load.js.call(null,path_13173,new cljs.core.Keyword(null,"sync","sync",1017449997));
{
var G__13174 = seq__13136_13169;
var G__13175 = chunk__13137_13170;
var G__13176 = count__13138_13171;
var G__13177 = (i__13139_13172 + 1);
seq__13136_13169 = G__13174;
chunk__13137_13170 = G__13175;
count__13138_13171 = G__13176;
i__13139_13172 = G__13177;
continue;
}
} else
{var temp__4092__auto___13178 = cljs.core.seq.call(null,seq__13136_13169);if(temp__4092__auto___13178)
{var seq__13136_13179__$1 = temp__4092__auto___13178;if(cljs.core.chunked_seq_QMARK_.call(null,seq__13136_13179__$1))
{var c__4262__auto___13180 = cljs.core.chunk_first.call(null,seq__13136_13179__$1);{
var G__13181 = cljs.core.chunk_rest.call(null,seq__13136_13179__$1);
var G__13182 = c__4262__auto___13180;
var G__13183 = cljs.core.count.call(null,c__4262__auto___13180);
var G__13184 = 0;
seq__13136_13169 = G__13181;
chunk__13137_13170 = G__13182;
count__13138_13171 = G__13183;
i__13139_13172 = G__13184;
continue;
}
} else
{var path_13185 = cljs.core.first.call(null,seq__13136_13179__$1);lt.util.load.js.call(null,path_13185,new cljs.core.Keyword(null,"sync","sync",1017449997));
{
var G__13186 = cljs.core.next.call(null,seq__13136_13179__$1);
var G__13187 = null;
var G__13188 = 0;
var G__13189 = 0;
seq__13136_13169 = G__13186;
chunk__13137_13170 = G__13187;
count__13138_13171 = G__13188;
i__13139_13172 = G__13189;
continue;
}
}
} else
{}
}
break;
}
return (CodeMirror.keyMap.basic["Tab"] = lt.objs.editor.expand_tab);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","init-codemirror","lt.objs.editor/init-codemirror",2308508570),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__init_codemirror,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"init","init",1017141378),null], null), null));
lt.objs.editor.__BEH__load_addon = (function __BEH__load_addon(this$,path){var paths = cljs.core.map.call(null,(function (p1__13190_SHARP_){return lt.objs.files.join.call(null,lt.objs.files.lt_home.call(null),"core/node_modules/codemirror/addon",p1__13190_SHARP_);
}),((cljs.core.coll_QMARK_.call(null,path))?path:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [path], null)));lt.object.call_behavior_reaction.call(null,new cljs.core.Keyword("lt.objs.plugins","load-js","lt.objs.plugins/load-js",3701155451),this$,cljs.core.filter.call(null,(function (p1__13191_SHARP_){return cljs.core._EQ_.call(null,lt.objs.files.ext.call(null,p1__13191_SHARP_),"js");
}),paths));
return lt.object.call_behavior_reaction.call(null,new cljs.core.Keyword("lt.objs.plugins","load-css","lt.objs.plugins/load-css",934792943),this$,cljs.core.filter.call(null,(function (p1__13192_SHARP_){return cljs.core._EQ_.call(null,lt.objs.files.ext.call(null,p1__13192_SHARP_),"css");
}),paths));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","load-addon","lt.objs.editor/load-addon",3778832778),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__load_addon,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Load CodeMirror addon path(s)",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"path(s)",new cljs.core.Keyword(null,"example","example",3985900764),"edit/matchtags.js"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant-load","object.instant-load",4025433875),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.editor.__BEH__set_rulers = (function __BEH__set_rulers(this$,rulers){if(cljs.core.truth_(lt.objs.editor.__GT_cm_ed.call(null,this$).getOption("rulers")))
{} else
{lt.util.load.js.call(null,"core/node_modules/codemirror/addon/display/rulers.js",new cljs.core.Keyword(null,"sync","sync",1017449997));
}
var rulers__$1 = (function (){var or__3520__auto__ = rulers;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lineStyle","lineStyle",3501738383),"dashed",new cljs.core.Keyword(null,"color","color",1108746965),"#aff",new cljs.core.Keyword(null,"column","column",3954034376),80], null)], null);
}
})();return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"rulers","rulers",4388997551),cljs.core.clj__GT_js.call(null,rulers__$1)], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","set-rulers","lt.objs.editor/set-rulers",3148696167),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__set_rulers,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Set CodeMirror rulers",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"Vector of rulers",new cljs.core.Keyword(null,"example","example",3985900764),"[{:color \"#cfc\" :column 100 :lineStyle \"dashed\"}]"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.editor.__BEH__autoclose_brackets = (function __BEH__autoclose_brackets(this$,opts){if(cljs.core.truth_(opts))
{return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoCloseBrackets","autoCloseBrackets",4348439782),cljs.core.clj__GT_js.call(null,opts)], null));
} else
{return lt.objs.editor.set_options.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoCloseBrackets","autoCloseBrackets",4348439782),true], null));
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.editor","autoclose-brackets","lt.objs.editor/autoclose-brackets",2094848960),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.editor.__BEH__autoclose_brackets,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Enable autoclose brackets",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"map",new cljs.core.Keyword(null,"example","example",3985900764),"{:pairs \"()[]{}''\\\"\\\"\" :explode \"[]{}\"}"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
