// Compiled by ClojureScript 0.0-2138
goog.provide('lt.object');
goog.require('cljs.core');
goog.require('lt.util.dom');
goog.require('lt.util.js');
goog.require('crate.binding');
goog.require('lt.util.js');
goog.require('lt.util.dom');
goog.require('lt.util.cljs');
goog.require('crate.core');
goog.require('lt.util.dom');
goog.require('clojure.string');
goog.require('lt.util.cljs');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('crate.binding');
goog.require('clojure.set');
goog.require('crate.core');
/**
* Counter to guarantee unique object ids
*/
lt.object.obj_id = cljs.core.atom.call(null,0);
/**
* Map of object ids to objects created by object/create
*/
lt.object.instances = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
/**
* Map of behavior names to behaviors created by macros/behavior
*/
lt.object.behaviors = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
* Map of object template keys to template maps created by object/object*
*/
lt.object.object_defs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
* Map of tags to associated lists of behaviors
*/
lt.object.tags = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
* Map of tags to dissociated lists of behaviors e.g. :-behavior
*/
lt.object.negated_tags = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
* Metadata of current behavior set during raise and raise-reduce
*/
lt.object._STAR_behavior_meta_STAR_ = null;
lt.object.add = (function add(obj){return cljs.core.swap_BANG_.call(null,lt.object.object_defs,cljs.core.assoc,new cljs.core.Keyword("lt.object","type","lt.object/type",701613666).cljs$core$IFn$_invoke$arity$1(obj),obj);
});
lt.object.add_behavior = (function add_behavior(beh){return cljs.core.swap_BANG_.call(null,lt.object.behaviors,cljs.core.assoc,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(beh),beh);
});
/**
* Return id of given object
*/
lt.object.__GT_id = (function __GT_id(obj){if(crate.binding.deref_QMARK_.call(null,obj))
{return new cljs.core.Keyword("lt.object","id","lt.object/id",706431105).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj));
} else
{return new cljs.core.Keyword("lt.object","id","lt.object/id",706431105).cljs$core$IFn$_invoke$arity$1(obj);
}
});
lt.object.__GT_behavior_name = (function __GT_behavior_name(beh){if(cljs.core.coll_QMARK_.call(null,beh))
{return cljs.core.first.call(null,beh);
} else
{return beh;
}
});
lt.object.__GT_behavior = (function __GT_behavior(beh){return cljs.core.deref.call(null,lt.object.behaviors).call(null,lt.object.__GT_behavior_name.call(null,beh));
});
lt.object.__GT_triggers = (function __GT_triggers(behs){var result = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));var seq__5117_5129 = cljs.core.seq.call(null,behs);var chunk__5122_5130 = null;var count__5123_5131 = 0;var i__5124_5132 = 0;while(true){
if((i__5124_5132 < count__5123_5131))
{var beh_5133 = cljs.core._nth.call(null,chunk__5122_5130,i__5124_5132);var seq__5125_5134 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"triggers","triggers",2516997421).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,beh_5133)));var chunk__5126_5135 = null;var count__5127_5136 = 0;var i__5128_5137 = 0;while(true){
if((i__5128_5137 < count__5127_5136))
{var t_5138 = cljs.core._nth.call(null,chunk__5126_5135,i__5128_5137);cljs.core.swap_BANG_.call(null,result,cljs.core.assoc_BANG_,t_5138,cljs.core.conj.call(null,(function (){var or__3520__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,result),t_5138);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),beh_5133));
{
var G__5139 = seq__5125_5134;
var G__5140 = chunk__5126_5135;
var G__5141 = count__5127_5136;
var G__5142 = (i__5128_5137 + 1);
seq__5125_5134 = G__5139;
chunk__5126_5135 = G__5140;
count__5127_5136 = G__5141;
i__5128_5137 = G__5142;
continue;
}
} else
{var temp__4092__auto___5143 = cljs.core.seq.call(null,seq__5125_5134);if(temp__4092__auto___5143)
{var seq__5125_5144__$1 = temp__4092__auto___5143;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5125_5144__$1))
{var c__4262__auto___5145 = cljs.core.chunk_first.call(null,seq__5125_5144__$1);{
var G__5146 = cljs.core.chunk_rest.call(null,seq__5125_5144__$1);
var G__5147 = c__4262__auto___5145;
var G__5148 = cljs.core.count.call(null,c__4262__auto___5145);
var G__5149 = 0;
seq__5125_5134 = G__5146;
chunk__5126_5135 = G__5147;
count__5127_5136 = G__5148;
i__5128_5137 = G__5149;
continue;
}
} else
{var t_5150 = cljs.core.first.call(null,seq__5125_5144__$1);cljs.core.swap_BANG_.call(null,result,cljs.core.assoc_BANG_,t_5150,cljs.core.conj.call(null,(function (){var or__3520__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,result),t_5150);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),beh_5133));
{
var G__5151 = cljs.core.next.call(null,seq__5125_5144__$1);
var G__5152 = null;
var G__5153 = 0;
var G__5154 = 0;
seq__5125_5134 = G__5151;
chunk__5126_5135 = G__5152;
count__5127_5136 = G__5153;
i__5128_5137 = G__5154;
continue;
}
}
} else
{}
}
break;
}
{
var G__5155 = seq__5117_5129;
var G__5156 = chunk__5122_5130;
var G__5157 = count__5123_5131;
var G__5158 = (i__5124_5132 + 1);
seq__5117_5129 = G__5155;
chunk__5122_5130 = G__5156;
count__5123_5131 = G__5157;
i__5124_5132 = G__5158;
continue;
}
} else
{var temp__4092__auto___5159 = cljs.core.seq.call(null,seq__5117_5129);if(temp__4092__auto___5159)
{var seq__5117_5160__$1 = temp__4092__auto___5159;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5117_5160__$1))
{var c__4262__auto___5161 = cljs.core.chunk_first.call(null,seq__5117_5160__$1);{
var G__5162 = cljs.core.chunk_rest.call(null,seq__5117_5160__$1);
var G__5163 = c__4262__auto___5161;
var G__5164 = cljs.core.count.call(null,c__4262__auto___5161);
var G__5165 = 0;
seq__5117_5129 = G__5162;
chunk__5122_5130 = G__5163;
count__5123_5131 = G__5164;
i__5124_5132 = G__5165;
continue;
}
} else
{var beh_5166 = cljs.core.first.call(null,seq__5117_5160__$1);var seq__5118_5167 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"triggers","triggers",2516997421).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,beh_5166)));var chunk__5119_5168 = null;var count__5120_5169 = 0;var i__5121_5170 = 0;while(true){
if((i__5121_5170 < count__5120_5169))
{var t_5171 = cljs.core._nth.call(null,chunk__5119_5168,i__5121_5170);cljs.core.swap_BANG_.call(null,result,cljs.core.assoc_BANG_,t_5171,cljs.core.conj.call(null,(function (){var or__3520__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,result),t_5171);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),beh_5166));
{
var G__5172 = seq__5118_5167;
var G__5173 = chunk__5119_5168;
var G__5174 = count__5120_5169;
var G__5175 = (i__5121_5170 + 1);
seq__5118_5167 = G__5172;
chunk__5119_5168 = G__5173;
count__5120_5169 = G__5174;
i__5121_5170 = G__5175;
continue;
}
} else
{var temp__4092__auto___5176__$1 = cljs.core.seq.call(null,seq__5118_5167);if(temp__4092__auto___5176__$1)
{var seq__5118_5177__$1 = temp__4092__auto___5176__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5118_5177__$1))
{var c__4262__auto___5178 = cljs.core.chunk_first.call(null,seq__5118_5177__$1);{
var G__5179 = cljs.core.chunk_rest.call(null,seq__5118_5177__$1);
var G__5180 = c__4262__auto___5178;
var G__5181 = cljs.core.count.call(null,c__4262__auto___5178);
var G__5182 = 0;
seq__5118_5167 = G__5179;
chunk__5119_5168 = G__5180;
count__5120_5169 = G__5181;
i__5121_5170 = G__5182;
continue;
}
} else
{var t_5183 = cljs.core.first.call(null,seq__5118_5177__$1);cljs.core.swap_BANG_.call(null,result,cljs.core.assoc_BANG_,t_5183,cljs.core.conj.call(null,(function (){var or__3520__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,result),t_5183);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),beh_5166));
{
var G__5184 = cljs.core.next.call(null,seq__5118_5177__$1);
var G__5185 = null;
var G__5186 = 0;
var G__5187 = 0;
seq__5118_5167 = G__5184;
chunk__5119_5168 = G__5185;
count__5120_5169 = G__5186;
i__5121_5170 = G__5187;
continue;
}
}
} else
{}
}
break;
}
{
var G__5188 = cljs.core.next.call(null,seq__5117_5160__$1);
var G__5189 = null;
var G__5190 = 0;
var G__5191 = 0;
seq__5117_5129 = G__5188;
chunk__5122_5130 = G__5189;
count__5123_5131 = G__5190;
i__5124_5132 = G__5191;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,result));
});
lt.object.specificity_sort = (function() {
var specificity_sort = null;
var specificity_sort__1 = (function (xs){return specificity_sort.call(null,xs,null);
});
var specificity_sort__2 = (function (xs,dir){var arr = [];var seq__5196_5200 = cljs.core.seq.call(null,xs);var chunk__5197_5201 = null;var count__5198_5202 = 0;var i__5199_5203 = 0;while(true){
if((i__5199_5203 < count__5198_5202))
{var x_5204 = cljs.core._nth.call(null,chunk__5197_5201,i__5199_5203);arr.push([[cljs.core.str(x_5204)].join('').split(".").length,[cljs.core.str(x_5204)].join(''),x_5204]);
{
var G__5205 = seq__5196_5200;
var G__5206 = chunk__5197_5201;
var G__5207 = count__5198_5202;
var G__5208 = (i__5199_5203 + 1);
seq__5196_5200 = G__5205;
chunk__5197_5201 = G__5206;
count__5198_5202 = G__5207;
i__5199_5203 = G__5208;
continue;
}
} else
{var temp__4092__auto___5209 = cljs.core.seq.call(null,seq__5196_5200);if(temp__4092__auto___5209)
{var seq__5196_5210__$1 = temp__4092__auto___5209;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5196_5210__$1))
{var c__4262__auto___5211 = cljs.core.chunk_first.call(null,seq__5196_5210__$1);{
var G__5212 = cljs.core.chunk_rest.call(null,seq__5196_5210__$1);
var G__5213 = c__4262__auto___5211;
var G__5214 = cljs.core.count.call(null,c__4262__auto___5211);
var G__5215 = 0;
seq__5196_5200 = G__5212;
chunk__5197_5201 = G__5213;
count__5198_5202 = G__5214;
i__5199_5203 = G__5215;
continue;
}
} else
{var x_5216 = cljs.core.first.call(null,seq__5196_5210__$1);arr.push([[cljs.core.str(x_5216)].join('').split(".").length,[cljs.core.str(x_5216)].join(''),x_5216]);
{
var G__5217 = cljs.core.next.call(null,seq__5196_5210__$1);
var G__5218 = null;
var G__5219 = 0;
var G__5220 = 0;
seq__5196_5200 = G__5217;
chunk__5197_5201 = G__5218;
count__5198_5202 = G__5219;
i__5199_5203 = G__5220;
continue;
}
}
} else
{}
}
break;
}
arr.sort();
if(cljs.core.truth_(dir))
{} else
{arr.reverse();
}
var arr__3409__auto___5221 = arr;var i_5222 = 0;while(true){
if((i_5222 < arr__3409__auto___5221.length))
{(arr[i_5222] = (arr[i_5222][2]));
{
var G__5223 = (i_5222 + 1);
i_5222 = G__5223;
continue;
}
} else
{}
break;
}
return arr;
});
specificity_sort = function(xs,dir){
switch(arguments.length){
case 1:
return specificity_sort__1.call(this,xs);
case 2:
return specificity_sort__2.call(this,xs,dir);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
specificity_sort.cljs$core$IFn$_invoke$arity$1 = specificity_sort__1;
specificity_sort.cljs$core$IFn$_invoke$arity$2 = specificity_sort__2;
return specificity_sort;
})()
;
lt.object.ts__GT_negations = (function ts__GT_negations(ts){var seen = (function (){var obj5231 = {};return obj5231;
})();var seq__5232_5236 = cljs.core.seq.call(null,cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,cljs.core.deref.call(null,lt.object.negated_tags),ts)));var chunk__5233_5237 = null;var count__5234_5238 = 0;var i__5235_5239 = 0;while(true){
if((i__5235_5239 < count__5234_5238))
{var beh_5240 = cljs.core._nth.call(null,chunk__5233_5237,i__5235_5239);(seen[lt.object.__GT_behavior_name.call(null,beh_5240)] = true);
{
var G__5241 = seq__5232_5236;
var G__5242 = chunk__5233_5237;
var G__5243 = count__5234_5238;
var G__5244 = (i__5235_5239 + 1);
seq__5232_5236 = G__5241;
chunk__5233_5237 = G__5242;
count__5234_5238 = G__5243;
i__5235_5239 = G__5244;
continue;
}
} else
{var temp__4092__auto___5245 = cljs.core.seq.call(null,seq__5232_5236);if(temp__4092__auto___5245)
{var seq__5232_5246__$1 = temp__4092__auto___5245;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5232_5246__$1))
{var c__4262__auto___5247 = cljs.core.chunk_first.call(null,seq__5232_5246__$1);{
var G__5248 = cljs.core.chunk_rest.call(null,seq__5232_5246__$1);
var G__5249 = c__4262__auto___5247;
var G__5250 = cljs.core.count.call(null,c__4262__auto___5247);
var G__5251 = 0;
seq__5232_5236 = G__5248;
chunk__5233_5237 = G__5249;
count__5234_5238 = G__5250;
i__5235_5239 = G__5251;
continue;
}
} else
{var beh_5252 = cljs.core.first.call(null,seq__5232_5246__$1);(seen[lt.object.__GT_behavior_name.call(null,beh_5252)] = true);
{
var G__5253 = cljs.core.next.call(null,seq__5232_5246__$1);
var G__5254 = null;
var G__5255 = 0;
var G__5256 = 0;
seq__5232_5236 = G__5253;
chunk__5233_5237 = G__5254;
count__5234_5238 = G__5255;
i__5235_5239 = G__5256;
continue;
}
}
} else
{}
}
break;
}
return seen;
});
lt.object.tags__GT_behaviors = (function tags__GT_behaviors(ts){var duped = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,cljs.core.deref.call(null,lt.object.tags),lt.object.specificity_sort.call(null,ts)));var de_duped = cljs.core.reduce.call(null,((function (duped){
return (function (res,cur){if(cljs.core.truth_((new cljs.core.Keyword(null,"seen","seen",1017430509).cljs$core$IFn$_invoke$arity$1(res)[lt.object.__GT_behavior_name.call(null,cur)])))
{return res;
} else
{var beh = lt.object.__GT_behavior.call(null,cur);if(cljs.core.truth_(new cljs.core.Keyword(null,"exclusive","exclusive",2700522000).cljs$core$IFn$_invoke$arity$1(beh)))
{if(cljs.core.coll_QMARK_.call(null,new cljs.core.Keyword(null,"exclusive","exclusive",2700522000).cljs$core$IFn$_invoke$arity$1(beh)))
{var seq__5261_5265 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"exclusive","exclusive",2700522000).cljs$core$IFn$_invoke$arity$1(beh));var chunk__5262_5266 = null;var count__5263_5267 = 0;var i__5264_5268 = 0;while(true){
if((i__5264_5268 < count__5263_5267))
{var exclude_5269 = cljs.core._nth.call(null,chunk__5262_5266,i__5264_5268);(new cljs.core.Keyword(null,"seen","seen",1017430509).cljs$core$IFn$_invoke$arity$1(res)[exclude_5269] = true);
{
var G__5270 = seq__5261_5265;
var G__5271 = chunk__5262_5266;
var G__5272 = count__5263_5267;
var G__5273 = (i__5264_5268 + 1);
seq__5261_5265 = G__5270;
chunk__5262_5266 = G__5271;
count__5263_5267 = G__5272;
i__5264_5268 = G__5273;
continue;
}
} else
{var temp__4092__auto___5274 = cljs.core.seq.call(null,seq__5261_5265);if(temp__4092__auto___5274)
{var seq__5261_5275__$1 = temp__4092__auto___5274;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5261_5275__$1))
{var c__4262__auto___5276 = cljs.core.chunk_first.call(null,seq__5261_5275__$1);{
var G__5277 = cljs.core.chunk_rest.call(null,seq__5261_5275__$1);
var G__5278 = c__4262__auto___5276;
var G__5279 = cljs.core.count.call(null,c__4262__auto___5276);
var G__5280 = 0;
seq__5261_5265 = G__5277;
chunk__5262_5266 = G__5278;
count__5263_5267 = G__5279;
i__5264_5268 = G__5280;
continue;
}
} else
{var exclude_5281 = cljs.core.first.call(null,seq__5261_5275__$1);(new cljs.core.Keyword(null,"seen","seen",1017430509).cljs$core$IFn$_invoke$arity$1(res)[exclude_5281] = true);
{
var G__5282 = cljs.core.next.call(null,seq__5261_5275__$1);
var G__5283 = null;
var G__5284 = 0;
var G__5285 = 0;
seq__5261_5265 = G__5282;
chunk__5262_5266 = G__5283;
count__5263_5267 = G__5284;
i__5264_5268 = G__5285;
continue;
}
}
} else
{}
}
break;
}
} else
{}
(new cljs.core.Keyword(null,"seen","seen",1017430509).cljs$core$IFn$_invoke$arity$1(res)[lt.object.__GT_behavior_name.call(null,cur)] = true);
} else
{}
cljs.core.conj_BANG_.call(null,new cljs.core.Keyword(null,"final","final",1111340264).cljs$core$IFn$_invoke$arity$1(res),cur);
return res;
}
});})(duped))
,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",1017430509),lt.object.ts__GT_negations.call(null,ts),new cljs.core.Keyword(null,"final","final",1111340264),cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY)], null),duped);return cljs.core.reverse.call(null,cljs.core.persistent_BANG_.call(null,new cljs.core.Keyword(null,"final","final",1111340264).cljs$core$IFn$_invoke$arity$1(de_duped)));
});
lt.object.trigger__GT_behaviors = (function trigger__GT_behaviors(trig,ts){return cljs.core.get.call(null,lt.object.__GT_triggers.call(null,lt.object.tags__GT_behaviors.call(null,ts)),trig);
});
lt.object.safe_report_error = (function safe_report_error(e){if(cljs.core.truth_(lt.objs.console))
{return lt.objs.console.error(e);
} else
{return console.error(((typeof e === 'string')?e:e.stack));
}
});
lt.object.raise_STAR_ = (function() {
var raise_STAR_ = null;
var raise_STAR___3 = (function (obj,reactions,args){return raise_STAR_.call(null,obj,reactions,args,null);
});
var raise_STAR___4 = (function (obj,reactions,args,trigger){var seq__5300 = cljs.core.seq.call(null,reactions);var chunk__5303 = null;var count__5304 = 0;var i__5305 = 0;while(true){
if((i__5305 < count__5304))
{var r = cljs.core._nth.call(null,chunk__5303,i__5305);var func = new cljs.core.Keyword(null,"reaction","reaction",4441361819).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,r));var args__$1 = ((cljs.core.coll_QMARK_.call(null,r))?cljs.core.concat.call(null,cljs.core.rest.call(null,r),args):args);var meta = ((cljs.core.coll_QMARK_.call(null,r))?cljs.core.meta.call(null,r):cljs.core.PersistentArrayMap.EMPTY);if(cljs.core.truth_(func))
{try{var start5309_5314 = (new Date()).getTime();var _STAR_behavior_meta_STAR_5310_5315 = lt.object._STAR_behavior_meta_STAR_;try{lt.object._STAR_behavior_meta_STAR_ = meta;
cljs.core.apply.call(null,func,obj,args__$1);
}finally {lt.object._STAR_behavior_meta_STAR_ = _STAR_behavior_meta_STAR_5310_5315;
}if(cljs.core._EQ_.call(null,trigger,new cljs.core.Keyword(null,"object.behavior.time","object.behavior.time",854340588)))
{} else
{lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"object.behavior.time","object.behavior.time",854340588),r,((new Date()).getTime() - start5309_5314),trigger);
}
}catch (e5308){var e_5316 = e5308;lt.object.safe_report_error.call(null,[cljs.core.str("Invalid behavior: "),cljs.core.str(new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,r)))].join(''));
lt.object.safe_report_error.call(null,e_5316);
}{
var G__5317 = seq__5300;
var G__5318 = chunk__5303;
var G__5319 = count__5304;
var G__5320 = (i__5305 + 1);
seq__5300 = G__5317;
chunk__5303 = G__5318;
count__5304 = G__5319;
i__5305 = G__5320;
continue;
}
} else
{{
var G__5321 = seq__5300;
var G__5322 = chunk__5303;
var G__5323 = count__5304;
var G__5324 = (i__5305 + 1);
seq__5300 = G__5321;
chunk__5303 = G__5322;
count__5304 = G__5323;
i__5305 = G__5324;
continue;
}
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__5300);if(temp__4092__auto__)
{var seq__5300__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5300__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__5300__$1);{
var G__5325 = cljs.core.chunk_rest.call(null,seq__5300__$1);
var G__5326 = c__4262__auto__;
var G__5327 = cljs.core.count.call(null,c__4262__auto__);
var G__5328 = 0;
seq__5300 = G__5325;
chunk__5303 = G__5326;
count__5304 = G__5327;
i__5305 = G__5328;
continue;
}
} else
{var r = cljs.core.first.call(null,seq__5300__$1);var func = new cljs.core.Keyword(null,"reaction","reaction",4441361819).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,r));var args__$1 = ((cljs.core.coll_QMARK_.call(null,r))?cljs.core.concat.call(null,cljs.core.rest.call(null,r),args):args);var meta = ((cljs.core.coll_QMARK_.call(null,r))?cljs.core.meta.call(null,r):cljs.core.PersistentArrayMap.EMPTY);if(cljs.core.truth_(func))
{try{var start5312_5329 = (new Date()).getTime();var _STAR_behavior_meta_STAR_5313_5330 = lt.object._STAR_behavior_meta_STAR_;try{lt.object._STAR_behavior_meta_STAR_ = meta;
cljs.core.apply.call(null,func,obj,args__$1);
}finally {lt.object._STAR_behavior_meta_STAR_ = _STAR_behavior_meta_STAR_5313_5330;
}if(cljs.core._EQ_.call(null,trigger,new cljs.core.Keyword(null,"object.behavior.time","object.behavior.time",854340588)))
{} else
{lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"object.behavior.time","object.behavior.time",854340588),r,((new Date()).getTime() - start5312_5329),trigger);
}
}catch (e5311){var e_5331 = e5311;lt.object.safe_report_error.call(null,[cljs.core.str("Invalid behavior: "),cljs.core.str(new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,r)))].join(''));
lt.object.safe_report_error.call(null,e_5331);
}{
var G__5332 = cljs.core.next.call(null,seq__5300__$1);
var G__5333 = null;
var G__5334 = 0;
var G__5335 = 0;
seq__5300 = G__5332;
chunk__5303 = G__5333;
count__5304 = G__5334;
i__5305 = G__5335;
continue;
}
} else
{{
var G__5336 = cljs.core.next.call(null,seq__5300__$1);
var G__5337 = null;
var G__5338 = 0;
var G__5339 = 0;
seq__5300 = G__5336;
chunk__5303 = G__5337;
count__5304 = G__5338;
i__5305 = G__5339;
continue;
}
}
}
} else
{return null;
}
}
break;
}
});
raise_STAR_ = function(obj,reactions,args,trigger){
switch(arguments.length){
case 3:
return raise_STAR___3.call(this,obj,reactions,args);
case 4:
return raise_STAR___4.call(this,obj,reactions,args,trigger);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
raise_STAR_.cljs$core$IFn$_invoke$arity$3 = raise_STAR___3;
raise_STAR_.cljs$core$IFn$_invoke$arity$4 = raise_STAR___4;
return raise_STAR_;
})()
;
/**
* Invoke object's behavior fns for given trigger. Args are passed to behavior fns
* @param {...*} var_args
*/
lt.object.raise = (function() { 
var raise__delegate = function (obj,k,args){var reactions = k.call(null,new cljs.core.Keyword(null,"listeners","listeners",4090152369).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj)));return lt.object.raise_STAR_.call(null,obj,reactions,args,k);
};
var raise = function (obj,k,var_args){
var args = null;if (arguments.length > 2) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return raise__delegate.call(this,obj,k,args);};
raise.cljs$lang$maxFixedArity = 2;
raise.cljs$lang$applyTo = (function (arglist__5340){
var obj = cljs.core.first(arglist__5340);
arglist__5340 = cljs.core.next(arglist__5340);
var k = cljs.core.first(arglist__5340);
var args = cljs.core.rest(arglist__5340);
return raise__delegate(obj,k,args);
});
raise.cljs$core$IFn$_invoke$arity$variadic = raise__delegate;
return raise;
})()
;
/**
* For a given behavior keyword id, call its :reaction fn with given args
* @param {...*} var_args
*/
lt.object.call_behavior_reaction = (function() { 
var call_behavior_reaction__delegate = function (id,args){var behavior_fn = new cljs.core.Keyword(null,"reaction","reaction",4441361819).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,id));if(cljs.core.truth_(behavior_fn))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"behavior-fn","behavior-fn",-1300659236,null)))].join('')));
}
return cljs.core.apply.call(null,behavior_fn,args);
};
var call_behavior_reaction = function (id,var_args){
var args = null;if (arguments.length > 1) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return call_behavior_reaction__delegate.call(this,id,args);};
call_behavior_reaction.cljs$lang$maxFixedArity = 1;
call_behavior_reaction.cljs$lang$applyTo = (function (arglist__5341){
var id = cljs.core.first(arglist__5341);
var args = cljs.core.rest(arglist__5341);
return call_behavior_reaction__delegate(id,args);
});
call_behavior_reaction.cljs$core$IFn$_invoke$arity$variadic = call_behavior_reaction__delegate;
return call_behavior_reaction;
})()
;
lt.object.update_listeners = (function() {
var update_listeners = null;
var update_listeners__1 = (function (obj){return update_listeners.call(null,obj,null);
});
var update_listeners__2 = (function (obj,instants){var cur = cljs.core.deref.call(null,obj);var behs = cljs.core.set.call(null,cljs.core.concat.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",607554515).cljs$core$IFn$_invoke$arity$1(cur),lt.object.tags__GT_behaviors.call(null,new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cur))));var trigs = lt.object.__GT_triggers.call(null,behs);var trigs__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"object.instant-load","object.instant-load",4025433875).cljs$core$IFn$_invoke$arity$1(trigs))?(function (){lt.object.raise_STAR_.call(null,obj,new cljs.core.Keyword(null,"object.instant-load","object.instant-load",4025433875).cljs$core$IFn$_invoke$arity$1(trigs),null,new cljs.core.Keyword(null,"object.instant-load","object.instant-load",4025433875));
return lt.object.__GT_triggers.call(null,behs);
})():trigs);var trigs__$2 = (cljs.core.truth_(instants)?trigs__$1:cljs.core.dissoc.call(null,trigs__$1,new cljs.core.Keyword(null,"object.instant","object.instant",773332388),new cljs.core.Keyword(null,"object.instant-load","object.instant-load",4025433875)));return cljs.core.assoc.call(null,cljs.core.deref.call(null,obj),new cljs.core.Keyword(null,"listeners","listeners",4090152369),trigs__$2);
});
update_listeners = function(obj,instants){
switch(arguments.length){
case 1:
return update_listeners__1.call(this,obj);
case 2:
return update_listeners__2.call(this,obj,instants);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update_listeners.cljs$core$IFn$_invoke$arity$1 = update_listeners__1;
update_listeners.cljs$core$IFn$_invoke$arity$2 = update_listeners__2;
return update_listeners;
})()
;
/**
* @param {...*} var_args
*/
lt.object.make_object_STAR_ = (function() { 
var make_object_STAR___delegate = function (name,r){var obj = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"behaviors","behaviors",607554515),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"tags","tags",1017456523),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"triggers","triggers",2516997421),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",4090152369),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("lt.object","type","lt.object/type",701613666),name,new cljs.core.Keyword(null,"children","children",2673430897),cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.apply.call(null,cljs.core.hash_map,r));return obj;
};
var make_object_STAR_ = function (name,var_args){
var r = null;if (arguments.length > 1) {
  r = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return make_object_STAR___delegate.call(this,name,r);};
make_object_STAR_.cljs$lang$maxFixedArity = 1;
make_object_STAR_.cljs$lang$applyTo = (function (arglist__5342){
var name = cljs.core.first(arglist__5342);
var r = cljs.core.rest(arglist__5342);
return make_object_STAR___delegate(name,r);
});
make_object_STAR_.cljs$core$IFn$_invoke$arity$variadic = make_object_STAR___delegate;
return make_object_STAR_;
})()
;
lt.object.store_object_STAR_ = (function store_object_STAR_(obj){lt.object.add.call(null,obj);
return obj;
});
/**
* Return all objects for given type (template name)
*/
lt.object.instances_by_type = (function instances_by_type(type){return cljs.core.filter.call(null,(function (p1__5343_SHARP_){return cljs.core._EQ_.call(null,type,new cljs.core.Keyword("lt.object","type","lt.object/type",701613666).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,p1__5343_SHARP_)));
}),cljs.core.vals.call(null,cljs.core.deref.call(null,lt.object.instances)));
});
/**
* Merge map into object
*/
lt.object.merge_BANG_ = (function merge_BANG_(obj,m){if(cljs.core.truth_((function (){var and__3508__auto__ = m;if(cljs.core.truth_(and__3508__auto__))
{return !(cljs.core.map_QMARK_.call(null,m));
} else
{return and__3508__auto__;
}
})()))
{throw (new Error([cljs.core.str("Merge requires a map: "),cljs.core.str(m)].join('')));
} else
{}
return cljs.core.swap_BANG_.call(null,obj,cljs.core.merge,m);
});
lt.object.handle_redef = (function handle_redef(odef){var id = new cljs.core.Keyword("lt.object","type","lt.object/type",701613666).cljs$core$IFn$_invoke$arity$1(odef);var seq__5350_5356 = cljs.core.seq.call(null,lt.object.instances_by_type.call(null,id));var chunk__5352_5357 = null;var count__5353_5358 = 0;var i__5354_5359 = 0;while(true){
if((i__5354_5359 < count__5353_5358))
{var o_5360 = cljs.core._nth.call(null,chunk__5352_5357,i__5354_5359);var o_5361__$1 = cljs.core.deref.call(null,o_5360);var args_5362 = new cljs.core.Keyword(null,"args","args",1016906831).cljs$core$IFn$_invoke$arity$1(o_5361__$1);var old_5363 = new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(o_5361__$1);var behs_5364 = cljs.core.set.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",607554515).cljs$core$IFn$_invoke$arity$1(o_5361__$1));var inst_5365 = cljs.core.deref.call(null,lt.object.instances).call(null,lt.object.__GT_id.call(null,o_5361__$1));var neue_5366 = (cljs.core.truth_(new cljs.core.Keyword(null,"init","init",1017141378).cljs$core$IFn$_invoke$arity$1(odef))?cljs.core.apply.call(null,new cljs.core.Keyword(null,"init","init",1017141378).cljs$core$IFn$_invoke$arity$1(odef),inst_5365,args_5362):null);var neue_5367__$1 = ((cljs.core.vector_QMARK_.call(null,neue_5366))?crate.core.html.call(null,neue_5366):neue_5366);lt.object.merge_BANG_.call(null,inst_5365,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tags","tags",1017456523),clojure.set.union.call(null,new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(o_5361__$1),new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(odef)),new cljs.core.Keyword(null,"behaviors","behaviors",607554515),clojure.set.union.call(null,behs_5364,cljs.core.set.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",607554515).cljs$core$IFn$_invoke$arity$1(odef))),new cljs.core.Keyword(null,"content","content",1965434859),neue_5367__$1], null));
lt.object.merge_BANG_.call(null,inst_5365,lt.object.update_listeners.call(null,inst_5365));
if(cljs.core.truth_((function (){var and__3508__auto__ = old_5363;if(cljs.core.truth_(and__3508__auto__))
{return neue_5367__$1;
} else
{return and__3508__auto__;
}
})()))
{lt.util.dom.replace_with.call(null,old_5363,neue_5367__$1);
} else
{}
lt.object.raise.call(null,inst_5365,new cljs.core.Keyword(null,"redef","redef",1122293860));
{
var G__5368 = seq__5350_5356;
var G__5369 = chunk__5352_5357;
var G__5370 = count__5353_5358;
var G__5371 = (i__5354_5359 + 1);
seq__5350_5356 = G__5368;
chunk__5352_5357 = G__5369;
count__5353_5358 = G__5370;
i__5354_5359 = G__5371;
continue;
}
} else
{var temp__4092__auto___5372 = cljs.core.seq.call(null,seq__5350_5356);if(temp__4092__auto___5372)
{var seq__5350_5373__$1 = temp__4092__auto___5372;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5350_5373__$1))
{var c__4262__auto___5374 = cljs.core.chunk_first.call(null,seq__5350_5373__$1);{
var G__5375 = cljs.core.chunk_rest.call(null,seq__5350_5373__$1);
var G__5376 = c__4262__auto___5374;
var G__5377 = cljs.core.count.call(null,c__4262__auto___5374);
var G__5378 = 0;
seq__5350_5356 = G__5375;
chunk__5352_5357 = G__5376;
count__5353_5358 = G__5377;
i__5354_5359 = G__5378;
continue;
}
} else
{var o_5379 = cljs.core.first.call(null,seq__5350_5373__$1);var o_5380__$1 = cljs.core.deref.call(null,o_5379);var args_5381 = new cljs.core.Keyword(null,"args","args",1016906831).cljs$core$IFn$_invoke$arity$1(o_5380__$1);var old_5382 = new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(o_5380__$1);var behs_5383 = cljs.core.set.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",607554515).cljs$core$IFn$_invoke$arity$1(o_5380__$1));var inst_5384 = cljs.core.deref.call(null,lt.object.instances).call(null,lt.object.__GT_id.call(null,o_5380__$1));var neue_5385 = (cljs.core.truth_(new cljs.core.Keyword(null,"init","init",1017141378).cljs$core$IFn$_invoke$arity$1(odef))?cljs.core.apply.call(null,new cljs.core.Keyword(null,"init","init",1017141378).cljs$core$IFn$_invoke$arity$1(odef),inst_5384,args_5381):null);var neue_5386__$1 = ((cljs.core.vector_QMARK_.call(null,neue_5385))?crate.core.html.call(null,neue_5385):neue_5385);lt.object.merge_BANG_.call(null,inst_5384,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tags","tags",1017456523),clojure.set.union.call(null,new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(o_5380__$1),new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(odef)),new cljs.core.Keyword(null,"behaviors","behaviors",607554515),clojure.set.union.call(null,behs_5383,cljs.core.set.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",607554515).cljs$core$IFn$_invoke$arity$1(odef))),new cljs.core.Keyword(null,"content","content",1965434859),neue_5386__$1], null));
lt.object.merge_BANG_.call(null,inst_5384,lt.object.update_listeners.call(null,inst_5384));
if(cljs.core.truth_((function (){var and__3508__auto__ = old_5382;if(cljs.core.truth_(and__3508__auto__))
{return neue_5386__$1;
} else
{return and__3508__auto__;
}
})()))
{lt.util.dom.replace_with.call(null,old_5382,neue_5386__$1);
} else
{}
lt.object.raise.call(null,inst_5384,new cljs.core.Keyword(null,"redef","redef",1122293860));
{
var G__5387 = cljs.core.next.call(null,seq__5350_5373__$1);
var G__5388 = null;
var G__5389 = 0;
var G__5390 = 0;
seq__5350_5356 = G__5387;
chunk__5352_5357 = G__5388;
count__5353_5358 = G__5389;
i__5354_5359 = G__5390;
continue;
}
}
} else
{}
}
break;
}
return id;
});
/**
* Create object template (type) given keyword name and key-value pairs.
* These pairs serve as default attributes for an object. Following keys
* have special meaning:
* 
* * :behaviors - Set of object's behaviors
* * :tags - Set of object's tags
* * :triggers - Set of object's triggers
* * :init - Init fn called when object is created. Fn's return value
* is hiccup html content and saved to :content
* * :listeners (internal) - Map of triggers to vectors of behaviors
* @param {...*} var_args
*/
lt.object.object_STAR_ = (function() { 
var object_STAR___delegate = function (name,r){return lt.object.handle_redef.call(null,lt.object.store_object_STAR_.call(null,cljs.core.apply.call(null,lt.object.make_object_STAR_,name,r)));
};
var object_STAR_ = function (name,var_args){
var r = null;if (arguments.length > 1) {
  r = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return object_STAR___delegate.call(this,name,r);};
object_STAR_.cljs$lang$maxFixedArity = 1;
object_STAR_.cljs$lang$applyTo = (function (arglist__5391){
var name = cljs.core.first(arglist__5391);
var r = cljs.core.rest(arglist__5391);
return object_STAR___delegate(name,r);
});
object_STAR_.cljs$core$IFn$_invoke$arity$variadic = object_STAR___delegate;
return object_STAR_;
})()
;
/**
* @param {...*} var_args
*/
lt.object.make_behavior_STAR_ = (function() { 
var make_behavior_STAR___delegate = function (name,r){var be = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1017277949),name], null),cljs.core.apply.call(null,cljs.core.hash_map,r));return be;
};
var make_behavior_STAR_ = function (name,var_args){
var r = null;if (arguments.length > 1) {
  r = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return make_behavior_STAR___delegate.call(this,name,r);};
make_behavior_STAR_.cljs$lang$maxFixedArity = 1;
make_behavior_STAR_.cljs$lang$applyTo = (function (arglist__5392){
var name = cljs.core.first(arglist__5392);
var r = cljs.core.rest(arglist__5392);
return make_behavior_STAR___delegate(name,r);
});
make_behavior_STAR_.cljs$core$IFn$_invoke$arity$variadic = make_behavior_STAR___delegate;
return make_behavior_STAR_;
})()
;
lt.object.store_behavior_STAR_ = (function store_behavior_STAR_(beh){lt.object.add_behavior.call(null,beh);
return new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(beh);
});
lt.object.wrap_throttle = (function wrap_throttle(beh){var temp__4090__auto__ = new cljs.core.Keyword(null,"throttle","throttle",2497347228).cljs$core$IFn$_invoke$arity$1(beh);if(cljs.core.truth_(temp__4090__auto__))
{var thr = temp__4090__auto__;return cljs.core.assoc.call(null,beh,new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.util.js.throttle.call(null,thr,new cljs.core.Keyword(null,"reaction","reaction",4441361819).cljs$core$IFn$_invoke$arity$1(beh)));
} else
{return beh;
}
});
lt.object.wrap_debounce = (function wrap_debounce(beh){var temp__4090__auto__ = new cljs.core.Keyword(null,"debounce","debounce",1556599227).cljs$core$IFn$_invoke$arity$1(beh);if(cljs.core.truth_(temp__4090__auto__))
{var thr = temp__4090__auto__;return cljs.core.assoc.call(null,beh,new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.util.js.debounce.call(null,thr,new cljs.core.Keyword(null,"reaction","reaction",4441361819).cljs$core$IFn$_invoke$arity$1(beh)));
} else
{return beh;
}
});
/**
* @param {...*} var_args
*/
lt.object.behavior_STAR_ = (function() { 
var behavior_STAR___delegate = function (name,r){return lt.object.store_behavior_STAR_.call(null,lt.object.wrap_debounce.call(null,lt.object.wrap_throttle.call(null,cljs.core.apply.call(null,lt.object.make_behavior_STAR_,name,r))));
};
var behavior_STAR_ = function (name,var_args){
var r = null;if (arguments.length > 1) {
  r = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return behavior_STAR___delegate.call(this,name,r);};
behavior_STAR_.cljs$lang$maxFixedArity = 1;
behavior_STAR_.cljs$lang$applyTo = (function (arglist__5393){
var name = cljs.core.first(arglist__5393);
var r = cljs.core.rest(arglist__5393);
return behavior_STAR___delegate(name,r);
});
behavior_STAR_.cljs$core$IFn$_invoke$arity$variadic = behavior_STAR___delegate;
return behavior_STAR_;
})()
;
/**
* Reduce over invoked object's behavior fns for given trigger. Start
* is initial value for reduce and any args are passed to behavior fn
* @param {...*} var_args
*/
lt.object.raise_reduce = (function() { 
var raise_reduce__delegate = function (obj,k,start,args){var reactions = k.call(null,new cljs.core.Keyword(null,"listeners","listeners",4090152369).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj)));return cljs.core.reduce.call(null,(function (res,cur){var func = new cljs.core.Keyword(null,"reaction","reaction",4441361819).cljs$core$IFn$_invoke$arity$1(lt.object.__GT_behavior.call(null,cur));var args__$1 = ((cljs.core.coll_QMARK_.call(null,cur))?cljs.core.concat.call(null,cljs.core.rest.call(null,cur),args):args);var meta = ((cljs.core.coll_QMARK_.call(null,cur))?cljs.core.meta.call(null,cur):cljs.core.PersistentArrayMap.EMPTY);if(cljs.core.not.call(null,func))
{return res;
} else
{var _STAR_behavior_meta_STAR_5395 = lt.object._STAR_behavior_meta_STAR_;try{lt.object._STAR_behavior_meta_STAR_ = meta;
return cljs.core.apply.call(null,func,obj,res,args__$1);
}finally {lt.object._STAR_behavior_meta_STAR_ = _STAR_behavior_meta_STAR_5395;
}}
}),start,reactions);
};
var raise_reduce = function (obj,k,start,var_args){
var args = null;if (arguments.length > 3) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);} 
return raise_reduce__delegate.call(this,obj,k,start,args);};
raise_reduce.cljs$lang$maxFixedArity = 3;
raise_reduce.cljs$lang$applyTo = (function (arglist__5396){
var obj = cljs.core.first(arglist__5396);
arglist__5396 = cljs.core.next(arglist__5396);
var k = cljs.core.first(arglist__5396);
arglist__5396 = cljs.core.next(arglist__5396);
var start = cljs.core.first(arglist__5396);
var args = cljs.core.rest(arglist__5396);
return raise_reduce__delegate(obj,k,start,args);
});
raise_reduce.cljs$core$IFn$_invoke$arity$variadic = raise_reduce__delegate;
return raise_reduce;
})()
;
/**
* Update object with update-in with [:key], fn and args
* @param {...*} var_args
*/
lt.object.update_BANG_ = (function() { 
var update_BANG___delegate = function (obj,r){return cljs.core.swap_BANG_.call(null,obj,(function (p1__5397_SHARP_){return cljs.core.apply.call(null,cljs.core.update_in,p1__5397_SHARP_,r);
}));
};
var update_BANG_ = function (obj,var_args){
var r = null;if (arguments.length > 1) {
  r = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return update_BANG___delegate.call(this,obj,r);};
update_BANG_.cljs$lang$maxFixedArity = 1;
update_BANG_.cljs$lang$applyTo = (function (arglist__5398){
var obj = cljs.core.first(arglist__5398);
var r = cljs.core.rest(arglist__5398);
return update_BANG___delegate(obj,r);
});
update_BANG_.cljs$core$IFn$_invoke$arity$variadic = update_BANG___delegate;
return update_BANG_;
})()
;
/**
* Update object with assoc-in for given key and value
*/
lt.object.assoc_in_BANG_ = (function assoc_in_BANG_(obj,k,v){if(cljs.core.truth_((function (){var and__3508__auto__ = k;if(cljs.core.truth_(and__3508__auto__))
{return !(cljs.core.sequential_QMARK_.call(null,k));
} else
{return and__3508__auto__;
}
})()))
{throw (new Error([cljs.core.str("Associate requires a sequence of keys: "),cljs.core.str(k)].join('')));
} else
{}
return cljs.core.swap_BANG_.call(null,obj,(function (p1__5399_SHARP_){return cljs.core.assoc_in.call(null,p1__5399_SHARP_,k,v);
}));
});
lt.object.__GT_inst = (function __GT_inst(o){if(cljs.core.map_QMARK_.call(null,o))
{return cljs.core.deref.call(null,lt.object.instances).call(null,lt.object.__GT_id.call(null,o));
} else
{if(crate.binding.deref_QMARK_.call(null,o))
{return o;
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return cljs.core.deref.call(null,lt.object.instances).call(null,o);
} else
{return null;
}
}
}
});
/**
* Return DOM content associated with object
*/
lt.object.__GT_content = (function __GT_content(obj){return new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj));
});
/**
* Destroy object by calling its :destroy trigger, removing it from
* cache and removing associated DOM content
*/
lt.object.destroy_BANG_ = (function destroy_BANG_(obj){var temp__4092__auto__ = lt.object.__GT_inst.call(null,obj);if(cljs.core.truth_(temp__4092__auto__))
{var inst = temp__4092__auto__;lt.object.raise.call(null,inst,new cljs.core.Keyword(null,"destroy","destroy",2571277164));
cljs.core.swap_BANG_.call(null,lt.object.instances,cljs.core.dissoc,lt.object.__GT_id.call(null,inst));
if(cljs.core.truth_(lt.object.__GT_content.call(null,obj)))
{lt.util.dom.remove.call(null,lt.object.__GT_content.call(null,obj));
} else
{}
return cljs.core.reset_BANG_.call(null,obj,null);
} else
{return null;
}
});
lt.object.store_inst = (function store_inst(inst){cljs.core.swap_BANG_.call(null,lt.object.instances,cljs.core.assoc,new cljs.core.Keyword("lt.object","id","lt.object/id",706431105).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,inst)),inst);
return inst;
});
/**
* Create object given keyword name of object template or an object template
* and key-value pairs. See object* for special keys.
* During object creation the following happens to object in order:
* 
* * :init fn is called with given args
* * :object.instant trigger is raised
* * :init trigger is raised
* @param {...*} var_args
*/
lt.object.create = (function() { 
var create__delegate = function (obj_name,args){var obj = (((obj_name instanceof cljs.core.Keyword))?cljs.core.deref.call(null,lt.object.object_defs).call(null,obj_name):obj_name);var id = (function (){var or__3520__auto__ = new cljs.core.Keyword("lt.object","id","lt.object/id",706431105).cljs$core$IFn$_invoke$arity$1(obj);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.swap_BANG_.call(null,lt.object.obj_id,cljs.core.inc);
}
})();var inst = cljs.core.atom.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,obj,new cljs.core.Keyword(null,"init","init",1017141378)),new cljs.core.Keyword("lt.object","id","lt.object/id",706431105),id,new cljs.core.Keyword(null,"args","args",1016906831),args,new cljs.core.Keyword(null,"behaviors","behaviors",607554515),cljs.core.set.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",607554515).cljs$core$IFn$_invoke$arity$1(obj)),new cljs.core.Keyword(null,"tags","tags",1017456523),cljs.core.set.call(null,cljs.core.conj.call(null,new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(obj),new cljs.core.Keyword(null,"object","object",4285503153)))));var inst__$1 = lt.object.store_inst.call(null,inst);var _ = lt.object.merge_BANG_.call(null,inst__$1,lt.object.update_listeners.call(null,inst__$1));var content = (cljs.core.truth_(new cljs.core.Keyword(null,"init","init",1017141378).cljs$core$IFn$_invoke$arity$1(obj))?cljs.core.apply.call(null,new cljs.core.Keyword(null,"init","init",1017141378).cljs$core$IFn$_invoke$arity$1(obj),inst__$1,args):null);var content__$1 = ((cljs.core.vector_QMARK_.call(null,content))?crate.core.html.call(null,content):content);var final$ = lt.object.merge_BANG_.call(null,inst__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"content","content",1965434859),content__$1], null));cljs.core.add_watch.call(null,inst__$1,new cljs.core.Keyword("lt.object","change","lt.object/change",2456955616),(function (___$1,___$2,___$3,___$4){return lt.object.raise.call(null,inst__$1,new cljs.core.Keyword(null,"object.change","object.change",966833329));
}));
lt.object.raise_STAR_.call(null,inst__$1,lt.object.trigger__GT_behaviors.call(null,new cljs.core.Keyword(null,"object.instant","object.instant",773332388),new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,inst__$1))),null);
lt.object.raise.call(null,inst__$1,new cljs.core.Keyword(null,"init","init",1017141378));
return inst__$1;
};
var create = function (obj_name,var_args){
var args = null;if (arguments.length > 1) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return create__delegate.call(this,obj_name,args);};
create.cljs$lang$maxFixedArity = 1;
create.cljs$lang$applyTo = (function (arglist__5400){
var obj_name = cljs.core.first(arglist__5400);
var args = cljs.core.rest(arglist__5400);
return create__delegate(obj_name,args);
});
create.cljs$core$IFn$_invoke$arity$variadic = create__delegate;
return create;
})()
;
lt.object.refresh_BANG_ = (function refresh_BANG_(obj){cljs.core.reset_BANG_.call(null,obj,lt.object.update_listeners.call(null,obj));
lt.object.raise_STAR_.call(null,obj,lt.object.trigger__GT_behaviors.call(null,new cljs.core.Keyword(null,"object.instant","object.instant",773332388),new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj))),null);
return lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"object.refresh","object.refresh",4196174494));
});
/**
* Add behavior to object and update its listeners
*/
lt.object.add_behavior_BANG_ = (function add_behavior_BANG_(obj,behavior){lt.object.update_BANG_.call(null,obj,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"behaviors","behaviors",607554515)], null),cljs.core.conj,behavior);
return cljs.core.reset_BANG_.call(null,obj,lt.object.update_listeners.call(null,obj));
});
/**
* Remove behavior from object and update its listeners
*/
lt.object.rem_behavior_BANG_ = (function rem_behavior_BANG_(obj,behavior){lt.object.update_BANG_.call(null,obj,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"behaviors","behaviors",607554515)], null),(function (p1__5401_SHARP_){return cljs.core.remove.call(null,cljs.core.PersistentHashSet.fromArray([behavior], true),p1__5401_SHARP_);
}));
return cljs.core.reset_BANG_.call(null,obj,lt.object.update_listeners.call(null,obj));
});
lt.object.__GT_def = (function __GT_def(def_BAR_name){if(cljs.core.map_QMARK_.call(null,def_BAR_name))
{return def_BAR_name;
} else
{return cljs.core.deref.call(null,lt.object.object_defs).call(null,def_BAR_name);
}
});
/**
* Find object by its unique numerical id
*/
lt.object.by_id = (function by_id(id){if(cljs.core.truth_(id))
{return cljs.core.deref.call(null,lt.object.instances).call(null,id);
} else
{return null;
}
});
/**
* Find objects that have given tag
*/
lt.object.by_tag = (function by_tag(tag){return cljs.core.sort_by.call(null,cljs.core.comp.call(null,new cljs.core.Keyword("lt.object","id","lt.object/id",706431105),cljs.core.deref),cljs.core.filter.call(null,(function (p1__5402_SHARP_){var temp__4092__auto__ = new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,p1__5402_SHARP_));if(cljs.core.truth_(temp__4092__auto__))
{var ts = temp__4092__auto__;return ts.call(null,tag);
} else
{return null;
}
}),cljs.core.vals.call(null,cljs.core.deref.call(null,lt.object.instances))));
});
lt.object.in_tag_QMARK_ = (function in_tag_QMARK_(tag,behavior){return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.PersistentHashSet.fromArray([behavior], true),cljs.core.deref.call(null,lt.object.tags).call(null,tag)));
});
/**
* Return truthy if object has tag
*/
lt.object.has_tag_QMARK_ = (function has_tag_QMARK_(obj,tag){return new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj)).call(null,tag);
});
/**
* Add tags to given object and updates effected behaviors and listeners.
* ::tags-added trigger is raised on object after update
*/
lt.object.add_tags = (function add_tags(obj,ts){lt.object.update_BANG_.call(null,obj,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tags","tags",1017456523)], null),(function (p1__5403_SHARP_){return cljs.core.reduce.call(null,cljs.core.conj,p1__5403_SHARP_,cljs.core.filter.call(null,cljs.core.identity,ts));
}));
cljs.core.reset_BANG_.call(null,obj,lt.object.update_listeners.call(null,obj));
lt.object.raise.call(null,obj,new cljs.core.Keyword("lt.object","tags-added","lt.object/tags-added",1756253556),ts);
lt.object.raise_STAR_.call(null,obj,lt.object.trigger__GT_behaviors.call(null,new cljs.core.Keyword(null,"object.instant","object.instant",773332388),ts),null);
return obj;
});
/**
* Remove tags from given object and updates effected behaviors and listeners.
* ::tags-removed trigger is raised on object after update
*/
lt.object.remove_tags = (function remove_tags(obj,ts){var cur = cljs.core.deref.call(null,obj);var behs = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,cljs.core.deref.call(null,lt.object.tags),ts));var cur__$1 = cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,cur,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tags","tags",1017456523)], null),((function (cur,behs){
return (function (p1__5404_SHARP_){return cljs.core.reduce.call(null,cljs.core.disj,p1__5404_SHARP_,ts);
});})(cur,behs))
),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"behaviors","behaviors",607554515)], null),((function (cur,behs){
return (function (p1__5405_SHARP_){return cljs.core.remove.call(null,cljs.core.PersistentHashSet.fromArray([behs], true),p1__5405_SHARP_);
});})(cur,behs))
),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",4090152369)], null),((function (cur,behs){
return (function (p1__5406_SHARP_){return cljs.core.apply.call(null,cljs.core.dissoc,p1__5406_SHARP_,ts);
});})(cur,behs))
);lt.object.merge_BANG_.call(null,obj,cur__$1);
cljs.core.reset_BANG_.call(null,obj,lt.object.update_listeners.call(null,obj));
lt.object.raise.call(null,obj,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),ts);
return obj;
});
/**
* Associate behaviors to given tag and refresh objects with given tag
*/
lt.object.tag_behaviors = (function tag_behaviors(tag,behs){cljs.core.swap_BANG_.call(null,lt.object.tags,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag], null),(function (p1__5407_SHARP_){return cljs.core.reduce.call(null,cljs.core.conj,(function (){var or__3520__auto__ = p1__5407_SHARP_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.List.EMPTY;
}
})(),behs);
}));
var seq__5412_5416 = cljs.core.seq.call(null,lt.object.by_tag.call(null,tag));var chunk__5413_5417 = null;var count__5414_5418 = 0;var i__5415_5419 = 0;while(true){
if((i__5415_5419 < count__5414_5418))
{var cur_5420 = cljs.core._nth.call(null,chunk__5413_5417,i__5415_5419);lt.object.refresh_BANG_.call(null,cur_5420);
{
var G__5421 = seq__5412_5416;
var G__5422 = chunk__5413_5417;
var G__5423 = count__5414_5418;
var G__5424 = (i__5415_5419 + 1);
seq__5412_5416 = G__5421;
chunk__5413_5417 = G__5422;
count__5414_5418 = G__5423;
i__5415_5419 = G__5424;
continue;
}
} else
{var temp__4092__auto___5425 = cljs.core.seq.call(null,seq__5412_5416);if(temp__4092__auto___5425)
{var seq__5412_5426__$1 = temp__4092__auto___5425;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5412_5426__$1))
{var c__4262__auto___5427 = cljs.core.chunk_first.call(null,seq__5412_5426__$1);{
var G__5428 = cljs.core.chunk_rest.call(null,seq__5412_5426__$1);
var G__5429 = c__4262__auto___5427;
var G__5430 = cljs.core.count.call(null,c__4262__auto___5427);
var G__5431 = 0;
seq__5412_5416 = G__5428;
chunk__5413_5417 = G__5429;
count__5414_5418 = G__5430;
i__5415_5419 = G__5431;
continue;
}
} else
{var cur_5432 = cljs.core.first.call(null,seq__5412_5426__$1);lt.object.refresh_BANG_.call(null,cur_5432);
{
var G__5433 = cljs.core.next.call(null,seq__5412_5426__$1);
var G__5434 = null;
var G__5435 = 0;
var G__5436 = 0;
seq__5412_5416 = G__5433;
chunk__5413_5417 = G__5434;
count__5414_5418 = G__5435;
i__5415_5419 = G__5436;
continue;
}
}
} else
{}
}
break;
}
return cljs.core.deref.call(null,lt.object.tags).call(null,tag);
});
lt.object.remove_tag_behaviors = (function remove_tag_behaviors(tag,behs){cljs.core.swap_BANG_.call(null,lt.object.tags,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag], null),(function (p1__5437_SHARP_){return cljs.core.remove.call(null,cljs.core.set.call(null,behs),(function (){var or__3520__auto__ = p1__5437_SHARP_;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.List.EMPTY;
}
})());
}));
var seq__5450 = cljs.core.seq.call(null,lt.object.by_tag.call(null,tag));var chunk__5455 = null;var count__5456 = 0;var i__5457 = 0;while(true){
if((i__5457 < count__5456))
{var cur = cljs.core._nth.call(null,chunk__5455,i__5457);var seq__5458_5462 = cljs.core.seq.call(null,behs);var chunk__5459_5463 = null;var count__5460_5464 = 0;var i__5461_5465 = 0;while(true){
if((i__5461_5465 < count__5460_5464))
{var b_5466 = cljs.core._nth.call(null,chunk__5459_5463,i__5461_5465);lt.object.rem_behavior_BANG_.call(null,cur,b_5466);
{
var G__5467 = seq__5458_5462;
var G__5468 = chunk__5459_5463;
var G__5469 = count__5460_5464;
var G__5470 = (i__5461_5465 + 1);
seq__5458_5462 = G__5467;
chunk__5459_5463 = G__5468;
count__5460_5464 = G__5469;
i__5461_5465 = G__5470;
continue;
}
} else
{var temp__4092__auto___5471 = cljs.core.seq.call(null,seq__5458_5462);if(temp__4092__auto___5471)
{var seq__5458_5472__$1 = temp__4092__auto___5471;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5458_5472__$1))
{var c__4262__auto___5473 = cljs.core.chunk_first.call(null,seq__5458_5472__$1);{
var G__5474 = cljs.core.chunk_rest.call(null,seq__5458_5472__$1);
var G__5475 = c__4262__auto___5473;
var G__5476 = cljs.core.count.call(null,c__4262__auto___5473);
var G__5477 = 0;
seq__5458_5462 = G__5474;
chunk__5459_5463 = G__5475;
count__5460_5464 = G__5476;
i__5461_5465 = G__5477;
continue;
}
} else
{var b_5478 = cljs.core.first.call(null,seq__5458_5472__$1);lt.object.rem_behavior_BANG_.call(null,cur,b_5478);
{
var G__5479 = cljs.core.next.call(null,seq__5458_5472__$1);
var G__5480 = null;
var G__5481 = 0;
var G__5482 = 0;
seq__5458_5462 = G__5479;
chunk__5459_5463 = G__5480;
count__5460_5464 = G__5481;
i__5461_5465 = G__5482;
continue;
}
}
} else
{}
}
break;
}
{
var G__5483 = seq__5450;
var G__5484 = chunk__5455;
var G__5485 = count__5456;
var G__5486 = (i__5457 + 1);
seq__5450 = G__5483;
chunk__5455 = G__5484;
count__5456 = G__5485;
i__5457 = G__5486;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__5450);if(temp__4092__auto__)
{var seq__5450__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5450__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__5450__$1);{
var G__5487 = cljs.core.chunk_rest.call(null,seq__5450__$1);
var G__5488 = c__4262__auto__;
var G__5489 = cljs.core.count.call(null,c__4262__auto__);
var G__5490 = 0;
seq__5450 = G__5487;
chunk__5455 = G__5488;
count__5456 = G__5489;
i__5457 = G__5490;
continue;
}
} else
{var cur = cljs.core.first.call(null,seq__5450__$1);var seq__5451_5491 = cljs.core.seq.call(null,behs);var chunk__5452_5492 = null;var count__5453_5493 = 0;var i__5454_5494 = 0;while(true){
if((i__5454_5494 < count__5453_5493))
{var b_5495 = cljs.core._nth.call(null,chunk__5452_5492,i__5454_5494);lt.object.rem_behavior_BANG_.call(null,cur,b_5495);
{
var G__5496 = seq__5451_5491;
var G__5497 = chunk__5452_5492;
var G__5498 = count__5453_5493;
var G__5499 = (i__5454_5494 + 1);
seq__5451_5491 = G__5496;
chunk__5452_5492 = G__5497;
count__5453_5493 = G__5498;
i__5454_5494 = G__5499;
continue;
}
} else
{var temp__4092__auto___5500__$1 = cljs.core.seq.call(null,seq__5451_5491);if(temp__4092__auto___5500__$1)
{var seq__5451_5501__$1 = temp__4092__auto___5500__$1;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5451_5501__$1))
{var c__4262__auto___5502 = cljs.core.chunk_first.call(null,seq__5451_5501__$1);{
var G__5503 = cljs.core.chunk_rest.call(null,seq__5451_5501__$1);
var G__5504 = c__4262__auto___5502;
var G__5505 = cljs.core.count.call(null,c__4262__auto___5502);
var G__5506 = 0;
seq__5451_5491 = G__5503;
chunk__5452_5492 = G__5504;
count__5453_5493 = G__5505;
i__5454_5494 = G__5506;
continue;
}
} else
{var b_5507 = cljs.core.first.call(null,seq__5451_5501__$1);lt.object.rem_behavior_BANG_.call(null,cur,b_5507);
{
var G__5508 = cljs.core.next.call(null,seq__5451_5501__$1);
var G__5509 = null;
var G__5510 = 0;
var G__5511 = 0;
seq__5451_5491 = G__5508;
chunk__5452_5492 = G__5509;
count__5453_5493 = G__5510;
i__5454_5494 = G__5511;
continue;
}
}
} else
{}
}
break;
}
{
var G__5512 = cljs.core.next.call(null,seq__5450__$1);
var G__5513 = null;
var G__5514 = 0;
var G__5515 = 0;
seq__5450 = G__5512;
chunk__5455 = G__5513;
count__5456 = G__5514;
i__5457 = G__5515;
continue;
}
}
} else
{return null;
}
}
break;
}
});
lt.object.__BEH__add_tag = (function __BEH__add_tag(this$,t){if(cljs.core.truth_(t))
{return lt.object.add_tags.call(null,this$,((cljs.core.coll_QMARK_.call(null,t))?t:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [t], null)));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.object","add-tag","lt.object/add-tag",1703923742),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.object.__BEH__add_tag,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Add tag to object",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"tag"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.object.__BEH__remove_tag = (function __BEH__remove_tag(this$,t){if(cljs.core.truth_(lt.object.has_tag_QMARK_.call(null,this$,t)))
{return lt.object.remove_tags.call(null,this$,((cljs.core.coll_QMARK_.call(null,t))?t:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [t], null)));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.object","remove-tag","lt.object/remove-tag",3883925951),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.object.__BEH__remove_tag,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Remove tag from object",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"tag"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-added","lt.object/tags-added",1756253556),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.object.__BEH__shadow_tag = (function __BEH__shadow_tag(this$,to_shadow,to_add){var has_shadow_QMARK_ = lt.object.has_tag_QMARK_.call(null,this$,to_shadow);var has_add_QMARK_ = lt.object.has_tag_QMARK_.call(null,this$,to_add);if(cljs.core.truth_((function (){var and__3508__auto__ = has_shadow_QMARK_;if(cljs.core.truth_(and__3508__auto__))
{return cljs.core.not.call(null,has_add_QMARK_);
} else
{return and__3508__auto__;
}
})()))
{return lt.object.add_tags.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [to_add], null));
} else
{if(cljs.core.truth_((function (){var and__3508__auto__ = cljs.core.not.call(null,has_shadow_QMARK_);if(and__3508__auto__)
{return has_add_QMARK_;
} else
{return and__3508__auto__;
}
})()))
{return lt.object.remove_tags.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [to_add], null));
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return null;
} else
{return null;
}
}
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.object","shadow-tag","lt.object/shadow-tag",1731213395),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.object.__BEH__shadow_tag,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Shadow a tag on an object",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"tag to shadow"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"tag to add"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null,new cljs.core.Keyword("lt.object","tags-added","lt.object/tags-added",1756253556),null,new cljs.core.Keyword("lt.object","tags-removed","lt.object/tags-removed",4080090644),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.object.__BEH__report_time = (function __BEH__report_time(this$,beh,time,trigger){if(cljs.core.truth_(lt.objs.console))
{return lt.objs.console.log([cljs.core.str(beh),cljs.core.str(" triggered by "),cljs.core.str(trigger),cljs.core.str(" took "),cljs.core.str(time),cljs.core.str("ms")].join(''));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.object","report-time","lt.object/report-time",1387009782),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.object.__BEH__report_time,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.behavior.time","object.behavior.time",854340588),null], null), null));
