// Compiled by ClojureScript 0.0-2138
goog.provide('lt.util.load');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.string');
lt.util.load.fpath = require("path");
lt.util.load.fs = require("fs");
lt.util.load.dir = [cljs.core.str(__dirname),cljs.core.str("/..")].join('');
lt.util.load._STAR_force_reload_STAR_ = false;
lt.util.load.separator = lt.util.load.fpath.sep;
lt.util.load.absolute_QMARK_ = (function absolute_QMARK_(path){return cljs.core.boolean$.call(null,cljs.core.re_seq.call(null,/^\s*[\\\\/]|([\w]+:[\\\\/])/,path));
});
lt.util.load.node_module = (function node_module(path){return require([cljs.core.str(lt.util.load.dir),cljs.core.str("/core/node_modules/"),cljs.core.str(path)].join(''));
});
lt.util.load.abs_source_mapping_url = (function abs_source_mapping_url(code,file){var temp__4090__auto__ = cljs.core.second.call(null,cljs.core.re_find.call(null,/\n\/\/# sourceMappingURL=(.*\.map)/,code));if(cljs.core.truth_(temp__4090__auto__))
{var path_to_source_map = temp__4090__auto__;if(!(lt.util.load.absolute_QMARK_.call(null,path_to_source_map)))
{var abs_path_to_source_map = clojure.string.replace.call(null,lt.util.load.fpath.join(lt.util.load.fpath.dirname(file),path_to_source_map),"\\","/");var abs_path_to_source_map__$1 = ((cljs.core._EQ_.call(null,lt.util.load.separator,"\\"))?[cljs.core.str("/"),cljs.core.str(abs_path_to_source_map)].join(''):abs_path_to_source_map);return clojure.string.replace_first.call(null,code,/\n\/\/# sourceMappingURL=.*/,[cljs.core.str("\n//# sourceMappingURL="),cljs.core.str(encodeURI(abs_path_to_source_map__$1))].join(''));
} else
{return code;
}
} else
{return code;
}
});
lt.util.load.prep = (function prep(code,file){return [cljs.core.str(lt.util.load.abs_source_mapping_url.call(null,code,file)),cljs.core.str("\n\n//# sourceURL="),cljs.core.str(encodeURI(file))].join('');
});
lt.util.load.js = (function() {
var js = null;
var js__1 = (function (file){return js.call(null,file,false);
});
var js__2 = (function (file,sync){var file__$1 = ((!(lt.util.load.absolute_QMARK_.call(null,file)))?lt.util.load.fpath.join(lt.util.load.dir,file):file);if(cljs.core.truth_(sync))
{return window.eval(lt.util.load.prep.call(null,lt.util.load.fs.readFileSync(file__$1).toString(),file__$1));
} else
{return lt.util.load.fs.readFile(lt.util.load.fpath.join(lt.util.load.dir,file__$1),(function (content){return window.eval(lt.util.load.prep.call(null,content.toString(),file__$1));
}));
}
});
js = function(file,sync){
switch(arguments.length){
case 1:
return js__1.call(this,file);
case 2:
return js__2.call(this,file,sync);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
js.cljs$core$IFn$_invoke$arity$1 = js__1;
js.cljs$core$IFn$_invoke$arity$2 = js__2;
return js;
})()
;
lt.util.load.css = (function css(file){var link = document.createElement("link");link.type = "text/css";
link.rel = "stylesheet";
link.href = ((lt.util.load.absolute_QMARK_.call(null,file))?[cljs.core.str("file://"),cljs.core.str(file)].join(''):file);
document.head.appendChild(link);
return link;
});
lt.util.load.obj_exists_QMARK_ = (function obj_exists_QMARK_(s){var parts = clojure.string.split.call(null,s,".");var cur = window;while(true){
if(cljs.core.not.call(null,cljs.core.first.call(null,parts)))
{return cur;
} else
{var temp__4090__auto__ = (cur[cljs.core.first.call(null,parts)]);if(cljs.core.truth_(temp__4090__auto__))
{var cur__$1 = temp__4090__auto__;{
var G__5656 = cljs.core.rest.call(null,parts);
var G__5657 = cur__$1;
parts = G__5656;
cur = G__5657;
continue;
}
} else
{return null;
}
}
break;
}
});
lt.util.load.provided = {};
lt.util.load.provided_ancestors = (function provided_ancestors(parent){return cljs.core.count.call(null,Object.keys(lt.util.load.provided).filter((function (p1__5658_SHARP_){return (p1__5658_SHARP_.indexOf(parent) > -1);
})));
});
lt.util.load.only_ancestors_QMARK_ = (function only_ancestors_QMARK_(cur,s){return (Object.keys(cur).length <= lt.util.load.provided_ancestors.call(null,s));
});
lt.util.load.provided_QMARK_ = (function provided_QMARK_(s){if(cljs.core.truth_(lt.util.load._STAR_force_reload_STAR_))
{return false;
} else
{var res = (cljs.core.truth_((lt.util.load.provided[s]))?true:(function (){var temp__4092__auto__ = lt.util.load.obj_exists_QMARK_.call(null,s);if(cljs.core.truth_(temp__4092__auto__))
{var cur = temp__4092__auto__;return !(lt.util.load.only_ancestors_QMARK_.call(null,cur,s));
} else
{return null;
}
})());(lt.util.load.provided[s] = true);
return res;
}
});
