// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.opener');
goog.require('cljs.core');
goog.require('lt.util.cljs');
goog.require('crate.binding');
goog.require('lt.objs.app');
goog.require('lt.objs.sidebar.command');
goog.require('lt.objs.files');
goog.require('lt.util.dom');
goog.require('lt.objs.editor.file');
goog.require('lt.objs.tabs');
goog.require('lt.objs.popup');
goog.require('lt.objs.dialogs');
goog.require('lt.objs.popup');
goog.require('lt.objs.metrics');
goog.require('lt.objs.workspace');
goog.require('lt.objs.notifos');
goog.require('lt.objs.notifos');
goog.require('lt.objs.workspace');
goog.require('lt.util.dom');
goog.require('lt.objs.editor.pool');
goog.require('lt.util.cljs');
goog.require('lt.objs.files');
goog.require('lt.objs.app');
goog.require('crate.binding');
goog.require('lt.objs.editor');
goog.require('lt.object');
goog.require('lt.object');
goog.require('lt.objs.dialogs');
goog.require('lt.objs.console');
goog.require('lt.objs.tabs');
goog.require('lt.objs.editor');
goog.require('lt.objs.console');
goog.require('lt.objs.metrics');
goog.require('lt.objs.editor.pool');
goog.require('lt.objs.sidebar.command');
goog.require('lt.objs.document');
goog.require('lt.objs.document');
goog.require('lt.objs.editor.file');
lt.objs.opener.path__GT_info = (function path__GT_info(path){if(cljs.core.truth_(path))
{var type = lt.objs.files.path__GT_type.call(null,path);return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1017277949),lt.objs.files.basename.call(null,path),new cljs.core.Keyword(null,"type-name","type-name",1486910640),new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(type),new cljs.core.Keyword(null,"path","path",1017337751),path,new cljs.core.Keyword(null,"mime","mime",1017255846),new cljs.core.Keyword(null,"mime","mime",1017255846).cljs$core$IFn$_invoke$arity$1(type),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(type)], null);
} else
{return null;
}
});
lt.objs.opener.untitled_count = cljs.core.atom.call(null,0);
lt.objs.opener.__BEH__open_transient_editor = (function __BEH__open_transient_editor(this$,path,dirty_QMARK_){var last = lt.objs.editor.pool.last_active.call(null);var info = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"mime","mime",1017255846),"plaintext",new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editor.plaintext","editor.plaintext",4474629672)], null),new cljs.core.Keyword(null,"name","name",1017277949),[cljs.core.str("untitled-"),cljs.core.str(cljs.core.swap_BANG_.call(null,lt.objs.opener.untitled_count,cljs.core.inc))].join('')], null),lt.objs.opener.path__GT_info.call(null,path));var ed = lt.objs.editor.pool.create.call(null,info);lt.object.add_tags.call(null,ed,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editor.transient","editor.transient",3554141883)], null));
lt.object.merge_BANG_.call(null,ed,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dirty","dirty",1109497668),dirty_QMARK_], null));
lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"open","open",1017321916),ed);
lt.objs.tabs.add_BANG_.call(null,ed);
return lt.objs.tabs.active_BANG_.call(null,ed);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","open-transient-editor","lt.objs.opener/open-transient-editor",565416896),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__open_transient_editor,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new!","new!",1017282035),null], null), null));
lt.objs.opener.__BEH__transient_save = (function __BEH__transient_save(this$){var path = (function (){var or__3520__auto__ = cljs.core.first.call(null,new cljs.core.Keyword(null,"folders","folders",4625622327).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.workspace.current_ws)));if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.objs.files.home.call(null);
}
})();var info = new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$));var fname = new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(info);var ext = (function (){var temp__4092__auto__ = new cljs.core.Keyword(null,"exts","exts",1017032164).cljs$core$IFn$_invoke$arity$1(info);if(cljs.core.truth_(temp__4092__auto__))
{var e = temp__4092__auto__;return [cljs.core.str("."),cljs.core.str(cljs.core.name.call(null,cljs.core.first.call(null,e)))].join('');
} else
{return null;
}
})();return lt.objs.dialogs.save_as.call(null,this$,new cljs.core.Keyword(null,"save-as!","save-as!",3235093841),lt.objs.files.join.call(null,path,[cljs.core.str(fname),cljs.core.str(ext)].join('')));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","transient-save","lt.objs.opener/transient-save",1543824427),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__transient_save,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"save-as-rename!","save-as-rename!",4344908746),null,new cljs.core.Keyword(null,"save","save",1017427183),null], null), null));
lt.objs.opener.__BEH__save_as_rename_BANG_ = (function __BEH__save_as_rename_BANG_(this$){return lt.objs.dialogs.save_as.call(null,this$,new cljs.core.Keyword(null,"save-as!","save-as!",3235093841),new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$))));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","save-as-rename!","lt.objs.opener/save-as-rename!",2578562723),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__save_as_rename_BANG_,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"save-as-rename!","save-as-rename!",4344908746),null], null), null));
lt.objs.opener.__BEH__save_as = (function __BEH__save_as(this$,path){if(!(cljs.core.empty_QMARK_.call(null,path)))
{var type = lt.objs.files.path__GT_type.call(null,path);var prev_tags = new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)));var mode = lt.objs.files.path__GT_mode.call(null,path);var neue_doc = lt.objs.document.create.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"doc","doc",1014003882),lt.objs.editor.get_doc.call(null,this$),new cljs.core.Keyword(null,"line-ending","line-ending",4015468690),lt.objs.files.line_ending,new cljs.core.Keyword(null,"mtime","mtime",1118128172),lt.objs.files.stats.call(null,path),new cljs.core.Keyword(null,"mime","mime",1017255846),mode], null));if(cljs.core.truth_(new cljs.core.Keyword(null,"doc","doc",1014003882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$))))
{lt.object.raise.call(null,new cljs.core.Keyword(null,"doc","doc",1014003882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)),new cljs.core.Keyword(null,"close.force","close.force",4409585383));
} else
{}
lt.objs.document.register_doc.call(null,neue_doc,path);
lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",1017141280)], null),cljs.core.merge,lt.objs.opener.path__GT_info.call(null,path));
lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dirty","dirty",1109497668),true,new cljs.core.Keyword(null,"doc","doc",1014003882),neue_doc], null));
lt.objs.editor.set_mode.call(null,this$,mode);
lt.object.remove_tags.call(null,this$,cljs.core.conj.call(null,prev_tags,new cljs.core.Keyword(null,"editor.transient","editor.transient",3554141883)));
lt.object.add_tags.call(null,this$,cljs.core.conj.call(null,new cljs.core.Keyword(null,"tags","tags",1017456523).cljs$core$IFn$_invoke$arity$1(type),new cljs.core.Keyword(null,"editor.file-backed","editor.file-backed",4684256680)));
lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"save-as","save-as",2886670836));
return lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"save","save",1017427183));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","save-as","lt.objs.opener/save-as",1078379657),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__save_as,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"save-as!","save-as!",3235093841),null], null), null));
lt.objs.opener.__BEH__check_read_only = (function __BEH__check_read_only(this$,ed){var temp__4092__auto__ = new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed)));if(cljs.core.truth_(temp__4092__auto__))
{var path = temp__4092__auto__;if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,path)))
{if(cljs.core.truth_(lt.objs.files.writable_QMARK_.call(null,path)))
{return null;
} else
{return lt.object.add_tags.call(null,ed,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editor.read-only","editor.read-only",1341634996)], null));
}
} else
{return null;
}
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","check-read-only","lt.objs.opener/check-read-only",1331582981),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__check_read_only,new cljs.core.Keyword(null,"desc","desc",1016984067),"Opener: check if file is read only",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open","open",1017321916),null], null), null));
lt.objs.opener.__BEH__open_from_info = (function __BEH__open_from_info(obj,info){var ed = lt.objs.editor.pool.create.call(null,info);lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"open","open",1017321916),ed);
lt.objs.tabs.add_BANG_.call(null,ed);
return lt.objs.tabs.active_BANG_.call(null,ed);
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","open-from-info","lt.objs.opener/open-from-info",4587616757),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__open_from_info,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open-info!","open-info!",4559273826),null], null), null));
lt.objs.opener.open_path_STAR_ = (function open_path_STAR_(doc_fn,obj,path){return doc_fn.call(null,path,(function (doc){var type = lt.objs.files.path__GT_type.call(null,path);var ed = lt.objs.editor.pool.create.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"doc","doc",1014003882),doc,new cljs.core.Keyword(null,"line-ending","line-ending",4015468690),new cljs.core.Keyword(null,"line-ending","line-ending",4015468690).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,doc))], null),lt.objs.opener.path__GT_info.call(null,path)));lt.objs.metrics.capture_BANG_.call(null,new cljs.core.Keyword(null,"editor.open","editor.open",4270591389),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1017479852),(function (){var or__3520__auto__ = new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(type);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.objs.files.ext.call(null,path);
}
})(),new cljs.core.Keyword(null,"lines","lines",1116881521),lt.objs.editor.last_line.call(null,ed)], null));
lt.object.add_tags.call(null,ed,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"editor.file-backed","editor.file-backed",4684256680)], null));
lt.object.raise.call(null,obj,new cljs.core.Keyword(null,"open","open",1017321916),ed);
lt.objs.tabs.add_BANG_.call(null,ed);
return lt.objs.tabs.active_BANG_.call(null,ed);
}));
});
/**
* Open a path given an ::opener object and path
*/
lt.objs.opener.open_path = cljs.core.partial.call(null,lt.objs.opener.open_path_STAR_,lt.objs.document.open);
/**
* Open a path as a linked doc given the editor with the document to be linked to.
*/
lt.objs.opener.open_linked_path = (function open_linked_path(ed,obj,path,ldoc_options){return lt.objs.opener.open_path_STAR_.call(null,cljs.core.partial.call(null,lt.objs.document.linked_open,ed,ldoc_options),obj,path);
});
lt.objs.opener.__BEH__existing_path_opens_linked_doc = (function __BEH__existing_path_opens_linked_doc(this$,bool){return lt.object.merge_BANG_.call(null,this$,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open-linked-doc","open-linked-doc",3889050201),bool], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","existing-path-opens-linked-doc","lt.objs.opener/existing-path-opens-linked-doc",3110254293),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__existing_path_opens_linked_doc,new cljs.core.Keyword(null,"desc","desc",1016984067),"Doc: Open a linked document when the file is already opened",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),true);
lt.objs.opener.__BEH__open_standard_editor = (function __BEH__open_standard_editor(obj,path){if(cljs.core.not.call(null,lt.objs.files.file_QMARK_.call(null,path)))
{if(cljs.core.truth_(lt.objs.files.dir_QMARK_.call(null,path)))
{return lt.objs.notifos.set_msg_BANG_.call(null,[cljs.core.str("Cannot open a directory: "),cljs.core.str(path)].join(''));
} else
{return lt.objs.notifos.set_msg_BANG_.call(null,[cljs.core.str("No such file: "),cljs.core.str(path)].join(''));
}
} else
{var resolved_path = lt.objs.files.resolve.call(null,lt.objs.files.cwd,path);var temp__4090__auto__ = cljs.core.first.call(null,lt.objs.editor.pool.by_path.call(null,resolved_path));if(cljs.core.truth_(temp__4090__auto__))
{var ed = temp__4090__auto__;if(cljs.core.truth_(new cljs.core.Keyword(null,"open-linked-doc","open-linked-doc",3889050201).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,obj))))
{return lt.objs.opener.open_linked_path.call(null,ed,obj,resolved_path,cljs.core.PersistentArrayMap.EMPTY);
} else
{return lt.objs.tabs.active_BANG_.call(null,ed);
}
} else
{return lt.objs.opener.open_path.call(null,obj,resolved_path);
}
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","open-standard-editor","lt.objs.opener/open-standard-editor",3476080129),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__open_standard_editor,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open!","open!",1119852169),null], null), null));
lt.objs.opener.__BEH__track_open_files = (function __BEH__track_open_files(this$,ed){var temp__4092__auto__ = new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed)));if(cljs.core.truth_(temp__4092__auto__))
{var path = temp__4092__auto__;return lt.object.update_BANG_.call(null,this$,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"open-files","open-files",4556359846)], null),cljs.core.conj,path);
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","track-open-files","lt.objs.opener/track-open-files",4794255357),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__track_open_files,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open","open",1017321916),null], null), null));
lt.objs.opener.__BEH__untrack_closed = (function __BEH__untrack_closed(this$){var temp__4092__auto__ = new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$)));if(cljs.core.truth_(temp__4092__auto__))
{var path = temp__4092__auto__;return lt.object.update_BANG_.call(null,lt.objs.opener.opener,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"open-files","open-files",4556359846)], null),cljs.core.disj,new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,this$))));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","untrack-closed","lt.objs.opener/untrack-closed",1646138836),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__untrack_closed,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"destroy","destroy",2571277164),null], null), null));
lt.objs.opener.__BEH__unwatch_closed = (function __BEH__unwatch_closed(ed){var temp__4092__auto__ = new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed)));if(cljs.core.truth_(temp__4092__auto__))
{var path = temp__4092__auto__;return lt.objs.workspace.unwatch_BANG_.call(null,new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed))));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","unwatch-closed","lt.objs.opener/unwatch-closed",3293767120),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__unwatch_closed,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"close.force","close.force",4409585383),null], null), null));
lt.objs.opener.__BEH__watch_on_open = (function __BEH__watch_on_open(this$,ed){var temp__4092__auto__ = new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed)));if(cljs.core.truth_(temp__4092__auto__))
{var path = temp__4092__auto__;return lt.objs.workspace.watch_BANG_.call(null,new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",1017141280).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed))));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","watch-on-open","lt.objs.opener/watch-on-open",2046768257),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__watch_on_open,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open","open",1017321916),null], null), null));
lt.objs.opener.__BEH__watch_open_files = (function __BEH__watch_open_files(this$,cur){return cljs.core.concat.call(null,cur,new cljs.core.Keyword(null,"open-files","open-files",4556359846).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.opener.opener)));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","watch-open-files","lt.objs.opener/watch-open-files",877081081),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__watch_open_files,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"watch-paths+","watch-paths+",2265407277),null], null), null));
lt.objs.opener.__BEH__save_on_focus_lost = (function __BEH__save_on_focus_lost(this$){if(cljs.core.truth_(lt.object.has_tag_QMARK_.call(null,this$,new cljs.core.Keyword(null,"editor","editor",4001043679))))
{return lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"save","save",1017427183));
} else
{return lt.objs.sidebar.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"save","save",1017427183));
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","save-on-focus-lost","lt.objs.opener/save-on-focus-lost",1020338596),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__save_on_focus_lost,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Save on focus lost",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"blur","blur",1016931289),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.opener.__BEH__save_all_on_focus_lost = (function __BEH__save_all_on_focus_lost(this$){return lt.objs.sidebar.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"save-all","save-all",3235093699));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","save-all-on-focus-lost","lt.objs.opener/save-all-on-focus-lost",915651832),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__save_all_on_focus_lost,new cljs.core.Keyword(null,"desc","desc",1016984067),"Editor: Save all on focus lost",new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"blur","blur",1016931289),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.opener.__BEH__save_failed = (function __BEH__save_failed(this$,path,e){return lt.objs.popup.popup_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",4087600639),[cljs.core.str("Failed to save: "),cljs.core.str(lt.objs.files.basename.call(null,path))].join(''),new cljs.core.Keyword(null,"body","body",1016933652),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pre","pre",1014015509),(cljs.core.truth_(e)?[cljs.core.str(e)].join(''):null)], null),new cljs.core.Keyword(null,"buttons","buttons",1255256819),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),"cancel"], null)], null)], null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","save-failed","lt.objs.opener/save-failed",2586027158),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.opener.__BEH__save_failed,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"files.save.error","files.save.error",2424546720),null], null), null));
lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.opener","opener","lt.objs.opener/opener",2624228996),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opener","opener",4298292201),null], null), null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"open-files","open-files",4556359846),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"behaviors","behaviors",607554515),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lt.objs.opener","open-standard-editor","lt.objs.opener/open-standard-editor",3476080129)], null),new cljs.core.Keyword(null,"init","init",1017141378),(function (this$){return null;
}));
lt.objs.opener.opener = lt.object.create.call(null,new cljs.core.Keyword("lt.objs.opener","opener","lt.objs.opener/opener",2624228996));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"new-file","new-file",2344641787),new cljs.core.Keyword(null,"desc","desc",1016984067),"File: New file",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (dirty_QMARK_){return lt.object.raise.call(null,lt.objs.opener.opener,new cljs.core.Keyword(null,"new!","new!",1017282035),null,dirty_QMARK_);
})], null));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"open-file","open-file",2513650321),new cljs.core.Keyword(null,"desc","desc",1016984067),"File: Open file",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){return lt.objs.dialogs.file.call(null,lt.objs.opener.opener,new cljs.core.Keyword(null,"open!","open!",1119852169));
})], null));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"open-path","open-path",2513940794),new cljs.core.Keyword(null,"desc","desc",1016984067),"File: Open path",new cljs.core.Keyword(null,"hidden","hidden",4091384092),true,new cljs.core.Keyword(null,"exec","exec",1017031683),(function (path){return lt.object.raise.call(null,lt.objs.opener.opener,new cljs.core.Keyword(null,"open!","open!",1119852169),path);
})], null));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"save","save",1017427183),new cljs.core.Keyword(null,"desc","desc",1016984067),"File: Save file",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var temp__4092__auto__ = lt.objs.editor.pool.last_active.call(null);if(cljs.core.truth_(temp__4092__auto__))
{var ed = temp__4092__auto__;return lt.object.raise.call(null,ed,new cljs.core.Keyword(null,"save","save",1017427183));
} else
{return null;
}
})], null));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"save-all","save-all",3235093699),new cljs.core.Keyword(null,"desc","desc",1016984067),"File: Save all",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var seq__12923 = cljs.core.seq.call(null,lt.object.by_tag.call(null,new cljs.core.Keyword(null,"editor.file-backed","editor.file-backed",4684256680)));var chunk__12925 = null;var count__12926 = 0;var i__12927 = 0;while(true){
if((i__12927 < count__12926))
{var ed = cljs.core._nth.call(null,chunk__12925,i__12927);if(cljs.core.truth_(new cljs.core.Keyword(null,"dirty","dirty",1109497668).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed))))
{lt.object.raise.call(null,ed,new cljs.core.Keyword(null,"save","save",1017427183));
{
var G__12929 = seq__12923;
var G__12930 = chunk__12925;
var G__12931 = count__12926;
var G__12932 = (i__12927 + 1);
seq__12923 = G__12929;
chunk__12925 = G__12930;
count__12926 = G__12931;
i__12927 = G__12932;
continue;
}
} else
{{
var G__12933 = seq__12923;
var G__12934 = chunk__12925;
var G__12935 = count__12926;
var G__12936 = (i__12927 + 1);
seq__12923 = G__12933;
chunk__12925 = G__12934;
count__12926 = G__12935;
i__12927 = G__12936;
continue;
}
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__12923);if(temp__4092__auto__)
{var seq__12923__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__12923__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__12923__$1);{
var G__12937 = cljs.core.chunk_rest.call(null,seq__12923__$1);
var G__12938 = c__4262__auto__;
var G__12939 = cljs.core.count.call(null,c__4262__auto__);
var G__12940 = 0;
seq__12923 = G__12937;
chunk__12925 = G__12938;
count__12926 = G__12939;
i__12927 = G__12940;
continue;
}
} else
{var ed = cljs.core.first.call(null,seq__12923__$1);if(cljs.core.truth_(new cljs.core.Keyword(null,"dirty","dirty",1109497668).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ed))))
{lt.object.raise.call(null,ed,new cljs.core.Keyword(null,"save","save",1017427183));
{
var G__12941 = cljs.core.next.call(null,seq__12923__$1);
var G__12942 = null;
var G__12943 = 0;
var G__12944 = 0;
seq__12923 = G__12941;
chunk__12925 = G__12942;
count__12926 = G__12943;
i__12927 = G__12944;
continue;
}
} else
{{
var G__12945 = cljs.core.next.call(null,seq__12923__$1);
var G__12946 = null;
var G__12947 = 0;
var G__12948 = 0;
seq__12923 = G__12945;
chunk__12925 = G__12946;
count__12926 = G__12947;
i__12927 = G__12948;
continue;
}
}
}
} else
{return null;
}
}
break;
}
})], null));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"save-as","save-as",2886670836),new cljs.core.Keyword(null,"desc","desc",1016984067),"File: Save file as..",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var temp__4092__auto__ = lt.objs.editor.pool.last_active.call(null);if(cljs.core.truth_(temp__4092__auto__))
{var ed = temp__4092__auto__;return lt.object.raise.call(null,ed,new cljs.core.Keyword(null,"save-as-rename!","save-as-rename!",4344908746));
} else
{return null;
}
})], null));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"opener.open-info","opener.open-info",2298471692),new cljs.core.Keyword(null,"desc","desc",1016984067),"Opener: open info",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (info){return lt.object.raise.call(null,lt.objs.opener.opener,new cljs.core.Keyword(null,"open-info!","open-info!",4559273826),info);
})], null));
lt.objs.sidebar.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"opener.open-linked-doc","opener.open-linked-doc",2184055522),new cljs.core.Keyword(null,"desc","desc",1016984067),"File: Open another view of current file",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var ed = lt.objs.editor.pool.last_active.call(null);return lt.objs.opener.open_linked_path.call(null,ed,lt.objs.opener.opener,cljs.core.get_in.call(null,cljs.core.deref.call(null,ed),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",1017141280),new cljs.core.Keyword(null,"path","path",1017337751)], null)),cljs.core.PersistentArrayMap.EMPTY);
})], null));
window.ondrop = (function (e){try{var size = e.dataTransfer.files.length;var i = 0;while(true){
if((i < size))
{lt.object.raise.call(null,lt.objs.opener.opener,new cljs.core.Keyword(null,"open!","open!",1119852169),(e.dataTransfer.files[i]).path);
{
var G__12950 = (i + 1);
i = G__12950;
continue;
}
} else
{return null;
}
break;
}
}catch (e12949){var err = e12949;return lt.objs.console.error.call(null,err);
}});
