/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.debug.core.model.IMemoryBlock;

public class SynchronizeInfo {
    private IMemoryBlock fBlock;
    private Hashtable fProperties;

    public SynchronizeInfo(IMemoryBlock block) {
        this.fBlock = block;
        this.fProperties = new Hashtable();
    }

    public void setProperty(String propertyId, Object value) {
        if (propertyId == null) {
            return;
        }
        if (value == null) {
            return;
        }
        this.fProperties.put(propertyId, value);
    }

    public Object getProperty(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        Object value = this.fProperties.get(propertyId);
        return value;
    }

    public String[] getPropertyIds() {
        if (this.fProperties == null) {
            return new String[0];
        }
        Enumeration enumeration = this.fProperties.keys();
        ArrayList ids = new ArrayList();
        while (enumeration.hasMoreElements()) {
            ids.add(enumeration.nextElement());
        }
        return ids.toArray(new String[ids.size()]);
    }

    public void delete() {
        if (this.fProperties != null) {
            this.fProperties.clear();
            this.fProperties = null;
        }
        if (this.fBlock != null) {
            this.fBlock = null;
        }
    }
}

