/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.shared.target.AddBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.EditBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationLabelProvider;
import org.eclipse.pde.internal.ui.shared.target.UpdateTargetJob;
import org.eclipse.pde.ui.target.ITargetLocationEditor;
import org.eclipse.pde.ui.target.ITargetLocationUpdater;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;

public class TargetLocationsGroup {
    private TreeViewer fTreeViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fUpdateButton;
    private Button fShowContentButton;
    private ITargetDefinition fTarget;
    private ListenerList fChangeListeners = new ListenerList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static TargetLocationsGroup createInForm(Composite parent, FormToolkit toolkit) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createFormContents(parent, toolkit);
        return contentTable;
    }

    public static TargetLocationsGroup createInDialog(Composite parent) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createDialogContents(parent);
        return contentTable;
    }

    private TargetLocationsGroup() {
    }

    public void addTargetChangedListener(ITargetChangedListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    private void createFormContents(Composite parent, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(parent);
        comp.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        comp.setLayoutData((Object)new GridData(1808));
        Tree atree = toolkit.createTree(comp, 770);
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        atree.setLayoutData((Object)gd);
        atree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && TargetLocationsGroup.this.fRemoveButton.getEnabled()) {
                    TargetLocationsGroup.this.handleRemove();
                }
            }
        });
        Composite buttonComp = toolkit.createComposite(comp);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_0, 8);
        this.fEditButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_1, 8);
        this.fRemoveButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_2, 8);
        this.fUpdateButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_3, 8);
        this.fShowContentButton = toolkit.createButton(comp, Messages.TargetLocationsGroup_1, 32);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
        toolkit.paintBordersFor(comp);
    }

    private void createDialogContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        Tree atree = new Tree(comp, 2818);
        atree.setFont(comp.getFont());
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        atree.setLayoutData((Object)gd);
        atree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && TargetLocationsGroup.this.fRemoveButton.getEnabled()) {
                    TargetLocationsGroup.this.handleRemove();
                }
            }
        });
        Composite buttonComp = SWTFactory.createComposite(comp, 2, 1, 1808);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_0, null);
        this.fEditButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_1, null);
        this.fRemoveButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_2, null);
        this.fUpdateButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_3, null);
        this.fShowContentButton = SWTFactory.createCheckButton(comp, Messages.TargetLocationsGroup_1, null, false, 2);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
    }

    private void initializeTreeViewer(Tree tree) {
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)new TargetLocationContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TargetLocationLabelProvider(true, false));
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IStatus && !(e2 instanceof IStatus)) {
                    return 1;
                }
                if (e2 instanceof IStatus && !(e1 instanceof IStatus)) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetLocationsGroup.this.updateButtons();
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TargetLocationsGroup.this.handleEdit();
                }
            }
        });
        this.fTreeViewer.setAutoExpandLevel(-1);
    }

    private void initializeButtons() {
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.handleAdd();
            }
        });
        this.fAddButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fAddButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.handleEdit();
            }
        });
        this.fEditButton.setLayoutData((Object)new GridData());
        this.fEditButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fEditButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.handleRemove();
            }
        });
        this.fRemoveButton.setLayoutData((Object)new GridData());
        this.fRemoveButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fRemoveButton);
        this.fUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.handleUpdate();
            }
        });
        this.fUpdateButton.setLayoutData((Object)new GridData());
        this.fUpdateButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fUpdateButton);
        this.fShowContentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetLocationsGroup.this.fTreeViewer.refresh();
                TargetLocationsGroup.this.fTreeViewer.expandAll();
            }
        });
        this.fShowContentButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fShowContentButton);
    }

    public void setInput(ITargetDefinition target) {
        this.fTarget = target;
        this.fTreeViewer.setInput((Object)this.fTarget);
        this.updateButtons();
    }

    private void handleAdd() {
        AddBundleContainerWizard wizard = new AddBundleContainerWizard(this.fTarget);
        Shell parent = this.fTreeViewer.getTree().getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        if (dialog.open() != 1) {
            this.contentsChanged(false);
            this.fTreeViewer.refresh();
            this.updateButtons();
        }
    }

    private void handleEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            EditBundleContainerWizard editWizard;
            Object currentSelection = iterator.next();
            if (currentSelection instanceof ITargetLocation) {
                EditBundleContainerWizard wizard;
                ITargetLocationEditor editor;
                ITargetLocation location = (ITargetLocation)currentSelection;
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.pde.ui.target.ITargetLocationEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((editor = (ITargetLocationEditor)iAdapterManager.getAdapter((Object)location, (Class)clazz)) != null) {
                    Shell parent;
                    WizardDialog wizard2;
                    if (!editor.canEdit(this.fTarget, location)) continue;
                    IWizard editWizard2 = editor.getEditWizard(this.fTarget, location);
                    if (editWizard2 == null || (wizard2 = new WizardDialog(parent = this.fTreeViewer.getTree().getShell(), editWizard2)).open() != 0) break;
                    this.contentsChanged(false);
                    this.fTreeViewer.refresh();
                    this.updateButtons();
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)location), true);
                    break;
                }
                if (!(location instanceof AbstractBundleContainer)) continue;
                Shell parent = this.fTreeViewer.getTree().getShell();
                WizardDialog dialog = new WizardDialog(parent, (IWizard)(wizard = new EditBundleContainerWizard(this.fTarget, location)));
                if (dialog.open() != 0) break;
                this.contentsChanged(false);
                this.fTreeViewer.refresh();
                this.updateButtons();
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)location), true);
                break;
            }
            if (!(currentSelection instanceof IUContentProvider.IUWrapper)) continue;
            IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)currentSelection;
            Shell parent = this.fTreeViewer.getTree().getShell();
            WizardDialog wizard = new WizardDialog(parent, (IWizard)(editWizard = new EditBundleContainerWizard(this.fTarget, (ITargetLocation)wrapper.getParent())));
            if (wizard.open() != 0) break;
            this.contentsChanged(false);
            this.fTreeViewer.refresh();
            this.updateButtons();
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)wrapper.getParent()), true);
            break;
        }
    }

    private void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        ITargetLocation[] containers = this.fTarget.getTargetLocations();
        if (!selection.isEmpty() && containers != null && containers.length > 0) {
            ArrayList toRemove = new ArrayList();
            boolean removedSite = false;
            boolean removedContainer = false;
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object currentSelection = iterator.next();
                if (currentSelection instanceof ITargetLocation) {
                    if (currentSelection instanceof IUBundleContainer) {
                        removedSite = true;
                    }
                    removedContainer = true;
                    toRemove.add(currentSelection);
                }
                if (!(currentSelection instanceof IUContentProvider.IUWrapper)) continue;
                toRemove.add(currentSelection);
            }
            if (removedContainer) {
                HashSet<ITargetLocation> newContainers = new HashSet<ITargetLocation>();
                newContainers.addAll(Arrays.asList(this.fTarget.getTargetLocations()));
                newContainers.removeAll(toRemove);
                if (newContainers.size() > 0) {
                    this.fTarget.setTargetLocations(newContainers.toArray(new ITargetLocation[newContainers.size()]));
                } else {
                    this.fTarget.setTargetLocations(null);
                }
                this.contentsChanged(removedSite);
                this.fTreeViewer.refresh(false);
                this.updateButtons();
            } else {
                iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    Object current = iterator.next();
                    if (!(current instanceof IUContentProvider.IUWrapper)) continue;
                    ((IUContentProvider.IUWrapper)current).getParent().removeInstallableUnit(((IUContentProvider.IUWrapper)current).getIU());
                }
                this.contentsChanged(removedSite);
                this.fTreeViewer.refresh(true);
                this.updateButtons();
            }
        }
    }

    private void handleUpdate() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        HashMap toUpdate = new HashMap();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object currentSelection = iterator.next();
            if (currentSelection instanceof ITargetLocation) {
                toUpdate.put(currentSelection, new HashSet(0));
                continue;
            }
            if (!(currentSelection instanceof IUContentProvider.IUWrapper)) continue;
            IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)currentSelection;
            HashSet<String> iuSet = (HashSet<String>)toUpdate.get(wrapper.getParent());
            if (iuSet == null) {
                iuSet = new HashSet<String>();
                iuSet.add(wrapper.getIU().getId());
                toUpdate.put(wrapper.getParent(), iuSet);
                continue;
            }
            if (iuSet.isEmpty()) continue;
            iuSet.add(wrapper.getIU().getId());
        }
        if (toUpdate.isEmpty()) {
            return;
        }
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIJob job = new UIJob(this, Messages.UpdateTargetJob_UpdateJobName, event){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ IJobChangeEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = iJobChangeEvent;
                    }

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IStatus result = this.val$event.getJob().getResult();
                        if (!result.isOK()) {
                            ErrorDialog.openError((Shell)TargetLocationsGroup.access$7(11.access$0(this.this$1)).getTree().getShell(), (String)Messages.TargetLocationsGroup_TargetUpdateErrorDialog, (String)result.getMessage(), (IStatus)result);
                        } else if (result.getCode() != 101) {
                            TargetLocationsGroup.access$8(11.access$0(this.this$1), true);
                            TargetLocationsGroup.access$7(11.access$0(this.this$1)).refresh(true);
                            try {
                                ITargetHandle currentTarget = TargetPlatformService.getDefault().getWorkspaceTargetHandle();
                                if (TargetLocationsGroup.access$9(11.access$0(this.this$1)).getHandle().equals(currentTarget)) {
                                    LoadTargetDefinitionJob.load((ITargetDefinition)TargetLocationsGroup.access$9(11.access$0(this.this$1)));
                                }
                            }
                            catch (CoreException coreException) {}
                            TargetLocationsGroup.access$3(11.access$0(this.this$1));
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }

            static /* synthetic */ TargetLocationsGroup access$0(11 var0) {
                return var0.TargetLocationsGroup.this;
            }
        };
        UpdateTargetJob.update(this.fTarget, toUpdate, (IJobChangeListener)listener);
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.isEmpty()) {
            this.fRemoveButton.setEnabled(false);
            this.fUpdateButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
        }
        boolean canRemove = false;
        boolean canEdit = false;
        boolean canUpdate = false;
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object currentSelection = iterator.next();
            if (currentSelection instanceof ITargetLocation) {
                ITargetLocation location;
                canRemove = true;
                if (!canEdit) {
                    ITargetLocationEditor editor;
                    location = (ITargetLocation)currentSelection;
                    IAdapterManager iAdapterManager = Platform.getAdapterManager();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.pde.ui.target.ITargetLocationEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((editor = (ITargetLocationEditor)iAdapterManager.getAdapter((Object)location, (Class)clazz)) != null) {
                        canEdit = editor.canEdit(this.fTarget, location);
                    }
                    if (location instanceof AbstractBundleContainer) {
                        canEdit = true;
                    }
                }
                if (!canUpdate) {
                    ITargetLocationUpdater updater;
                    location = (ITargetLocation)currentSelection;
                    IAdapterManager iAdapterManager = Platform.getAdapterManager();
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.pde.ui.target.ITargetLocationUpdater");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((updater = (ITargetLocationUpdater)iAdapterManager.getAdapter((Object)location, (Class)clazz)) != null) {
                        canUpdate = updater.canUpdate(this.fTarget, location);
                    }
                }
            } else if (currentSelection instanceof IUContentProvider.IUWrapper) {
                canRemove = true;
                canEdit = true;
                canUpdate = true;
            }
            if (canRemove && canEdit && canUpdate) break;
        }
        this.fRemoveButton.setEnabled(canRemove);
        this.fEditButton.setEnabled(canEdit);
        this.fUpdateButton.setEnabled(canUpdate);
    }

    private void contentsChanged(boolean force) {
        Object[] listeners = this.fChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITargetChangedListener)listeners[i]).contentsChanged(this.fTarget, this, true, force);
            ++i;
        }
    }

    static /* synthetic */ void access$8(TargetLocationsGroup targetLocationsGroup, boolean bl) {
        targetLocationsGroup.contentsChanged(bl);
    }

    static /* synthetic */ ITargetDefinition access$9(TargetLocationsGroup targetLocationsGroup) {
        return targetLocationsGroup.fTarget;
    }

    class TargetLocationContentProvider
    implements ITreeContentProvider {
        TargetLocationContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITargetDefinition) {
                ITargetLocation[] containers = ((ITargetDefinition)parentElement).getTargetLocations();
                return containers != null ? containers : new Object[]{};
            }
            if (parentElement instanceof ITargetLocation) {
                ITargetLocation location = (ITargetLocation)parentElement;
                if (location.isResolved()) {
                    IStatus status = location.getStatus();
                    if (!status.isOK() && !status.isMultiStatus()) {
                        return new Object[]{status};
                    }
                    if (TargetLocationsGroup.this.fShowContentButton.getSelection()) {
                        return location.getBundles();
                    }
                    if (!status.isOK()) {
                        if (status.isMultiStatus()) {
                            return status.getChildren();
                        }
                    } else {
                        ITreeContentProvider provider;
                        IAdapterManager iAdapterManager = Platform.getAdapterManager();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ITreeContentProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((provider = (ITreeContentProvider)iAdapterManager.getAdapter(parentElement, (Class)clazz)) != null) {
                            return provider.getChildren(parentElement);
                        }
                    }
                }
            } else {
                ITreeContentProvider provider;
                if (parentElement instanceof MultiStatus) {
                    return ((MultiStatus)parentElement).getChildren();
                }
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ITreeContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((provider = (ITreeContentProvider)iAdapterManager.getAdapter(parentElement, (Class)clazz)) != null) {
                    return provider.getChildren(parentElement);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IUContentProvider.IUWrapper) {
                return ((IUContentProvider.IUWrapper)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITargetDefinition) {
                IStatus status;
                boolean hasContainerStatus = false;
                ArrayList<Object> result = new ArrayList<Object>();
                ITargetLocation[] containers = ((ITargetDefinition)inputElement).getTargetLocations();
                if (containers != null) {
                    int i = 0;
                    while (i < containers.length) {
                        result.add(containers[i]);
                        if (containers[i].getStatus() != null && !containers[i].getStatus().isOK()) {
                            hasContainerStatus = true;
                        }
                        ++i;
                    }
                }
                if (!hasContainerStatus && (status = ((ITargetDefinition)inputElement).getStatus()) != null && !status.isOK()) {
                    result.add(status);
                }
                return result.toArray();
            }
            if (inputElement instanceof String) {
                return new Object[]{inputElement};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

