/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.util;

import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.util.ParameterTypeConverter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeAnalyser {
    private static final ASTParser AST_PARSER = ASTParser.newParser((int)3);

    public static boolean isRightParameterType(String string) {
        return "java.lang.String".equals(string);
    }

    public static boolean hasValidMethods(IType iType) throws JavaModelException {
        return CodeAnalyser.getValidMethods(iType, null, true).size() > 0;
    }

    public static List<MethodReference> getValidMethods(AccessorConfiguration accessorConfiguration, ClassReference classReference) throws JavaModelException {
        IType iType = accessorConfiguration.resolve(classReference);
        if (iType != null) {
            return CodeAnalyser.getValidMethods(iType, classReference, false);
        }
        return Collections.emptyList();
    }

    private static List<MethodReference> getValidMethods(IType iType, ClassReference classReference, boolean bl) throws JavaModelException {
        LinkedList<MethodReference> linkedList = new LinkedList<MethodReference>();
        if (iType.isBinary()) {
            CodeAnalyser.resolveMethodsFromBinaryType(iType, classReference, bl, linkedList);
        } else {
            CodeAnalyser.resolveMethodsFromSourceType(iType, classReference, bl, linkedList);
        }
        return linkedList;
    }

    private static void resolveMethodsFromSourceType(IType iType, ClassReference classReference, boolean bl, List<MethodReference> list) {
        AST_PARSER.setSource(iType.getTypeRoot());
        AST_PARSER.setResolveBindings(true);
        ASTNode aSTNode = AST_PARSER.createAST(null);
        aSTNode.accept((ASTVisitor)new SourceTypeVisitor(classReference, bl, list));
    }

    private static void resolveMethodsFromBinaryType(IType iType, ClassReference classReference, boolean bl, List<MethodReference> list) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            if (!iMethodArray[n].isConstructor()) {
                String[] stringArray = iMethodArray[n].getParameterTypes();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (CodeAnalyser.isRightParameterType(ParameterTypeConverter.decodeQualifiedSignatureString(stringArray[n2]))) {
                        list.add(CodeAnalyser.createMethodReference(classReference, iMethodArray[n]));
                        if (!bl) break;
                        return;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static final MethodReference createMethodReference(ClassReference classReference, IMethod iMethod) {
        String[] stringArray = iMethod.getParameterTypes();
        String[] stringArray2 = null;
        try {
            stringArray2 = iMethod.getParameterNames();
        }
        catch (JavaModelException javaModelException) {
            stringArray2 = new String[stringArray.length];
        }
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray3 = new String[]{ParameterTypeConverter.decodeQualifiedSignatureString(stringArray[n]), stringArray2[n]};
            linkedList.add(stringArray3);
            ++n;
        }
        return new MethodReference(classReference, iMethod.getElementName(), linkedList);
    }

    static final MethodReference createMethodReference(ClassReference classReference, MethodDeclaration methodDeclaration) {
        List list = methodDeclaration.parameters();
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        for (SingleVariableDeclaration singleVariableDeclaration : list) {
            String string = ParameterTypeConverter.toQualifiedString(singleVariableDeclaration);
            if (string == null) {
                return null;
            }
            String string2 = singleVariableDeclaration.getName().getFullyQualifiedName();
            linkedList.add(new String[]{string, string2});
        }
        return new MethodReference(classReference, methodDeclaration.getName().getFullyQualifiedName(), linkedList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SourceTypeVisitor
    extends ASTVisitor {
        private ClassReference fClassReference;
        private boolean fReturnOnFirstMatch;
        private List<MethodReference> fValidMethods;

        SourceTypeVisitor(ClassReference classReference, boolean bl, List<MethodReference> list) {
            this.fClassReference = classReference;
            this.fReturnOnFirstMatch = bl;
            this.fValidMethods = list;
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            if (!methodDeclaration.isConstructor()) {
                List list = methodDeclaration.parameters();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = ParameterTypeConverter.toQualifiedString((SingleVariableDeclaration)iterator.next());
                    if (!CodeAnalyser.isRightParameterType(string)) continue;
                    MethodReference methodReference = CodeAnalyser.createMethodReference(this.fClassReference, methodDeclaration);
                    if (methodReference != null) {
                        this.fValidMethods.add(methodReference);
                    }
                    if (!this.fReturnOnFirstMatch) break;
                    return false;
                }
            }
            return true;
        }
    }
}

