/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.model;

import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.io.CharsetInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;

public class ResourceFile {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CHARSET_UTF = "UTF-";
    private IStorage fileStorage;
    private Locale localeInfos;

    public ResourceFile(IStorage iStorage, Locale locale) {
        this.setFileStorage(iStorage);
        this.setLocaleInfos(locale);
    }

    public Properties loadProperties() throws IOException, CoreException {
        Properties properties = new Properties();
        try {
            String string;
            IStorage iStorage = this.getFileStorage();
            InputStream inputStream = null;
            if (iStorage instanceof IEncodedStorage && (string = ((IEncodedStorage)iStorage).getCharset()) != null) {
                inputStream = new CharsetInputStream(iStorage.getContents(), string);
            }
            if (inputStream == null) {
                inputStream = iStorage.getContents();
            }
            properties.load(inputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Illegal arguments in file " + this.getFileStorage().getName() + ": " + illegalArgumentException.getMessage());
        }
        return properties;
    }

    protected void saveProperties(Properties properties, boolean bl) throws IOException, CoreException {
        IStorage iStorage;
        if (this.isDirty(properties) && (iStorage = this.getFileStorage()) instanceof IFile) {
            byte[] byArray;
            IFile iFile = (IFile)this.getFileStorage();
            String string = null;
            if (bl) {
                string = "Created by JInto - www.guh-software.de";
            }
            JIntoOutputStream jIntoOutputStream = new JIntoOutputStream(!bl);
            properties.store(jIntoOutputStream, string);
            jIntoOutputStream.flush();
            byte[] byArray2 = jIntoOutputStream.toByteArray();
            String string2 = new String(byArray2, "8859_1");
            String string3 = iFile.getCharset();
            if (string3 != null && string3.startsWith(CHARSET_UTF)) {
                string2 = ResourceFile.unescapeForSaving(string2);
            }
            InputStream inputStream = new ByteArrayInputStream(string2.getBytes(string3));
            IContentDescription iContentDescription = iFile.getContentDescription();
            if (CHARSET_UTF_8.equals(string3) && iContentDescription != null && (byArray = (byte[])iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK)) != null) {
                inputStream = new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
            }
            ((IFile)this.getFileStorage()).setContents(inputStream, false, false, null);
        }
    }

    public static String unescapeForSaving(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            block0 : switch (c) {
                case '\\': {
                    if (++n < string.length()) {
                        c = string.charAt(n);
                        switch (c) {
                            case 'u': {
                                int n2 = 0;
                                ++n;
                                int n3 = 0;
                                while (n3 < 4) {
                                    int n4 = -1;
                                    if (n + n3 > string.length()) {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                    char c2 = string.charAt(n + n3);
                                    if (c2 >= '0' && c2 <= '9') {
                                        n4 = c2 - 48;
                                    } else if (c2 >= 'a' && c2 <= 'f') {
                                        n4 = c2 - 97 + 10;
                                    } else if (c2 >= 'A' && c2 <= 'F') {
                                        n4 = c2 - 65 + 10;
                                    } else {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                    n2 = (n2 << 4) + n4;
                                    ++n3;
                                }
                                n += 3;
                                stringBuffer.append((char)n2);
                                break block0;
                            }
                        }
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        break;
                    }
                    throw new IllegalArgumentException("Illegal escape sequence!");
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isDirty(Properties properties) throws IOException, CoreException {
        return !this.loadProperties().equals(properties);
    }

    public String getResourceKey() {
        return Util.getDisplayNameForLocale(this.getLocaleInfos());
    }

    public IStorage getFileStorage() {
        return this.fileStorage;
    }

    private void setFileStorage(IStorage iStorage) {
        this.fileStorage = iStorage;
    }

    public Locale getLocaleInfos() {
        return this.localeInfos;
    }

    private void setLocaleInfos(Locale locale) {
        this.localeInfos = locale;
    }

    private static class JIntoOutputStream
    extends ByteArrayOutputStream {
        private final char SEPARATOR_START = System.getProperty("line.separator").charAt(0);
        private boolean inFirstLine = true;
        private boolean isFirstWrite = true;
        private boolean isComment = false;
        private boolean skipHeader;

        public JIntoOutputStream(boolean bl) {
            this.skipHeader = bl;
        }

        public synchronized void write(byte[] byArray, int n, int n2) {
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.skipHeader && this.inFirstLine) {
                if (this.isFirstWrite) {
                    this.isFirstWrite = false;
                    if (byArray[n] == 35) {
                        this.isComment = true;
                    }
                }
                int n3 = 0;
                while (n3 < n2) {
                    if (this.isComment && byArray[n3 + n] == this.SEPARATOR_START) {
                        n += n3;
                        n2 -= n3;
                        this.inFirstLine = false;
                        break;
                    }
                    ++n3;
                }
            }
            super.write(byArray, n, n2);
        }
    }
}

