/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.model;

import de.guhsoft.jinto.core.Messages;
import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.model.IResourceBundleListener;
import de.guhsoft.jinto.core.model.ResourceFile;
import de.guhsoft.jinto.core.model.ResourceProperties;
import de.guhsoft.jinto.core.model.ResourceRow;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.SafeRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceBundleModel {
    private String name;
    private AbstractMap<String, ResourceRow> rows;
    private AbstractMap<String, ResourceFile> resourceFilesMap;
    private IStorage selectedStorage;
    private boolean load;
    private ListenerList fListenerList;
    private IUndoContext fUndoContent;

    protected ResourceBundleModel(String string, IStorage iStorage, boolean bl) {
        this.setName(string);
        this.setSelectedStorage(iStorage);
        this.setRows(new HashMap<String, ResourceRow>());
        this.setResourceFilesMap(new HashMap<String, ResourceFile>());
        this.fListenerList = new ListenerList();
        this.load = bl;
        this.fUndoContent = new ObjectUndoContext((Object)this);
    }

    public IUndoContext getUndoContent() {
        return this.fUndoContent;
    }

    public void load() throws IOException, CoreException {
        this.rows.clear();
        this.load = true;
        int n = 0;
        while (n < this.getResourceFileCount()) {
            Map.Entry<String, ResourceFile> entry = this.getResourceFileMapEntry(n);
            this.loadResourceFile(entry.getValue(), entry.getKey());
            ++n;
        }
    }

    public boolean isLoaded() {
        return this.load;
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl, boolean bl2) throws IOException, CoreException {
        Object object;
        Object[] objectArray;
        int n = this.getResourceFileCount() + 1;
        iProgressMonitor.beginTask(Messages.getString("save.progressMonitor", new Object[0]), n);
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        int n2 = 0;
        while (n2 < this.getResourceFileCount()) {
            objectArray = new Object[3];
            object = this.getResourceFileMapEntry(n2);
            objectArray[0] = object.getKey();
            objectArray[1] = object.getValue();
            objectArray[2] = new ResourceProperties();
            linkedList.add(objectArray);
            ++n2;
        }
        object = this.getRowKeys();
        while (object.hasNext()) {
            String string = (String)object.next();
            ResourceRow resourceRow = this.getRow(string);
            int n3 = 0;
            while (n3 < linkedList.size()) {
                objectArray = (Object[])linkedList.get(n3);
                String string2 = resourceRow.getColumnValue((String)objectArray[0]);
                if (bl) {
                    ((Properties)objectArray[2]).put(string, Util.unescapeForLabel(string2));
                } else if (string2.length() > 0) {
                    ((Properties)objectArray[2]).put(string, Util.unescapeForLabel(string2));
                }
                ++n3;
            }
        }
        iProgressMonitor.worked(1);
        int n4 = 0;
        while (n4 < linkedList.size()) {
            objectArray = (Object[])linkedList.get(n4);
            ((ResourceFile)objectArray[1]).saveProperties((Properties)objectArray[2], bl2);
            iProgressMonitor.worked(2 + n4);
            ++n4;
        }
        iProgressMonitor.done();
    }

    public void addListener(IResourceBundleListener iResourceBundleListener) {
        this.fListenerList.add((Object)iResourceBundleListener);
    }

    public void removeListener(IResourceBundleListener iResourceBundleListener) {
        this.fListenerList.remove((Object)iResourceBundleListener);
    }

    private void fireRowRemoved(final String string, final ResourceRow resourceRow) {
        final Object[] objectArray = this.fListenerList.getListeners();
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                int n = 0;
                while (n < objectArray.length) {
                    ((IResourceBundleListener)objectArray[n]).rowRemoved(string, resourceRow);
                    ++n;
                }
            }
        });
    }

    private void fireRowAdded(final String string, final ResourceRow resourceRow) {
        final Object[] objectArray = this.fListenerList.getListeners();
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                int n = 0;
                while (n < objectArray.length) {
                    ((IResourceBundleListener)objectArray[n]).rowAdded(string, resourceRow);
                    ++n;
                }
            }
        });
    }

    private void fireRowKeyChanged(final String string, final String string2, final ResourceRow resourceRow) {
        final Object[] objectArray = this.fListenerList.getListeners();
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                int n = 0;
                while (n < objectArray.length) {
                    ((IResourceBundleListener)objectArray[n]).rowKeyChanged(string, string2, resourceRow);
                    ++n;
                }
            }
        });
    }

    protected void fireRowValueChanged(final ResourceRow resourceRow, final String string, final String string2) {
        final Object[] objectArray = this.fListenerList.getListeners();
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                int n = 0;
                while (n < objectArray.length) {
                    ((IResourceBundleListener)objectArray[n]).rowValueChanged(resourceRow, string, string2);
                    ++n;
                }
            }
        });
    }

    protected ResourceRow removeRow(String string) {
        return this.removeRow(string, true);
    }

    public ResourceRow removeRow(String string, boolean bl) {
        ResourceRow resourceRow = this.rows.remove(string);
        if (resourceRow != null && bl) {
            this.fireRowRemoved(string, resourceRow);
        }
        return resourceRow;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Iterator<String> getRowKeys() {
        return this.rows.keySet().iterator();
    }

    public ResourceRow getRow(String string) {
        return this.rows.get(string);
    }

    public ResourceRow[] getRows() {
        Collection<ResourceRow> collection = this.rows.values();
        return collection.toArray(new ResourceRow[collection.size()]);
    }

    protected boolean setRowKey(String string, String string2) {
        ResourceRow resourceRow = this.rows.get(string);
        if (resourceRow != null) {
            resourceRow.setKey(string2);
            this.rows.remove(string);
            this.rows.put(string2, resourceRow);
            this.fireRowKeyChanged(string, string2, resourceRow);
            return true;
        }
        return false;
    }

    protected void addRow(String string) {
        this.addRow(string, new ResourceRow(string, this));
    }

    protected void addRow(String string, ResourceRow resourceRow) {
        this.addRow(string, resourceRow, true);
    }

    public void addRow(String string, ResourceRow resourceRow, boolean bl) {
        this.rows.put(string, resourceRow);
        if (bl) {
            this.fireRowAdded(string, resourceRow);
        }
    }

    public int getResourceFileCount() {
        return this.getResourceFilesMap().size();
    }

    public Map.Entry<String, ResourceFile> getResourceFileMapEntry(int n) {
        int n2 = 0;
        for (Map.Entry<String, ResourceFile> entry : this.getResourceFilesMap().entrySet()) {
            if (n2 == n) {
                return entry;
            }
            ++n2;
        }
        throw new IndexOutOfBoundsException("Index out of range: " + n);
    }

    public ResourceFile getResourceFile(String string) {
        return this.getResourceFilesMap().get(string);
    }

    public void addResourceFile(ResourceFile resourceFile) throws IOException, CoreException {
        String string = resourceFile.getResourceKey();
        this.getResourceFilesMap().put(string, resourceFile);
        if (this.load) {
            this.loadResourceFile(resourceFile, string);
        }
    }

    private void loadResourceFile(ResourceFile resourceFile, String string) throws IOException, CoreException {
        ResourceRow resourceRow;
        Object object;
        IResource iResource = (IResource)resourceFile.getFileStorage().getAdapter(IResource.class);
        if (iResource != null && !iResource.exists()) {
            this.removeResourceFile(resourceFile);
            return;
        }
        Properties properties = resourceFile.loadProperties();
        Object object2 = this.getRowKeys();
        while (object2.hasNext()) {
            object = object2.next();
            resourceRow = this.getRow((String)object);
            String string2 = (String)properties.remove(object);
            resourceRow.setColumnValue(string, Util.escapeForLabel(string2 == null ? "" : string2), false);
        }
        object = properties.keys();
        while (object.hasMoreElements()) {
            object2 = (String)object.nextElement();
            resourceRow = new ResourceRow(Util.escapeForLabel((String)object2), this);
            resourceRow.setColumnValue(string, Util.escapeForLabel(properties.getProperty((String)object2)), false);
            this.rows.put(Util.escapeForLabel((String)object2), resourceRow);
        }
    }

    public void removeResourceFile(ResourceFile resourceFile) {
        String string = resourceFile.getResourceKey();
        this.getResourceFilesMap().remove(string);
        if (this.load) {
            Iterator<String> iterator = this.rows.keySet().iterator();
            while (iterator.hasNext()) {
                ResourceRow resourceRow = this.rows.get(iterator.next());
                resourceRow.removeColumnValue(string);
            }
        }
    }

    public ResourceFile getDefaultResourceFile() {
        int n = 0;
        while (n < this.getResourceFileCount()) {
            ResourceFile resourceFile = this.getResourceFileMapEntry(n).getValue();
            Locale locale = resourceFile.getLocaleInfos();
            if (locale == null) {
                return resourceFile;
            }
            ++n;
        }
        return null;
    }

    public boolean contains(IStorage iStorage) {
        int n = 0;
        while (n < this.getResourceFileCount()) {
            if (this.getResourceFileMapEntry(n).getValue().getFileStorage().equals(iStorage)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private AbstractMap<String, ResourceFile> getResourceFilesMap() {
        return this.resourceFilesMap;
    }

    private void setResourceFilesMap(AbstractMap<String, ResourceFile> abstractMap) {
        this.resourceFilesMap = abstractMap;
    }

    private void setRows(AbstractMap<String, ResourceRow> abstractMap) {
        this.rows = abstractMap;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String string) {
        this.name = string;
    }

    public IStorage getSelectedStorage() {
        return this.selectedStorage;
    }

    protected void setSelectedStorage(IStorage iStorage) {
        this.selectedStorage = iStorage;
    }

    public String getFullyQualifiedName(boolean bl) {
        IFile iFile;
        IJavaElement iJavaElement;
        if (this.getSelectedStorage() instanceof IFile && (iJavaElement = JavaCore.create((IResource)(iFile = (IFile)this.getSelectedStorage()).getParent())) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append(iJavaElement.getJavaProject().getElementName());
                stringBuffer.append(':');
            }
            if (iJavaElement.getElementType() == 4) {
                stringBuffer.append(iJavaElement.getElementName());
                stringBuffer.append('.');
            }
            stringBuffer.append(this.getName());
            return stringBuffer.toString();
        }
        return this.getSelectedStorage().getFullPath().toString();
    }

    public String toString() {
        return this.getFullyQualifiedName(true);
    }
}

