/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration.accessor;

import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.util.CodeAnalyser;
import de.guhsoft.jinto.core.util.ParameterTypeConverter;
import org.eclipse.ui.IMemento;

public class ParameterReference {
    private MethodReference fMethodReference;
    private int fIndex;
    private String fFullyQualifiedParameterType;
    private String fParameterName;
    private boolean fIsSelected;
    private boolean fIsValidType;

    public ParameterReference(MethodReference methodReference, int n, String string, String string2) {
        this(methodReference, n, false, string, string2);
    }

    protected ParameterReference(MethodReference methodReference, int n, boolean bl, String string, String string2) {
        this.fMethodReference = methodReference;
        this.fIndex = n;
        this.fFullyQualifiedParameterType = string;
        this.fParameterName = string2;
        this.fIsSelected = bl;
        this.fIsValidType = CodeAnalyser.isRightParameterType(string);
    }

    public MethodReference getMethodReference() {
        return this.fMethodReference;
    }

    public boolean isValidType() {
        return this.fIsValidType;
    }

    public void setSelected(boolean bl) {
        this.fIsSelected = bl;
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ParameterTypeConverter.getSimpleName(this.fFullyQualifiedParameterType));
        if (this.fParameterName != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.fParameterName);
        }
        return stringBuffer.toString();
    }

    public String getFullyQualifiedParameterType() {
        return this.fFullyQualifiedParameterType;
    }

    public int getIndex() {
        return this.fIndex;
    }

    protected void writeMemento(IMemento iMemento) {
        iMemento.putString("parameterType", this.fFullyQualifiedParameterType);
        iMemento.putString("parameterName", this.fParameterName);
        iMemento.putInteger("index", this.fIndex);
        iMemento.putString("isSelected", String.valueOf(this.isSelected()));
    }

    protected static ParameterReference readMemento(MethodReference methodReference, IMemento iMemento) {
        String string = iMemento.getString("parameterType");
        String string2 = iMemento.getString("parameterName");
        Integer n = iMemento.getInteger("index");
        Boolean bl = Boolean.valueOf(iMemento.getString("isSelected"));
        if (string != null && string2 != null && n != null && bl != null) {
            return new ParameterReference(methodReference, n, bl, string, string2);
        }
        return null;
    }
}

