/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration.accessor;

import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.ParameterReference;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodReference
implements Cloneable {
    private ClassReference fParent;
    private String fMethodName;
    private List<ParameterReference> fParameterReferences;

    public MethodReference(ClassReference classReference, String string, List<String[]> list) {
        this(classReference, string);
        LinkedList<ParameterReference> linkedList = new LinkedList<ParameterReference>();
        int n = 0;
        while (n < list.size()) {
            String[] stringArray = list.get(n);
            linkedList.add(new ParameterReference(this, n, stringArray[0], stringArray[1]));
            ++n;
        }
        this.setParameterReferences(linkedList);
    }

    protected MethodReference(ClassReference classReference, String string) {
        this.fParent = classReference;
        this.fMethodName = string;
    }

    public MethodReference clone() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"clone");
        this.writeMemento((IMemento)xMLMemento);
        return MethodReference.readMemento(this.fParent, (IMemento)xMLMemento);
    }

    public ClassReference getClassReference() {
        return this.fParent;
    }

    private void setParameterReferences(List<ParameterReference> list) {
        this.fParameterReferences = list;
    }

    public void setSelectedParameter(Object object) {
        for (ParameterReference parameterReference : this.fParameterReferences) {
            parameterReference.setSelected(parameterReference.equals(object));
        }
    }

    public ParameterReference getSelectedParameter() {
        for (ParameterReference parameterReference : this.fParameterReferences) {
            if (!parameterReference.isSelected()) continue;
            return parameterReference;
        }
        return null;
    }

    public int getParameterCount() {
        return this.fParameterReferences.size();
    }

    public ParameterReference getParameter(int n) {
        for (ParameterReference parameterReference : this.fParameterReferences) {
            if (n != parameterReference.getIndex()) continue;
            return parameterReference;
        }
        return null;
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMethodName());
        stringBuffer.append("(");
        int n = this.getParameterCount();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.getParameter(n2).getDisplayString());
            if (n2 + 1 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    protected void writeMemento(IMemento iMemento) {
        iMemento.putString("methodName", this.fMethodName);
        for (ParameterReference parameterReference : this.fParameterReferences) {
            parameterReference.writeMemento(iMemento.createChild("parameter"));
        }
    }

    protected static MethodReference readMemento(ClassReference classReference, IMemento iMemento) {
        String string = iMemento.getString("methodName");
        MethodReference methodReference = new MethodReference(classReference, string);
        IMemento[] iMementoArray = iMemento.getChildren("parameter");
        LinkedList<ParameterReference> linkedList = new LinkedList<ParameterReference>();
        int n = 0;
        while (n < iMementoArray.length) {
            ParameterReference parameterReference = ParameterReference.readMemento(methodReference, iMementoArray[n]);
            if (parameterReference == null) {
                return null;
            }
            linkedList.add(parameterReference);
            ++n;
        }
        methodReference.setParameterReferences(linkedList);
        return methodReference;
    }
}

