/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration.accessor;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ParameterReference;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import de.guhsoft.jinto.core.model.ResourceBundleManager;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorConfigurationManager {
    private static AccessorConfigurationManager INSTANCE;
    private static final int IGNORE_PARAMETER_INDEX = -1;
    private IElementChangedListener fElementChangedListener;
    private AccessorConfigurationMapper fAccessorConfigurationMapper = new AccessorConfigurationMapper();

    public static AccessorConfigurationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AccessorConfigurationManager();
        }
        return INSTANCE;
    }

    private AccessorConfigurationManager() {
        this.fElementChangedListener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent elementChangedEvent) {
                try {
                    AccessorConfigurationManager.this.elementChanged(elementChangedEvent.getDelta());
                }
                catch (CoreException coreException) {
                    String string = "Unexpected exception while checking elementChanged event";
                    JIntoCore.getDefault().getLog().log((IStatus)new Status(4, JIntoCore.getID(), string, (Throwable)coreException));
                }
                catch (IOException iOException) {
                    String string = "Unexpected exception while checking elementChanged event";
                    JIntoCore.getDefault().getLog().log((IStatus)new Status(4, JIntoCore.getID(), string, (Throwable)iOException));
                }
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this.fElementChangedListener, (int)1);
    }

    public AccessorConfiguration getAccessorConfiguration(IJavaProject iJavaProject) throws CoreException {
        if (iJavaProject != null) {
            return this.fAccessorConfigurationMapper.getAccessorConfiguration(iJavaProject);
        }
        return null;
    }

    public final ProjectMethodReference getMethodReference(IJavaProject iJavaProject, MethodInvocation methodInvocation) throws JavaModelException, IOException, CoreException {
        return this.getMethodReference(iJavaProject, methodInvocation, -1, new HashSet<IJavaProject>());
    }

    public final ResourceBundleModel getResourceBundle(IJavaProject iJavaProject, MethodInvocation methodInvocation, int n) throws JavaModelException, IOException, CoreException {
        ClassReference classReference;
        ProjectMethodReference projectMethodReference = this.getMethodReference(iJavaProject, methodInvocation, n, new HashSet<IJavaProject>());
        if (projectMethodReference != null && (classReference = projectMethodReference.getMethodReference().getClassReference()) != null) {
            Object object;
            IJavaProject iJavaProject2 = projectMethodReference.getReferencedProject();
            AccessorConfiguration accessorConfiguration = this.getAccessorConfiguration(iJavaProject2);
            if (accessorConfiguration != null && (object = accessorConfiguration.resolve(classReference.getResourceBundleReference())) != null) {
                return object;
            }
            Object object2 = object = iJavaProject2.getProject().getReferencingProjects();
            int n2 = ((IProject[])object).length;
            int n3 = 0;
            while (n3 < n2) {
                ResourceBundleModel resourceBundleModel;
                IProject iProject = object2[n3];
                IJavaProject iJavaProject3 = JavaCore.create((IProject)iProject);
                if (iJavaProject3 != null && iJavaProject3.exists() && iJavaProject3.isOpen() && (accessorConfiguration = this.getAccessorConfiguration(iJavaProject3)) != null && (resourceBundleModel = accessorConfiguration.resolve(classReference.getResourceBundleReference())) != null) {
                    return resourceBundleModel;
                }
                ++n3;
            }
        }
        return null;
    }

    private final ProjectMethodReference getMethodReference(IJavaProject iJavaProject, MethodInvocation methodInvocation, int n, Set<IJavaProject> set) throws JavaModelException, IOException, CoreException {
        if (set.contains(iJavaProject)) {
            return null;
        }
        set.add(iJavaProject);
        this.getAccessorConfiguration(iJavaProject);
        ProjectMethodReference projectMethodReference = this.fAccessorConfigurationMapper.getMethodReference(methodInvocation, n);
        if (projectMethodReference != null) {
            return projectMethodReference;
        }
        IProject iProject = iJavaProject.getProject();
        if (iProject.exists()) {
            IProject[] iProjectArray = iProject.getReferencedProjects();
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                IJavaProject iJavaProject2 = JavaCore.create((IProject)iProjectArray[n2]);
                if (iJavaProject2 != null && (projectMethodReference = this.getMethodReference(iJavaProject2, methodInvocation, n, set)) != null) {
                    return projectMethodReference;
                }
                ++n2;
            }
        }
        return null;
    }

    public void save(AccessorConfiguration accessorConfiguration, List<ResourceBundleReference> list) throws IOException {
        accessorConfiguration.save(list);
        this.fAccessorConfigurationMapper.rebuild();
    }

    void elementChanged(IJavaElementDelta iJavaElementDelta) throws CoreException, IOException {
        block0 : switch (iJavaElementDelta.getKind()) {
            case 2: 
            case 4: {
                IResourceDelta[] iResourceDeltaArray = iJavaElementDelta.getResourceDeltas();
                if (iResourceDeltaArray != null && iResourceDeltaArray.length > 0) {
                    this.resourcesChanged(iJavaElementDelta.getElement().getJavaProject(), iResourceDeltaArray);
                }
                IJavaElement iJavaElement = iJavaElementDelta.getElement();
                switch (iJavaElement.getElementType()) {
                    case 5: {
                        if (!iJavaElement.exists()) break block0;
                        IType[] iTypeArray = ((ICompilationUnit)iJavaElement).getTypes();
                        int n = 0;
                        while (n < iTypeArray.length) {
                            this.typeChanged(iTypeArray[n]);
                            ++n;
                        }
                        break block0;
                    }
                    case 7: {
                        this.typeChanged((IType)iJavaElement);
                        break block0;
                    }
                    default: {
                        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
                        int n = 0;
                        while (n < iJavaElementDeltaArray.length) {
                            this.elementChanged(iJavaElementDeltaArray[n]);
                            ++n;
                        }
                        break block0;
                    }
                }
            }
        }
    }

    private void resourcesChanged(IJavaProject iJavaProject, IResourceDelta[] iResourceDeltaArray) throws CoreException, IOException {
        AccessorConfiguration accessorConfiguration = this.getAccessorConfiguration(iJavaProject);
        if (accessorConfiguration != null) {
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                ResourceBundleModel resourceBundleModel;
                IStorage iStorage;
                IResource iResource = iResourceDeltaArray[n].getResource();
                if ("properties".equals(iResource.getFileExtension()) && (iStorage = (IStorage)iResource.getAdapter(IStorage.class)) != null && (resourceBundleModel = ResourceBundleManager.createForFile(iStorage, false)) != null) {
                    for (ResourceBundleReference resourceBundleReference : accessorConfiguration.getResourceBundleReferences()) {
                        if (!resourceBundleModel.equals(accessorConfiguration.resolve(resourceBundleReference))) continue;
                        this.fAccessorConfigurationMapper.rebuild();
                        break;
                    }
                }
                ++n;
            }
        }
    }

    private void typeChanged(IType iType) throws CoreException {
        AccessorConfiguration accessorConfiguration = this.getAccessorConfiguration(iType.getJavaProject());
        if (accessorConfiguration != null) {
            block0: for (ResourceBundleReference resourceBundleReference : accessorConfiguration.getResourceBundleReferences()) {
                for (ClassReference classReference : resourceBundleReference.getAccessorClasses()) {
                    if (!iType.equals(accessorConfiguration.resolve(classReference))) continue;
                    this.fAccessorConfigurationMapper.rebuild();
                    continue block0;
                }
            }
        }
    }

    public void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementChangedListener);
        this.fAccessorConfigurationMapper.shutdown();
        this.fAccessorConfigurationMapper = null;
    }

    private static final class AccessorConfigurationMapper {
        private Map<IJavaProject, AccessorConfiguration> fAccessorConfigurations = new HashMap<IJavaProject, AccessorConfiguration>();
        private Map<String, AccessorConfiguration> fResourceBundleMapping = new HashMap<String, AccessorConfiguration>();
        private Map<String, ClassReferenceMapper> fClassReferences = new HashMap<String, ClassReferenceMapper>();

        AccessorConfigurationMapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final AccessorConfiguration getAccessorConfiguration(IJavaProject iJavaProject) throws CoreException {
            AccessorConfiguration accessorConfiguration = this.fAccessorConfigurations.get(iJavaProject);
            if (accessorConfiguration == null) {
                accessorConfiguration = new AccessorConfiguration(iJavaProject);
                accessorConfiguration.load();
                AccessorConfigurationMapper accessorConfigurationMapper = this;
                synchronized (accessorConfigurationMapper) {
                    this.fAccessorConfigurations.put(iJavaProject, accessorConfiguration);
                }
                this.rebuild();
            }
            return accessorConfiguration;
        }

        public final ProjectMethodReference getMethodReference(MethodInvocation methodInvocation, int n) {
            Object object;
            ITypeBinding iTypeBinding = null;
            IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
            if (iMethodBinding != null) {
                iTypeBinding = iMethodBinding.getDeclaringClass();
            }
            if (iTypeBinding == null && (object = methodInvocation.getExpression()) != null) {
                iTypeBinding = object.resolveTypeBinding();
            }
            while (iTypeBinding != null) {
                object = this.fClassReferences.get(iTypeBinding.getQualifiedName());
                if (object != null) {
                    MethodReference methodReference = ((ClassReferenceMapper)object).getMethodReference(iMethodBinding, n);
                    if (methodReference != null) {
                        IJavaElement iJavaElement;
                        IJavaProject iJavaProject = null;
                        if (iMethodBinding != null && (iJavaElement = iMethodBinding.getJavaElement()) != null) {
                            iJavaProject = iJavaElement.getJavaProject();
                        }
                        if (iJavaProject != null) {
                            return new ProjectMethodReference(iJavaProject, methodReference);
                        }
                    }
                    return null;
                }
                iTypeBinding = iTypeBinding.getSuperclass();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void rebuild() {
            AccessorConfigurationMapper accessorConfigurationMapper = this;
            synchronized (accessorConfigurationMapper) {
                this.fResourceBundleMapping.clear();
                for (String object : this.fClassReferences.keySet()) {
                    this.fClassReferences.get(object).clear();
                }
                this.fClassReferences.clear();
                for (AccessorConfiguration accessorConfiguration : this.fAccessorConfigurations.values()) {
                    if (!accessorConfiguration.validate().isOK()) continue;
                    for (ResourceBundleReference resourceBundleReference : accessorConfiguration.getResourceBundleReferences()) {
                        this.fResourceBundleMapping.put(resourceBundleReference.getFullyQualifiedName(), accessorConfiguration);
                        for (ClassReference classReference : resourceBundleReference.getAccessorClasses()) {
                            this.fClassReferences.put(classReference.getFullyQualifiedTypeName(), new ClassReferenceMapper(classReference));
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void shutdown() {
            AccessorConfigurationMapper accessorConfigurationMapper = this;
            synchronized (accessorConfigurationMapper) {
                this.fAccessorConfigurations.clear();
                this.fAccessorConfigurations = null;
            }
        }

        private static final class ClassReferenceMapper {
            private Map<String, MethodReferenceMapper> fMethodReferences = new HashMap<String, MethodReferenceMapper>();

            public ClassReferenceMapper(ClassReference classReference) {
                for (MethodReference methodReference : classReference.getMethodReferences()) {
                    String string = methodReference.getMethodName();
                    MethodReferenceMapper methodReferenceMapper = this.fMethodReferences.get(string);
                    if (methodReferenceMapper == null) {
                        methodReferenceMapper = new MethodReferenceMapper();
                        this.fMethodReferences.put(string, methodReferenceMapper);
                    }
                    methodReferenceMapper.add(methodReference);
                }
            }

            public final MethodReference getMethodReference(IMethodBinding iMethodBinding, int n) {
                MethodReferenceMapper methodReferenceMapper = this.fMethodReferences.get(iMethodBinding.getName());
                if (methodReferenceMapper != null) {
                    return methodReferenceMapper.getMethodReference(iMethodBinding, n);
                }
                return null;
            }

            public final void clear() {
                for (String string : this.fMethodReferences.keySet()) {
                    this.fMethodReferences.get(string).clear();
                }
                this.fMethodReferences.clear();
            }

            private static final class MethodReferenceMapper {
                private Map<String, MethodReference> fMethodReferences = new HashMap<String, MethodReference>();

                public void add(MethodReference methodReference) {
                    String[] stringArray = new String[methodReference.getParameterCount()];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = methodReference.getParameter(n).getFullyQualifiedParameterType();
                        ++n;
                    }
                    this.fMethodReferences.put(this.createKey(stringArray), methodReference);
                }

                public final MethodReference getMethodReference(IMethodBinding iMethodBinding, int n) {
                    ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
                    String[] stringArray = new String[iTypeBindingArray.length];
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        stringArray[n2] = iTypeBindingArray[n2].getQualifiedName();
                        ++n2;
                    }
                    MethodReference methodReference = this.fMethodReferences.get(this.createKey(stringArray));
                    if (n == -1 || this.isParameterIndexValid(methodReference, n)) {
                        return methodReference;
                    }
                    return null;
                }

                private final boolean isParameterIndexValid(MethodReference methodReference, int n) {
                    ParameterReference parameterReference;
                    return methodReference != null && (parameterReference = methodReference.getSelectedParameter()) != null && n == parameterReference.getIndex();
                }

                private String createKey(String[] stringArray) {
                    return Arrays.toString(stringArray);
                }

                public final void clear() {
                    this.fMethodReferences.clear();
                }
            }
        }
    }

    public static final class ProjectMethodReference {
        private IJavaProject fReferencedProject;
        private MethodReference fMethodReference;

        public ProjectMethodReference(IJavaProject iJavaProject, MethodReference methodReference) {
            this.fReferencedProject = iJavaProject;
            this.fMethodReference = methodReference;
        }

        public MethodReference getMethodReference() {
            return this.fMethodReference;
        }

        public IJavaProject getReferencedProject() {
            return this.fReferencedProject;
        }
    }
}

