/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core.configuration;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.Messages;
import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfigurationManager;
import de.guhsoft.jinto.core.configuration.accessor.ResourceBundleReference;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorConfigurationProblemJob
extends Job {
    private IJavaProject fProject;
    private static final String MARKER_ID = "de.guhsoft.jinto.core.configuration.problem";

    public static final void cleanMarkers(IProject iProject) {
        try {
            iProject.deleteMarkers(MARKER_ID, true, 0);
        }
        catch (CoreException coreException) {
            AccessorConfigurationProblemJob.logError(coreException, "Error while deleting markers in rebuild for project " + iProject.getName());
        }
    }

    public AccessorConfigurationProblemJob(IJavaProject iJavaProject) {
        super(Messages.getString("configProblemJob.title", new Object[0]));
        this.fProject = iJavaProject;
        this.setRule(new AccessorConfigurationSchedulingRule(iJavaProject));
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.checkForConfigurationProblems(linkedList, iProgressMonitor) == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        if (iProgressMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.syncMarkers(linkedList);
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }

    private IStatus checkForConfigurationProblems(List<String> list, IProgressMonitor iProgressMonitor) {
        try {
            List<ResourceBundleReference> list2;
            AccessorConfiguration accessorConfiguration = AccessorConfigurationManager.getInstance().getAccessorConfiguration(this.fProject);
            if (accessorConfiguration != null && (list2 = accessorConfiguration.getResourceBundleReferences()) != null) {
                iProgressMonitor.beginTask("", list2.size());
                for (ResourceBundleReference resourceBundleReference : list2) {
                    String string;
                    IStatus iStatus = accessorConfiguration.validate(resourceBundleReference, true);
                    if (!(4 != iStatus.getSeverity() && 2 != iStatus.getSeverity() || list.contains(string = this.getErrorMessage(iStatus, resourceBundleReference)))) {
                        list.add(string);
                    }
                    iProgressMonitor.worked(1);
                    if (!iProgressMonitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.OK_STATUS;
        }
        catch (CoreException coreException) {
            AccessorConfigurationProblemJob.logError(coreException, "Error while loading AccessorConfiguration for project " + this.fProject.getElementName());
            return Status.CANCEL_STATUS;
        }
    }

    private String getErrorMessage(IStatus iStatus, ResourceBundleReference resourceBundleReference) {
        StringBuffer stringBuffer = new StringBuffer(iStatus.getMessage());
        stringBuffer.append(" (");
        stringBuffer.append(Util.convertFullyQualifiedNameIntoLeadingName(resourceBundleReference.getFullyQualifiedName()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void syncMarkers(List<String> list) {
        IResource iResource = this.fProject.getResource();
        if (iResource != null) {
            try {
                IMarker[] iMarkerArray = this.fProject.getProject().findMarkers(MARKER_ID, true, 0);
                if (iMarkerArray != null) {
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        if (iMarkerArray[n].getResource().equals((Object)iResource)) {
                            String string = iMarkerArray[n].getAttribute("message", "");
                            boolean bl = false;
                            for (String string2 : list) {
                                if (!string.equals(string2)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                list.remove(string);
                            } else {
                                iMarkerArray[n].delete();
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                AccessorConfigurationProblemJob.logError(coreException, "Could not search for markers.");
            }
            if (list != null && list.size() > 0) {
                this.createMarker(this.fProject, list);
            }
        }
    }

    private void createMarker(final IJavaProject iJavaProject, final List<String> list) {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                for (String string : list) {
                    IMarker iMarker = iJavaProject.getProject().createMarker(AccessorConfigurationProblemJob.MARKER_ID);
                    iMarker.setAttribute("severity", 1);
                    iMarker.setAttribute("message", (Object)string);
                    iMarker.setAttribute("location", (Object)Messages.getString("configProblemJob.location", new Object[0]));
                }
            }
        };
        try {
            iJavaProject.getResource().getWorkspace().run(iWorkspaceRunnable, null, 1, null);
        }
        catch (CoreException coreException) {
            AccessorConfigurationProblemJob.logError(coreException, "Error while create problem marker for AccessorConfiguration" + this.fProject.getElementName());
        }
    }

    private static final void logError(CoreException coreException, String string) {
        String string2 = JIntoCore.getID();
        Status status = new Status(4, string2, 4, string, (Throwable)coreException);
        JIntoCore.getDefault().getLog().log((IStatus)status);
    }

    private static final class AccessorConfigurationSchedulingRule
    implements ISchedulingRule {
        private IJavaProject fProject;

        public AccessorConfigurationSchedulingRule(IJavaProject iJavaProject) {
            this.fProject = iJavaProject;
        }

        public boolean contains(ISchedulingRule iSchedulingRule) {
            return iSchedulingRule == this;
        }

        public boolean isConflicting(ISchedulingRule iSchedulingRule) {
            boolean bl = false;
            if (iSchedulingRule instanceof AccessorConfigurationSchedulingRule) {
                bl = ((AccessorConfigurationSchedulingRule)iSchedulingRule).getProject() == this.getProject();
            }
            return bl;
        }

        public IJavaProject getProject() {
            return this.fProject;
        }
    }
}

