/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core;

import java.util.Locale;

public class Util {
    public static final String RESOURCE_FILE_EXTENSION = "properties";

    public static String escapeForLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String unescapeForLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            block0 : switch (c) {
                case '\\': {
                    if (++n < string.length()) {
                        c = string.charAt(n);
                        switch (c) {
                            case 'u': {
                                int n2 = 0;
                                ++n;
                                int n3 = 0;
                                while (n3 < 4) {
                                    int n4 = -1;
                                    if (n + n3 > string.length()) {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                    char c2 = string.charAt(n + n3);
                                    if (c2 >= '0' && c2 <= '9') {
                                        n4 = c2 - 48;
                                    } else if (c2 >= 'a' && c2 <= 'f') {
                                        n4 = c2 - 97 + 10;
                                    } else if (c2 >= 'A' && c2 <= 'F') {
                                        n4 = c2 - 65 + 10;
                                    } else {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                    n2 = (n2 << 4) + n4;
                                    ++n3;
                                }
                                n += 3;
                                stringBuffer.append((char)n2);
                                break block0;
                            }
                            case '\\': {
                                stringBuffer.append('\\');
                                break block0;
                            }
                            case 't': {
                                stringBuffer.append('\t');
                                break block0;
                            }
                            case 'f': {
                                stringBuffer.append('\f');
                                break block0;
                            }
                            case 'n': {
                                stringBuffer.append('\n');
                                break block0;
                            }
                            case 'r': {
                                stringBuffer.append('\r');
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Illegal escape sequence!");
                    }
                    throw new IllegalArgumentException("Illegal escape sequence!");
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isLegalSequence(String string) {
        try {
            Util.unescapeForLabel(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public static String getDisplayNameForLocale(Locale locale) {
        Locale locale2 = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        String string = locale == null ? "-" : locale.getDisplayName();
        Locale.setDefault(locale2);
        return string;
    }

    public static String convertFullyQualifiedNameIntoLeadingName(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.indexOf(58);
        if (n != -1) {
            stringBuffer.append(string2.substring(0, n));
            stringBuffer.append(" : ");
            string2 = string2.substring(n + 1);
        }
        if ((n = string2.lastIndexOf(46)) != -1) {
            stringBuffer.append(string2.substring(n + 1));
            stringBuffer.append(" - ");
            string2 = string2.substring(0, n);
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

