/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIntoBundleMarker {
    public static final String ID = "de.guhsoft.jinto.core.bundle.problem";
    private static final String ROW_COUNT = "rowCount";
    private static final String ROW_INDEX = "rowIndex";

    public static IMarker[] findMarkersForModel(ResourceBundleModel resourceBundleModel) throws CoreException {
        IMarker[] iMarkerArray = new IMarker[]{};
        int n = 0;
        while (n < resourceBundleModel.getResourceFileCount()) {
            IMarker[] iMarkerArray2;
            IStorage iStorage = resourceBundleModel.getResourceFileMapEntry(n).getValue().getFileStorage();
            IResource iResource = (IResource)iStorage.getAdapter(IResource.class);
            if (iResource != null && (iMarkerArray2 = iResource.findMarkers(ID, false, 0)) != null && iMarkerArray2.length > 0) {
                IMarker[] iMarkerArray3 = new IMarker[iMarkerArray.length + iMarkerArray2.length];
                System.arraycopy(iMarkerArray, 0, iMarkerArray3, 0, iMarkerArray.length);
                System.arraycopy(iMarkerArray2, 0, iMarkerArray3, iMarkerArray.length, iMarkerArray2.length);
                iMarkerArray = iMarkerArray3;
            }
            ++n;
        }
        return iMarkerArray;
    }

    public static void createMarker(IResource iResource, Map<String, Object> map) throws CoreException {
        JIntoBundleMarker.createMarker(iResource, map, ID);
    }

    public static void setSeverity(Map<String, Object> map, int n) {
        map.put("severity", new Integer(n));
    }

    public static void setMessage(Map<String, Object> map, String string) {
        map.put("message", string);
    }

    public static void addRow(Map<String, Object> map, String string) {
        Integer n = (Integer)map.get(ROW_COUNT);
        if (n == null) {
            n = new Integer(0);
        }
        int n2 = n;
        map.put(ROW_COUNT, new Integer(n2 + 1));
        map.put(ROW_INDEX + n2, string);
    }

    public static String[] getRows(IMarker iMarker) throws CoreException {
        JIntoBundleMarker.checkMarkerType(iMarker);
        int n = iMarker.getAttribute(ROW_COUNT, 0);
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)iMarker.getAttribute(ROW_INDEX + n2);
            ++n2;
        }
        return stringArray;
    }

    public static boolean isBundleMarker(IMarker iMarker) throws CoreException {
        return ID.equals(iMarker.getType());
    }

    public static boolean isEqual(IMarker iMarker, Map<String, Object> map) {
        int n;
        if (iMarker.getAttribute("severity", -1) != ((Integer)map.get("severity")).intValue()) {
            return false;
        }
        if (!iMarker.getAttribute("message", "").equals(map.get("message"))) {
            return false;
        }
        int n2 = iMarker.getAttribute(ROW_COUNT, -1);
        if (n2 != (n = ((Integer)map.get(ROW_COUNT)).intValue())) {
            return false;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        int n3 = 0;
        while (n3 < n2) {
            linkedList.add(iMarker.getAttribute(ROW_INDEX + n3, ""));
            ++n3;
        }
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        int n4 = 0;
        while (n4 < n) {
            linkedList2.add(map.get(ROW_INDEX + n4));
            ++n4;
        }
        n4 = 0;
        while (n4 < linkedList2.size()) {
            if (!linkedList.remove(linkedList2.get(n4))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private static void checkMarkerType(IMarker iMarker) throws CoreException {
        if (!JIntoBundleMarker.isBundleMarker(iMarker)) {
            String string = JIntoCore.getID();
            String string2 = "Invalid marker type: " + iMarker.getType();
            Status status = new Status(4, string, 4, string2, new Throwable());
            throw new CoreException((IStatus)status);
        }
    }

    private static void createMarker(final IResource iResource, final Map<?, ?> map, final String string) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iResource.createMarker(string);
                iMarker.setAttributes(map);
            }
        };
        iResource.getWorkspace().run(iWorkspaceRunnable, null, 1, null);
    }
}

