/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.core;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTUtil {
    public static List<StringLiteral> getStringLiteral(ASTNode aSTNode) {
        LinkedList<StringLiteral> linkedList = new LinkedList<StringLiteral>();
        ASTUtil.resolveStringLiterals(aSTNode, linkedList);
        return linkedList;
    }

    public static MethodInvocation getMethodInvocationParent(StringLiteral stringLiteral) {
        return ASTUtil.getMethodInvocationParentImpl((ASTNode)stringLiteral);
    }

    public static MethodInvocation getMethodInvocationParent(SimpleName simpleName) {
        return ASTUtil.getMethodInvocationParentImpl((ASTNode)simpleName);
    }

    public static int indexOf(MethodInvocation methodInvocation, ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode;
        while (aSTNode2.getParent() != null && !aSTNode2.getParent().equals((Object)methodInvocation)) {
            aSTNode2 = aSTNode2.getParent();
        }
        return methodInvocation.arguments().indexOf(aSTNode2);
    }

    private static void resolveStringLiterals(ASTNode aSTNode, List<StringLiteral> list) {
        switch (aSTNode.getNodeType()) {
            case 36: {
                ASTUtil.resolveStringLiterals((ASTNode)((ParenthesizedExpression)aSTNode).getExpression(), list);
                break;
            }
            case 16: {
                ConditionalExpression conditionalExpression = (ConditionalExpression)aSTNode;
                ASTUtil.resolveStringLiterals((ASTNode)conditionalExpression.getThenExpression(), list);
                ASTUtil.resolveStringLiterals((ASTNode)conditionalExpression.getElseExpression(), list);
                break;
            }
            case 45: {
                list.add((StringLiteral)aSTNode);
            }
        }
    }

    private static MethodInvocation getMethodInvocationParentImpl(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        switch (aSTNode2.getNodeType()) {
            case 16: 
            case 36: {
                return ASTUtil.getMethodInvocationParentImpl(aSTNode2);
            }
            case 32: {
                return (MethodInvocation)aSTNode2;
            }
        }
        return null;
    }
}

