/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.wizard;

import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.wizard.FileListLabelProvider;
import de.guhsoft.jinto.ui.wizard.INewResourceWizardPage;
import de.guhsoft.jinto.ui.wizard.LocaleComparator;
import de.guhsoft.jinto.ui.wizard.LocaleLabelProvider;
import de.guhsoft.jinto.ui.wizard.StatusInfo;
import de.guhsoft.jinto.ui.wizard.WizardContentProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConfigureNewResourceFilesPage
extends NewTypeWizardPage
implements INewResourceWizardPage,
SelectionListener,
ModifyListener {
    private ComboViewer languageComboViewer;
    private ComboViewer countryComboViewer;
    private Text variantText;
    private ListViewer listViewer;
    private Button addButton;
    private Button removeButton;
    private IStatus resourceNameStatus;
    private IStatus listSelectionStatus;
    private Locale currentCombination;
    private List<Locale> selectedFiles;

    protected ConfigureNewResourceFilesPage(String string) {
        super(true, string);
        this.setTitle(Messages.getString("wizard.firstStep.title", new Object[0]));
        this.setDescription(Messages.getString("wizard.firstStep.description", new Object[0]));
        this.setPageComplete(false);
        this.resourceNameStatus = new StatusInfo();
        this.listSelectionStatus = new StatusInfo();
        this.currentCombination = new Locale("");
    }

    public void init(IStructuredSelection iStructuredSelection, String string, boolean bl) {
        IJavaElement iJavaElement = this.getInitialJavaElement(iStructuredSelection);
        this.initContainerPage(iJavaElement);
        this.initTypePage(iJavaElement);
        if (!bl) {
            this.setPackageFragmentRoot(this.getPackageFragmentRoot(), bl);
            this.setPackageFragment(this.getPackageFragment(), bl);
        }
        if (string != null) {
            this.setTypeName(string, bl);
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.resourceNameStatus, this.listSelectionStatus};
        this.updateStatus(iStatusArray);
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        this.resourceNameStatus = this.resourceNameChanged();
        this.checkCombination();
        if (this.listViewer != null) {
            this.listViewer.refresh();
        }
        this.listSelectionStatus = this.listSelectionChanged();
        this.doStatusUpdate();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        int n = 4;
        composite2.setLayout((Layout)new GridLayout(n, false));
        this.createContainerControls(composite2, n);
        this.createPackageControls(composite2, n);
        this.createTypeNameControls(composite2, n);
        this.createSeperatorControls(composite2, n);
        this.createLanguageControls(composite2, n);
        this.createCountryControls(composite2, n);
        this.createVariantControls(composite2, n);
        this.createListControls(composite2, n);
        this.createSeperatorControls(composite2, n);
        this.setControl((Control)composite2);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.getTypeName().length() > 0) {
                this.languageComboViewer.getCombo().setFocus();
                this.checkCombination();
            } else {
                this.setFocus();
            }
        }
        super.setVisible(bl);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string = (String)modifyEvent.widget.getData();
        if (string.equals("resourceNameText")) {
            this.listViewer.refresh();
            this.handleFieldChanged("NewContainerWizardPage.container");
        } else if (string.equals("variantText")) {
            this.checkCombination();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string = (String)selectionEvent.widget.getData();
        if (string.equals("addButton")) {
            this.selectedFiles.add(this.currentCombination);
            this.listViewer.refresh();
            this.handleFieldChanged("NewContainerWizardPage.container");
            this.checkCombination();
        } else if (string.equals("removeButton")) {
            StructuredSelection structuredSelection = (StructuredSelection)this.listViewer.getSelection();
            Iterator iterator = structuredSelection.iterator();
            while (iterator.hasNext()) {
                this.selectedFiles.remove(iterator.next());
            }
            this.listViewer.refresh();
            this.checkRemoveButton();
            this.handleFieldChanged("NewContainerWizardPage.container");
        } else if (string.equals("languageComboViewer") || string.equals("countryComboViewer")) {
            this.checkCombination();
        } else if (string.equals("list")) {
            this.checkRemoveButton();
        }
    }

    private void checkRemoveButton() {
        if (this.listViewer.getSelection().isEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    void checkCombination() {
        if (this.languageComboViewer != null && this.countryComboViewer != null && this.variantText != null && this.addButton != null) {
            boolean bl;
            block13: {
                Locale locale = (Locale)((StructuredSelection)this.languageComboViewer.getSelection()).getFirstElement();
                String string = "";
                if (locale != null) {
                    string = locale.getLanguage();
                }
                locale = (Locale)((StructuredSelection)this.countryComboViewer.getSelection()).getFirstElement();
                String string2 = "";
                if (locale != null) {
                    string2 = locale.getCountry();
                }
                String string3 = this.variantText.getText();
                bl = true;
                if (string.equals("") && !string2.equals("") || string.equals("") && !string3.equals("")) {
                    bl = false;
                }
                this.currentCombination = new Locale(string, string2, string3);
                if (bl) {
                    int n = 0;
                    while (n < this.selectedFiles.size()) {
                        if (this.currentCombination.equals(this.selectedFiles.get(n))) {
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.getTypeName());
                    if (!this.currentCombination.getLanguage().equals("")) {
                        stringBuffer.append("_");
                        stringBuffer.append(this.currentCombination);
                    }
                    stringBuffer.append(".");
                    stringBuffer.append("properties");
                    try {
                        if (this.getPackageFragment() == null) break block13;
                        Object[] objectArray = new Object[]{};
                        objectArray = this.getPackageFragment().isDefaultPackage() ? ((IPackageFragmentRoot)this.getPackageFragment().getParent()).getNonJavaResources() : this.getPackageFragment().getNonJavaResources();
                        int n = 0;
                        while (n < objectArray.length) {
                            IFile iFile;
                            if (((IResource)objectArray[n]).getType() == 1 && (iFile = (IFile)objectArray[n]).getName().equals(stringBuffer.toString())) {
                                bl = false;
                                break;
                            }
                            ++n;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
            this.addButton.setEnabled(bl);
        }
    }

    private void createLanguageControls(Composite composite, int n) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("wizard.label.language", new Object[0]));
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.languageComboViewer = new ComboViewer(composite, 8);
        this.languageComboViewer.setContentProvider((IContentProvider)new WizardContentProvider());
        this.languageComboViewer.setLabelProvider((IBaseLabelProvider)new LocaleLabelProvider(0));
        String[] stringArray = Locale.getISOLanguages();
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        linkedList.add(new Locale(""));
        int n2 = 0;
        while (n2 < stringArray.length) {
            linkedList.add(new Locale(stringArray[n2]));
            ++n2;
        }
        Collections.sort(linkedList, new LocaleComparator(0));
        this.languageComboViewer.setInput(linkedList);
        Combo combo = this.languageComboViewer.getCombo();
        combo.setData((Object)"languageComboViewer");
        combo.addSelectionListener((SelectionListener)this);
        combo.setLayoutData((Object)new GridData(4, 0, false, false, n - 1, 1));
        this.addFastSelection(combo);
    }

    private void createCountryControls(Composite composite, int n) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("wizard.label.country", new Object[0]));
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.countryComboViewer = new ComboViewer(composite, 8);
        this.countryComboViewer.setContentProvider((IContentProvider)new WizardContentProvider());
        this.countryComboViewer.setLabelProvider((IBaseLabelProvider)new LocaleLabelProvider(1));
        String[] stringArray = Locale.getISOCountries();
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        linkedList.add(new Locale("", ""));
        int n2 = 0;
        while (n2 < stringArray.length) {
            linkedList.add(new Locale("", stringArray[n2]));
            ++n2;
        }
        Collections.sort(linkedList, new LocaleComparator(1));
        this.countryComboViewer.setInput(linkedList);
        Combo combo = this.countryComboViewer.getCombo();
        combo.setData((Object)"countryComboViewer");
        combo.addSelectionListener((SelectionListener)this);
        combo.setLayoutData((Object)new GridData(4, 0, false, false, n - 1, 1));
        this.addFastSelection(combo);
    }

    private void createVariantControls(Composite composite, int n) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("wizard.label.variant", new Object[0]));
        label.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.variantText = new Text(composite, 2048);
        this.variantText.setData((Object)"variantText");
        this.variantText.addModifyListener((ModifyListener)this);
        this.variantText.setLayoutData((Object)new GridData(4, 0, false, false, n - 1, 1));
    }

    private void createListControls(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.listViewer = new ListViewer(composite2, 2818);
        this.listViewer.setContentProvider((IContentProvider)new WizardContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new FileListLabelProvider(this));
        this.selectedFiles = new LinkedList<Locale>();
        this.listViewer.setInput(this.selectedFiles);
        org.eclipse.swt.widgets.List list = this.listViewer.getList();
        list.setData((Object)"list");
        list.addSelectionListener((SelectionListener)this);
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        Label label = new Label(composite2, 0);
        label.setVisible(false);
        label.setLayoutData((Object)new GridData(0, 4, false, true));
        this.addButton = new Button(composite2, 8);
        this.addButton.setImage(JIntoUI.getImage("addIcon"));
        this.addButton.setData((Object)"addButton");
        this.addButton.addSelectionListener((SelectionListener)this);
        this.addButton.setLayoutData((Object)new GridData(0, 0, false, false));
        label = new Label(composite2, 0);
        label.setVisible(false);
        label.setLayoutData((Object)new GridData(0, 0, false, false));
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.setImage(JIntoUI.getImage("removeIcon"));
        this.removeButton.setData((Object)"removeButton");
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.removeButton.setLayoutData((Object)new GridData(0, 0, false, false));
        label = new Label(composite2, 0);
        label.setVisible(false);
        label.setLayoutData((Object)new GridData(0, 4, false, true));
        composite2.setLayoutData((Object)new GridData(4, 4, false, true, n, 1));
    }

    private void createSeperatorControls(Composite composite, int n) {
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0, false, false, n, 1));
    }

    private IStatus resourceNameChanged() {
        String string = this.getTypeName();
        int n = 0;
        String string2 = "OK";
        if (string.length() == 0) {
            n = 4;
            string2 = Messages.getString("wizard.error.empty", new Object[0]);
        } else {
            IStatus iStatus = JavaConventions.validateJavaTypeName((String)string, null, null);
            if (iStatus.getSeverity() == 4) {
                n = iStatus.getSeverity();
                string2 = String.valueOf(Messages.getString("wizard.error.valid", new Object[0])) + " " + iStatus.getMessage();
            } else {
                n = iStatus.getSeverity();
                string2 = String.valueOf(Messages.getString("wizard.error.valid", new Object[0])) + " " + iStatus.getMessage();
            }
        }
        return new StatusInfo(n, string2);
    }

    private IStatus listSelectionChanged() {
        if (this.selectedFiles != null && this.selectedFiles.isEmpty()) {
            return new StatusInfo(4, Messages.getString("wizard.error.list", new Object[0]));
        }
        return new StatusInfo();
    }

    public int calcProgressMonitorWorkItems() {
        int n = 0;
        n += this.selectedFiles.size() * 5;
        return ++n;
    }

    public void finishPage(IProgressMonitor iProgressMonitor) throws CoreException {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        IPackageFragment iPackageFragment = this.getPackageFragment();
        if (iPackageFragment == null) {
            iPackageFragment = iPackageFragmentRoot.getPackageFragment("");
        }
        if (!iPackageFragment.exists()) {
            String string = iPackageFragment.getElementName();
            iPackageFragmentRoot.createPackageFragment(string, true, null);
        }
        iProgressMonitor.worked(1);
        int n = 0;
        while (n < this.selectedFiles.size()) {
            String string = ((ILabelProvider)this.listViewer.getLabelProvider()).getText((Object)this.selectedFiles.get(n));
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getPackageFragment().getPath().append(string));
            iFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 5));
            ++n;
        }
    }

    public String getProgressMonitorTaskName() {
        return Messages.getString("wizard.firstStep.task", new Object[0]);
    }

    private void addFastSelection(Combo combo) {
        if (Platform.getOS().equals("linux")) {
            combo.addKeyListener((KeyListener)new ComboKeyListener(combo));
        }
    }

    private class ComboKeyListener
    extends KeyAdapter {
        private Combo combo;

        public ComboKeyListener(Combo combo) {
            this.combo = combo;
        }

        public void keyReleased(KeyEvent keyEvent) {
            String string = String.valueOf(keyEvent.character).toLowerCase();
            int n = this.combo.getSelectionIndex();
            if (n != -1 && this.combo.getItem(n).toLowerCase().startsWith(string) && this.combo.getItemCount() > ++n && this.combo.getItem(n).toLowerCase().startsWith(string)) {
                this.combo.select(n);
            } else {
                int n2 = 0;
                while (n2 < this.combo.getItemCount()) {
                    if (this.combo.getItem(n2).toLowerCase().startsWith(string)) {
                        this.combo.select(n2);
                        break;
                    }
                    ++n2;
                }
            }
            ConfigureNewResourceFilesPage.this.checkCombination();
        }
    }
}

