/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search.reference;

import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.search.SearchUtil;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReferenceSearchResultPage
extends AbstractTextSearchViewPage {
    public ReferenceSearchResultPage() {
        super(2);
    }

    protected void elementsChanged(Object[] objectArray) {
        if (objectArray.length > 0) {
            this.getViewer().refresh();
        }
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    protected void configureTreeViewer(final TreeViewer treeViewer) {
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object object) {
                Object[] objectArray = ((AbstractTextSearchResult)treeViewer.getInput()).getElements();
                IJavaElement[] iJavaElementArray = new IJavaElement[objectArray.length];
                System.arraycopy(objectArray, 0, iJavaElementArray, 0, objectArray.length);
                return SearchUtil.getChildrenWithSkippingCompilationUnitsAndNotNeededElements((IJavaElement)object, iJavaElementArray);
            }

            public Object getParent(Object object) {
                return null;
            }

            public boolean hasChildren(Object object) {
                return this.getChildren(object).length > 0;
            }

            public Object[] getElements(Object object) {
                AbstractTextSearchResult abstractTextSearchResult = (AbstractTextSearchResult)object;
                Object[] objectArray = abstractTextSearchResult.getElements();
                if (objectArray.length > 0) {
                    return this.getChildren(((IJavaElement)objectArray[0]).getJavaModel());
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
    }

    protected void configureTableViewer(TableViewer tableViewer) {
    }

    protected void showMatch(Match match, int n, int n2, boolean bl) {
        int n3 = match.getOffset();
        int n4 = match.getLength();
        try {
            Object object = match.getElement();
            IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IResource iResource = ((IJavaElement)object).getResource();
            IFile iFile = null;
            if (iResource.getType() == 1) {
                iFile = (IFile)iResource;
            }
            if (iFile != null) {
                IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)bl);
                if (iEditorPart instanceof ITextEditor) {
                    ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                    iTextEditor.selectAndReveal(n3, n4);
                } else if (iEditorPart != null && object instanceof IFile) {
                    this.showWithMarker(iEditorPart, iFile, n3, n4);
                }
            } else {
                String string = JIntoUI.getID();
                String string2 = "Resource " + iResource + " is not a type of IFile.";
                Status status = new Status(4, string, 4, string2, new Throwable());
                JIntoUI.getDefault().getLog().log((IStatus)status);
            }
        }
        catch (PartInitException partInitException) {
            String string = JIntoUI.getID();
            Status status = new Status(4, string, 4, partInitException.getMessage(), (Throwable)partInitException);
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
    }

    private void showWithMarker(IEditorPart iEditorPart, IFile iFile, int n, int n2) throws PartInitException {
        try {
            IMarker iMarker = iFile.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(4);
            hashMap.put("charStart", new Integer(n));
            hashMap.put("charEnd", new Integer(n + n2));
            iMarker.setAttributes(hashMap);
            IDE.gotoMarker((IEditorPart)iEditorPart, (IMarker)iMarker);
            iMarker.delete();
        }
        catch (CoreException coreException) {
            throw new PartInitException("Could not create marker", (Throwable)coreException);
        }
    }
}

