/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.search;

import de.guhsoft.jinto.ui.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIntoSearchScope {
    private IJavaElement[] fRootElements;
    List<IJavaElement> fCompilationUnitReferences;

    public static JIntoSearchScope createWorkspaceScope(IRunnableContext iRunnableContext) {
        return new JIntoSearchScope((IJavaElement)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), iRunnableContext);
    }

    public static JIntoSearchScope createSelectionScope(IStructuredSelection iStructuredSelection, IRunnableContext iRunnableContext) {
        return JIntoSearchScope.createSelectionScope(iStructuredSelection, false, iRunnableContext);
    }

    public static JIntoSearchScope createSelectedProjectsScope(IStructuredSelection iStructuredSelection, IRunnableContext iRunnableContext) {
        return JIntoSearchScope.createSelectionScope(iStructuredSelection, true, iRunnableContext);
    }

    private static JIntoSearchScope createSelectionScope(IStructuredSelection iStructuredSelection, boolean bl, IRunnableContext iRunnableContext) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        for (Object e : iStructuredSelection) {
            IJavaElement iJavaElement;
            IResource iResource;
            if (!(e instanceof IAdaptable) || (iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class)) == null || bl && !(iResource instanceof IProject) || (iJavaElement = JavaCore.create((IResource)iResource)) == null) continue;
            arrayList.add(iJavaElement);
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[arrayList.size()];
        arrayList.toArray(iJavaElementArray);
        return new JIntoSearchScope(iJavaElementArray, iRunnableContext);
    }

    public static JIntoSearchScope createWorkingSetScope(IWorkingSet[] iWorkingSetArray, IRunnableContext iRunnableContext) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            IAdaptable[] iAdaptableArray = iWorkingSetArray[n].getElements();
            int n2 = 0;
            while (n2 < iAdaptableArray.length) {
                IJavaElement iJavaElement;
                IResource iResource = (IResource)iAdaptableArray[n2].getAdapter(IResource.class);
                if (iResource != null && (iJavaElement = JavaCore.create((IResource)iResource)) != null) {
                    arrayList.add(iJavaElement);
                }
                ++n2;
            }
            ++n;
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[arrayList.size()];
        arrayList.toArray(iJavaElementArray);
        return new JIntoSearchScope(iJavaElementArray, iRunnableContext);
    }

    private JIntoSearchScope(IJavaElement iJavaElement, IRunnableContext iRunnableContext) {
        this(new IJavaElement[]{iJavaElement}, iRunnableContext);
    }

    private JIntoSearchScope(final IJavaElement[] iJavaElementArray, IRunnableContext iRunnableContext) {
        this.fRootElements = iJavaElementArray;
        this.fCompilationUnitReferences = new LinkedList<IJavaElement>();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                String string = Messages.getString("search.label.monitor.indexing", new Object[0]);
                iProgressMonitor.beginTask(string, -1);
                JIntoSearchScope.this.collectCompilationUnits(JIntoSearchScope.this.fCompilationUnitReferences, iJavaElementArray, iProgressMonitor);
                iProgressMonitor.done();
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            iRunnableContext.run(true, true, iRunnableWithProgress);
        }
        catch (Exception exception) {}
    }

    protected IJavaElement[] getRootElements() {
        return this.fRootElements;
    }

    void collectCompilationUnits(List<IJavaElement> list, IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) {
        try {
            int n = 0;
            while (n < iJavaElementArray.length) {
                switch (iJavaElementArray[n].getElementType()) {
                    case 1: {
                        this.collectCompilationUnits(list, (IJavaElement[])((IJavaModel)iJavaElementArray[n]).getJavaProjects(), iProgressMonitor);
                        break;
                    }
                    case 2: {
                        this.collectCompilationUnits(list, (IJavaElement[])((IJavaProject)iJavaElementArray[n]).getPackageFragments(), iProgressMonitor);
                        break;
                    }
                    case 4: {
                        this.collectCompilationUnits(list, ((IParent)iJavaElementArray[n]).getChildren(), iProgressMonitor);
                        break;
                    }
                    case 5: {
                        list.add(iJavaElementArray[n]);
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public int size() {
        return this.fCompilationUnitReferences.size();
    }

    public Iterator<IJavaElement> iterator() {
        return this.fCompilationUnitReferences.iterator();
    }
}

