/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.ruler;

import de.guhsoft.jinto.ui.ruler.IRulerColumn;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolTip;

public class VerticalTableRuler
extends Canvas {
    private static final String TOOLTIP_ROW_KEY = "tooltipRow";
    private static final String TOOLTIP_RULER_COLUMN_KEY = "tooltipColumn";
    private TableViewer fTableViewer;
    private List<IRulerColumn> fColumns = new LinkedList<IRulerColumn>();
    int fPreferredHeight;
    private ToolTip fToolTip;
    private int fItemCalculationHeaderHeight;

    public VerticalTableRuler(Composite composite, int n) {
        super(composite, n);
        this.fToolTip = new ToolTip(composite.getShell(), 0);
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent mouseEvent) {
                VerticalTableRuler.this.onMouseHover(mouseEvent.x, mouseEvent.y);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                VerticalTableRuler.this.onMouseExit();
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                VerticalTableRuler.this.onMouseMove(mouseEvent.x, mouseEvent.y);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                VerticalTableRuler.this.onPaint(paintEvent.gc);
            }
        });
    }

    public void connect(final TableViewer tableViewer) {
        this.fTableViewer = tableViewer;
        final Table table = tableViewer.getTable();
        this.fItemCalculationHeaderHeight = 0;
        if (table.getHeaderVisible() && "gtk".equals(SWT.getPlatform())) {
            this.fItemCalculationHeaderHeight = table.getHeaderHeight();
        }
        table.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VerticalTableRuler.this.redraw();
            }
        });
        table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                VerticalTableRuler.this.redraw();
            }
        });
        table.addControlListener((ControlListener)new ControlAdapter(){
            private int fOldClientAreaHeight = 0;

            public void controlResized(ControlEvent controlEvent) {
                int n = table.getClientArea().height;
                if (this.fOldClientAreaHeight != n) {
                    this.fOldClientAreaHeight = n;
                    VerticalTableRuler.this.redraw();
                }
            }
        });
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                Object object = event.item.getData();
                String string = null;
                CellLabelProvider cellLabelProvider = tableViewer.getLabelProvider(event.index);
                if (cellLabelProvider instanceof ColumnLabelProvider) {
                    string = ((ColumnLabelProvider)cellLabelProvider).getText(object);
                } else {
                    cellLabelProvider = tableViewer.getLabelProvider();
                    if (cellLabelProvider instanceof ITableLabelProvider) {
                        string = ((ITableLabelProvider)cellLabelProvider).getColumnText(object, event.index);
                    }
                }
                if (string != null) {
                    Point point = event.gc.textExtent(string);
                    event.width = Math.max(point.x, event.width);
                    FontMetrics fontMetrics = event.gc.getFontMetrics();
                    int n = fontMetrics.getDescent();
                    event.height = Math.max(point.y + n, VerticalTableRuler.this.fPreferredHeight);
                }
            }
        });
    }

    private final int computePreferredRowHeight() {
        int n = 0;
        Iterator<IRulerColumn> iterator = this.fColumns.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, iterator.next().getPreferredRowHeight());
        }
        return n;
    }

    public void addColumn(IRulerColumn iRulerColumn) {
        this.fColumns.add(iRulerColumn);
        iRulerColumn.installed(this);
        this.fPreferredHeight = this.computePreferredRowHeight();
        this.getParent().layout(true, true);
    }

    public void removeColumn(IRulerColumn iRulerColumn) {
        if (this.fColumns.remove(iRulerColumn)) {
            iRulerColumn.deinstalled(this);
            this.fPreferredHeight = this.computePreferredRowHeight();
            this.getParent().layout(true, true);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        int n3 = 0;
        Iterator<IRulerColumn> iterator = this.fColumns.iterator();
        while (iterator.hasNext()) {
            n3 += iterator.next().getWidth();
        }
        point.x = n3;
        return point;
    }

    final void onMouseHover(int n, int n2) {
        TableItem tableItem;
        Table table = this.fTableViewer.getTable();
        if (table.getHeaderVisible() && n2 <= table.getHeaderHeight()) {
            return;
        }
        IRulerColumn iRulerColumn = this.getRulerColumn(n);
        if (iRulerColumn != null && (tableItem = this.getRow(n2)) != null) {
            this.showTooltip(iRulerColumn, tableItem);
        }
    }

    final void onMouseMove(int n, int n2) {
        if (this.fToolTip.isVisible()) {
            TableItem tableItem;
            boolean bl = false;
            IRulerColumn iRulerColumn = this.getRulerColumn(n);
            if (iRulerColumn == null || !iRulerColumn.equals(this.fToolTip.getData(TOOLTIP_RULER_COLUMN_KEY))) {
                bl = true;
            }
            if (!(bl || (tableItem = this.getRow(n2)) != null && tableItem.equals(this.fToolTip.getData(TOOLTIP_ROW_KEY)))) {
                bl = true;
            }
            if (bl) {
                this.hideToolTip();
            }
        }
    }

    final void onMouseExit() {
        this.hideToolTip();
    }

    private final void showTooltip(IRulerColumn iRulerColumn, TableItem tableItem) {
        String string = iRulerColumn.getTooltipText(tableItem);
        if (string != null) {
            this.fToolTip.setData(TOOLTIP_ROW_KEY, (Object)tableItem);
            this.fToolTip.setData(TOOLTIP_RULER_COLUMN_KEY, (Object)iRulerColumn);
            this.fToolTip.setMessage(string);
            Rectangle rectangle = this.getBounds();
            Point point = new Point(rectangle.x + rectangle.width, this.getBounds((TableItem)tableItem).y);
            int n = this.toDisplay((Point)point).x;
            int n2 = this.fTableViewer.getTable().toDisplay((Point)point).y;
            this.fToolTip.setLocation(n, n2);
            this.fToolTip.setVisible(true);
        } else {
            this.hideToolTip();
        }
    }

    private final void hideToolTip() {
        if (this.fToolTip.isVisible()) {
            this.fToolTip.setVisible(false);
        }
    }

    private final IRulerColumn getRulerColumn(int n) {
        int n2 = 0;
        for (IRulerColumn iRulerColumn : this.fColumns) {
            int n3 = iRulerColumn.getWidth();
            if (n >= n2 && n < n3) {
                return iRulerColumn;
            }
            n2 += n3;
        }
        return null;
    }

    private final TableItem getRow(int n) {
        return this.fTableViewer.getTable().getItem(new Point(0, n - this.fItemCalculationHeaderHeight));
    }

    void onPaint(GC gC) {
        Table table = this.fTableViewer.getTable();
        int n = table.getClientArea().height;
        int n2 = 0;
        Rectangle rectangle = gC.getClipping();
        if (table.getHeaderVisible()) {
            n2 += table.getHeaderHeight();
        }
        rectangle.y = n2;
        rectangle.height = n - n2;
        gC.setClipping(rectangle);
        int n3 = -1;
        TableItem[] tableItemArray = table.getItems();
        int n4 = 0;
        while (n4 < tableItemArray.length) {
            if (this.getBounds((TableItem)tableItemArray[n4]).y > 0) {
                n3 = n4 > 0 ? n4 - 1 : n4;
                break;
            }
            ++n4;
        }
        if (n3 >= 0) {
            Rectangle rectangle2 = this.getBounds(tableItemArray[n3]);
            n2 = this.getY(rectangle2);
            while (n2 < n && n3 < tableItemArray.length) {
                Iterator<IRulerColumn> iterator = this.fColumns.iterator();
                while (iterator.hasNext()) {
                    iterator.next().paint(gC, n2, rectangle2.height, tableItemArray[n3]);
                }
                if (++n3 >= tableItemArray.length) continue;
                rectangle2 = this.getBounds(tableItemArray[n3]);
                n2 = this.getY(rectangle2);
            }
        }
    }

    private final Rectangle getBounds(TableItem tableItem) {
        Rectangle rectangle = tableItem.getBounds();
        if (rectangle.width == 0 && rectangle.height == 0) {
            int n = tableItem.getParent().getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                rectangle = tableItem.getBounds(n2);
                if (rectangle.width != 0 && rectangle.height != 0) break;
                ++n2;
            }
        }
        return rectangle;
    }

    private final int getY(Rectangle rectangle) {
        return rectangle.y + this.fItemCalculationHeaderHeight;
    }
}

