/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.properties;

import de.guhsoft.jinto.core.configuration.accessor.AccessorConfiguration;
import de.guhsoft.jinto.core.configuration.accessor.ClassReference;
import de.guhsoft.jinto.core.configuration.accessor.MethodReference;
import de.guhsoft.jinto.core.configuration.accessor.ParameterReference;
import de.guhsoft.jinto.core.util.CodeAnalyser;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.properties.AccessorConfigurationLabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorMethodDialog
extends Dialog {
    private ClassReference fClassReference;
    private List<MethodReference> fSelectedMethods;
    CheckboxTreeViewer fTreeViewer;
    private AccessorConfiguration fConfiguration;

    public AccessorMethodDialog(Shell shell, ClassReference classReference, List<MethodReference> list, AccessorConfiguration accessorConfiguration) {
        super(shell);
        this.fClassReference = classReference;
        this.fConfiguration = accessorConfiguration;
        this.fSelectedMethods = new LinkedList<MethodReference>();
        for (MethodReference methodReference : list) {
            this.fSelectedMethods.add(methodReference.clone());
        }
    }

    public List<MethodReference> getValue() {
        return this.fSelectedMethods;
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.getString("property.dialog.methodSelection.title", new Object[0]));
        super.configureShell(shell);
    }

    protected void setShellStyle(int n) {
        super.setShellStyle(n | 0x10);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected Control createDialogArea(Composite composite) {
        Cursor cursor = new Cursor((Device)this.getShell().getDisplay(), 1);
        this.getParentShell().setCursor(cursor);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("property.dialog.methodSelection.text", new Object[0]));
        CLabel cLabel = new CLabel(composite2, 0);
        AccessorConfigurationLabelProvider accessorConfigurationLabelProvider = new AccessorConfigurationLabelProvider(this.fConfiguration);
        cLabel.setImage(accessorConfigurationLabelProvider.getImage(this.fClassReference));
        cLabel.setText(accessorConfigurationLabelProvider.getText(this.fClassReference));
        this.fTreeViewer = new CheckboxTreeViewer(composite2, 2048);
        this.fTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof MethodReference) {
                    int n = ((MethodReference)object).getParameterCount();
                    Object[] objectArray = new Object[n];
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        objectArray[n2] = ((MethodReference)object).getParameter(n2);
                        ++n2;
                    }
                    return objectArray;
                }
                return new Object[0];
            }

            public Object getParent(Object object) {
                return null;
            }

            public boolean hasChildren(Object object) {
                return object instanceof MethodReference;
            }

            public Object[] getElements(Object object) {
                if (object instanceof Object[]) {
                    return (Object[])object;
                }
                if (object instanceof Collection) {
                    return ((Collection)object).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new AccessorConfigurationLabelProvider(this.fConfiguration));
        List<MethodReference> list = this.calculateInput();
        if (list != null && list.size() > 0) {
            this.fTreeViewer.setInput(list);
            this.fTreeViewer.setCheckedElements(this.calcCheckedElements(list));
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)list.get(0)));
        }
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                if (object instanceof MethodReference) {
                    MethodReference methodReference = (MethodReference)object;
                    if (checkStateChangedEvent.getChecked()) {
                        AccessorMethodDialog.this.fTreeViewer.expandToLevel(object, 1);
                        if (methodReference.getSelectedParameter() == null) {
                            int n = methodReference.getParameterCount();
                            int n2 = 0;
                            while (n2 < n) {
                                ParameterReference parameterReference = methodReference.getParameter(n2);
                                if (parameterReference.isValidType()) {
                                    methodReference.setSelectedParameter((Object)parameterReference);
                                    AccessorMethodDialog.this.fTreeViewer.setChecked((Object)parameterReference, true);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    } else {
                        ParameterReference parameterReference = methodReference.getSelectedParameter();
                        methodReference.setSelectedParameter(null);
                        if (parameterReference != null) {
                            AccessorMethodDialog.this.fTreeViewer.setChecked((Object)parameterReference, false);
                        }
                        AccessorMethodDialog.this.fTreeViewer.collapseToLevel((Object)methodReference, 1);
                    }
                } else if (object instanceof ParameterReference) {
                    ParameterReference parameterReference = (ParameterReference)object;
                    if (checkStateChangedEvent.getChecked()) {
                        if (parameterReference.isValidType()) {
                            MethodReference methodReference = parameterReference.getMethodReference();
                            ParameterReference parameterReference2 = methodReference.getSelectedParameter();
                            if (parameterReference2 != null) {
                                AccessorMethodDialog.this.fTreeViewer.setChecked((Object)parameterReference2, false);
                            }
                            methodReference.setSelectedParameter((Object)parameterReference);
                            AccessorMethodDialog.this.fTreeViewer.setChecked((Object)methodReference, true);
                        } else {
                            AccessorMethodDialog.this.fTreeViewer.setChecked((Object)parameterReference, false);
                        }
                    } else {
                        MethodReference methodReference = parameterReference.getMethodReference();
                        methodReference.setSelectedParameter(null);
                        AccessorMethodDialog.this.fTreeViewer.setChecked((Object)methodReference, false);
                        AccessorMethodDialog.this.fTreeViewer.collapseToLevel((Object)methodReference, 1);
                    }
                }
                AccessorMethodDialog.this.validate();
            }
        });
        this.getParentShell().setCursor(null);
        cursor.dispose();
        return composite2;
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.validate();
        return control;
    }

    protected void okPressed() {
        ArrayList<MethodReference> arrayList = new ArrayList<MethodReference>();
        List list = (List)this.fTreeViewer.getInput();
        for (MethodReference methodReference : list) {
            if (methodReference.getSelectedParameter() == null) continue;
            arrayList.add(methodReference);
        }
        this.fSelectedMethods = arrayList;
        super.okPressed();
    }

    void validate() {
        this.getButton(0).setEnabled(this.fTreeViewer.getCheckedElements().length > 0);
    }

    private Object[] calcCheckedElements(List<MethodReference> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (MethodReference methodReference : list) {
            ParameterReference parameterReference = methodReference.getSelectedParameter();
            if (parameterReference == null) continue;
            arrayList.add(methodReference);
            this.fTreeViewer.expandToLevel((Object)methodReference, -1);
            arrayList.add(parameterReference);
        }
        return arrayList.toArray();
    }

    private List<MethodReference> calculateInput() {
        try {
            List list = CodeAnalyser.getValidMethods((AccessorConfiguration)this.fConfiguration, (ClassReference)this.fClassReference);
            block2: for (MethodReference methodReference : this.fSelectedMethods) {
                int n = 0;
                while (n < list.size()) {
                    int n2;
                    int n3;
                    MethodReference methodReference2 = (MethodReference)list.get(n);
                    if (methodReference.getMethodName().equals(methodReference2.getMethodName()) && (n3 = methodReference.getParameterCount()) == (n2 = methodReference2.getParameterCount())) {
                        boolean bl = true;
                        int n4 = 0;
                        while (n4 < n3) {
                            String string;
                            String string2 = methodReference.getParameter(n4).getFullyQualifiedParameterType();
                            if (!string2.equals(string = methodReference2.getParameter(n4).getFullyQualifiedParameterType())) {
                                bl = false;
                                break;
                            }
                            ++n4;
                        }
                        if (bl) {
                            list.set(n, methodReference);
                            continue block2;
                        }
                    }
                    ++n;
                }
            }
            Collections.sort(list, new Comparator<MethodReference>(){

                @Override
                public int compare(MethodReference methodReference, MethodReference methodReference2) {
                    return methodReference.getMethodName().compareTo(methodReference2.getMethodName());
                }
            });
            return list;
        }
        catch (JavaModelException javaModelException) {
            StringBuffer stringBuffer = new StringBuffer("Resolving valid method's for type '");
            stringBuffer.append(this.fClassReference.getFullyQualifiedTypeName());
            stringBuffer.append("' failed.");
            JIntoUI.getDefault().getLog().log((IStatus)new Status(4, JIntoUI.getID(), stringBuffer.toString(), (Throwable)javaModelException));
            return Collections.emptyList();
        }
    }
}

