/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.hyperlink;

import de.guhsoft.jinto.core.ASTUtil;
import de.guhsoft.jinto.core.configuration.accessor.AccessorConfigurationManager;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.editor.hyperlink.JIntoHyperlink;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class JIntoHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer iTextViewer, IRegion iRegion, boolean bl) {
        Object object;
        ITextEditor iTextEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (iRegion == null || iTextEditor == null) {
            return null;
        }
        IEditorSite iEditorSite = iTextEditor.getEditorSite();
        if (iEditorSite == null) {
            return null;
        }
        ITypeRoot iTypeRoot = this.getInputJavaElement(iTextEditor);
        if (iTypeRoot == null) {
            return null;
        }
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)iTypeRoot, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_NO, null);
        if (compilationUnit == null) {
            return null;
        }
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, (int)iRegion.getOffset(), (int)1);
        if (aSTNode.getNodeType() != 45) {
            return null;
        }
        MethodInvocation methodInvocation = ASTUtil.getMethodInvocationParent((StringLiteral)((StringLiteral)aSTNode));
        if (methodInvocation == null) {
            return null;
        }
        int n = ASTUtil.indexOf((MethodInvocation)methodInvocation, (ASTNode)aSTNode);
        ResourceBundleModel resourceBundleModel = null;
        try {
            object = AccessorConfigurationManager.getInstance();
            resourceBundleModel = object.getResourceBundle(iTypeRoot.getJavaProject(), methodInvocation, n);
        }
        catch (JavaModelException javaModelException) {
            this.logException(methodInvocation, (Exception)((Object)javaModelException));
        }
        catch (IOException iOException) {
            this.logException(methodInvocation, iOException);
        }
        catch (CoreException coreException) {
            this.logException(methodInvocation, (Exception)((Object)coreException));
        }
        if (resourceBundleModel == null) {
            return null;
        }
        object = ((StringLiteral)aSTNode).getLiteralValue();
        if (object == null) {
            return null;
        }
        Region region = new Region(aSTNode.getStartPosition(), aSTNode.getLength());
        return new IHyperlink[]{new JIntoHyperlink((IRegion)region, (String)object, resourceBundleModel, (IEditorPart)iTextEditor)};
    }

    private void logException(MethodInvocation methodInvocation, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer("Error while resolving accessor for method '");
        stringBuffer.append(methodInvocation.getName().getFullyQualifiedName());
        stringBuffer.append("'.");
        JIntoUI.getDefault().getLog().log((IStatus)new Status(4, JIntoUI.getID(), stringBuffer.toString(), (Throwable)exception));
    }

    private ITypeRoot getInputJavaElement(ITextEditor iTextEditor) {
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (iEditorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)iEditorInput).getClassFile();
        }
        if (iTextEditor instanceof CompilationUnitEditor) {
            return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput);
        }
        return null;
    }
}

