/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor.hyperlink;

import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class JIntoHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private ResourceBundleModel fResourceBundleModel;
    private IEditorPart fEditor;
    String fKeyName;

    public JIntoHyperlink(IRegion iRegion, String string, ResourceBundleModel resourceBundleModel, IEditorPart iEditorPart) {
        Assert.isNotNull((Object)iRegion);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)resourceBundleModel);
        Assert.isNotNull((Object)iEditorPart);
        this.fRegion = iRegion;
        this.fKeyName = string;
        this.fResourceBundleModel = resourceBundleModel;
        this.fEditor = iEditorPart;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        IWorkbenchPage iWorkbenchPage;
        IStorage iStorage = this.fResourceBundleModel.getSelectedStorage();
        if (iStorage == null) {
            this.showErrorInStatusLine(this.fEditor, Messages.getString("editor.hyperlink.fileNotFound", new Object[0]));
            return;
        }
        IEditorPart iEditorPart = null;
        try {
            iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iStorage instanceof IFile) {
                iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)((IFile)iStorage), (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            this.handleOpenPropertiesFileFailed(iStorage);
            return;
        }
        if (iEditorPart instanceof ResourceEditor) {
            iWorkbenchPage = this.fEditor.getSite().getShell().getDisplay();
            final IEditorPart iEditorPart2 = iEditorPart;
            iWorkbenchPage.asyncExec(new Runnable(){

                public void run() {
                    if (!((ResourceEditor)iEditorPart2).selectRow(JIntoHyperlink.this.fKeyName)) {
                        JIntoHyperlink.this.showErrorInStatusLine(iEditorPart2, Messages.getString("editor.hyperlink.keyNotFound", JIntoHyperlink.this.fKeyName));
                    }
                }
            });
        }
    }

    private void showErrorInStatusLine(IEditorPart iEditorPart, final String string) {
        Display display = this.fEditor.getSite().getShell().getDisplay();
        display.beep();
        final IEditorStatusLine iEditorStatusLine = (IEditorStatusLine)iEditorPart.getAdapter(IEditorStatusLine.class);
        if (iEditorStatusLine != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    iEditorStatusLine.setMessage(true, string, null);
                }
            });
        }
    }

    private void handleOpenPropertiesFileFailed(IStorage iStorage) {
        this.showErrorInStatusLine(this.fEditor, Messages.getString("editor.hyperlink.errorOpenEditor", iStorage.getFullPath().toOSString()));
    }

    public String getTypeLabel() {
        return Messages.getString("editor.hyperlink.type", new Object[0]);
    }

    public String getHyperlinkText() {
        return Messages.getString("editor.hyperlink.text", this.fKeyName, this.fResourceBundleModel.getFullyQualifiedName(false));
    }
}

