/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor;

import de.guhsoft.jinto.core.Util;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceFile;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.ProblemsCheckingJob;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import de.guhsoft.jinto.ui.editor.SuccessiveSchedulingRule;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorPart;

public class UpdateEditorJob
extends Job {
    ResourceEditor resourceEditor;
    private IResourceDelta resourceDelta;
    ResourceFile resourceFile;

    public UpdateEditorJob(ResourceEditor resourceEditor, IResourceDelta iResourceDelta, ResourceFile resourceFile) {
        super(Messages.getString("editor.update.title", new Object[0]));
        this.resourceEditor = resourceEditor;
        this.resourceDelta = iResourceDelta;
        this.resourceFile = resourceFile;
        this.setRule(new SuccessiveSchedulingRule((IEditorPart)resourceEditor));
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        ResourceBundleModel resourceBundleModel = this.resourceEditor.getResourceDataModel();
        switch (this.resourceDelta.getKind()) {
            case 4: {
                this.deltaChanged(resourceBundleModel);
                break;
            }
            case 1: {
                this.deltaAdded(resourceBundleModel);
                break;
            }
            case 2: {
                this.deltaRemoved(resourceBundleModel);
            }
        }
        new ProblemsCheckingJob(this.resourceEditor).schedule();
        return Status.OK_STATUS;
    }

    private void deltaChanged(ResourceBundleModel resourceBundleModel) {
        Properties properties = null;
        try {
            properties = this.resourceFile.loadProperties();
        }
        catch (IOException iOException) {
            Status status = new Status(4, JIntoUI.getID(), 4, "IOException occurs", iOException.fillInStackTrace());
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
        catch (CoreException coreException) {
            Status status = new Status(4, JIntoUI.getID(), 4, "IOException occurs", coreException.fillInStackTrace());
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
        if (properties != null) {
            this.refreshModelAndEditor(resourceBundleModel, properties);
        }
    }

    private void refreshModelAndEditor(ResourceBundleModel resourceBundleModel, Properties properties) {
        String string;
        ResourceRow resourceRow;
        String string2;
        String string3 = this.resourceFile.getResourceKey();
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = resourceBundleModel.getRowKeys();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            resourceRow = resourceBundleModel.getRow(string2);
            string = (String)properties.remove(string2);
            if (string == null) {
                boolean bl = true;
                int n = 0;
                while (n < resourceBundleModel.getResourceFileCount()) {
                    ResourceFile resourceFile = (ResourceFile)resourceBundleModel.getResourceFileMapEntry(n).getValue();
                    String string4 = resourceRow.getColumnValue(resourceFile.getResourceKey());
                    if (string4 != null && !string4.equals("")) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    linkedList.add(string2);
                    continue;
                }
                resourceRow.setColumnValue(string3, "", false);
                continue;
            }
            resourceRow.setColumnValue(string3, Util.escapeForLabel((String)string), false);
        }
        int n = 0;
        while (n < linkedList.size()) {
            resourceBundleModel.removeRow((String)linkedList.get(n), false);
            ++n;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string2 = Util.escapeForLabel((String)((String)enumeration.nextElement()));
            string = properties.getProperty(string2);
            resourceRow = new ResourceRow(string2, resourceBundleModel);
            resourceRow.setColumnValue(string3, Util.escapeForLabel((String)(string == null ? "" : string)), false);
            resourceBundleModel.addRow(string2, resourceRow, false);
        }
        if (!this.resourceEditor.isDisposed()) {
            this.resourceEditor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    UpdateEditorJob.this.resourceEditor.clearOperationHistory();
                    UpdateEditorJob.this.resourceEditor.refreshTable();
                }
            });
        }
    }

    private void deltaAdded(ResourceBundleModel resourceBundleModel) {
        try {
            resourceBundleModel.addResourceFile(this.resourceFile);
            if (!this.resourceEditor.isDisposed()) {
                this.resourceEditor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        UpdateEditorJob.this.resourceEditor.addColumn(UpdateEditorJob.this.resourceFile.getResourceKey());
                    }
                });
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, JIntoUI.getID(), 4, "IOException occurs", iOException.fillInStackTrace());
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
        catch (CoreException coreException) {
            Status status = new Status(4, JIntoUI.getID(), 4, "CoreException occurs", coreException.fillInStackTrace());
            JIntoUI.getDefault().getLog().log((IStatus)status);
        }
    }

    private void deltaRemoved(ResourceBundleModel resourceBundleModel) {
        if (resourceBundleModel.getResourceFileCount() == 1 || resourceBundleModel.getSelectedStorage().equals(this.resourceFile.getFileStorage())) {
            this.resourceEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    UpdateEditorJob.this.resourceEditor.getSite().getPage().closeEditor((IEditorPart)UpdateEditorJob.this.resourceEditor, false);
                }
            });
        } else {
            resourceBundleModel.removeResourceFile(this.resourceFile);
            if (!this.resourceEditor.isDisposed()) {
                this.resourceEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        UpdateEditorJob.this.resourceEditor.removeColumn(UpdateEditorJob.this.resourceFile.getResourceKey());
                    }
                });
            }
        }
    }
}

