/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor;

import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.model.AddRowOperation;
import de.guhsoft.jinto.core.model.IResourceBundleListener;
import de.guhsoft.jinto.core.model.ModifyRowKeyOperation;
import de.guhsoft.jinto.core.model.ModifyRowValueOperation;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceFile;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import de.guhsoft.jinto.core.util.LocaleComparator;
import de.guhsoft.jinto.ui.Constants;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.DisplayColumnsAction;
import de.guhsoft.jinto.ui.editor.JIntoMarkerColumn;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import de.guhsoft.jinto.ui.editor.actions.SearchForReferenceAction;
import de.guhsoft.jinto.ui.editor.table.ResourceFocusCellHighlighter;
import de.guhsoft.jinto.ui.editor.table.ResourceTextCellEditor;
import de.guhsoft.jinto.ui.editor.table.ResourceViewer;
import de.guhsoft.jinto.ui.editor.table.ResourceViewerEditor;
import de.guhsoft.jinto.ui.editor.table.ResourceViewerFocusCellManager;
import de.guhsoft.jinto.ui.ruler.VerticalTableRuler;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResourceEditorRenderer
implements ISelectionProvider,
IResourceBundleListener,
IOperationHistoryListener,
ICellEditorListener {
    private ResourceViewer fTableViewer;
    ResourceEditor fEditor;
    private ResourceViewerFocusCellManager fFocusCellManager;
    private boolean fIsOperationRunning;
    private ResourceTextCellEditor fCellEditor;
    private Form fForm;
    private JIntoMarkerColumn fJIntoMarkerColumn;
    private DisplayColumnsAction fDisplayColumnsAction;

    public ResourceEditorRenderer(ResourceEditor resourceEditor) {
        this.fEditor = resourceEditor;
        this.fIsOperationRunning = false;
    }

    public void createContents(Composite composite) {
        FormToolkit formToolkit = new FormToolkit(composite.getDisplay());
        this.fForm = formToolkit.createForm(composite);
        this.fForm.setText(Messages.getString("editor.filename.addition", this.fEditor.getResourceDataModel().getName()));
        this.fForm.setImage(JIntoUI.getImage("resourceBundle"));
        formToolkit.decorateFormHeading(this.fForm);
        IToolBarManager iToolBarManager = this.fForm.getToolBarManager();
        Action action = new Action("", JIntoUI.getDescriptor("addIcon")){

            public void run() {
                ResourceEditorRenderer.this.fEditor.addNewRow();
            }
        };
        action.setToolTipText(Messages.getString("editor.addRow", new Object[0]));
        action.setEnabled(!this.fEditor.isReadOnly());
        iToolBarManager.add((IAction)action);
        Action action2 = new Action("", JIntoUI.getDescriptor("removeIcon")){

            public void run() {
                ResourceEditorRenderer.this.fEditor.removeSelectedRows();
            }
        };
        action2.setToolTipText(Messages.getString("editor.removeRow", new Object[0]));
        action2.setEnabled(!this.fEditor.isReadOnly());
        iToolBarManager.add((IAction)action2);
        iToolBarManager.add((IContributionItem)new Separator());
        this.fDisplayColumnsAction = new DisplayColumnsAction(this);
        iToolBarManager.add((IAction)this.fDisplayColumnsAction);
        this.fForm.updateToolBar();
        Composite composite2 = this.fForm.getBody();
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        VerticalTableRuler verticalTableRuler = new VerticalTableRuler(composite2, 0);
        verticalTableRuler.setLayoutData(new GridData(1040));
        VerticalSpacer verticalSpacer = new VerticalSpacer(composite2, 0, formToolkit.getColors());
        verticalSpacer.setLayoutData(new GridData(1040));
        Table table = new Table(composite2, 65536);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.fTableViewer = new ResourceViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fJIntoMarkerColumn = new JIntoMarkerColumn(this.fEditor.getResourceDataModel(), this.fTableViewer);
        verticalTableRuler.addColumn(this.fJIntoMarkerColumn);
        verticalTableRuler.connect(this.fTableViewer);
        ResourceFocusCellHighlighter resourceFocusCellHighlighter = new ResourceFocusCellHighlighter(this.fTableViewer);
        this.fFocusCellManager = new ResourceViewerFocusCellManager(this.fTableViewer, (FocusCellHighlighter)resourceFocusCellHighlighter);
        ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
                return columnViewerEditorActivationEvent.eventType == 5 || columnViewerEditorActivationEvent.eventType == 3 || columnViewerEditorActivationEvent.eventType == 1 && columnViewerEditorActivationEvent.keyCode == 13 || columnViewerEditorActivationEvent.eventType == 4;
            }
        };
        ResourceViewerEditor.create(this.fTableViewer, this.fFocusCellManager, columnViewerEditorActivationStrategy, 58, this);
        this.fCellEditor = new ResourceTextCellEditor((Composite)table);
        this.fCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object object) {
                ViewerCell viewerCell = ResourceEditorRenderer.this.getFocusCellManager().getFocusCell();
                if (viewerCell.getColumnIndex() == 0) {
                    return ResourceEditorRenderer.this.validateKey(viewerCell, object != null ? object.toString() : "");
                }
                return null;
            }
        });
        this.fCellEditor.addListener(this);
        this.fTableViewer.setInput(this.fEditor.getResourceDataModel());
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.fTableViewer, 0);
        tableViewerColumn.getColumn().setText(Constants.KEY_COLUMN);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new KeyColumnLabelProvider());
        tableViewerColumn.setEditingSupport((EditingSupport)new KeyEditingSupport(this.fTableViewer, (CellEditor)this.fCellEditor, this.fEditor, this.fJIntoMarkerColumn));
        KeyColumnSorter keyColumnSorter = new KeyColumnSorter((ColumnViewer)this.fTableViewer, tableViewerColumn);
        this.installKeyColumnContextMenu(this.fTableViewer, this.fFocusCellManager);
        this.initializeColumnSize(tableViewerColumn.getColumn());
        int n = 0;
        while (n < this.fEditor.getResourceDataModel().getResourceFileCount()) {
            Map.Entry entry = this.fEditor.getResourceDataModel().getResourceFileMapEntry(n);
            this.addColumn((String)entry.getKey(), this.fCellEditor);
            ++n;
        }
        keyColumnSorter.setSorter(keyColumnSorter, 1);
        this.fEditor.getResourceDataModel().addListener((IResourceBundleListener)this);
        table.addKeyListener((KeyListener)this.fEditor);
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
    }

    private void installKeyColumnContextMenu(TableViewer tableViewer, final TableViewerFocusCellManager tableViewerFocusCellManager) {
        final SearchForReferenceAction searchForReferenceAction = new SearchForReferenceAction(new SearchForReferenceAction.IKeyResolver(){

            public String resolveKey() {
                ViewerCell viewerCell = tableViewerFocusCellManager.getFocusCell();
                if (viewerCell != null) {
                    return viewerCell.getText();
                }
                return null;
            }
        });
        final MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ViewerCell viewerCell = tableViewerFocusCellManager.getFocusCell();
                if (viewerCell != null && viewerCell.getColumnIndex() == 0) {
                    menuManager.add((IAction)searchForReferenceAction);
                }
            }
        });
        Table table = tableViewer.getTable();
        table.setMenu(menuManager.createContextMenu((Control)table));
    }

    public String validateKey(ViewerCell viewerCell, String string) {
        ResourceBundleModel resourceBundleModel = this.fEditor.getResourceDataModel();
        ResourceRow resourceRow = resourceBundleModel.getRow(string);
        if (resourceRow != null && !resourceRow.equals(viewerCell.getElement())) {
            return Messages.getString("editor.autoCheck.duplicateKeys", new Object[0]);
        }
        return null;
    }

    public void execute(IUndoableOperation iUndoableOperation) {
        this.fEditor.execute(iUndoableOperation);
    }

    public ResourceBundleModel getResourceDataModel() {
        return this.fEditor.getResourceDataModel();
    }

    public ResourceViewerFocusCellManager getFocusCellManager() {
        return this.fFocusCellManager;
    }

    protected void sizeColumnsToEditorWidth() {
        if (this.fEditor != null) {
            this.fEditor.cancelEditing();
        }
        Table table = this.fTableViewer.getTable();
        table.setRedraw(false);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = table.getClientArea().width / tableColumnArray.length;
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            tableColumnArray[n2].setWidth(n);
            ++n2;
        }
        table.setRedraw(true);
    }

    protected void sizeColumnsToOptimalWidth() {
        if (this.fEditor != null) {
            this.fEditor.cancelEditing();
        }
        Table table = this.fTableViewer.getTable();
        table.setRedraw(false);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            this.sizeColumnsToOptimalWidth(tableColumnArray[n]);
            ++n;
        }
        table.setRedraw(true);
    }

    private void sizeColumnsToOptimalWidth(TableColumn tableColumn) {
        tableColumn.pack();
        if (Platform.getOS().equals("win32")) {
            tableColumn.setWidth(tableColumn.getWidth() + 2);
        }
    }

    protected void cancelEditing() {
        this.fTableViewer.cancelEditing();
    }

    private TableViewerColumn addColumn(String string, TextCellEditor textCellEditor) {
        int n = this.resolveIndexForNewColumn(string);
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.fTableViewer, 0, n);
        tableViewerColumn.getColumn().setText(string);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ValuesColumnLabelProvider(string, this.fEditor.getResourceDataModel()));
        tableViewerColumn.setEditingSupport((EditingSupport)new ValuesEditingSupport(string, this.fTableViewer, (CellEditor)textCellEditor, this.fEditor));
        new ValuesColumnSorter(string, (ColumnViewer)this.fTableViewer, tableViewerColumn);
        this.initializeColumnSize(tableViewerColumn.getColumn());
        return tableViewerColumn;
    }

    public void addColumn(String string) {
        this.addColumn(string, this.fCellEditor);
        this.fTableViewer.refresh();
    }

    public int getColumnCount() {
        return this.fTableViewer.getTable().getColumnCount();
    }

    public boolean isColumnExisting(String string) {
        TableColumn[] tableColumnArray = this.fTableViewer.getTable().getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            if (string.equals(tableColumnArray[n].getText())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void initializeColumnSize(TableColumn tableColumn) {
        final IEclipsePreferences iEclipsePreferences = JIntoCore.getPreferences();
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                TableColumn tableColumn = (TableColumn)controlEvent.getSource();
                iEclipsePreferences.putInt(ResourceEditorRenderer.this.getColumnPreferencesIdentifier(tableColumn), tableColumn.getWidth());
            }
        });
        int n = iEclipsePreferences.getInt(this.getColumnPreferencesIdentifier(tableColumn), -1);
        if (n <= 0) {
            this.sizeColumnsToOptimalWidth(tableColumn);
        } else {
            tableColumn.setWidth(n);
        }
    }

    String getColumnPreferencesIdentifier(TableColumn tableColumn) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getResourceDataModel().toString());
        stringBuffer.append("_");
        stringBuffer.append(tableColumn.getText());
        return stringBuffer.toString();
    }

    private int resolveIndexForNewColumn(String string) {
        int n;
        Table table = this.fTableViewer.getTable();
        int n2 = n = table.getColumnCount();
        ResourceFile resourceFile = this.getResourceDataModel().getResourceFile(string);
        Locale locale = resourceFile.getLocaleInfos();
        if (locale == null) {
            n2 = 1;
        } else {
            LocaleComparator localeComparator = new LocaleComparator();
            int n3 = 1;
            while (n3 < n) {
                Locale locale2;
                resourceFile = this.getResourceDataModel().getResourceFile(table.getColumn(n3).getText());
                if (resourceFile != null && locale != (locale2 = resourceFile.getLocaleInfos()) && locale2 != null && localeComparator.compare(locale, locale2) < 0) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        return n2;
    }

    public void removeColumn(String string) {
        TableColumn[] tableColumnArray = this.fTableViewer.getTable().getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            if (string.equals(tableColumnArray[n].getText())) {
                tableColumnArray[n].dispose();
                break;
            }
            ++n;
        }
        this.fTableViewer.refresh();
    }

    public void refreshTable() {
        this.fTableViewer.refresh();
    }

    public boolean isDisposed() {
        return this.fTableViewer.getControl().isDisposed();
    }

    public void dispose() {
        if (this.fJIntoMarkerColumn != null) {
            this.fJIntoMarkerColumn.dispose();
        }
        if (this.fDisplayColumnsAction != null) {
            this.fDisplayColumnsAction.dispose();
        }
        this.fEditor.getResourceDataModel().removeListener((IResourceBundleListener)this);
    }

    public void rowAdded(String string, ResourceRow resourceRow) {
        ResourceRow resourceRow2;
        int n = -1;
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection && (resourceRow2 = (ResourceRow)((IStructuredSelection)iSelection).getFirstElement()) != null) {
            n = resourceRow2.getSortIndex();
        }
        resourceRow.setSortIndex(++n);
        ResourceRow[] resourceRowArray = this.getResourceDataModel().getRows();
        int n2 = resourceRowArray.length;
        int n3 = 0;
        while (n3 < n2) {
            resourceRow2 = resourceRowArray[n3];
            if (resourceRow2.getSortIndex() > n || resourceRow2.getSortIndex() == n && resourceRow2 != resourceRow) {
                resourceRow2.setSortIndex(resourceRow2.getSortIndex() + 1);
            }
            ++n3;
        }
        this.fTableViewer.refresh();
        if (this.fIsOperationRunning) {
            this.fFocusCellManager.setViewerFocusCell(this.fTableViewer.getViewerCell(resourceRow, null));
        } else {
            this.fTableViewer.editElement(resourceRow, 0);
        }
    }

    public void rowRemoved(String string, ResourceRow resourceRow) {
        ResourceRow resourceRow2;
        ViewerCell viewerCell = null;
        ViewerCell viewerCell2 = this.fFocusCellManager.getFocusCell();
        ViewerCell viewerCell3 = viewerCell2.getNeighbor(ViewerCell.ABOVE, true);
        ViewerCell viewerCell4 = viewerCell2.getNeighbor(ViewerCell.BELOW, true);
        int n = resourceRow.getSortIndex();
        Object object = this.getResourceDataModel().getRows();
        int n2 = ((ResourceRow[])object).length;
        int n3 = 0;
        while (n3 < n2) {
            resourceRow2 = object[n3];
            if (resourceRow2.getSortIndex() >= n) {
                resourceRow2.setSortIndex(resourceRow2.getSortIndex() - 1);
            }
            ++n3;
        }
        this.fTableViewer.refresh();
        resourceRow2 = this.fEditor.getResourceDataModel();
        n3 = resourceRow2.getRowCount();
        if (n3 > 0) {
            if (n3 > 1) {
                if (viewerCell3 != null) {
                    viewerCell4 = viewerCell3.getNeighbor(ViewerCell.BELOW, true);
                } else if (viewerCell4 != null) {
                    viewerCell4 = viewerCell4.getNeighbor(ViewerCell.ABOVE, true);
                }
                viewerCell = viewerCell4 != null ? viewerCell4 : viewerCell3;
            } else {
                TableColumn tableColumn = this.fTableViewer.getTable().getColumn(viewerCell2.getColumnIndex());
                if (tableColumn != null) {
                    object = tableColumn.getText();
                    ResourceRow resourceRow3 = resourceRow2.getRows()[0];
                    viewerCell = this.fTableViewer.getViewerCell(resourceRow3, (String)object);
                }
            }
            this.fFocusCellManager.setViewerFocusCell(viewerCell);
        }
    }

    public void rowKeyChanged(String string, String string2, ResourceRow resourceRow) {
        this.fTableViewer.update(resourceRow, null);
        this.fFocusCellManager.setViewerFocusCell(this.fTableViewer.getViewerCell(resourceRow, null));
    }

    public void rowValueChanged(ResourceRow resourceRow, String string, String string2) {
        this.fTableViewer.update(resourceRow, null);
        this.fFocusCellManager.setViewerFocusCell(this.fTableViewer.getViewerCell(resourceRow, string));
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fTableViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.fTableViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fTableViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.fTableViewer.setSelection(iSelection, true);
    }

    public void historyNotification(OperationHistoryEvent operationHistoryEvent) {
        IUndoContext iUndoContext = this.fEditor.getResourceDataModel().getUndoContent();
        if (operationHistoryEvent.getOperation().hasContext(iUndoContext)) {
            switch (operationHistoryEvent.getEventType()) {
                case 2: 
                case 3: {
                    this.cancelEditing();
                    this.fIsOperationRunning = true;
                    break;
                }
                case 9: 
                case 10: {
                    this.fIsOperationRunning = false;
                }
            }
        }
    }

    public void applyEditorValue() {
    }

    public void cancelEditor() {
    }

    public void setFocus() {
        this.fTableViewer.getControl().setFocus();
    }

    public void editorValueChanged(boolean bl, boolean bl2) {
        if (bl != bl2) {
            ViewerRow viewerRow;
            if (!bl2 && (viewerRow = this.fFocusCellManager.getFocusCell().getViewerRow()).getColumnCount() > 0) {
                this.fJIntoMarkerColumn.setDuplicateKey(viewerRow.getText(0));
                return;
            }
            this.fJIntoMarkerColumn.setDuplicateKey(null);
        }
    }

    private static abstract class ColumnViewerSorter
    extends ViewerComparator {
        public static final int ASC = 1;
        public static final int DESC = -1;
        int fDirection = 0;
        private TableViewerColumn fColumn;
        ColumnViewer fViewer;
        boolean fSort = true;

        public ColumnViewerSorter(ColumnViewer columnViewer, TableViewerColumn tableViewerColumn) {
            this.fColumn = tableViewerColumn;
            this.fViewer = columnViewer;
            this.fColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColumnViewerSorter.this.fSort = true;
                    if (ColumnViewerSorter.this.fViewer.getComparator() != null) {
                        if (ColumnViewerSorter.this.fViewer.getComparator() == ColumnViewerSorter.this) {
                            int n = ColumnViewerSorter.this.fDirection;
                            if (n == 1) {
                                ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, -1);
                            } else if (n == -1) {
                                ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                            }
                        } else {
                            ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                        }
                    } else {
                        ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                    }
                }
            });
        }

        public void setSorter(ColumnViewerSorter columnViewerSorter, int n) {
            this.fColumn.getColumn().getParent().setSortColumn(this.fColumn.getColumn());
            columnViewerSorter.fDirection = n;
            if (n == 1) {
                this.fColumn.getColumn().getParent().setSortDirection(1024);
            } else {
                this.fColumn.getColumn().getParent().setSortDirection(128);
            }
            if (this.fViewer.getComparator() == columnViewerSorter) {
                this.fViewer.refresh();
            } else {
                this.fViewer.setComparator((ViewerComparator)columnViewerSorter);
            }
        }

        public void sort(Viewer viewer, Object[] objectArray) {
            super.sort(viewer, objectArray);
            int n = 0;
            while (n < objectArray.length) {
                ((ResourceRow)objectArray[n]).setSortIndex(n);
                ++n;
            }
            this.fSort = false;
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            if (!this.fSort) {
                return ((ResourceRow)object).getSortIndex() - ((ResourceRow)object2).getSortIndex();
            }
            return this.fDirection * this.doCompare(viewer, object, object2);
        }

        protected abstract int doCompare(Viewer var1, Object var2, Object var3);
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            return ((ResourceBundleModel)object).getRows();
        }

        public void dispose() {
        }
    }

    private static class KeyColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object object) {
            return ((ResourceRow)object).getKey();
        }
    }

    private static final class KeyColumnSorter
    extends ColumnViewerSorter {
        public KeyColumnSorter(ColumnViewer columnViewer, TableViewerColumn tableViewerColumn) {
            super(columnViewer, tableViewerColumn);
        }

        protected int doCompare(Viewer viewer, Object object, Object object2) {
            String string = ((ResourceRow)object).getKey();
            String string2 = ((ResourceRow)object2).getKey();
            return string.compareToIgnoreCase(string2);
        }
    }

    private static final class KeyEditingSupport
    extends EditingSupport {
        private CellEditor fCellEditor;
        private ResourceEditor fEditor;
        private JIntoMarkerColumn fJIntoMarkerColumn;

        public KeyEditingSupport(TableViewer tableViewer, CellEditor cellEditor, ResourceEditor resourceEditor, JIntoMarkerColumn jIntoMarkerColumn) {
            super((ColumnViewer)tableViewer);
            this.fCellEditor = cellEditor;
            this.fEditor = resourceEditor;
            this.fJIntoMarkerColumn = jIntoMarkerColumn;
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.fCellEditor;
        }

        protected Object getValue(Object object) {
            return ((ResourceRow)object).getKey();
        }

        protected void setValue(Object object, Object object2) {
            String string = ((ResourceRow)object).getKey();
            if (object2 != null) {
                String string2 = object2.toString();
                if (!string.equals(string2)) {
                    IOperationHistory iOperationHistory = OperationHistoryFactory.getOperationHistory();
                    ResourceBundleModel resourceBundleModel = this.fEditor.getResourceDataModel();
                    IUndoContext iUndoContext = resourceBundleModel.getUndoContent();
                    IUndoableOperation[] iUndoableOperationArray = iOperationHistory.getRedoHistory(iUndoContext);
                    IUndoableOperation iUndoableOperation = iOperationHistory.getUndoOperation(iUndoContext);
                    ModifyRowKeyOperation modifyRowKeyOperation = new ModifyRowKeyOperation(resourceBundleModel, string, string2);
                    this.fEditor.execute((IUndoableOperation)modifyRowKeyOperation);
                    if ((iUndoableOperationArray == null || iUndoableOperationArray.length == 0) && iUndoableOperation instanceof AddRowOperation && string.equals(((AddRowOperation)iUndoableOperation).getKey())) {
                        ((AddRowOperation)iUndoableOperation).setKey(string2);
                        iOperationHistory.replaceOperation((IUndoableOperation)modifyRowKeyOperation, new IUndoableOperation[0]);
                    }
                }
            } else {
                this.fJIntoMarkerColumn.setDuplicateKey(null);
            }
        }
    }

    private static class ValuesColumnLabelProvider
    extends ColumnLabelProvider {
        private String fColumnKey;
        private ResourceBundleModel fModel;
        private Color fVirtualColor;

        public ValuesColumnLabelProvider(String string, ResourceBundleModel resourceBundleModel) {
            this.fColumnKey = string;
            this.fModel = resourceBundleModel;
        }

        public String getText(Object object) {
            IEclipsePreferences iEclipsePreferences;
            String string = ((ResourceRow)object).getColumnValue(this.fColumnKey);
            if (string != null && string.length() == 0 && !(iEclipsePreferences = JIntoCore.getPreferences()).getBoolean(IPreferenceConstants.SAVING_EMPTY_VALUES.key(), ((Boolean)IPreferenceConstants.SAVING_EMPTY_VALUES.defaultValue()).booleanValue()) && iEclipsePreferences.getBoolean(IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.key(), ((Boolean)IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.defaultValue()).booleanValue())) {
                string = this.getVirtualText((ResourceRow)object, this.fColumnKey);
            }
            return string;
        }

        public Color getForeground(Object object) {
            IEclipsePreferences iEclipsePreferences;
            Color color = super.getForeground(object);
            String string = ((ResourceRow)object).getColumnValue(this.fColumnKey);
            if (string != null && string.length() == 0 && !(iEclipsePreferences = JIntoCore.getPreferences()).getBoolean(IPreferenceConstants.SAVING_EMPTY_VALUES.key(), ((Boolean)IPreferenceConstants.SAVING_EMPTY_VALUES.defaultValue()).booleanValue()) && iEclipsePreferences.getBoolean(IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.key(), ((Boolean)IPreferenceConstants.SAVING_SHOW_VIRTUAL_TEXT.defaultValue()).booleanValue())) {
                int n = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_RED.defaultValue()).intValue());
                int n2 = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_GREEN.defaultValue()).intValue());
                int n3 = iEclipsePreferences.getInt(IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.key(), ((Integer)IPreferenceConstants.SAVING_VIRTUAL_TEXT_COLOR_BLUE.defaultValue()).intValue());
                if (this.fVirtualColor == null || n != this.fVirtualColor.getRed() || n2 != this.fVirtualColor.getGreen() || n3 != this.fVirtualColor.getBlue()) {
                    if (this.fVirtualColor != null) {
                        this.fVirtualColor.dispose();
                    }
                    this.fVirtualColor = new Color((Device)PlatformUI.getWorkbench().getDisplay(), n, n2, n3);
                }
                color = this.fVirtualColor;
            }
            return color;
        }

        private String getVirtualText(ResourceRow resourceRow, String string) {
            String string2 = "";
            int n = 0;
            while (n < this.fModel.getResourceFileCount()) {
                Map.Entry entry = this.fModel.getResourceFileMapEntry(n);
                if (((String)entry.getKey()).equals(string)) {
                    ResourceFile resourceFile = (ResourceFile)entry.getValue();
                    if (resourceFile == null) break;
                    string2 = resourceRow.getColumnValue(resourceFile.getLocaleInfos());
                    break;
                }
                ++n;
            }
            return string2;
        }

        public void dispose() {
            super.dispose();
            if (this.fVirtualColor != null) {
                this.fVirtualColor.dispose();
            }
        }
    }

    private static final class ValuesColumnSorter
    extends ColumnViewerSorter {
        private String fColumnKey;

        public ValuesColumnSorter(String string, ColumnViewer columnViewer, TableViewerColumn tableViewerColumn) {
            super(columnViewer, tableViewerColumn);
            this.fColumnKey = string;
        }

        protected int doCompare(Viewer viewer, Object object, Object object2) {
            String string = ((ResourceRow)object).getColumnValue(this.fColumnKey);
            String string2 = ((ResourceRow)object2).getColumnValue(this.fColumnKey);
            return string.compareToIgnoreCase(string2);
        }
    }

    private static class ValuesEditingSupport
    extends EditingSupport {
        private String fColumnKey;
        private CellEditor fCellEditor;
        private ResourceEditor fEditor;

        public ValuesEditingSupport(String string, TableViewer tableViewer, CellEditor cellEditor, ResourceEditor resourceEditor) {
            super((ColumnViewer)tableViewer);
            this.fColumnKey = string;
            this.fCellEditor = cellEditor;
            this.fEditor = resourceEditor;
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.fCellEditor;
        }

        protected Object getValue(Object object) {
            return ((ResourceRow)object).getColumnValue(this.fColumnKey);
        }

        protected void setValue(Object object, Object object2) {
            ResourceRow resourceRow = (ResourceRow)object;
            if (object2 != null) {
                String string = object2.toString();
                if (!resourceRow.getColumnValue(this.fColumnKey).equals(string)) {
                    ResourceBundleModel resourceBundleModel = this.fEditor.getResourceDataModel();
                    this.fEditor.execute((IUndoableOperation)new ModifyRowValueOperation(resourceBundleModel, resourceRow, this.fColumnKey, string));
                }
            }
        }
    }

    private static final class VerticalSpacer
    extends Canvas {
        private FormColors fColors;

        public VerticalSpacer(Composite composite, int n, FormColors formColors) {
            super(composite, n);
            this.fColors = formColors;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    VerticalSpacer.this.onPaint(paintEvent.gc);
                }
            });
        }

        void onPaint(GC gC) {
            Rectangle rectangle = gC.getClipping();
            Color color = null;
            Color color2 = null;
            color = this.fColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1");
            color2 = this.fColors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2");
            gC.setForeground(color);
            gC.drawLine(0, rectangle.y, 0, rectangle.height);
            gC.setForeground(color2);
            gC.drawLine(1, rectangle.y, 1, rectangle.height);
        }

        public Point computeSize(int n, int n2, boolean bl) {
            Point point = super.computeSize(n, n2, bl);
            point.x = 2;
            return point;
        }
    }
}

