/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor;

import de.guhsoft.jinto.core.model.IResourceBundleListener;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import java.text.MessageFormat;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class ResourceEditorActionContributor
extends EditorActionBarContributor
implements ISelectionChangedListener,
IResourceBundleListener {
    private static final String[] ACTIONS = new String[]{ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.FIND.getId()};
    private static final String STATUS_LINE_MODUS_ID = "de.guhsoft.jinto.modus";
    private IStatusLineManager fStatusLineManager;
    private ResourceEditor selectedEditor;

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        if (this.selectedEditor != null) {
            this.selectedEditor.getTableSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            this.selectedEditor.getResourceDataModel().removeListener((IResourceBundleListener)this);
        }
        this.selectedEditor = (ResourceEditor)iEditorPart;
        this.selectedEditor.getTableSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectedEditor.getResourceDataModel().addListener((IResourceBundleListener)this);
        this.handleSelection(this.selectedEditor.getTableSelectionProvider().getSelection());
        String string = null;
        string = this.selectedEditor.isReadOnly() ? Messages.getString("editor.state.readOnly", new Object[0]) : Messages.getString("editor.state.writable", new Object[0]);
        ((StatusLineContributionItem)this.fStatusLineManager.find(STATUS_LINE_MODUS_ID)).setText(string);
        IActionBars iActionBars = this.getActionBars();
        if (iActionBars != null) {
            int n = 0;
            while (n < ACTIONS.length) {
                iActionBars.setGlobalActionHandler(ACTIONS[n], this.getAction(this.selectedEditor, ACTIONS[n]));
                ++n;
            }
        }
    }

    private final IAction getAction(ResourceEditor resourceEditor, String string) {
        return resourceEditor == null || string == null ? null : resourceEditor.getAction(string);
    }

    public void contributeToStatusLine(IStatusLineManager iStatusLineManager) {
        super.contributeToStatusLine(iStatusLineManager);
        this.fStatusLineManager = iStatusLineManager;
        StatusLineContributionItem statusLineContributionItem = new StatusLineContributionItem(STATUS_LINE_MODUS_ID);
        this.fStatusLineManager.add((IContributionItem)statusLineContributionItem);
    }

    private void setStatusLineMessage(int n, ResourceRow resourceRow) {
        MessageFormat messageFormat = new MessageFormat(Messages.getString("statusLine.message", new Object[0]));
        this.fStatusLineManager.setMessage(messageFormat.format(new String[]{String.valueOf(n), resourceRow.getKey()}));
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.handleSelection(selectionChangedEvent.getSelection());
    }

    public void rowAdded(String string, ResourceRow resourceRow) {
        this.handleSelection(this.selectedEditor.getTableSelectionProvider().getSelection());
    }

    public void rowKeyChanged(String string, String string2, ResourceRow resourceRow) {
        this.handleSelection(this.selectedEditor.getTableSelectionProvider().getSelection());
    }

    public void rowRemoved(String string, ResourceRow resourceRow) {
        this.handleSelection(this.selectedEditor.getTableSelectionProvider().getSelection());
    }

    public void rowValueChanged(ResourceRow resourceRow, String string, String string2) {
        this.handleSelection(this.selectedEditor.getTableSelectionProvider().getSelection());
    }

    private void handleSelection(ISelection iSelection) {
        ResourceRow resourceRow;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (resourceRow = (ResourceRow)((IStructuredSelection)iSelection).getFirstElement()) != null) {
            this.setStatusLineMessage(this.selectedEditor.getResourceDataModel().getRowCount(), resourceRow);
        }
    }

    public void dispose() {
        ResourceBundleModel resourceBundleModel;
        super.dispose();
        if (this.selectedEditor != null && (resourceBundleModel = this.selectedEditor.getResourceDataModel()) != null) {
            resourceBundleModel.removeListener((IResourceBundleListener)this);
        }
    }
}

