/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.editor;

import de.guhsoft.jinto.core.JIntoBundleMarker;
import de.guhsoft.jinto.core.JIntoCore;
import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.core.preferences.IPreferenceConstants;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import de.guhsoft.jinto.ui.editor.ResourceEditor;
import de.guhsoft.jinto.ui.editor.SuccessiveSchedulingRule;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemsCheckingJob
extends Job {
    private ResourceBundleModel resourceDataModel;

    public ProblemsCheckingJob(ResourceEditor resourceEditor) {
        super(Messages.getString("editor.autoCheck.title", new Object[0]));
        this.resourceDataModel = resourceEditor.getResourceDataModel();
        this.setRule(new SuccessiveSchedulingRule((IEditorPart)resourceEditor));
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        IEclipsePreferences iEclipsePreferences = JIntoCore.getPreferences();
        int n = iEclipsePreferences.getInt(IPreferenceConstants.PROBLEMS_EMPTY_KEY.key(), ((Integer)IPreferenceConstants.PROBLEMS_EMPTY_KEY.defaultValue()).intValue());
        int n2 = iEclipsePreferences.getInt(IPreferenceConstants.PROBLEMS_EMPTY_VALUE.key(), ((Integer)IPreferenceConstants.PROBLEMS_EMPTY_VALUE.defaultValue()).intValue());
        int n3 = iEclipsePreferences.getInt(IPreferenceConstants.PROBLEMS_EQUAL_CELL_CONTENT.key(), ((Integer)IPreferenceConstants.PROBLEMS_EQUAL_CELL_CONTENT.defaultValue()).intValue());
        int n4 = this.resourceDataModel.getRowCount();
        int n5 = 1;
        n5 += n == JIntoCore.SEVERITY_IGNORE ? 0 : n4;
        n5 += n2 == JIntoCore.SEVERITY_IGNORE ? 0 : n4;
        iProgressMonitor.beginTask("", n5 += n3 == JIntoCore.SEVERITY_IGNORE ? 0 : n4);
        LinkedList<Map<String, Object>> linkedList = new LinkedList<Map<String, Object>>();
        if ((n != JIntoCore.SEVERITY_IGNORE || n2 != JIntoCore.SEVERITY_IGNORE) && this.checkForEmptyKeysAndValues(linkedList, iProgressMonitor, n, n2) == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        if (n3 != JIntoCore.SEVERITY_IGNORE && this.checkForEqualCellContent(linkedList, iProgressMonitor, n3) == Status.CANCEL_STATUS) {
            return Status.CANCEL_STATUS;
        }
        if (iProgressMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.syncMarkers(linkedList);
        iProgressMonitor.worked(1);
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }

    private IStatus checkForEmptyKeysAndValues(List<Map<String, Object>> list, IProgressMonitor iProgressMonitor, int n, int n2) {
        String[] stringArray = new String[this.resourceDataModel.getResourceFileCount()];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = (String)this.resourceDataModel.getResourceFileMapEntry(n3).getKey();
            ++n3;
        }
        Iterator iterator = this.resourceDataModel.getRowKeys();
        int n4 = 0;
        while (iterator.hasNext()) {
            HashMap hashMap;
            String string = (String)iterator.next();
            ResourceRow resourceRow = this.resourceDataModel.getRow(string);
            if (n != JIntoCore.SEVERITY_IGNORE) {
                if (string.equals("")) {
                    hashMap = new HashMap();
                    JIntoBundleMarker.setSeverity(hashMap, (int)n);
                    JIntoBundleMarker.addRow(hashMap, (String)string);
                    JIntoBundleMarker.setMessage(hashMap, (String)Messages.getString("editor.autoCheck.keyEmpty", new Object[0]));
                    list.add(hashMap);
                }
                iProgressMonitor.worked(1);
            }
            if (n2 != JIntoCore.SEVERITY_IGNORE) {
                int n5 = 0;
                while (n5 < stringArray.length) {
                    if (resourceRow.getColumnValue(stringArray[n5]).equals("")) {
                        hashMap = new HashMap();
                        JIntoBundleMarker.setSeverity(hashMap, (int)n2);
                        JIntoBundleMarker.addRow(hashMap, (String)string);
                        MessageFormat messageFormat = new MessageFormat(Messages.getString("editor.autoCheck.columnEmpty", new Object[0]));
                        JIntoBundleMarker.setMessage(hashMap, (String)messageFormat.format(new String[]{stringArray[n5], string}));
                        list.add(hashMap);
                    }
                    ++n5;
                }
                iProgressMonitor.worked(1);
            }
            if (n4 % 100 == 0 && iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ++n4;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkForEqualCellContent(List<Map<String, Object>> list, IProgressMonitor iProgressMonitor, int n) {
        if (this.resourceDataModel.getResourceFileCount() > 1) {
            String string;
            String[] stringArray = new String[this.resourceDataModel.getResourceFileCount()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = (String)this.resourceDataModel.getResourceFileMapEntry(n2).getKey();
                ++n2;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object = this.resourceDataModel.getRowKeys();
            while (object.hasNext()) {
                string = (String)object.next();
                hashMap.put(string, this.resourceDataModel.getRow(string).getColumnValue(stringArray[0]));
            }
            LinkedList<String> linkedList = null;
            while (!hashMap.isEmpty()) {
                Iterator iterator = hashMap.keySet().iterator();
                string = (String)iterator.next();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (!((String)hashMap.get(string)).equals(hashMap.get(object))) continue;
                    if (linkedList == null) {
                        linkedList = new LinkedList<String>();
                        linkedList.add(string);
                    }
                    linkedList.add((String)object);
                }
                boolean bl = true;
                if (linkedList != null) {
                    bl = !this.addEqualCellContentStrikeForMarkingProblem(stringArray, linkedList, hashMap, list, iProgressMonitor, n);
                    linkedList = null;
                }
                if (bl) {
                    hashMap.remove(string);
                    iProgressMonitor.worked(1);
                }
                if (!iProgressMonitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    private boolean addEqualCellContentStrikeForMarkingProblem(String[] stringArray, List<String> list, Map<String, String> map, List<Map<String, Object>> list2, IProgressMonitor iProgressMonitor, int n) {
        boolean bl = true;
        int n2 = 1;
        while (n2 < stringArray.length) {
            list.clear();
            list.addAll(this.getMatchingRows(list, stringArray[n2]));
            if (list.isEmpty()) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            HashMap hashMap = new HashMap();
            JIntoBundleMarker.setSeverity(hashMap, (int)n);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < list.size()) {
                String string = list.get(n3);
                map.remove(string);
                iProgressMonitor.worked(1);
                stringBuffer.append(string);
                if (n3 < list.size() - 1) {
                    stringBuffer.append(", ");
                }
                JIntoBundleMarker.addRow(hashMap, (String)string);
                ++n3;
            }
            MessageFormat messageFormat = new MessageFormat(Messages.getString("editor.autoCheck.equalCellContent", new Object[0]));
            JIntoBundleMarker.setMessage(hashMap, (String)messageFormat.format(new String[]{stringBuffer.toString()}));
            list2.add(hashMap);
        }
        return bl;
    }

    private List<String> getMatchingRows(List<String> list, String string) {
        HashMap<String, LinkedList<String>> hashMap = new HashMap<String, LinkedList<String>>();
        int n = 0;
        while (n < list.size()) {
            String string2 = list.get(n);
            String string3 = this.resourceDataModel.getRow(string2).getColumnValue(string);
            List<String> list2 = (List)((AbstractMap)hashMap).get(string3);
            if (list2 == null) {
                list2 = new LinkedList<String>();
                ((AbstractMap)hashMap).put(string3, list2);
            }
            list2.add(string2);
            ++n;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (List<String> list2 : ((AbstractMap)hashMap).values()) {
            if (list2.size() <= 1 || list2.size() <= linkedList.size()) continue;
            linkedList = list2;
        }
        return linkedList;
    }

    private void syncMarkers(List<Map<String, Object>> list) {
        IStorage iStorage = this.resourceDataModel.getSelectedStorage();
        IResource iResource = (IResource)iStorage.getAdapter(IResource.class);
        if (iResource != null) {
            int n;
            Object object;
            LinkedList<IMarker> linkedList = null;
            try {
                object = JIntoBundleMarker.findMarkersForModel((ResourceBundleModel)this.resourceDataModel);
                linkedList = new LinkedList<IMarker>();
                n = 0;
                while (n < ((IMarker[])object).length) {
                    linkedList.add(object[n]);
                    ++n;
                }
            }
            catch (CoreException coreException) {
                this.logError(coreException, "Could not search for markers.");
            }
            if (linkedList != null) {
                n = 0;
                while (n < list.size()) {
                    object = list.get(n);
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < linkedList.size()) {
                        IMarker iMarker = (IMarker)linkedList.get(n2);
                        if (JIntoBundleMarker.isEqual((IMarker)iMarker, (Map)object) && iMarker.getResource().equals((Object)iResource)) {
                            linkedList.remove(iMarker);
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        try {
                            JIntoBundleMarker.createMarker((IResource)iResource, (Map)object);
                        }
                        catch (CoreException coreException) {
                            this.logError(coreException, "Could not create marker on resource:" + iResource.getName());
                        }
                    }
                    ++n;
                }
                n = linkedList.size() - 1;
                while (n >= 0) {
                    try {
                        ((IMarker)linkedList.get(n)).delete();
                    }
                    catch (CoreException coreException) {
                        this.logError(coreException, "Could not delete marker.");
                    }
                    --n;
                }
            }
        }
    }

    private void logError(CoreException coreException, String string) {
        String string2 = JIntoUI.getID();
        Status status = new Status(4, string2, 4, string, (Throwable)coreException);
        JIntoUI.getDefault().getLog().log((IStatus)status);
    }
}

