/*
 * Decompiled with CFR 0.152.
 */
package de.guhsoft.jinto.ui.codeAssist;

import de.guhsoft.jinto.core.model.ResourceBundleModel;
import de.guhsoft.jinto.core.model.ResourceRow;
import de.guhsoft.jinto.ui.JIntoUI;
import de.guhsoft.jinto.ui.Messages;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;

public class JIntoCompletionProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private ResourceBundleModel fModel;
    private ICompilationUnit fCompilationUnit;
    private String fKey;
    private int fReplacementOffsetDiff;
    private int fReplacementLengthDiff;
    private IRegion fFilterRegion;
    private int fSelectionRange;

    public JIntoCompletionProposal(ResourceBundleModel resourceBundleModel, ICompilationUnit iCompilationUnit, String string, IRegion iRegion, IRegion iRegion2, int n) {
        this.fModel = resourceBundleModel;
        this.fCompilationUnit = iCompilationUnit;
        this.fReplacementOffsetDiff = iRegion.getOffset() - iRegion2.getOffset();
        this.fReplacementLengthDiff = iRegion.getOffset() + iRegion.getLength() - (iRegion2.getOffset() + iRegion2.getLength()) - this.fReplacementOffsetDiff;
        this.fFilterRegion = iRegion2;
        this.fSelectionRange = n;
        this.setKey(string);
    }

    public int getRelevance() {
        return 0;
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    protected ResourceBundleModel getModel() {
        return this.fModel;
    }

    public void setKey(String string) {
        this.fKey = string;
    }

    public String getKey() {
        return this.fKey;
    }

    protected String getReplacementString() {
        return "\"" + this.getKey() + "\"";
    }

    protected IRegion getReplacementRegion() {
        int n = this.fFilterRegion.getOffset() + this.fReplacementOffsetDiff;
        int n2 = this.fFilterRegion.getLength() + this.fReplacementLengthDiff;
        return new Region(n, n2);
    }

    public void apply(IDocument iDocument) {
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        try {
            TextEdit textEdit;
            IJavaProject iJavaProject;
            IRegion iRegion = this.getReplacementRegion();
            IDocument iDocument = iTextViewer.getDocument();
            String string = this.getReplacementString();
            if (!string.equals(iDocument.get(iRegion.getOffset(), iRegion.getLength()))) {
                iDocument.replace(iRegion.getOffset(), iRegion.getLength(), string);
            }
            if (!"ignore".equals((iJavaProject = this.fCompilationUnit.getJavaProject()).getOption("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", true)) && (textEdit = NLSUtil.createNLSEdit((ICompilationUnit)this.fCompilationUnit, (int)iRegion.getOffset())) != null) {
                textEdit.apply(iDocument);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
    }

    public String getAdditionalProposalInfo() {
        ResourceRow resourceRow = this.getModel().getRow(this.getKey());
        String string = resourceRow.getColumnValue(Locale.getDefault());
        if (string == null) {
            string = Messages.getString("codeAssist.noPropertiesFileForDefaultLocale", new Object[0]);
        }
        return this.toHtml(this.getModel().getFullyQualifiedName(false), string);
    }

    private String toHtml(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addSmallHeader((StringBuffer)stringBuffer, (String)string);
        HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (String)HTMLPrinter.convertToHTMLContent((String)string2));
        HTMLPrinter.insertPageProlog((StringBuffer)stringBuffer, (int)0);
        HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.getKey();
    }

    public Image getImage() {
        return JIntoUI.getImage("key");
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.getReplacementRegion().getOffset() + this.getReplacementString().length(), 0);
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new InformationControlCreator();
    }

    public int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.getReplacementRegion().getOffset();
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        return this.getReplacementString();
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        try {
            int n2 = this.fFilterRegion.getOffset();
            if (n >= n2 && this.getKey() != null) {
                String string = iDocument.get(n2, n - n2);
                this.fFilterRegion = new Region(n2, n - n2);
                if (this.fSelectionRange > 0) {
                    this.fReplacementLengthDiff -= this.fSelectionRange;
                    this.fSelectionRange = 0;
                }
                return this.getKey().toLowerCase().startsWith(string.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private static final class InformationControlCreator
    extends AbstractReusableInformationControlCreator {
        public IInformationControl doCreateInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
        }
    }
}

