/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.ui.DropdownMenuProvider;
import it.unibz.instasearch.ui.InstaSearchUI;
import it.unibz.instasearch.ui.SearchContentProposalProvider;
import it.unibz.instasearch.ui.StyledTextContentAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class SearchViewControl
implements DisposeListener {
    private static final String PROPOSAL_KEYSTROKE = "Ctrl+Space";
    private static final String SEARCH_TEXT_TIP = "search text " + (Object)((Object)Field.PROJ) + ":MyProject " + (Object)((Object)Field.EXT) + ":xml,java";
    private TreeViewer resultViewer;
    private StyledText searchText;
    private ImageRegistry imageRegistry = new ImageRegistry();
    private ToolBar filterBar;
    private SearchContentProposalProvider proposalProvider;
    private Composite parent;
    private int itemInsertIndex = 0;
    private ModifyListener modifyListener;
    private Color searchTipColor = this.getDisplay().getSystemColor(16);
    private Color defaultSearchColor = this.getDisplay().getSystemColor(2);

    public SearchViewControl(Composite parent, ModifyListener modifyListener) {
        this.parent = parent;
        this.modifyListener = modifyListener;
        this.createControl(parent);
        parent.addDisposeListener((DisposeListener)this);
    }

    public StyledText getSearchText() {
        return this.searchText;
    }

    public TreeViewer getResultViewer() {
        return this.resultViewer;
    }

    private void createControl(Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginLeft = 0;
        parentLayout.horizontalSpacing = 0;
        parentLayout.verticalSpacing = 0;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 2;
        parent.setLayout((Layout)parentLayout);
        Composite textComposite = new Composite(parent, 0);
        GridData textCompositeGridData = new GridData(4, 1, true, false);
        textComposite.setLayoutData((Object)textCompositeGridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textComposite.setLayout((Layout)layout);
        this.createSearchTextControl(textComposite);
        this.createFilterBar(textComposite);
        Composite viewComposite = new Composite(parent, 0);
        viewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 0;
        viewComposite.setLayout((Layout)fillLayout);
        this.resultViewer = new TreeViewer(viewComposite, 65536);
    }

    private void createFilterBar(Composite parent) {
        this.filterBar = new ToolBar(parent, 0x820000);
        GridData gridData = new GridData(3, 2, false, false);
        this.filterBar.setLayoutData((Object)gridData);
        ToolItem clearItem = new ToolItem(this.filterBar, 0);
        clearItem.setImage(this.getPluginImage("close"));
        clearItem.setToolTipText("Clear search text");
        clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchViewControl.this.searchText.setText("");
                SearchViewControl.this.searchText.setFocus();
            }
        });
        new ToolItem(this.filterBar, 2);
        this.itemInsertIndex = this.filterBar.getItemCount();
        ToolItem filterItem = new ToolItem(this.filterBar, 4);
        filterItem.setToolTipText("Filter by...");
        filterItem.setImage(this.getPluginImage("filter"));
        DropdownMenuProvider<FieldFilterAction> dropdown = new DropdownMenuProvider<FieldFilterAction>(filterItem);
        dropdown.add(new ProjFilterAction(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT")));
        dropdown.add(new ExtensionFilterAction(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE")));
        dropdown.add(new FieldFilterAction(Field.WS, InstaSearchPlugin.getImageDescriptor("workingsets")));
        dropdown.add(new FieldFilterAction(Field.MODIFIED, InstaSearchPlugin.getImageDescriptor("dates")));
        this.filterBar.update();
    }

    private void updateSearch() {
        this.modifyListener.modifyText(null);
    }

    private void createSearchTextControl(Composite textComposite) {
        this.searchText = new StyledText(textComposite, 2436);
        textComposite.setTabList(new Control[]{this.searchText});
        GridData searchTextGridData = new GridData(4, 2, true, false);
        this.searchText.setLayoutData((Object)searchTextGridData);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (SearchViewControl.this.searchText.isDisposed()) {
                    return;
                }
                if (SearchViewControl.this.isShowingSearchTip()) {
                    SearchViewControl.this.searchText.setForeground(SearchViewControl.this.defaultSearchColor);
                    if (SEARCH_TEXT_TIP.equals(SearchViewControl.this.searchText.getText())) {
                        SearchViewControl.this.searchText.setText("");
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                if (SearchViewControl.this.searchText.getText().length() == 0) {
                    SearchViewControl.this.searchText.setForeground(SearchViewControl.this.searchTipColor);
                    SearchViewControl.this.searchText.setText(SEARCH_TEXT_TIP);
                }
            }
        };
        this.searchText.addFocusListener(focusListener);
        this.searchText.setToolTipText(String.valueOf(SEARCH_TEXT_TIP) + "\n(" + PROPOSAL_KEYSTROKE + " for autocompletion)");
    }

    public boolean isShowingSearchTip() {
        return this.searchText.getForeground().equals((Object)this.searchTipColor);
    }

    private Display getDisplay() {
        return Display.getCurrent();
    }

    public void setContentProposalAdapter(SearchContentProposalProvider provider) {
        this.proposalProvider = provider;
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)PROPOSAL_KEYSTROKE);
        }
        catch (Exception e) {
            InstaSearchPlugin.log(e);
        }
        char[] autoActivationCharacters = new char[]{':', ','};
        SearchContentProposalAdapter adapter = new SearchContentProposalAdapter((Control)this.searchText, (IControlContentAdapter)new StyledTextContentAdapter(), (IContentProposalProvider)provider, keyStroke, autoActivationCharacters);
        adapter.setPopupSize(new Point(300, 150));
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
    }

    private Image getPluginImage(String name) {
        Image img = this.imageRegistry.get(name);
        if (img == null) {
            this.imageRegistry.put(name, InstaSearchPlugin.getImageDescriptor(name));
            img = this.imageRegistry.get(name);
        }
        return img;
    }

    private ImageDescriptor getExtImageDescriptor(String ext) {
        String key = (Object)((Object)Field.EXT) + ":" + ext;
        ImageDescriptor fileImage = this.imageRegistry.getDescriptor(key);
        if (fileImage == null) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            fileImage = registry.getImageDescriptor("*." + ext);
            this.imageRegistry.put(key, fileImage);
        }
        return fileImage;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.imageRegistry.dispose();
    }

    public Map<Field, Set<String>> getFilter() {
        HashMap<Field, Set<String>> filters = new HashMap<Field, Set<String>>();
        ToolItem[] toolItemArray = this.filterBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            Object data = item.getData();
            if (data != null && data instanceof Field) {
                Field field = (Field)((Object)data);
                String value = item.getText();
                if (!"".equals(value)) {
                    Set<String> values = filters.get((Object)field);
                    if (values == null) {
                        values = new TreeSet<String>();
                        filters.put(field, values);
                    }
                    values.add(value);
                }
            }
            ++n2;
        }
        return filters;
    }

    public void setFilter(Map<Field, Set<String>> filter) {
        this.clearFilter();
    }

    private void clearFilter() {
        ToolItem[] toolItemArray = this.filterBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            Object data = item.getData();
            if (data != null && data instanceof Field) {
                item.dispose();
            }
            ++n2;
        }
    }

    private class ExtensionFilterAction
    extends FieldFilterAction {
        public ExtensionFilterAction(ImageDescriptor img) {
            super(Field.EXT, img);
        }

        @Override
        protected Image getImage(String proposal) {
            SearchViewControl.this.getExtImageDescriptor(proposal);
            return SearchViewControl.this.imageRegistry.get((Object)((Object)Field.EXT) + ":" + proposal);
        }

        @Override
        protected FilterChangeAction addAction(DropdownMenuProvider<FilterChangeAction> dropdown, String proposal) {
            IResource res;
            IEditorInput adaptable;
            IEditorPart editor;
            FilterChangeAction action = super.addAction(dropdown, proposal);
            ImageDescriptor imgDesc = SearchViewControl.this.getExtImageDescriptor(proposal);
            if (imgDesc != null) {
                action.setImageDescriptor(imgDesc);
            }
            if ((editor = InstaSearchUI.getActiveEditor()) != null && (adaptable = editor.getEditorInput()) != null && (res = (IResource)adaptable.getAdapter(IResource.class)) != null && proposal.equals(res.getFileExtension())) {
                action.run();
            }
            return action;
        }
    }

    private class FieldFilterAction
    extends FilterChangeAction {
        private Field field;

        public FieldFilterAction(Field field, ImageDescriptor img) {
            super(field.getTitle(), img);
            this.field = field;
        }

        protected Image getImage(String proposal) {
            String key = (Object)((Object)this.field) + ":" + proposal;
            Image img = SearchViewControl.this.imageRegistry.get(key);
            if (img == null) {
                img = SearchViewControl.this.imageRegistry.get((Object)((Object)this.field) + ":");
            }
            if (img == null) {
                SearchViewControl.this.imageRegistry.put(key, this.getImageDescriptor());
                img = SearchViewControl.this.imageRegistry.get(key);
            }
            return img;
        }

        @Override
        public void runAction() {
            ToolItem fieldItem = new ToolItem(SearchViewControl.this.filterBar, 4, SearchViewControl.this.itemInsertIndex);
            fieldItem.setToolTipText("Filter by " + this.field.getTitle());
            fieldItem.setImage(this.getImage(""));
            fieldItem.setData((Object)this.field);
            DropdownMenuProvider<FilterChangeAction> dropdown = new DropdownMenuProvider<FilterChangeAction>(fieldItem);
            this.addRemoveAction(fieldItem, dropdown);
            dropdown.addSeparator();
            List<String> proposals = SearchViewControl.this.proposalProvider.getFieldProposals(this.field, "");
            FilterChangeAction firstAction = null;
            for (String proposal : proposals) {
                FilterChangeAction action = this.addAction(dropdown, proposal);
                if (firstAction != null) continue;
                firstAction = action;
            }
            if ("".equals(fieldItem.getText()) && firstAction != null) {
                firstAction.run();
            }
            SearchViewControl.this.parent.layout(true, true);
        }

        private void addRemoveAction(final ToolItem fieldItem, DropdownMenuProvider<FilterChangeAction> dropdown) {
            FilterChangeAction removeAction = new FilterChangeAction(SearchViewControl.this, "Remove"){

                @Override
                public void runAction() {
                    fieldItem.dispose();
                    SearchViewControl.this.parent.layout(true, true);
                }
            };
            removeAction.setImageDescriptor(InstaSearchPlugin.getImageDescriptor("close"));
            dropdown.add(removeAction);
        }

        protected FilterChangeAction addAction(final DropdownMenuProvider<FilterChangeAction> dropdown, final String proposal) {
            FilterChangeAction action = new FilterChangeAction(SearchViewControl.this, proposal, this.getImageDescriptor()){

                @Override
                public void runAction() {
                    dropdown.getToolItem().setText(this.getText());
                    dropdown.getToolItem().setImage(FieldFilterAction.this.getImage(proposal));
                    SearchViewControl.this.parent.layout(true, true);
                }
            };
            dropdown.add(action);
            return action;
        }
    }

    private abstract class FilterChangeAction
    extends Action {
        public FilterChangeAction(String proposal, ImageDescriptor imageDescriptor) {
            super(proposal, imageDescriptor);
        }

        public FilterChangeAction(String string) {
            super(string);
        }

        public final void run() {
            this.runAction();
            SearchViewControl.this.updateSearch();
        }

        protected abstract void runAction();
    }

    private class ProjFilterAction
    extends FieldFilterAction {
        public ProjFilterAction(ImageDescriptor img) {
            super(Field.PROJ, img);
        }

        @Override
        protected FilterChangeAction addAction(DropdownMenuProvider<FilterChangeAction> dropdown, String proposal) {
            FilterChangeAction action = super.addAction(dropdown, proposal);
            if (proposal.equals(InstaSearchUI.getActiveProject())) {
                action.run();
            }
            return action;
        }
    }

    private class SearchContentProposalAdapter
    extends ContentProposalAdapter {
        public SearchContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
            super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
        }

        protected void closeProposalPopup() {
            String content = this.getControlContentAdapter().getControlContents(this.getControl());
            int pos = this.getControlContentAdapter().getCursorPosition(this.getControl());
            if (content.length() == 0 || pos == 0) {
                super.closeProposalPopup();
                return;
            }
            String prefix = content.substring(0, pos);
            if (prefix.length() == 0 || prefix.endsWith(" ")) {
                super.closeProposalPopup();
                return;
            }
        }

        public int getProposalAcceptanceStyle() {
            return 1;
        }
    }
}

