/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.indexing.SearchQuery;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.ui.InstaSearchUI;
import it.unibz.instasearch.ui.InstaSearchView;
import it.unibz.instasearch.ui.ResultContentProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class SearchJob
extends Job {
    private TreeViewer resultViewer = null;
    private SearchQuery searchQuery = null;
    private boolean selectLast = false;
    private InstaSearchView searchView;
    private IStatusLineManager statusLineManager;

    public SearchJob(InstaSearchView searchView) {
        super("Search");
        this.searchView = searchView;
        this.resultViewer = searchView.getResultViewer();
        this.statusLineManager = searchView.getViewSite().getActionBars().getStatusLineManager();
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.CANCEL_STATUS) {
                    SearchJob.this.cancelSearch();
                }
            }
        });
        this.setPriority(10);
    }

    public void schedule(SearchQuery searchQuery, boolean selectLast, long delay) {
        this.cancelSearch();
        this.searchQuery = searchQuery;
        this.selectLast = selectLast;
        if (this.searchQuery != null) {
            this.searchQuery.setCanceled(false);
            this.searchQuery.setCurrentProject(InstaSearchUI.getActiveProject());
            this.schedule(delay);
        }
    }

    private void cancelSearch() {
        if (this.searchQuery != null) {
            this.searchQuery.setCanceled(true);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        ResultContentProvider prov = (ResultContentProvider)this.resultViewer.getContentProvider();
        if (prov == null || monitor.isCanceled() || this.searchQuery == null || this.searchQuery.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        prov.getElements(this.searchQuery);
        if (monitor.isCanceled() || this.searchQuery.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Display display = this.resultViewer.getControl().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                SearchJob.this.search();
            }
        });
        return Status.OK_STATUS;
    }

    private void search() {
        int items = this.resultViewer.getTree().getItemCount();
        this.resultViewer.setInput((Object)this.searchQuery);
        int newItems = this.resultViewer.getTree().getItemCount();
        if (this.selectLast && items != 0 && newItems >= items) {
            this.resultViewer.getTree().setSelection(this.resultViewer.getTree().getItem(items - 1));
        }
        int resultCount = this.countSearchResults(newItems);
        String resultsDesc = " " + (this.searchQuery.isExact() ? "exact" : "similar") + " results";
        if (this.searchQuery.isLimited()) {
            if (resultCount >= this.searchQuery.getMaxResults()) {
                this.statusLineManager.setMessage(this.searchView.getTitleImage(), String.valueOf(this.searchQuery.getMaxResults()) + "+" + resultsDesc + " (Ctrl+Enter to see all)");
            } else {
                this.statusLineManager.setMessage(this.searchView.getTitleImage(), String.valueOf(resultCount) + resultsDesc);
            }
        } else {
            this.statusLineManager.setMessage(this.searchView.getTitleImage(), String.valueOf(resultCount) + resultsDesc);
        }
    }

    private int countSearchResults(int newItems) {
        int allItems = this.resultViewer.getTree().getItemCount();
        int i = allItems - 1;
        while (i >= 0) {
            TreeItem treeItem = this.resultViewer.getTree().getItem(i);
            if (treeItem != null && treeItem.getData() != null && treeItem.getData() instanceof SearchResultDoc) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }
}

