/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.SearchQuery;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.ui.InstaSearchUI;
import it.unibz.instasearch.ui.ResultContentProvider;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class ResultLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IPropertyChangeListener {
    private static final String HIGHLIGHT_COLOR_NAME = "it.unibz.instasearch.ui.HighlightColor";
    private static final String IMG_OBJ_TEXT_SEARCH_LINE = "org.eclipse.search.ui.line_match";
    private static final String MORE_RESULTS_LABEL = "More...";
    private static final String FIND_SIMILAR_LABEL = "Find similar...";
    private static final String DOWN_ARROW_IMG_KEY = "down_arrow";
    private ImageRegistry imageRegistry = new ImageRegistry();
    private StyledString.Styler highlightStyle;
    private WorkbenchLabelProvider labelProvider;
    private ResultContentProvider contentProvider;
    private Image matchImage;
    private boolean showMatchCount;
    private boolean showFullPath;

    public ResultLabelProvider(ResultContentProvider contentProvider) {
        JFaceResources.getColorRegistry().put(HIGHLIGHT_COLOR_NAME, new RGB(206, 204, 247));
        this.labelProvider = new WorkbenchLabelProvider();
        this.highlightStyle = StyledString.createColorRegistryStyler(null, (String)HIGHLIGHT_COLOR_NAME);
        this.contentProvider = contentProvider;
        this.matchImage = InstaSearchUI.getSharedImage(IMG_OBJ_TEXT_SEARCH_LINE);
        this.imageRegistry.put(DOWN_ARROW_IMG_KEY, InstaSearchPlugin.getImageDescriptor(DOWN_ARROW_IMG_KEY));
        this.showMatchCount = InstaSearchPlugin.getBoolPref("showMatchCounts");
        this.showFullPath = InstaSearchPlugin.getBoolPref("showFullPath");
        InstaSearchPlugin.addPreferenceChangeListener(this);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof SearchResultDoc) {
            SearchResultDoc doc = (SearchResultDoc)element;
            return this.decorateFile(doc);
        }
        if (element instanceof ResultContentProvider.MatchLine) {
            ResultContentProvider.MatchLine lineMatches = (ResultContentProvider.MatchLine)element;
            return this.decorateLineMatches(lineMatches);
        }
        if (element instanceof SearchQuery) {
            SearchQuery query = (SearchQuery)element;
            if (!query.isLimited()) {
                return new StyledString(MORE_RESULTS_LABEL);
            }
            return new StyledString(FIND_SIMILAR_LABEL);
        }
        return new StyledString(element.toString());
    }

    private StyledString decorateFile(SearchResultDoc doc) {
        String filePath;
        String fileName = doc.getFileName();
        StyledString str = new StyledString(fileName);
        Collection<String> searchTerms = this.contentProvider.getSearchTerms();
        for (String searchTerm : searchTerms) {
            int termPos = fileName.toLowerCase(Locale.ENGLISH).indexOf(searchTerm);
            if (termPos == -1) continue;
            str.setStyle(termPos, searchTerm.length(), this.highlightStyle);
        }
        int matchCount = doc.getMatchCount();
        if (matchCount > 1 && this.showMatchCount) {
            str.append(" (", StyledString.COUNTER_STYLER);
            str.append(Integer.toString(matchCount), StyledString.COUNTER_STYLER);
            str.append(" matches)", StyledString.COUNTER_STYLER);
        }
        str.append(" - ", StyledString.QUALIFIER_STYLER);
        str.append(doc.getProjectName(), StyledString.QUALIFIER_STYLER);
        if (this.showFullPath && !"".equals(filePath = this.getCompactFilePath(doc, fileName))) {
            str.append(" - ", StyledString.QUALIFIER_STYLER);
            str.append(filePath, StyledString.QUALIFIER_STYLER);
        }
        if (InstaSearchPlugin.isDebug()) {
            str.append(" - [", StyledString.DECORATIONS_STYLER);
            str.append(String.format("%.03f", Float.valueOf(doc.getScore())), StyledString.DECORATIONS_STYLER);
            str.append("]", StyledString.DECORATIONS_STYLER);
        }
        return str;
    }

    private String getCompactFilePath(SearchResultDoc doc, String fileName) {
        String projectName = doc.getProjectName();
        String filePath = doc.getFilePath();
        int end = filePath.length() - 1;
        int start = filePath.indexOf(projectName);
        start = start == -1 ? 0 : start + projectName.length() + 1;
        if (filePath.endsWith(fileName)) {
            end = filePath.length() - fileName.length() - 1;
        }
        if (start > end) {
            return "";
        }
        filePath = filePath.substring(start, end);
        return filePath;
    }

    private StyledString decorateLineMatches(ResultContentProvider.MatchLine lineMatches) {
        String line = lineMatches.getLine();
        StyledString str = new StyledString(line);
        for (Match m : lineMatches.getMatches()) {
            str.setStyle(m.getOffset(), m.getLength(), this.highlightStyle);
        }
        StyledString ret = new StyledString();
        ret.append(String.valueOf(lineMatches.getLineNumber()) + ": ", StyledString.QUALIFIER_STYLER);
        ret.append(str);
        return ret;
    }

    public Image getImage(Object element) {
        try {
            if (element instanceof SearchResultDoc) {
                SearchResultDoc doc = (SearchResultDoc)element;
                Image image = null;
                if (!doc.isInJar()) {
                    image = this.labelProvider.getImage((Object)doc.getFile());
                }
                if (image == null) {
                    image = this.getFileImage(doc);
                }
                if (image == null) {
                    image = InstaSearchUI.getSharedImage("IMG_OBJ_FILE");
                }
                return image;
            }
            if (element instanceof ResultContentProvider.MatchLine) {
                return this.matchImage;
            }
            if (element instanceof Exception) {
                return InstaSearchUI.getSharedImage("IMG_OBJS_WARN_TSK");
            }
            if (element instanceof SearchQuery) {
                return this.imageRegistry.get(DOWN_ARROW_IMG_KEY);
            }
        }
        catch (Exception e) {
            InstaSearchPlugin.log(e);
            return InstaSearchUI.getSharedImage("IMG_OBJS_WARN_TSK");
        }
        return InstaSearchUI.getSharedImage("IMG_OBJS_INFO_TSK");
    }

    private Image getFileImage(SearchResultDoc doc) {
        String ext = doc.getFileExtension();
        Image fileImage = this.imageRegistry.get(ext);
        if (fileImage == null) {
            ImageDescriptor imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(doc.getFileName());
            fileImage = imageDescriptor.createImage(true);
            this.imageRegistry.put(ext, fileImage);
        }
        return fileImage;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("showMatchCounts".equals(event.getProperty())) {
            this.showMatchCount = InstaSearchPlugin.getBoolPref("showMatchCounts");
        } else if ("showFullPath".equals(event.getProperty())) {
            this.showFullPath = InstaSearchPlugin.getBoolPref("showFullPath");
        }
    }

    public void dispose() {
        super.dispose();
        this.imageRegistry.dispose();
        InstaSearchPlugin.removePreferenceChangeListener(this);
    }
}

