/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearch;
import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.SearchQuery;
import it.unibz.instasearch.indexing.SearchResult;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.indexing.Searcher;
import it.unibz.instasearch.indexing.StorageIndexer;
import it.unibz.instasearch.indexing.WorkspaceIndexer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;

class ResultContentProvider
implements ITreeContentProvider {
    private static final String[] NO_INDEX_MESSAGE = new String[]{"Index is not built"};
    private static final String[] NO_FILE_MESSAGE = new String[]{"File missing"};
    private static final String NO_RESULTS_MESSAGE = "0 matches";
    public static final double MAX_LINE_SIMILARITY = 0.9;
    public static final int MAX_LINES_TO_PROCESS = 5000;
    private WorkspaceIndexer indexer;
    private Searcher searcher;
    private SearchQuery currentSearchQuery;
    private Map<String, Float> searchTerms;
    private Object[] cachedResults;
    private SearchResultDoc cachedResultDoc;
    private Object[] cachedChildren;
    private int resultCount;

    public ResultContentProvider() {
        InstaSearch instaSearch = InstaSearchPlugin.getInstaSearch();
        this.indexer = instaSearch.getIndexer();
        this.searcher = instaSearch.getSearcher();
    }

    public void inputChanged(Viewer v, Object oldInput, Object newSearch) {
        if (newSearch == null || !(newSearch instanceof SearchQuery)) {
            this.currentSearchQuery = null;
            this.cachedResults = null;
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object searchQueryObj) {
        if (searchQueryObj == null || !(searchQueryObj instanceof SearchQuery)) {
            return Collections.EMPTY_LIST.toArray();
        }
        SearchQuery searchQuery = (SearchQuery)searchQueryObj;
        String searchString = searchQuery.getSearchString();
        if (searchString == null || searchString.toString().length() < 2) {
            return Collections.EMPTY_LIST.toArray();
        }
        try {
            if (!this.indexer.isIndexed()) {
                return NO_INDEX_MESSAGE;
            }
        }
        catch (Exception e) {
            InstaSearchPlugin.log(e);
            return new Exception[]{e};
        }
        if (searchQuery.equals(this.currentSearchQuery) && this.cachedResults != null) {
            return this.cachedResults;
        }
        SearchResult result = null;
        this.cachedResults = null;
        this.resultCount = 0;
        Object[] resultArray = null;
        if (searchString != null) {
            try {
                result = this.searcher.search(searchQuery);
                this.currentSearchQuery = searchQuery;
                if (result == null) {
                    if (!searchQuery.isFuzzy()) {
                        SearchQuery newQuery = new SearchQuery(searchQuery);
                        newQuery.setExact(false);
                        newQuery.setFuzzy(true);
                        resultArray = new Object[]{NO_RESULTS_MESSAGE, newQuery};
                    } else {
                        resultArray = new Object[]{NO_RESULTS_MESSAGE};
                    }
                    this.cachedResults = resultArray;
                    return resultArray;
                }
                this.searchTerms = result.getSearchTerms();
            }
            catch (Exception e) {
                InstaSearchPlugin.log(e);
                return new Exception[]{e};
            }
        }
        List<SearchResultDoc> resultDocs = result.getResultDocs();
        this.resultCount = resultDocs.size();
        boolean addMoreResults = false;
        boolean addFindSimilar = false;
        if (searchQuery.isLimited() && result.isFull()) {
            addMoreResults = true;
        } else if (searchQuery.isExact() && !searchQuery.isFuzzy()) {
            addFindSimilar = true;
        }
        resultArray = addMoreResults || addFindSimilar ? new Object[this.resultCount + 1] : new Object[this.resultCount];
        resultDocs.toArray(resultArray);
        if (addMoreResults) {
            SearchQuery moreResultsQuery = new SearchQuery(this.currentSearchQuery);
            moreResultsQuery.setMaxResults(-1);
            resultArray[this.resultCount] = moreResultsQuery;
        } else if (addFindSimilar) {
            SearchQuery findSimilarQuery = new SearchQuery(this.currentSearchQuery);
            findSimilarQuery.setExact(false);
            resultArray[this.resultCount] = findSimilarQuery;
        }
        this.cachedResults = resultArray;
        return resultArray;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public Object[] getElements() {
        return this.cachedResults;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof SearchResultDoc) {
            SearchResultDoc doc = (SearchResultDoc)parent;
            if (this.cachedResultDoc != null && doc.equals(this.cachedResultDoc)) {
                return this.cachedChildren;
            }
            List<MatchLine> matches = null;
            Object[] children = null;
            try {
                matches = this.getMatchLines(doc, true, null);
                if (matches != null) {
                    children = matches.toArray();
                }
            }
            catch (Exception e) {
                InstaSearchPlugin.log(e);
            }
            if (matches == null) {
                children = NO_FILE_MESSAGE;
            }
            this.cachedResultDoc = doc;
            this.cachedChildren = children;
            return children;
        }
        if (parent instanceof Exception) {
            Exception e = (Exception)parent;
            return e.getStackTrace();
        }
        return Collections.EMPTY_LIST.toArray();
    }

    List<MatchLine> getMatchLines(SearchResultDoc doc, boolean limit, MatchFindCallback callback) throws Exception {
        String line;
        if (this.searchTerms == null || this.currentSearchQuery == null) {
            return Collections.emptyList();
        }
        int maxMatches = InstaSearchPlugin.getIntPref("shownLineCount");
        List<MatchLine> matchedLines = new ArrayList<MatchLine>();
        int matchCount = doc.getMatchCount();
        String searchString = this.currentSearchQuery.getSearchString().toLowerCase(Locale.ENGLISH);
        IStorage f = this.getStorage(doc);
        if (f == null) {
            return null;
        }
        InputStream fileInputStream = null;
        if (f instanceof IFile) {
            IFile file = (IFile)f;
            if (!file.exists()) {
                return null;
            }
            fileInputStream = file.getContents(true);
        } else {
            fileInputStream = f.getContents();
        }
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(fileInputStream));
        while ((line = lineReader.readLine()) != null) {
            Map<String, List<Integer>> lineTerms;
            if (callback != null && callback.isCanceled()) break;
            if ("".equals(line) || (lineTerms = StorageIndexer.extractTextTerms(line)).isEmpty()) continue;
            HashSet<String> matchedTerms = new HashSet<String>(this.searchTerms.keySet());
            matchedTerms.retainAll(lineTerms.keySet());
            if (matchedTerms.isEmpty() && matchCount != 0 && limit) continue;
            float[] lineTermScoreVector = doc.getTermScoreVector(lineTerms.keySet());
            float[] matchedTermScoreVector = doc.getTermScoreVector(matchedTerms);
            MatchLine matchLine = new MatchLine(doc, line, lineReader.getLineNumber(), matchedTerms, lineTermScoreVector, matchedTermScoreVector);
            matchedLines.add(matchLine);
            this.addMatches(matchLine, lineTerms, matchedTerms, searchString);
            if (callback != null) {
                callback.matchFound(matchLine);
            }
            if (lineReader.getLineNumber() > 5000) break;
        }
        lineReader.close();
        if (limit && matchedLines.size() > maxMatches) {
            matchedLines = this.getTopMatchLines(maxMatches, matchedLines);
            return matchedLines;
        }
        return matchedLines;
    }

    private List<MatchLine> getTopMatchLines(int maxMatchLines, List<MatchLine> matchedLines) {
        Collections.sort(matchedLines);
        this.removeSimilarLines(matchedLines, maxMatchLines);
        matchedLines = matchedLines.subList(0, maxMatchLines);
        Collections.sort(matchedLines, new Comparator<MatchLine>(){

            @Override
            public int compare(MatchLine l1, MatchLine l2) {
                return l1.getLineNumber() - l2.getLineNumber();
            }
        });
        return matchedLines;
    }

    private float addMatches(MatchLine matchLine, Map<String, List<Integer>> terms, Set<String> matchedTerms, String searchString) {
        String lcaseLine = matchLine.getLine().toLowerCase(Locale.ENGLISH);
        if (!matchedTerms.contains(searchString) && !this.currentSearchQuery.isFuzzy()) {
            int pos = lcaseLine.indexOf(searchString);
            while (pos != -1) {
                Match m = new Match((Object)searchString, pos, searchString.length());
                matchLine.add(m, true);
                pos = lcaseLine.indexOf(searchString, pos + searchString.length() - 1);
            }
        }
        float matchedTermBoost = 0.0f;
        for (String term : matchedTerms) {
            List<Integer> offsets = terms.get(term);
            for (int offset : offsets) {
                int pos = lcaseLine.indexOf(term, offset);
                if (pos == -1) continue;
                Match m = new Match((Object)term, pos, term.length());
                matchLine.add(m);
            }
            float boost = this.searchTerms.get(term).floatValue();
            matchedTermBoost += boost;
        }
        matchLine.setMatchedTermBoost(matchedTermBoost);
        return matchedTermBoost;
    }

    private void removeSimilarLines(List<MatchLine> matchedLines, int maxMatches) {
        MatchLine curMatchLine = null;
        int lineNr = 0;
        Iterator<MatchLine> iterator = matchedLines.iterator();
        while (iterator.hasNext() && matchedLines.size() > maxMatches) {
            MatchLine matchLine = iterator.next();
            if (curMatchLine == null) {
                curMatchLine = matchLine;
                ++lineNr;
                continue;
            }
            double similarity = this.getLineSimilarity(curMatchLine, matchLine);
            if (similarity > 0.9) {
                iterator.remove();
            } else {
                curMatchLine = matchLine;
                ++lineNr;
            }
            if (lineNr == maxMatches) break;
        }
    }

    private double getLineSimilarity(MatchLine lineMatches1, MatchLine lineMatches2) {
        float[] vect1 = lineMatches1.getScoreVector();
        float[] vect2 = lineMatches2.getScoreVector();
        double dotProduct = 0.0;
        double magnitude1 = 0.0;
        double magnitude2 = 0.0;
        int i = 0;
        while (i < vect1.length) {
            double val1 = vect1[i];
            double val2 = vect2[i];
            magnitude1 += val1 * val1;
            magnitude2 += val2 * val2;
            dotProduct += val1 * val2;
            ++i;
        }
        magnitude1 = Math.sqrt(magnitude1);
        magnitude2 = Math.sqrt(magnitude2);
        return magnitude1 == 0.0 || magnitude2 == 0.0 ? 0.0 : dotProduct / (magnitude1 * magnitude2);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof SearchResultDoc || element instanceof SearchQuery;
    }

    public Collection<String> getSearchTerms() {
        return this.searchTerms.keySet();
    }

    public IEditorInput getEditorInput(SearchResultDoc doc) throws Exception {
        return this.indexer.getEditorInput(doc);
    }

    public IStorage getStorage(SearchResultDoc doc) throws Exception {
        return this.indexer.getStorage(doc);
    }

    public List<String> getProposals(String prefix, Field field) throws IOException {
        List<String> ucaseProposals = this.searcher.getProposals(prefix.toUpperCase(), field);
        if (prefix.toUpperCase().equals(prefix.toLowerCase(Locale.ENGLISH))) {
            return ucaseProposals;
        }
        List<String> lcaseProposals = this.searcher.getProposals(prefix.toLowerCase(Locale.ENGLISH), field);
        ucaseProposals.addAll(lcaseProposals);
        Collections.sort(ucaseProposals, String.CASE_INSENSITIVE_ORDER);
        return ucaseProposals;
    }

    public static interface MatchFindCallback {
        public void matchFound(MatchLine var1);

        public boolean isCanceled();
    }

    class MatchLine
    implements Comparable<MatchLine> {
        private String lineText;
        private List<Match> matches = new LinkedList<Match>();
        private SearchResultDoc doc;
        private int lineNumber;
        private double termScore;
        private double matchedTermScore;
        private float[] scoreVector;
        private float matchedTermBoost;
        private int exactMatches;
        private int matchedTermCount;

        private MatchLine(SearchResultDoc doc, String lineText, int lineNumber, Set<String> matchedTerms, float[] termScoreVector, float[] matchedTermScoreVector) throws IOException {
            this.doc = doc;
            this.lineText = lineText;
            this.lineNumber = lineNumber;
            this.scoreVector = termScoreVector;
            this.termScore = this.getMagnitude(termScoreVector);
            this.matchedTermScore = this.getMagnitude(matchedTermScoreVector);
            this.matchedTermCount = matchedTerms.size();
        }

        public void setMatchedTermBoost(float matchedTermBoost) {
            this.matchedTermBoost = matchedTermBoost;
        }

        public float getMatchedTermBoost() {
            return this.matchedTermBoost;
        }

        public void add(Match m) {
            this.matches.add(m);
        }

        public void add(Match m, boolean isExactMatch) {
            this.matches.add(m);
            if (isExactMatch) {
                ++this.exactMatches;
            }
        }

        public List<Match> getMatches() {
            return this.matches;
        }

        public String getLine() {
            return this.lineText;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public double getTermScore() {
            return this.termScore;
        }

        public float[] getScoreVector() {
            return this.scoreVector;
        }

        public double getMatchedTermScore() {
            return this.matchedTermScore;
        }

        @Override
        public int compareTo(MatchLine lineMatches) {
            int diff = lineMatches.exactMatches - this.exactMatches;
            if (diff == 0) {
                diff = lineMatches.matchedTermCount - this.matchedTermCount;
            }
            if (diff == 0) {
                Double.compare(lineMatches.matchedTermBoost, this.matchedTermBoost);
            }
            if (diff == 0) {
                diff = Double.compare(lineMatches.termScore, this.termScore);
            }
            if (diff == 0) {
                return this.getLineNumber() - lineMatches.lineNumber;
            }
            return diff;
        }

        public SearchResultDoc getResultDoc() {
            return this.doc;
        }

        private double getMagnitude(float[] vect) {
            double magnitude = 0.0;
            float[] fArray = vect;
            int n = vect.length;
            int n2 = 0;
            while (n2 < n) {
                float value = fArray[n2];
                magnitude += (double)(value * value);
                ++n2;
            }
            magnitude = Math.sqrt(magnitude);
            return magnitude;
        }

        public String toString() {
            return "Line " + this.lineNumber + ": (" + this.matchedTermCount + ")" + this.lineText;
        }
    }
}

