/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.actions.CheckUpdatesActionDelegate;
import it.unibz.instasearch.actions.ShowExceptionAction;
import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.SearchQuery;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.jobs.CheckUpdatesJob;
import it.unibz.instasearch.ui.InstaSearchUI;
import it.unibz.instasearch.ui.MatchHighlightJob;
import it.unibz.instasearch.ui.ResultContentProvider;
import it.unibz.instasearch.ui.ResultLabelProvider;
import it.unibz.instasearch.ui.SearchContentProposalProvider;
import it.unibz.instasearch.ui.SearchJob;
import it.unibz.instasearch.ui.SearchViewControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class InstaSearchView
extends ViewPart
implements ModifyListener,
ILogListener,
ITreeViewerListener,
IPropertyChangeListener {
    public static final String ID = InstaSearchView.class.getName();
    private TreeViewer resultViewer;
    private StyledText searchText;
    private IAction openAction;
    private SearchJob searchJob;
    private ExpandCollapseJob expandCollapseJob;
    private ResultContentProvider contentProvider;
    private int lastIncrementalSearchPos = 0;
    private int maxResults;
    private int typingSearchDelay;
    private boolean incrementalSearchEnabled;
    private SearchViewControl searchViewControl;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.scheduleUpdateCheck();
        InstaSearchPlugin.getDefault().getLog().addLogListener((ILogListener)this);
        this.initPrefs();
        InstaSearchPlugin.addPreferenceChangeListener(this);
    }

    private void initPrefs() {
        this.typingSearchDelay = InstaSearchPlugin.getIntPref("typingSearchDelay");
        this.maxResults = InstaSearchPlugin.getIntPref("shownFilesCount");
        this.incrementalSearchEnabled = InstaSearchPlugin.getBoolPref("incrementalSearch");
    }

    public void createPartControl(Composite parent) {
        this.searchViewControl = new SearchViewControl(parent, this);
        this.searchText = this.searchViewControl.getSearchText();
        this.resultViewer = this.searchViewControl.getResultViewer();
        this.searchText.addModifyListener((ModifyListener)this);
        this.contentProvider = new ResultContentProvider();
        ResultLabelProvider labelProvider = new ResultLabelProvider(this.contentProvider);
        DecoratingStyledCellLabelProvider decoratedLabelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, null, null);
        this.configureResultViewer(this.contentProvider, (IBaseLabelProvider)decoratedLabelProvider);
        this.searchViewControl.setContentProposalAdapter(new SearchContentProposalProvider(this.contentProvider));
        this.searchJob = new SearchJob(this);
        this.expandCollapseJob = new ExpandCollapseJob();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    public void modifyText(ModifyEvent e) {
        this.searchJob.cancel();
        StyleRange[] styleRanges = InstaSearchView.createStyledSearchString(this.searchText.getText());
        this.searchText.setStyleRanges(styleRanges);
        if (this.searchViewControl.isShowingSearchTip()) {
            return;
        }
        this.searchJob.schedule(this.getSearchQuery(), false, this.typingSearchDelay);
        if (this.incrementalSearchEnabled) {
            this.doIncrementalSearch();
        }
    }

    private void doIncrementalSearch() {
        IFindReplaceTarget target;
        IEditorPart editor = InstaSearchUI.getActiveEditor();
        if (editor != null && (target = (IFindReplaceTarget)editor.getAdapter(IFindReplaceTarget.class)) != null) {
            this.lastIncrementalSearchPos = target.findAndSelect(this.lastIncrementalSearchPos, this.searchText.getText(), true, false, false) + this.searchText.getText().length();
        }
    }

    private static StyleRange[] createStyledSearchString(String text) {
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        String lcaseText = text.toLowerCase(Locale.ENGLISH);
        ArrayList<String> fieldsToHighlight = new ArrayList<String>(Field.values().length);
        Field[] fieldArray = Field.values();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            fieldsToHighlight.add(field.toString());
            ++n2;
        }
        for (String fieldName : fieldsToHighlight) {
            int pos = lcaseText.indexOf(String.valueOf(fieldName) + ':');
            while (pos != -1) {
                styleRanges.add(new StyleRange(pos, fieldName.length(), null, null, 1));
                pos = lcaseText.indexOf(String.valueOf(fieldName) + ':', pos + fieldName.length() - 1);
            }
        }
        Collections.sort(styleRanges, new Comparator<StyleRange>(){

            @Override
            public int compare(StyleRange sr1, StyleRange sr2) {
                return sr1.start - sr2.start;
            }
        });
        return styleRanges.toArray(new StyleRange[styleRanges.size()]);
    }

    void setSearchString(String searchString) {
        this.searchText.setText(searchString);
    }

    void search(SearchQuery searchQuery, boolean selectLast) {
        this.searchJob.cancel();
        searchQuery.setFilter(this.searchViewControl.getFilter());
        this.searchJob.schedule(searchQuery, selectLast, 0L);
    }

    private SearchQuery getSearchQuery() {
        SearchQuery sq = new SearchQuery(this.getSearchText(), this.maxResults);
        sq.setFilter(this.searchViewControl.getFilter());
        return sq;
    }

    String getSearchText() {
        return this.searchText.getText().trim();
    }

    TreeViewer getResultViewer() {
        return this.resultViewer;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        if (event.getElement() instanceof SearchQuery) {
            this.search((SearchQuery)event.getElement(), true);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private void configureResultViewer(ResultContentProvider contentProvider, IBaseLabelProvider decoratedLabelProvider) {
        this.resultViewer.setContentProvider((IContentProvider)contentProvider);
        this.resultViewer.setLabelProvider(decoratedLabelProvider);
        this.resultViewer.setSorter(null);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.resultViewer);
        this.resultViewer.addTreeListener((ITreeViewerListener)this);
        this.resultViewer.getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                ViewerCell cell = InstaSearchView.this.resultViewer.getCell(new Point(e.x, e.y));
                if (cell != null && cell.getElement() instanceof SearchResultDoc) {
                    SearchResultDoc doc = (SearchResultDoc)cell.getElement();
                    InstaSearchView.this.resultViewer.getTree().setToolTipText(doc.getFilePath());
                } else {
                    InstaSearchView.this.resultViewer.getTree().setToolTipText("");
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                InstaSearchView.this.onSearchTextKeyPress(e);
            }
        };
        this.resultViewer.getControl().addKeyListener((KeyListener)keyListener);
        this.searchText.addKeyListener((KeyListener)keyListener);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                InstaSearchView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.resultViewer.getControl());
        this.resultViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.resultViewer);
    }

    private void onSearchTextKeyPress(KeyEvent e) {
        if (e.keyCode == 0x100000E) {
            this.refreshSearch();
        }
        if (e.keyCode == 127) {
            this.deleteSelectedMatch();
        }
        if (e.keyCode == 106 && (e.stateMask & 0x40000) != 0) {
            this.doIncrementalSearch();
        } else if (e.keyCode == 9) {
            this.resultViewer.getTree().setFocus();
        } else if (e.keyCode == 27) {
            if (this.expandCollapseJob.getState() == 4) {
                this.expandCollapseJob.cancel();
            } else if (this.searchText.getSelectionText().equals(this.searchText.getText())) {
                this.searchText.setText("");
            } else {
                this.searchText.setFocus();
                this.searchText.selectAll();
            }
        } else if (e.getSource() == this.searchText && e.keyCode == 13 && (e.stateMask & 0x40000) != 0) {
            this.showAllResults();
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        boolean haveSelection = !this.resultViewer.getSelection().isEmpty();
        SearchQuery sq = (SearchQuery)this.resultViewer.getInput();
        this.openAction.setEnabled(haveSelection);
        manager.add(this.openAction);
        boolean showingItems = this.resultViewer.getTree().getItemCount() > 0;
        Action expandAll = new Action("Expand All", InstaSearchPlugin.getImageDescriptor("expandall")){

            public void run() {
                InstaSearchView.this.expandAll();
            }
        };
        expandAll.setEnabled(showingItems);
        manager.add((IAction)expandAll);
        Action collapseAll = new Action("Collapse All", InstaSearchPlugin.getImageDescriptor("collapseall")){

            public void run() {
                InstaSearchView.this.collapseAll();
            }
        };
        collapseAll.setEnabled(showingItems);
        manager.add((IAction)collapseAll);
        Action refresh = new Action("Refresh"){

            public void run() {
                InstaSearchView.this.refreshSearch();
            }
        };
        refresh.setAccelerator(0x100000E);
        manager.add((IAction)refresh);
        Action delete = new Action("Delete Match"){

            public void run() {
                InstaSearchView.this.deleteSelectedMatch();
            }
        };
        delete.setAccelerator(127);
        manager.add((IAction)delete);
        Action moreResults = new Action("More Results..."){

            public void run() {
                InstaSearchView.this.showAllResults();
            }
        };
        moreResults.setEnabled(showingItems);
        manager.add((IAction)moreResults);
        if (sq == null || !sq.isLimited()) {
            moreResults.setEnabled(false);
        }
    }

    private void deleteSelectedMatch() {
        if (this.getResultViewer().getSelection() == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.resultViewer.getSelection();
        this.getResultViewer().remove(selection.toArray());
    }

    public void showAllResults() {
        SearchQuery sq = (SearchQuery)this.resultViewer.getInput();
        SearchQuery newSq = new SearchQuery(sq);
        newSq.setMaxResults(-1);
        this.search(newSq, false);
    }

    public void expandAll() {
        this.expandCollapseJob.schedule(true);
    }

    public void collapseAll() {
        this.expandCollapseJob.schedule(false);
    }

    private void openSelection() throws Exception {
        IStructuredSelection selection = (IStructuredSelection)this.resultViewer.getSelection();
        Object obj = selection.getFirstElement();
        SearchResultDoc doc = null;
        ResultContentProvider.MatchLine selectedLineMatches = null;
        if (obj instanceof SearchResultDoc) {
            doc = (SearchResultDoc)obj;
        } else if (obj instanceof ResultContentProvider.MatchLine) {
            selectedLineMatches = (ResultContentProvider.MatchLine)obj;
            doc = selectedLineMatches.getResultDoc();
        } else {
            if (obj instanceof Exception) {
                InstaSearchUI.showError((Exception)obj);
                return;
            }
            if (obj instanceof SearchQuery) {
                this.search((SearchQuery)obj, true);
                return;
            }
            return;
        }
        new MatchHighlightJob(doc, selectedLineMatches, this.contentProvider, this.searchJob, this.getSite().getPage()).schedule();
    }

    private void hookDoubleClickAction() {
        this.resultViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                InstaSearchView.this.openAction.run();
            }
        });
    }

    public void setFocus() {
        this.searchText.setFocus();
    }

    private void makeActions() {
        this.openAction = new Action("Open"){

            public void run() {
                try {
                    InstaSearchView.this.openSelection();
                }
                catch (Exception e) {
                    InstaSearchPlugin.log(e);
                }
            }
        };
    }

    private void scheduleUpdateCheck() {
        boolean checkUpdates = InstaSearchPlugin.getBoolPref("checkUpdates");
        if (!checkUpdates) {
            return;
        }
        CheckUpdatesJob checkUpdatesJob = new CheckUpdatesJob();
        checkUpdatesJob.setSystem(true);
        checkUpdatesJob.addJobChangeListener((IJobChangeListener)new UpdateJobChangeListener());
        checkUpdatesJob.schedule(InstaSearchPlugin.getIntPref("updateCheckDelay"));
    }

    public void logging(IStatus status, String plugin) {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        IContributionItem item = menuManager.find("it.unibz.instasearch.ui.InstaSearchUI.ShowExceptionAction");
        if (item != null) {
            menuManager.remove(item);
        }
        ShowExceptionAction action = new ShowExceptionAction(status);
        action.setText("Report Bug");
        menuManager.add((IAction)action);
    }

    public void dispose() {
        super.dispose();
        if (InstaSearchPlugin.getDefault() != null) {
            InstaSearchPlugin.getDefault().getLog().removeLogListener((ILogListener)this);
            InstaSearchPlugin.removePreferenceChangeListener(this);
        }
    }

    private void refreshSearch() {
        InstaSearchPlugin.getInstaSearch().updateIndex();
        SearchQuery input = (SearchQuery)this.resultViewer.getInput();
        if (input == null) {
            return;
        }
        this.resultViewer.setInput(null);
        this.searchJob.cancel();
        this.searchJob.schedule(input, false, this.typingSearchDelay);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.typingSearchDelay = InstaSearchPlugin.getIntPref("typingSearchDelay");
        this.maxResults = InstaSearchPlugin.getIntPref("shownFilesCount");
        this.incrementalSearchEnabled = InstaSearchPlugin.getBoolPref("incrementalSearch");
    }

    private class ExpandCollapseJob
    extends Job
    implements ISchedulingRule {
        public ExpandCollapseJob() {
            super("Expand All");
            this.setRule(this);
            InstaSearchView.this.searchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void scheduled(IJobChangeEvent event) {
                    ExpandCollapseJob.this.cancel();
                }

                public void done(IJobChangeEvent event) {
                    ExpandCollapseJob.this.cancel();
                }
            });
        }

        public void schedule(boolean expandAll) {
            this.cancel();
            if (!expandAll) {
                InstaSearchView.this.resultViewer.collapseAll();
                return;
            }
            if (InstaSearchView.this.resultViewer.getTree().getItemCount() == 0) {
                return;
            }
            this.schedule();
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display display = InstaSearchView.this.getViewSite().getShell().getDisplay();
            Object[] elements = InstaSearchView.this.contentProvider.getElements();
            monitor.beginTask("InstaSearch Expanding", elements.length);
            int i = 0;
            while (i < elements.length && !monitor.isCanceled()) {
                final Object curDoc = elements[i];
                if (curDoc != null && curDoc instanceof SearchResultDoc) {
                    InstaSearchView.this.contentProvider.getChildren(curDoc);
                    Runnable expander = new Runnable(){

                        @Override
                        public void run() {
                            InstaSearchView.this.resultViewer.setExpandedState(curDoc, true);
                        }
                    };
                    display.syncExec(expander);
                    monitor.worked(1);
                }
                ++i;
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule.getClass() == ((Object)((Object)this)).getClass();
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    private class UpdateJobChangeListener
    extends JobChangeAdapter {
        private UpdateJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            IStatus status = event.getResult();
            if (status.getSeverity() == 0) {
                boolean updateAvailable;
                boolean bl = updateAvailable = status.getCode() == 1;
                if (updateAvailable) {
                    InstaSearchView.this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UpdateJobChangeListener.this.addUpdateAction();
                            InstaSearchView.this.setTitleToolTip("New version available");
                            InstaSearchView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(InstaSearchView.this.getTitleImage(), "New version available");
                        }
                    });
                }
            }
        }

        private void addUpdateAction() {
            IAction updateAction = CheckUpdatesJob.createUpdateNotificationAction();
            updateAction.setImageDescriptor(InstaSearchPlugin.getImageDescriptor("lightbulb"));
            IToolBarManager mgr = InstaSearchView.this.getViewSite().getActionBars().getToolBarManager();
            mgr.add(updateAction);
            mgr.update(true);
            IMenuManager menuMgr = InstaSearchView.this.getViewSite().getActionBars().getMenuManager();
            menuMgr.add(updateAction);
            IContributionItem checkUpdatesItem = mgr.find(CheckUpdatesActionDelegate.ID);
            if (checkUpdatesItem != null) {
                checkUpdatesItem.setVisible(false);
            }
        }
    }
}

