/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.SearchQuery;
import it.unibz.instasearch.indexing.WorkspaceIndexerJDT;
import it.unibz.instasearch.ui.InstaSearchUI;
import it.unibz.instasearch.ui.InstaSearchView;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.TypeFilteringDialog;

public class InstaSearchPage
extends DialogPage
implements ISearchPage {
    public static final String ID = "it.unibz.instasearch.ui.InstaSearchPage";
    private ISearchPageContainer container;
    private Text searchText;
    private Button similarSearch;
    private StringButtonFieldEditor extensionEditor;

    public boolean performAction() {
        HashMap<Field, Set<String>> filter = new HashMap<Field, Set<String>>();
        if (this.container.getSelectedScope() == 3 && this.container.getSelectedProjectNames().length != 0) {
            TreeSet selectedProjects = new TreeSet();
            Collections.addAll(selectedProjects, this.container.getSelectedProjectNames());
            filter.put(Field.PROJ, selectedProjects);
        } else if (this.container.getSelectedScope() == 2 && this.container.getSelectedWorkingSets().length != 0) {
            filter.put(Field.WS, this.getWorkingSetSearchString());
        } else if (this.container.getSelectedScope() == 1 && !this.container.getSelection().isEmpty()) {
            this.getSelectedResources(filter);
        }
        filter.put(Field.EXT, this.getSelectedExtensions());
        this.extensionEditor.store();
        String searchString = this.searchText.getText();
        InstaSearchView searchView = InstaSearchUI.showSearchView();
        if (searchView != null) {
            int maxResults = -1;
            searchString = String.valueOf(searchString) + InstaSearchPage.convertFilterToString(filter);
            SearchQuery searchQuery = new SearchQuery(searchString, maxResults);
            searchQuery.setExact(this.similarSearch.getSelection());
            searchQuery.setFilter(null);
            searchView.setSearchString(searchString);
            searchView.search(searchQuery, false);
        }
        return true;
    }

    private void getSelectedResources(HashMap<Field, Set<String>> filter) {
        if (this.container.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.container.getSelection();
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                if (elem instanceof IAdaptable) {
                    IResource res = null;
                    if (elem instanceof IResource) {
                        res = (IResource)elem;
                    } else {
                        IAdaptable adaptable = (IAdaptable)elem;
                        res = (IResource)adaptable.getAdapter(IResource.class);
                    }
                    if (res != null) {
                        switch (res.getType()) {
                            case 4: {
                                Set<Object> projects = filter.containsKey((Object)Field.PROJ) ? filter.get((Object)Field.PROJ) : new TreeSet();
                                projects.add(((IProject)res).getName());
                                filter.put(Field.PROJ, projects);
                                break;
                            }
                            case 1: {
                                Set<Object> files = filter.containsKey((Object)Field.FILE) ? filter.get((Object)Field.FILE) : new TreeSet();
                                files.add(((IFile)res).getFullPath().toString());
                                filter.put(Field.FILE, files);
                                break;
                            }
                            case 2: {
                                Set<Object> folders = filter.containsKey((Object)Field.DIR) ? filter.get((Object)Field.DIR) : new TreeSet();
                                folders.add(res.getFullPath().toString());
                                filter.put(Field.DIR, folders);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static String convertFilterToString(HashMap<Field, Set<String>> filter) {
        String filterString = "";
        for (Map.Entry<Field, Set<String>> entry : filter.entrySet()) {
            String fieldFilterString = InstaSearchPage.getFieldFilterString(entry.getKey(), entry.getValue());
            if ("".equals(fieldFilterString)) continue;
            filterString = String.valueOf(filterString) + " " + fieldFilterString;
        }
        return filterString;
    }

    private Set<String> getSelectedExtensions() {
        TreeSet<String> extSet = new TreeSet<String>();
        String exts = this.extensionEditor.getStringValue();
        if (exts != null && !"".equals(exts) && !"*".equals(exts)) {
            exts = exts.replace(" ", "");
            exts = exts.replace("*.", "");
            Collections.addAll(extSet, exts.split(","));
        }
        return extSet;
    }

    private Set<String> getWorkingSetSearchString() {
        TreeSet<String> wsNames = new TreeSet<String>();
        IWorkingSet[] iWorkingSetArray = this.container.getSelectedWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet ws = iWorkingSetArray[n2];
            String workingSet = ws.getName();
            wsNames.add(workingSet);
            ++n2;
        }
        return wsNames;
    }

    private static String getFieldFilterString(Field field, Set<String> values) {
        String filterString = null;
        if (values.size() == 0) {
            return "";
        }
        for (String val : values) {
            filterString = filterString == null ? "" : String.valueOf(filterString) + ",";
            filterString = String.valueOf(filterString) + val;
        }
        if (filterString.contains(" ")) {
            filterString = String.valueOf('\"') + filterString + '\"';
        }
        return String.valueOf(field.toString()) + ':' + filterString;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 4);
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 1;
        pageComposite.setLayout((Layout)pageLayout);
        pageComposite.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Label label = new Label(pageComposite, 16384);
        label.setText("Search:");
        label.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.searchText = new Text(pageComposite, 2052);
        this.searchText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (this.container.getSelection() instanceof TextSelection) {
            String selection = ((TextSelection)this.container.getSelection()).getText();
            this.searchText.setText(selection);
        }
        this.createShowViewLink(pageComposite);
        this.similarSearch = new Button(pageComposite, 32);
        this.similarSearch.setText("Find similar matches");
        this.similarSearch.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (InstaSearchPlugin.getInstaSearch() != null) {
            boolean cfr_ignored_0 = InstaSearchPlugin.getInstaSearch().getIndexer() instanceof WorkspaceIndexerJDT;
        }
        this.createExtensionEditor(pageComposite);
        this.setControl((Control)this.searchText);
    }

    private void createExtensionEditor(Composite pageComposite) {
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 1;
        pageLayout.marginWidth = 1;
        Composite labelComposite = new Composite(pageComposite, 4);
        labelComposite.setLayout((Layout)pageLayout);
        Label label = new Label(labelComposite, 0);
        label.setText("File types:");
        labelComposite.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        Composite extensionsComposite = new Composite(pageComposite, 4);
        extensionsComposite.setLayout((Layout)pageLayout);
        extensionsComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.extensionEditor = new StringButtonFieldEditor("searchExtensions", "", extensionsComposite){

            protected String changePressed() {
                String exts = this.getStringValue();
                exts = exts.replace(" ", "");
                List<String> extList = Arrays.asList(exts.split(","));
                TypeFilteringDialog dialog = new TypeFilteringDialog(this.getShell(), extList);
                dialog.open();
                Object[] newSelectedTypes = dialog.getResult();
                return StringUtils.join((Object[])newSelectedTypes, (String)",");
            }
        };
        this.extensionEditor.setChangeButtonText("Choose...");
        this.extensionEditor.setEmptyStringAllowed(true);
        this.extensionEditor.setPreferenceStore(InstaSearchPlugin.getDefault().getPreferenceStore());
        this.extensionEditor.load();
        Text txt = this.extensionEditor.getTextControl(extensionsComposite);
        txt.setToolTipText("E.g:\njava, xml");
    }

    private void createShowViewLink(Composite pageComposite) {
        Composite linkComposite = new Composite(pageComposite, 4);
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        pageLayout.marginWidth = 1;
        linkComposite.setLayout((Layout)pageLayout);
        linkComposite.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Link openViewLink = new Link(linkComposite, 0);
        openViewLink.setText("You can search directly from the <a>search view</a>");
        openViewLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstaSearchUI.showSearchView();
            }
        });
        openViewLink.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.searchText.setFocus();
        this.container.setPerformActionEnabled(true);
    }
}

