/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.prefs;

import it.unibz.instasearch.InstaSearchPlugin;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorRegistry;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String DEFAULT_EXTENSIONS = "java,xml,xsd,txt,jsp,css,c,cpp,h,hpp,mf,properties,php,php4,php5,js,inc,ini,sql,sqlj,pl,sh,bat,cmd,htm,html";

    public void initializeDefaultPreferences() {
        IPreferenceStore store = InstaSearchPlugin.getDefault().getPreferenceStore();
        store.setDefault("checkUpdates", true);
        store.setDefault("showMatchCounts", true);
        store.setDefault("indexArchives", false);
        store.setDefault("indexEmptyExtension", false);
        store.setDefault("fuzzySearchAuto", true);
        store.setDefault("showFullPath", true);
        store.setDefault("dialogOnShortcut", false);
        store.setDefault("incrementalSearch", true);
        store.setDefault("shownFilesCount", 25);
        store.setDefault("shownLineCount", 4);
        store.setDefault("updateCheckDelay", 10000);
        store.setDefault("typingSearchDelay", 200);
        store.setDefault("indexUpdateInterval", 60000);
        store.setDefault("indexUpdateEnabled", true);
        String extensions = PreferenceInitializer.getIndexableExtensions();
        store.setDefault("indexableExtensions", extensions);
        store.setDefault("searchExtensions", "");
        store.setDefault("excludedFolders", "");
    }

    public static String getIndexableExtensions() {
        IContentType[] types;
        String[] defaultExtArray = DEFAULT_EXTENSIONS.split(",");
        TreeSet<String> extensions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        extensions.addAll(Arrays.asList(defaultExtArray));
        IFileEditorMapping[] allMappings = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getUnifiedMappings();
        IContentType text = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        int i = 0;
        while (i < allMappings.length) {
            if (allMappings[i].getName().equals("*")) {
                String ext = allMappings[i].getExtension();
                IContentType type = Platform.getContentTypeManager().findContentTypeFor("." + ext);
                if (type != null && type.isKindOf(text)) {
                    extensions.add(ext);
                }
            }
            ++i;
        }
        IContentType[] iContentTypeArray = types = Platform.getContentTypeManager().getAllContentTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType type = iContentTypeArray[n2];
            if (type.isKindOf(text)) {
                String[] exts = type.getFileSpecs(8);
                extensions.addAll(Arrays.asList(exts));
            }
            ++n2;
        }
        return StringUtils.join((Object[])extensions.toArray(), (String)",");
    }
}

