/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.prefs;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.WorkspaceIndexer;
import it.unibz.instasearch.indexing.WorkspaceIndexerJDT;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.TypeFilteringDialog;

public class InstaSearchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = InstaSearchPreferencePage.class.getName();
    private BooleanFieldEditor periodicReindexEnabled;
    private IntegerFieldEditor periodicReindexInterval;

    public InstaSearchPreferencePage() {
        super(1);
        this.setPreferenceStore(InstaSearchPlugin.getDefault().getPreferenceStore());
        this.setDescription("");
    }

    public void createFieldEditors() {
        String[] fileValues = new String[]{"5", "10", "15", "25", "50"};
        this.addField((FieldEditor)new ComboFieldEditor("shownFilesCount", "Shown results (initially)", InstaSearchPreferencePage.getArrayOfPairs(fileValues), this.getFieldEditorParent()));
        String[] lineValues = new String[]{"3", "4", "5", "7", "10", "15", "25"};
        this.addField((FieldEditor)new ComboFieldEditor("shownLineCount", "Preview lines", InstaSearchPreferencePage.getArrayOfPairs(lineValues), this.getFieldEditorParent()));
        this.addBoolField("showMatchCounts", "Show number of matches");
        this.addBoolField("showFullPath", "Show full file path in results");
        this.addBoolField("dialogOnShortcut", "Open search dialog with shortcut key (Ctrl+Alt+I)");
        ExtensionsFieldEditor extensions = new ExtensionsFieldEditor(this.getFieldEditorParent());
        extensions.setChangeButtonText("...");
        extensions.setEmptyStringAllowed(true);
        this.addField((FieldEditor)extensions);
        this.addBoolField("indexEmptyExtension", "Index files without extension");
        BooleanFieldEditor indexJars = new BooleanFieldEditor("indexArchives", "Index JAR Source Attachements (beta)", this.getFieldEditorParent());
        this.addField((FieldEditor)indexJars);
        indexJars.setEnabled(false, this.getFieldEditorParent());
        if (InstaSearchPlugin.getInstaSearch() != null && InstaSearchPlugin.getInstaSearch().getIndexer() instanceof WorkspaceIndexerJDT) {
            indexJars.setEnabled(true, this.getFieldEditorParent());
        }
        this.addBoolField("fuzzySearchAuto", "Find similar matches when no exact matches found");
        String version = InstaSearchPlugin.getVersion();
        this.addBoolField("checkUpdates", "Notify about updates (ver. " + version + ")");
        this.periodicReindexEnabled = this.addBoolField("indexUpdateEnabled", "Enable Automatic-Reindex");
        this.periodicReindexInterval = new IntegerFieldEditor("indexUpdateInterval", "Automatic Reindex interval", this.getFieldEditorParent());
        this.periodicReindexInterval.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.periodicReindexInterval);
        this.addField((FieldEditor)new WorkspacePathEditor("excludedFolders", "Exclude folders from index", "Select folder to exclude from indexing", this.getFieldEditorParent()));
        Link annotationsLink = new Link(this.getFieldEditorParent(), 0);
        annotationsLink.setText("See <a>Annotations</a> to set Search Results highlight color");
        annotationsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)InstaSearchPreferencePage.this.getShell(), (String)"org.eclipse.ui.editors.preferencePages.Annotations", null, null).open();
            }
        });
    }

    protected void initialize() {
        super.initialize();
        this.periodicReindexInterval.setEnabled(this.periodicReindexEnabled.getBooleanValue(), this.getFieldEditorParent());
    }

    public boolean performOk() {
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    private BooleanFieldEditor addBoolField(String id, String label) {
        BooleanFieldEditor field = new BooleanFieldEditor(id, label, this.getFieldEditorParent());
        this.addField((FieldEditor)field);
        return field;
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof FieldEditor) {
            FieldEditor field = (FieldEditor)event.getSource();
            if (field == this.periodicReindexEnabled) {
                this.periodicReindexInterval.setEnabled(this.periodicReindexEnabled.getBooleanValue(), this.getFieldEditorParent());
            }
            if ("indexableExtensions".equals(field.getPreferenceName()) || "excludedFolders".equals(field.getPreferenceName()) || "indexEmptyExtension".equals(field.getPreferenceName())) {
                this.setMessage("Rebuilding of index is recommended", 1);
            } else if ("indexArchives".equals(field.getPreferenceName())) {
                this.setMessage("Rebuilding of index is required", 1);
            }
        }
    }

    protected void checkState() {
        super.checkState();
        this.setValid(true);
    }

    private static String[][] getArrayOfPairs(String[] values) {
        String[][] pairs = new String[values.length][2];
        int i = 0;
        while (i < values.length) {
            String val = values[i];
            pairs[i] = new String[]{val, val};
            ++i;
        }
        return pairs;
    }

    private static class ExtensionsFieldEditor
    extends StringButtonFieldEditor {
        public ExtensionsFieldEditor(Composite parent) {
            super("indexableExtensions", "Extensions of files to index", parent);
        }

        protected String changePressed() {
            String exts = this.getStringValue();
            TypeFilteringDialog dialog = new TypeFilteringDialog(this.getPage().getShell(), Arrays.asList(exts.split(",")));
            dialog.open();
            Object[] newSelectedTypes = dialog.getResult();
            if (newSelectedTypes == null) {
                return null;
            }
            Arrays.sort(newSelectedTypes);
            return StringUtils.join((Object[])newSelectedTypes, (String)",");
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
            Text txt = this.getTextControl();
            GridData gd = (GridData)txt.getLayoutData();
            if (gd != null) {
                gd.widthHint = 250;
            }
        }
    }

    private static class FilteredResourcesPatternDialog
    extends FilteredResourcesSelectionDialog {
        private String lastPattern = null;
        private Pattern regexPattern;

        public FilteredResourcesPatternDialog(Shell shell) {
            super(shell, false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 6);
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            Text patternText = (Text)this.getPatternControl();
            String wcPattern = patternText.getText();
            if (wcPattern.startsWith("/")) {
                wcPattern = wcPattern.substring(1);
            }
            try {
                this.regexPattern = WorkspaceIndexer.wildcardToRegex(wcPattern);
            }
            catch (Exception t) {
                InstaSearchPlugin.log(t);
                return null;
            }
            this.lastPattern = wcPattern;
            FilteredResourcesSelectionDialog.ResourceFilter filter = new FilteredResourcesSelectionDialog.ResourceFilter(this){

                public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
                    return false;
                }

                public boolean matchItem(Object item) {
                    if (!(item instanceof IResource)) {
                        return false;
                    }
                    IResource resource = (IResource)item;
                    if (resource.getType() != 2 && resource.getType() != 4) {
                        return false;
                    }
                    if (resource.isDerived()) {
                        return false;
                    }
                    String path = resource.getFullPath().toString();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    boolean matches = false;
                    try {
                        matches = FilteredResourcesPatternDialog.this.regexPattern.matcher(path).matches();
                    }
                    catch (Exception t) {
                        InstaSearchPlugin.log(t);
                    }
                    return matches;
                }

                public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
                    return false;
                }
            };
            return filter;
        }

        public String getLastPattern() {
            return this.lastPattern;
        }
    }

    private static class WorkspacePathEditor
    extends PathEditor {
        public WorkspacePathEditor(String name, String labelText, String dirChooserLabelText, Composite parent) {
            super(name, labelText, dirChooserLabelText, parent);
        }

        protected String getNewInputObject() {
            FilteredResourcesPatternDialog dlg = new FilteredResourcesPatternDialog(this.getShell());
            dlg.setTitle("Exclude folders");
            dlg.setMessage("Exclude folders matching pattern (? = any character, * = any string, ** = any subfolder)");
            dlg.setInitialPattern("**/bin");
            dlg.setHelpAvailable(false);
            dlg.open();
            if (dlg.getReturnCode() == 0) {
                return dlg.getLastPattern();
            }
            return null;
        }
    }
}

