/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.jobs;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.actions.ShowExceptionAction;
import it.unibz.instasearch.indexing.WorkspaceIndexer;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.IProgressConstants;

public class IndexingJob
extends WorkspaceJob {
    private WorkspaceIndexer indexer;

    public IndexingJob(WorkspaceIndexer indexer) {
        super("InstaSearch Indexing");
        this.indexer = indexer;
        this.setRule(indexer);
        this.setProperty(IProgressConstants.ICON_PROPERTY, InstaSearchPlugin.getImageDescriptor("binary"));
        this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            this.indexer.createIndex(InstaSearchPlugin.getWorkspaceRoot(), monitor);
        }
        catch (Exception e) {
            monitor.beginTask("Exception", 1);
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new ShowExceptionAction(e, "Error Creating Index"));
            InstaSearchPlugin.log(e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

