/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.jobs;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.actions.ShowExceptionAction;
import it.unibz.instasearch.indexing.StorageIndexer;
import it.unibz.instasearch.indexing.WorkspaceIndexer;
import it.unibz.instasearch.ui.InstaSearchUI;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class IndexUpdateJob
extends WorkspaceJob
implements SynchronousBundleListener,
IResourceChangeListener,
IPropertyChangeListener {
    private WorkspaceIndexer indexer;
    private StorageIndexer.IndexChangeListener indexChangeListener;
    private Map<IResource, Integer> changedResources = new ConcurrentHashMap<IResource, Integer>();
    private boolean searchViewVisible = false;

    public IndexUpdateJob(WorkspaceIndexer indexer, StorageIndexer.IndexChangeListener indexChangeListener) {
        super("InstaSearch Index Update");
        this.indexer = indexer;
        this.indexChangeListener = indexChangeListener;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        if (InstaSearchPlugin.getDefault() != null) {
            InstaSearchPlugin.getDefault().getBundle().getBundleContext().addBundleListener((BundleListener)this);
        }
        this.setRule(indexer);
        this.setProperty(IProgressConstants.ICON_PROPERTY, InstaSearchPlugin.getImageDescriptor("syncdb"));
        this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 8 || event.getType() == 16) {
            return;
        }
        try {
            if (this.indexer.isIndexed() && event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                delta.accept(this.createResourceVisitor(), false);
            }
        }
        catch (Exception e) {
            InstaSearchPlugin.log(e);
        }
    }

    private IResourceDeltaVisitor createResourceVisitor() {
        return new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                if (resource.getType() == 1) {
                    IFile file = (IFile)resource;
                    if (IndexUpdateJob.this.indexer.isIndexable(file)) {
                        IndexUpdateJob.this.changedResources.put(file, file.getType());
                    }
                } else if (resource.getType() == 2 && delta.getFlags() == 0x400000) {
                    IndexUpdateJob.this.changedResources.put(resource, resource.getType());
                }
                return true;
            }
        };
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 256 || event.getType() == 4) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.cancel();
            if (event.getBundle() != null && event.getBundle().getBundleContext() != null) {
                event.getBundle().getBundleContext().removeBundleListener((BundleListener)this);
            }
        }
    }

    protected void canceling() {
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (InstaSearchPlugin.getDefault() == null || monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        int indexUpdateInterval = InstaSearchPlugin.getIntPref("indexUpdateInterval");
        boolean indexUpdateEnabled = InstaSearchPlugin.getBoolPref("indexUpdateEnabled");
        if (!indexUpdateEnabled) {
            return Status.CANCEL_STATUS;
        }
        boolean indexed = false;
        try {
            indexed = this.indexer.isIndexed();
        }
        catch (IOException e1) {
            InstaSearchPlugin.log(e1);
        }
        if (!(indexed && !this.changedResources.isEmpty() || monitor.isCanceled())) {
            this.schedule(indexUpdateInterval);
            return Status.CANCEL_STATUS;
        }
        monitor.beginTask("Updating Search Index", this.changedResources.size());
        IStatus returnStatus = Status.OK_STATUS;
        try {
            Iterator<IResource> iterator = this.changedResources.keySet().iterator();
            while (iterator.hasNext() && !monitor.isCanceled()) {
                IResource resource = iterator.next();
                monitor.subTask(resource.getName());
                if (resource.getType() == 1) {
                    this.indexer.updateFile((IFile)resource);
                } else if (resource.getType() == 2) {
                    this.indexer.updateFolder((IFolder)resource, monitor);
                }
                iterator.remove();
                monitor.worked(1);
            }
            this.indexChangeListener.onIndexUpdate();
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IndexUpdateJob.this.searchViewVisible = InstaSearchUI.isSearchViewVisible();
                }
            });
            if (!this.searchViewVisible) {
                this.indexer.optimizeIndex();
            }
            monitor.done();
        }
        catch (Exception e) {
            monitor.beginTask("Exception", 1);
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new ShowExceptionAction(e, "Error Updating Index"));
            InstaSearchPlugin.log(e);
            returnStatus = Status.CANCEL_STATUS;
        }
        if (!monitor.isCanceled() && indexUpdateEnabled) {
            this.schedule(indexUpdateInterval);
        }
        return returnStatus;
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean enableFlag;
        String prop = event.getProperty();
        if ("excludedFolders".equals(prop)) {
            String[] excludedDirArr;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String excludedDirStr = "";
            if (event.getOldValue() != null) {
                excludedDirStr = String.valueOf(excludedDirStr) + event.getOldValue().toString() + File.pathSeparator;
            }
            if (event.getNewValue() != null) {
                excludedDirStr = String.valueOf(excludedDirStr) + event.getNewValue().toString();
            }
            String[] stringArray = excludedDirArr = excludedDirStr.split(File.pathSeparator);
            int n = excludedDirArr.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res;
                Path path;
                String excludedDir = stringArray[n2];
                if (excludedDir.length() != 0 && root.exists((IPath)(path = new Path(excludedDir))) && (res = root.findMember((IPath)path)) != null) {
                    this.changedResources.put(res, res.getType());
                }
                ++n2;
            }
        } else if ("indexUpdateEnabled".equals(prop) && (enableFlag = ((Boolean)event.getNewValue()).booleanValue())) {
            int indexUpdateInterval = InstaSearchPlugin.getIntPref("indexUpdateInterval");
            this.cancel();
            this.schedule(indexUpdateInterval);
        }
    }
}

