/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.jobs;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.actions.ShowExceptionAction;
import it.unibz.instasearch.indexing.StorageIndexer;
import it.unibz.instasearch.indexing.WorkspaceIndexer;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.IProgressConstants;

public class DeleteIndexJob
extends WorkspaceJob {
    private StorageIndexer indexer;

    public DeleteIndexJob(WorkspaceIndexer indexer) {
        super("Delete InstaSearch Index");
        this.indexer = indexer;
        this.setRule(indexer);
        this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
        this.setProperty(IProgressConstants.ICON_PROPERTY, InstaSearchPlugin.getImageDescriptor("delete"));
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.isSystem()) {
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
        }
        try {
            this.indexer.deleteIndex();
        }
        catch (Exception e) {
            monitor.beginTask("Exception", 1);
            ShowExceptionAction action = new ShowExceptionAction(e, "Unable to delete index");
            this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)action);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

