/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class UppercaseNameExpander
extends QueryVisitor {
    @Override
    public Query visit(TermQuery termQuery, Field field) {
        if (field != Field.NAME) {
            return termQuery;
        }
        Term term = termQuery.getTerm();
        String text = term.text();
        if (text.matches("[A-Z][a-z0-9_]*[A-Z].*")) {
            BooleanQuery bq = new BooleanQuery();
            bq.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            String wcText = text.replaceAll("([A-Z][a-z0-9_]*)", "$1*");
            Term wcTerm = Field.NAME.createTerm(wcText);
            WildcardQuery wcQuery = new WildcardQuery(wcTerm);
            wcQuery.setBoost(termQuery.getBoost() / 2.0f);
            bq.add((Query)wcQuery, BooleanClause.Occur.SHOULD);
            return bq;
        }
        return super.visit(termQuery, field);
    }
}

