/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class PhraseSearcher
extends QueryVisitor {
    private static final int DEFAULT_SLOP = 10;

    @Override
    public BooleanQuery visit(BooleanQuery boolQuery) {
        PhraseQuery phraseQuery = new PhraseQuery();
        BooleanClause[] booleanClauseArray = boolQuery.getClauses();
        int n = booleanClauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanClause clause = booleanClauseArray[n2];
            if (clause.isProhibited() || !clause.isRequired() || !(clause.getQuery() instanceof TermQuery)) {
                return super.visit(boolQuery);
            }
            TermQuery tq = (TermQuery)clause.getQuery();
            Field field = Field.getByName(tq.getTerm().field());
            if (field == Field.CONTENTS) {
                phraseQuery.add(tq.getTerm());
            }
            ++n2;
        }
        phraseQuery.setSlop(10);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)phraseQuery, BooleanClause.Occur.SHOULD);
        bq.add((Query)boolQuery, BooleanClause.Occur.SHOULD);
        bq.setBoost(boolQuery.getBoost());
        phraseQuery.setBoost(boolQuery.getBoost());
        boolQuery.setBoost(phraseQuery.getBoost() * 0.5f);
        return bq;
    }
}

