/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LastTermQueryPrefixer
extends QueryVisitor {
    private int clauseCount = 0;
    private int minTermLength;

    public LastTermQueryPrefixer(int minTermLength) {
        this.minTermLength = minTermLength;
    }

    @Override
    public Query visit(TermQuery termQuery, Field field) {
        if (this.clauseCount == 0) {
            Term term = termQuery.getTerm();
            if (term.text().length() < this.minTermLength) {
                return termQuery;
            }
            PrefixQuery prefixQuery = new PrefixQuery(term);
            prefixQuery.setBoost(termQuery.getBoost() / 4.0f);
            BooleanQuery boolQuery = new BooleanQuery();
            boolQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            boolQuery.add((Query)prefixQuery, BooleanClause.Occur.SHOULD);
            boolQuery.setBoost(termQuery.getBoost());
            return boolQuery;
        }
        return termQuery;
    }

    @Override
    public BooleanQuery visit(BooleanQuery boolQuery) {
        this.clauseCount += boolQuery.getClauses().length;
        return super.visit(boolQuery);
    }

    @Override
    public boolean visit(BooleanClause boolClause) {
        --this.clauseCount;
        return boolClause.getOccur() != BooleanClause.Occur.MUST_NOT;
    }
}

