/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class FilterSetter
extends QueryVisitor {
    private Map<Field, Set<String>> filter;

    @Override
    public Query visit(TermQuery termQuery, Field field) {
        return this.addFilters((Query)termQuery, field);
    }

    @Override
    public Query visit(PrefixQuery originalQuery, Field field) {
        return this.addFilters((Query)originalQuery, field);
    }

    @Override
    public Query visit(WildcardQuery wildcardQuery, Field field) {
        return this.addFilters((Query)wildcardQuery, field);
    }

    private Query getFilterQuery(Query originalQuery, Field field, Set<String> values) {
        BooleanQuery boolQuery = new BooleanQuery();
        if (originalQuery != null) {
            boolQuery.add(originalQuery, BooleanClause.Occur.SHOULD);
            boolQuery.setBoost(originalQuery.getBoost());
        }
        for (String value : values) {
            boolQuery.add((Query)new TermQuery(field.createTerm(value)), BooleanClause.Occur.SHOULD);
        }
        return boolQuery;
    }

    private Query addFilters(Query originalQuery, Field field) {
        Set<String> values = this.filter.get((Object)field);
        if (values != null) {
            this.filter.remove((Object)field);
            return this.getFilterQuery(originalQuery, field, values);
        }
        return originalQuery;
    }

    @Override
    public Query endVisit(Query query) {
        if (this.filter.isEmpty()) {
            return super.endVisit(query);
        }
        BooleanQuery conjQuery = new BooleanQuery();
        conjQuery.add(query, BooleanClause.Occur.MUST);
        for (Field field : this.filter.keySet()) {
            Set<String> values = this.filter.get((Object)field);
            if (values.size() == 1) {
                String value = values.iterator().next();
                conjQuery.add((Query)new TermQuery(field.createTerm(value)), BooleanClause.Occur.MUST);
                continue;
            }
            conjQuery.add(this.getFilterQuery(null, field, values), BooleanClause.Occur.MUST);
        }
        return conjQuery;
    }

    public void setFilter(Map<Field, Set<String>> filter) {
        this.filter = filter;
    }
}

