/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.indexing.WorkspaceIndexer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.lucene.index.IndexWriter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.ui.IEditorInput;

public class WorkspaceIndexerJDT
extends WorkspaceIndexer {
    public WorkspaceIndexerJDT() throws Exception {
        if (JavaCore.getJavaCore() == null) {
            throw new RuntimeException("JDT not detected");
        }
    }

    @Override
    protected void indexContainers(IndexWriter indexWriter, IWorkspaceRoot workspaceRoot, IProgressMonitor monitor) throws Exception {
        super.indexContainers(indexWriter, workspaceRoot, monitor);
        boolean indexArchives = InstaSearchPlugin.getBoolPref("indexArchives");
        if (!indexArchives) {
            return;
        }
        try {
            IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
            List<IPackageFragmentRoot> jars = this.getJars(javaModel);
            monitor.beginTask("Indexing JAR Source Attachements (" + jars.size() + ")", jars.size());
            for (IPackageFragmentRoot jar : jars) {
                monitor.worked(1);
                this.indexClassFiles(indexWriter, jar, monitor);
                this.indexNonJavaResources(indexWriter, jar, monitor);
                if (!monitor.isCanceled()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            InstaSearchPlugin.log(e);
        }
        if (monitor.isCanceled()) {
            InstaSearchPlugin.setBoolPref("indexArchives", false);
        }
        monitor.done();
    }

    private void indexNonJavaResources(IndexWriter indexWriter, IPackageFragmentRoot jar, IProgressMonitor monitor) throws Exception {
        Object[] resources = jar.getNonJavaResources();
        if (resources == null || resources.length == 0) {
            return;
        }
        IJarEntryResource[] jarEntries = new IJarEntryResource[resources.length];
        System.arraycopy(resources, 0, jarEntries, 0, resources.length);
        this.indexNonJavaResources(indexWriter, jar, jarEntries, monitor);
    }

    private void indexNonJavaResources(IndexWriter indexWriter, IPackageFragmentRoot jar, IJarEntryResource[] resources, IProgressMonitor monitor) throws Exception {
        String jarName = this.getJarName(jar);
        String projectPath = this.getProjectPath(jar);
        IJarEntryResource[] iJarEntryResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IJarEntryResource resource = iJarEntryResourceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (resource.isFile()) {
                if (this.isIndexable(resource)) {
                    this.indexStorageWithRetry(indexWriter, (IStorage)resource, projectPath, -1L, jarName);
                }
            } else {
                this.indexNonJavaResources(indexWriter, jar, resource.getChildren(), monitor);
            }
            ++n2;
        }
    }

    private boolean isIndexable(IJarEntryResource jarRes) {
        String ext = jarRes.getFullPath().getFileExtension();
        return this.isIndexableExtension(ext);
    }

    private String getProjectPath(IPackageFragmentRoot jar) {
        return String.valueOf(jar.getJavaProject().getElementName()) + "/" + this.getJarName(jar);
    }

    private String getJarName(IPackageFragmentRoot jar) {
        return jar.getElementName();
    }

    private void indexClassFiles(IndexWriter indexWriter, IPackageFragmentRoot jar, IProgressMonitor monitor) throws Exception {
        String jarName = this.getJarName(jar);
        String projectPath = this.getProjectPath(jar);
        IJavaElement[] iJavaElementArray = jar.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement pkgRootChild = iJavaElementArray[n2];
            IPackageFragment pkg = (IPackageFragment)pkgRootChild;
            monitor.setTaskName("Indexing JAR Source Attachements: " + jar.getElementName() + " - " + pkg.getElementName());
            IClassFile[] iClassFileArray = pkg.getClassFiles();
            int n3 = iClassFileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IClassFile classFile = iClassFileArray[n4];
                if (!classFile.getElementName().contains("$")) {
                    ClassFileSourceStorage classFileSourceStorage = new ClassFileSourceStorage(classFile);
                    if (classFileSourceStorage.hasSource()) {
                        this.indexStorageWithRetry(indexWriter, classFileSourceStorage, projectPath, -1L, jarName);
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private List<IPackageFragmentRoot> getJars(IJavaModel javaModel) throws JavaModelException {
        IJavaProject[] projects = javaModel.getJavaProjects();
        TreeSet<String> jarNames = new TreeSet<String>();
        LinkedList<IPackageFragmentRoot> jars = new LinkedList<IPackageFragmentRoot>();
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot[] roots;
            IJavaProject javaProj = iJavaProjectArray[n2];
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProj.getPackageFragmentRoots();
            int n3 = roots.length;
            int n4 = 0;
            while (n4 < n3) {
                String name;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                if (root.isArchive() && root.getSourceAttachmentPath() != null && !jarNames.contains(name = root.getElementName())) {
                    jarNames.add(name);
                    jars.add(root);
                }
                ++n4;
            }
            ++n2;
        }
        return jars;
    }

    @Override
    public IEditorInput getEditorInput(SearchResultDoc doc) throws Exception {
        if (!doc.isInJar()) {
            return super.getEditorInput(doc);
        }
        if ("class".equals(doc.getFileExtension())) {
            IClassFile classFile = this.getClassFile(doc);
            if (classFile == null) {
                return null;
            }
            return EditorUtility.getEditorInput((Object)classFile);
        }
        IStorage storage = this.getNonJavaResource(doc);
        if (storage == null) {
            return null;
        }
        return EditorUtility.getEditorInput((Object)storage);
    }

    @Override
    public IStorage getStorage(SearchResultDoc doc) throws Exception {
        if (!doc.isInJar()) {
            return super.getStorage(doc);
        }
        if ("class".equals(doc.getFileExtension())) {
            IClassFile classFile = this.getClassFile(doc);
            if (classFile == null) {
                return null;
            }
            ClassFileSourceStorage storage = new ClassFileSourceStorage(classFile);
            return storage;
        }
        return this.getNonJavaResource(doc);
    }

    private IStorage getNonJavaResource(SearchResultDoc doc) throws JavaModelException {
        String javaProjectName;
        IWorkspaceRoot workspaceRoot = InstaSearchPlugin.getWorkspaceRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        IJavaProject javaProj = javaModel.getJavaProject(javaProjectName = doc.getProject().segment(0));
        if (!javaProj.isOpen()) {
            javaProj.open((IProgressMonitor)new NullProgressMonitor());
        }
        javaModel.refreshExternalArchives(new IJavaElement[]{javaProj}, (IProgressMonitor)new NullProgressMonitor());
        String jarName = doc.getJarName();
        IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
        IPackageFragmentRoot jar = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.isArchive() && root.getSourceAttachmentPath() != null && (name = root.getElementName()).equals(jarName)) {
                jar = root;
                break;
            }
            ++n2;
        }
        if (jar == null) {
            return null;
        }
        String filePath = doc.getFilePath();
        Path path = new Path(filePath);
        IJarEntryResource res = null;
        String[] stringArray = path.segments();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String segment = stringArray[n4];
            res = res == null ? this.findJarEntry(jar, segment) : this.findJarEntry(res.getChildren(), segment);
            ++n4;
        }
        return res;
    }

    private IJarEntryResource findJarEntry(IPackageFragmentRoot jar, String filePath) throws JavaModelException {
        Object[] resources = jar.getNonJavaResources();
        if (resources == null || resources.length == 0) {
            return null;
        }
        IJarEntryResource[] jarEntries = new IJarEntryResource[resources.length];
        System.arraycopy(resources, 0, jarEntries, 0, resources.length);
        return this.findJarEntry(jarEntries, filePath);
    }

    private IJarEntryResource findJarEntry(IJarEntryResource[] jarEntries, String filePath) {
        IJarEntryResource[] iJarEntryResourceArray = jarEntries;
        int n = jarEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IJarEntryResource entry = iJarEntryResourceArray[n2];
            if (filePath.equals(entry.getName())) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    private IClassFile getClassFile(SearchResultDoc doc) throws Exception {
        String javaProjectName;
        IWorkspaceRoot workspaceRoot = InstaSearchPlugin.getWorkspaceRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        IJavaProject proj = javaModel.getJavaProject(javaProjectName = doc.getProject().segment(0));
        if (proj == null) {
            throw new Exception("Project " + javaProjectName + " not found");
        }
        if (!proj.isOpen()) {
            proj.open((IProgressMonitor)new NullProgressMonitor());
        }
        javaModel.refreshExternalArchives(new IJavaElement[]{proj}, (IProgressMonitor)new NullProgressMonitor());
        Path filePath = new Path(doc.getFilePath());
        String fileName = filePath.lastSegment();
        IPath jarPath = filePath.removeLastSegments(2);
        IPackageFragmentRoot jar = null;
        IResource jarFile = workspaceRoot.findMember(jarPath);
        jar = jarFile != null ? proj.getPackageFragmentRoot(jarFile) : proj.getPackageFragmentRoot(jarPath.toString());
        if (jar == null) {
            throw new Exception("Jar " + jarPath + " not found in project " + doc.getProjectName());
        }
        IPath pkgPath = filePath.removeLastSegments(1);
        String pkgName = pkgPath.lastSegment();
        IPackageFragment pkg = jar.getPackageFragment(pkgName);
        if (pkg == null) {
            throw new Exception("Package " + pkgName + " not found  in " + doc.getProjectName());
        }
        IClassFile classFile = pkg.getClassFile(fileName);
        return classFile;
    }

    private class ClassFileSourceStorage
    implements IStorage {
        private IClassFile classFile;
        private String source;

        public ClassFileSourceStorage(IClassFile classFileWithSource) throws JavaModelException {
            this.classFile = classFileWithSource;
            this.source = this.classFile.getSource();
        }

        public InputStream getContents() throws CoreException {
            if (!this.hasSource()) {
                return null;
            }
            return new ByteArrayInputStream(this.source.getBytes());
        }

        public boolean hasSource() {
            return this.source != null;
        }

        public IPath getFullPath() {
            IPackageFragment pkg = (IPackageFragment)this.classFile.getParent();
            IPackageFragmentRoot jar = (IPackageFragmentRoot)pkg.getParent();
            String pkgName = pkg.getElementName();
            IPath jarPath = jar.getPath();
            IPath filePath = jarPath.append(pkgName).append(this.getName());
            return filePath;
        }

        public String getName() {
            return this.classFile.getElementName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return this.classFile.getAdapter(adapter);
        }
    }
}

