/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.ResourceCollector;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.indexing.StorageIndexer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class WorkspaceIndexer
extends StorageIndexer
implements ISchedulingRule,
IPropertyChangeListener {
    private IContentType TEXT_CONTENT_TYPE;
    private static final ResourceCollector resourceCollector = new ResourceCollector();
    private String[] fileExtensions = WorkspaceIndexer.getIndexableFileExtensions();
    private List<Pattern> excludedDirRegExes = WorkspaceIndexer.getExcludedDirsRegExes();
    private boolean indexEmptyExtension = InstaSearchPlugin.getBoolPref("indexEmptyExtension");

    public WorkspaceIndexer() throws Exception {
        if (Platform.getContentTypeManager() != null) {
            this.TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        }
    }

    @Override
    public Directory getIndexDir() throws IOException {
        return FSDirectory.open((File)this.getIndexDirLocation());
    }

    public void createIndex(IWorkspaceRoot root, IProgressMonitor monitor) throws Exception {
        this.getIndexChangeListener().onIndexReset();
        this.deleteIndex();
        FSDirectory indexDirectory = FSDirectory.open((File)this.getIndexDirLocation());
        IndexWriter indexWriter = this.createIndexWriter(true);
        this.indexContainers(indexWriter, root, monitor);
        monitor.setTaskName("Optimizing Index");
        indexWriter.optimize();
        indexWriter.close();
        indexDirectory.close();
        this.getIndexChangeListener().onIndexUpdate();
        monitor.done();
    }

    protected void indexContainers(IndexWriter indexWriter, IWorkspaceRoot workspaceRoot, IProgressMonitor monitor) throws Exception {
        resourceCollector.clear();
        resourceCollector.setExcludedDirRegExes(this.excludedDirRegExes);
        workspaceRoot.accept((IResourceVisitor)resourceCollector);
        monitor.beginTask("File Indexing", resourceCollector.getContainers().size());
        for (IContainer container : resourceCollector.getContainers()) {
            if (monitor.isCanceled()) break;
            monitor.setTaskName("Indexing: " + container.getProject().getName() + " - " + container.getName());
            this.indexContainer(indexWriter, container, monitor);
            monitor.worked(1);
        }
        monitor.done();
    }

    private File getIndexDirLocation() {
        File location = InstaSearchPlugin.getIndexDirLocation();
        if (!location.exists()) {
            location.mkdirs();
        }
        return location;
    }

    @Override
    public boolean isIndexed() throws IOException {
        return IndexReader.indexExists((Directory)this.getIndexDir()) && super.isIndexed();
    }

    private static List<Pattern> getExcludedDirsRegExes() {
        String[] excludedDirArr;
        String excludeDirList = InstaSearchPlugin.getDefault().getPreferenceStore().getString("excludedFolders");
        if (excludeDirList == null || "".equals(excludeDirList)) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> excludeDirSet = new ArrayList<Pattern>();
        String[] stringArray = excludedDirArr = excludeDirList.split(File.pathSeparator);
        int n = excludedDirArr.length;
        int n2 = 0;
        while (n2 < n) {
            String wildCardPattern = stringArray[n2];
            Pattern pattern = null;
            if (wildCardPattern.startsWith("/")) {
                wildCardPattern = wildCardPattern.substring(1);
            }
            try {
                pattern = WorkspaceIndexer.wildcardToRegex(wildCardPattern);
                excludeDirSet.add(pattern);
            }
            catch (Throwable t) {
                InstaSearchPlugin.debug(t);
            }
            ++n2;
        }
        return excludeDirSet;
    }

    private static String[] getIndexableFileExtensions() {
        String extensionList = InstaSearchPlugin.getDefault().getPreferenceStore().getString("indexableExtensions");
        if (extensionList == null || "".equals(extensionList) || "*".equals(extensionList)) {
            return null;
        }
        Object[] extensions = (extensionList = extensionList.replace(" ", "")).split("[,|;:]");
        if (extensions.length == 0) {
            return null;
        }
        int i = 0;
        while (i < extensions.length) {
            String ext = ((String)extensions[i]).toLowerCase(Locale.ENGLISH).trim();
            if (ext.startsWith("*")) {
                ext = ext.substring(1);
            }
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            extensions[i] = ext;
            ++i;
        }
        Arrays.sort(extensions);
        return extensions;
    }

    public boolean isIndexable(IFile file) throws CoreException {
        String ext = file.getFileExtension();
        return this.isIndexableExtension(ext) || this.isTextFile(file);
    }

    public boolean isIndexableExtension(String ext) {
        if (this.fileExtensions == null || this.fileExtensions.length == 0) {
            return true;
        }
        if (ext == null || "".equals(ext)) {
            return this.indexEmptyExtension;
        }
        return Arrays.binarySearch(this.fileExtensions, ext.toLowerCase(Locale.ENGLISH)) >= 0;
    }

    private void indexFile(IndexWriter indexWriter, IFile file) throws Exception {
        if (!file.isAccessible()) {
            return;
        }
        if (file.isDerived(512)) {
            return;
        }
        if (!file.isSynchronized(0)) {
            return;
        }
        if (file.getRawLocation() == null) {
            return;
        }
        File f = file.getRawLocation().toFile();
        if (f == null || !f.canRead()) {
            return;
        }
        this.indexStorageWithRetry(indexWriter, (IStorage)file, file.getProject().getName(), file.getLocalTimeStamp(), null);
    }

    public void updateFile(IFile file) throws Exception {
        if (!this.isIndexed()) {
            return;
        }
        this.deleteStorage((IStorage)file);
        if (!this.isIndexable(file)) {
            return;
        }
        if (file.isAccessible() && !file.isDerived(512)) {
            IndexWriter w = this.createIndexWriter(false);
            this.indexFile(w, file);
            w.close();
        }
    }

    public void updateFolder(IFolder folder, IProgressMonitor monitor) throws Exception {
        if (!this.isIndexed()) {
            return;
        }
        IndexReader reader = IndexReader.open((Directory)this.getIndexDir(), (boolean)false);
        this.deleteFolder(reader, (IContainer)folder);
        reader.close();
        if (!folder.isAccessible()) {
            return;
        }
        resourceCollector.clear();
        resourceCollector.setExcludedDirRegExes(this.excludedDirRegExes);
        folder.accept((IResourceVisitor)resourceCollector);
        IndexWriter w = this.createIndexWriter(false);
        for (IContainer container : resourceCollector.getContainers()) {
            if (this.isExcluded(container)) continue;
            this.indexContainer(w, container, monitor);
        }
        w.close();
    }

    private boolean isExcluded(IContainer container) {
        if (container == null || this.excludedDirRegExes == null || this.excludedDirRegExes.isEmpty()) {
            return false;
        }
        return ResourceCollector.isResourceExcluded((IResource)container, this.excludedDirRegExes) || this.isExcluded(container.getParent());
    }

    public void updateProject(IProject project, IProgressMonitor monitor) throws Exception {
        if (!this.isIndexed()) {
            return;
        }
        this.deleteProject(project);
        if (project.exists() && project.isAccessible() && project.isOpen()) {
            IndexWriter w = this.createIndexWriter(false);
            resourceCollector.clear();
            resourceCollector.setExcludedDirRegExes(this.excludedDirRegExes);
            project.accept((IResourceVisitor)resourceCollector);
            for (IContainer container : resourceCollector.getContainers()) {
                this.indexContainer(w, container, monitor);
            }
            w.close();
        }
    }

    private void indexContainer(IndexWriter w, IContainer container, IProgressMonitor monitor) throws Exception {
        IResource[] members;
        if (!container.isAccessible() || container.isDerived(512)) {
            return;
        }
        IResource[] iResourceArray = members = container.members(false);
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IResource member = iResourceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (member.getType() == 1 && member.isAccessible() && !member.isDerived() && this.isIndexable(file = (IFile)member)) {
                this.indexFile(w, file);
            }
            ++n2;
        }
    }

    private boolean isTextFile(IFile file) throws CoreException {
        if (!file.isSynchronized(0)) {
            return false;
        }
        IContentType contentType = IDE.getContentType((IFile)file);
        if (contentType == null) {
            contentType = IDE.guessContentType((IFile)file);
        }
        if (contentType == null) {
            return false;
        }
        return this.TEXT_CONTENT_TYPE != null && contentType.isKindOf(this.TEXT_CONTENT_TYPE);
    }

    private void deleteFolder(IndexReader reader, IContainer container) throws Exception {
        IndexSearcher searcher = new IndexSearcher(reader);
        String path = container.getFullPath().addTrailingSeparator().toString();
        TopDocs topDocs = searcher.search((Query)new PrefixQuery(Field.FILE.createTerm(path)), reader.numDocs());
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n = topDocs.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc doc = scoreDocArray[n2];
            int docNum = doc.doc;
            reader.deleteDocument(docNum);
            ++n2;
        }
        searcher.close();
    }

    public int deleteProject(IProject project) throws Exception {
        IndexReader reader = IndexReader.open((Directory)this.getIndexDir(), (boolean)false);
        String filePath = project.getFullPath().toString();
        Term term = Field.PROJ.createTerm(filePath);
        int deletedCount = reader.deleteDocuments(term);
        reader.close();
        return deletedCount;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public IEditorInput getEditorInput(SearchResultDoc doc) throws Exception {
        return new FileEditorInput(doc.getFile());
    }

    public IStorage getStorage(SearchResultDoc doc) throws Exception {
        return doc.getFile();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ("indexableExtensions".equals(prop)) {
            this.fileExtensions = WorkspaceIndexer.getIndexableFileExtensions();
        } else if ("excludedFolders".equals(prop)) {
            this.excludedDirRegExes = WorkspaceIndexer.getExcludedDirsRegExes();
        } else if ("indexEmptyExtension".equals(prop)) {
            this.indexEmptyExtension = InstaSearchPlugin.getBoolPref("indexEmptyExtension");
        }
    }

    public static Pattern wildcardToRegex(String pathWildcardPattern) {
        String regex = pathWildcardPattern;
        regex = regex.replaceAll("\\*\\*", "<double-star>");
        regex = regex.replaceAll("\\.", "\\.");
        regex = regex.replaceAll("\\*", "[^/]*");
        regex = regex.replaceAll("\\?", ".");
        regex = regex.replaceAll("<double-star>", ".*");
        Pattern pattern = Pattern.compile(regex);
        return pattern;
    }
}

