/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.FileAnalyzer;
import it.unibz.instasearch.indexing.LengthNormSimilarity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;

public class StorageIndexer {
    private static final int MAX_TERMS_PER_DOC = 200000;
    public static final String NO_VALUE = "<none>";
    public static final int MIN_WORD_LENGTH = 1;
    protected static final FileAnalyzer fileAnalyzer = new FileAnalyzer(1);
    private IndexChangeListener changeListener = new NullIndexChangeListener();
    private static final Similarity similarity = new LengthNormSimilarity();
    private static final int MAX_RETRY_ATTEMPTS = 10;
    private Directory indexDir;

    public StorageIndexer() throws IOException {
        this.checkLock();
    }

    private void checkLock() throws IOException {
        Directory indexDir = this.getIndexDir();
        if (IndexWriter.isLocked((Directory)indexDir)) {
            IndexWriter.unlock((Directory)indexDir);
        }
    }

    public Directory getIndexDir() throws IOException {
        if (this.indexDir == null) {
            this.indexDir = new RAMDirectory();
        }
        return this.indexDir;
    }

    public IndexWriter createIndexWriter(boolean create) throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.getIndexDir(), (Analyzer)fileAnalyzer, create, IndexWriter.MaxFieldLength.UNLIMITED);
        indexWriter.setMergeFactor(2);
        indexWriter.setSimilarity(similarity);
        indexWriter.setMaxFieldLength(200000);
        return indexWriter;
    }

    public boolean isIndexed() throws IOException {
        return IndexReader.indexExists((Directory)this.getIndexDir());
    }

    public boolean isReadable() {
        try {
            IndexReader reader = IndexReader.open((Directory)this.getIndexDir(), (boolean)true);
            reader.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void deleteIndex() throws Exception {
        RetryingRunnable runnable = new RetryingRunnable(){

            @Override
            public void run() throws Exception {
                IndexWriter w = StorageIndexer.this.createIndexWriter(true);
                w.deleteAll();
                w.commit();
                w.close(true);
                Directory dir = StorageIndexer.this.getIndexDir();
                String[] stringArray = dir.listAll();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    if (dir.fileExists(file)) {
                        dir.sync(file);
                        dir.deleteFile(file);
                    }
                    ++n2;
                }
                dir.close();
            }

            @Override
            public boolean handleException(Throwable e) {
                return true;
            }
        };
        this.changeListener.onIndexReset();
        StorageIndexer.runRetryingRunnable(runnable);
    }

    public void optimizeIndex() throws Exception {
        if (!this.isIndexed()) {
            return;
        }
        IndexWriter w = this.createIndexWriter(false);
        w.optimize();
        w.close();
        this.changeListener.onIndexUpdate();
    }

    public void setIndexChangeListener(IndexChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    protected IndexChangeListener getIndexChangeListener() {
        return this.changeListener;
    }

    public void indexStorage(IndexWriter indexWriter, IStorage storage, String projectName, long modificationStamp, String jar) throws IOException {
        InputStream contents;
        try {
            contents = storage.getContents();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        BufferedReader isReader = new BufferedReader(new InputStreamReader(contents));
        IPath fullPath = storage.getFullPath();
        String ext = fullPath.getFileExtension();
        if (ext == null) {
            ext = NO_VALUE;
        }
        Document doc = new Document();
        doc.add((Fieldable)StorageIndexer.createLuceneField(Field.CONTENTS, isReader));
        doc.add((Fieldable)StorageIndexer.createLuceneField(Field.FILE, fullPath.toString()));
        doc.add((Fieldable)StorageIndexer.createLuceneField(Field.PROJ, projectName));
        doc.add((Fieldable)StorageIndexer.createLuceneField(Field.NAME, fullPath.lastSegment()));
        doc.add((Fieldable)StorageIndexer.createLuceneField(Field.EXT, ext.toLowerCase(Locale.ENGLISH)));
        doc.add((Fieldable)StorageIndexer.createLuceneField(Field.MODIFIED, Long.toString(modificationStamp)));
        doc.add((Fieldable)StorageIndexer.createLuceneField(Field.JAR, jar == null ? NO_VALUE : jar));
        indexWriter.addDocument(doc);
    }

    private static void runRetryingRunnable(RetryingRunnable runnable) throws Exception {
        Throwable lastException = null;
        int i = 1;
        while (i <= 10) {
            try {
                runnable.run();
                lastException = null;
                break;
            }
            catch (Throwable e) {
                lastException = e;
                if (!runnable.handleException(e)) break;
                try {
                    Thread.sleep(i * 1000);
                }
                catch (Exception exception) {
                    break;
                }
                ++i;
            }
        }
        if (lastException != null) {
            if (lastException instanceof Exception) {
                throw (Exception)lastException;
            }
            throw new Exception(lastException);
        }
    }

    protected void indexStorageWithRetry(final IndexWriter indexWriter, final IStorage storage, final String projectName, final long modificationStamp, final String jar) throws Exception {
        RetryingRunnable runnable = new RetryingRunnable(){

            @Override
            public void run() throws Exception {
                StorageIndexer.this.indexStorage(indexWriter, storage, projectName, modificationStamp, jar);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean handleException(Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    if (indexWriter.getMaxFieldLength() <= 10000) return false;
                    indexWriter.setMaxFieldLength(10000);
                    return true;
                } else {
                    if (!(e instanceof IOException)) return true;
                    StorageIndexer.this.changeListener.onIndexReset();
                }
                return true;
            }
        };
        StorageIndexer.runRetryingRunnable(runnable);
    }

    public void deleteStorage(IStorage storage) throws Exception {
        IndexReader reader = IndexReader.open((Directory)this.getIndexDir(), (boolean)false);
        String filePath = storage.getFullPath().toString();
        Term term = Field.FILE.createTerm(filePath);
        reader.deleteDocuments(term);
        reader.close();
    }

    private static org.apache.lucene.document.Field createLuceneField(Field fieldName, String value) {
        return new org.apache.lucene.document.Field(fieldName.toString(), value, Field.Store.YES, Field.Index.NOT_ANALYZED);
    }

    private static org.apache.lucene.document.Field createLuceneField(Field fieldName, Reader reader) {
        return new org.apache.lucene.document.Field(fieldName.toString(), reader, Field.TermVector.YES);
    }

    public static Map<String, List<Integer>> extractTextTerms(String text) throws IOException {
        HashMap<String, List<Integer>> terms = new HashMap<String, List<Integer>>();
        TokenStream tokenStream = fileAnalyzer.tokenStream(Field.CONTENTS.toString(), new StringReader(text));
        TermAttribute termAtt = (TermAttribute)tokenStream.addAttribute(TermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
        while (tokenStream.incrementToken()) {
            String termText = termAtt.term().toLowerCase(Locale.ENGLISH);
            int offset = offsetAtt.startOffset();
            LinkedList<Integer> offsets = (LinkedList<Integer>)terms.get(termText);
            if (offsets == null) {
                offsets = new LinkedList<Integer>();
                terms.put(termText, offsets);
            }
            offsets.add(offset);
        }
        tokenStream.close();
        return terms;
    }

    public static interface IndexChangeListener {
        public void onIndexUpdate();

        public void onIndexReset();
    }

    private static class NullIndexChangeListener
    implements IndexChangeListener {
        private NullIndexChangeListener() {
        }

        @Override
        public void onIndexUpdate() {
        }

        @Override
        public void onIndexReset() {
        }
    }

    public static interface RetryingRunnable {
        public void run() throws Exception;

        public boolean handleException(Throwable var1);
    }
}

