/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.LengthNormSimilarity;
import it.unibz.instasearch.indexing.QueryAnalyzer;
import it.unibz.instasearch.indexing.SearchQuery;
import it.unibz.instasearch.indexing.SearchResult;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.indexing.StorageIndexer;
import it.unibz.instasearch.indexing.querying.CSVExpander;
import it.unibz.instasearch.indexing.querying.CurrentProjectSetter;
import it.unibz.instasearch.indexing.querying.FieldAliasConverter;
import it.unibz.instasearch.indexing.querying.FileNameSearcher;
import it.unibz.instasearch.indexing.querying.FilterSetter;
import it.unibz.instasearch.indexing.querying.FolderSearcher;
import it.unibz.instasearch.indexing.querying.LastTermQueryPrefixer;
import it.unibz.instasearch.indexing.querying.LowercaseConverter;
import it.unibz.instasearch.indexing.querying.ModifiedTimeConverter;
import it.unibz.instasearch.indexing.querying.QueryFuzzifier;
import it.unibz.instasearch.indexing.querying.UppercaseNameExpander;
import it.unibz.instasearch.indexing.querying.VisitableQuery;
import it.unibz.instasearch.indexing.querying.WorkingSetExpander;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.highlight.QueryTermExtractor;
import org.apache.lucene.search.highlight.WeightedTerm;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Searcher
implements IPropertyChangeListener,
StorageIndexer.IndexChangeListener {
    private static final int DEFAULT_PHRASE_SLOP = 0;
    public static final int MIN_QUERY_LENGTH = 2;
    public static final int MIN_WORD_LENGTH = 1;
    public static final String CURRENT_PROJECT_CHAR = ".";
    private static final Version LUCENE_VERSION = Version.LUCENE_29;
    private IndexSearcher indexSearcher;
    public static final LengthNormSimilarity SIMILARITY = new LengthNormSimilarity();
    private static final QueryAnalyzer queryAnalyzer = new QueryAnalyzer(1);
    private CSVExpander csvExpander = new CSVExpander();
    private WorkingSetExpander workingSetExpander = new WorkingSetExpander();
    private UppercaseNameExpander uppercaseNameExpander = new UppercaseNameExpander();
    private FieldAliasConverter fieldAliasConverter = new FieldAliasConverter();
    private ModifiedTimeConverter modifiedTimeConverter = new ModifiedTimeConverter();
    private LowercaseConverter lowercaseConverter = new LowercaseConverter();
    private FolderSearcher folderSearcher = new FolderSearcher();
    private FileNameSearcher fileNameSearcher = new FileNameSearcher();
    private CurrentProjectSetter currentProjectSetter = new CurrentProjectSetter();
    private QueryFuzzifier queryFuzzifier = new QueryFuzzifier();
    private LastTermQueryPrefixer lastTermQueryPrefixer = new LastTermQueryPrefixer(3);
    private FilterSetter filterSetter = new FilterSetter();
    private boolean showMatchCounts = true;
    private boolean fuzzySearchAuto = true;
    private SearcherConfig config;

    public Searcher(SearcherConfig config) {
        this.config = config;
        this.initPrefs();
    }

    protected Directory getIndexDir() throws IOException {
        return this.config.getIndexDir();
    }

    private SearchResult searchIndex(SearchQuery searchQuery) throws Exception {
        IndexSearcher indexSearcher = this.getIndexSearcher();
        IndexReader reader = indexSearcher.getIndexReader();
        boolean exact = searchQuery.isExact();
        Query query = null;
        try {
            query = this.parseSearchQuery(searchQuery, reader, exact, true);
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            query = this.parseSearchQuery(searchQuery, reader, exact, false);
        }
        catch (ParseException parseException) {
            String newSearchString = searchQuery.getSearchString().replaceAll("[\\(\\)\"\\[\\]'\\{\\}]", " ");
            try {
                searchQuery.setSearchString(newSearchString);
                query = this.parseSearchQuery(searchQuery, reader, exact, true);
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
        SearchResult searchResut = this.collectSearchResults(searchQuery, indexSearcher, reader, query);
        return searchResut;
    }

    private SearchResult collectSearchResults(SearchQuery searchQuery, IndexSearcher indexSearcher, IndexReader reader, Query query) throws IOException {
        int maxResults = reader.numDocs();
        if (searchQuery.isLimited()) {
            maxResults = searchQuery.getMaxResults();
        }
        Map<String, Float> searchTerms = Searcher.extractTerms(query);
        TopDocCollector collector = new TopDocCollector(maxResults);
        if (searchQuery.isCanceled()) {
            return null;
        }
        indexSearcher.search(query, (HitCollector)collector);
        if (collector.getTotalHits() == 0) {
            return null;
        }
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        ArrayList<SearchResultDoc> resultDocs = new ArrayList<SearchResultDoc>(hits.length);
        int i = 0;
        while (i < hits.length && !searchQuery.isCanceled()) {
            int docId = hits[i].doc;
            float score = hits[i].score;
            Document doc = reader.document(docId);
            SearchResultDoc resultDoc = new SearchResultDoc(this.getIndexDir(), doc, docId, score);
            if (this.showMatchCounts) {
                resultDoc.computeMatchCount(reader, searchTerms.keySet());
            }
            resultDocs.add(resultDoc);
            ++i;
        }
        return new SearchResult(searchQuery, resultDocs, searchTerms);
    }

    public SearchResult search(SearchQuery searchQuery) throws Exception {
        String searchString = searchQuery.getSearchString();
        if (searchString == null || searchString.length() < 2) {
            return null;
        }
        SearchResult result = null;
        if (searchQuery.isFuzzy()) {
            searchQuery.setExact(false);
            result = this.searchIndex(searchQuery);
        } else {
            if (searchQuery.isExact()) {
                result = this.searchIndex(searchQuery);
            }
            if ((result == null || result.isEmpty()) && !searchQuery.isCanceled()) {
                searchQuery.setExact(false);
                result = this.searchIndex(searchQuery);
            }
            if ((result == null || result.isEmpty()) && this.fuzzySearchAuto && !searchQuery.isCanceled()) {
                searchQuery.setFuzzy(true);
                searchQuery.setExact(false);
                result = this.searchIndex(searchQuery);
            }
        }
        return result;
    }

    private IndexSearcher getIndexSearcher() throws IOException {
        if (this.indexSearcher == null) {
            this.indexSearcher = new IndexSearcher(this.getIndexDir(), true);
            this.indexSearcher.setSimilarity((Similarity)SIMILARITY);
        }
        return this.indexSearcher;
    }

    public List<String> getProposals(String prefixText, Field prefixField) throws IOException {
        ArrayList<String> proposals = new ArrayList<String>();
        IndexReader reader = this.getIndexSearcher().getIndexReader();
        Term prefix = prefixField.createTerm(prefixText);
        TermEnum enumerator = reader.terms(prefix);
        prefixText = prefixText.toLowerCase(Locale.ENGLISH);
        try {
            Term term;
            while ((term = enumerator.term()) != null && term.text().toLowerCase(Locale.ENGLISH).startsWith(prefixText) && term.field().equalsIgnoreCase(prefixField.toString())) {
                proposals.add(term.text());
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
        }
        return proposals;
    }

    public List<String> getIndexProjects() throws IOException {
        return this.getProposals("", Field.PROJ);
    }

    @Override
    public void onIndexReset() {
        this.resetSearcher();
    }

    private void resetSearcher() {
        if (this.indexSearcher != null) {
            try {
                try {
                    this.indexSearcher.close();
                }
                catch (IOException e) {
                    this.config.log(e);
                    this.indexSearcher = null;
                }
            }
            finally {
                this.indexSearcher = null;
            }
        }
    }

    private void warmup() throws Exception {
        this.search(new SearchQuery("<warmup search>", 1));
    }

    @Override
    public void onIndexUpdate() {
        this.resetSearcher();
        try {
            this.warmup();
        }
        catch (Exception e) {
            this.config.log(e);
        }
    }

    private Query parseSearchQuery(SearchQuery searchQuery, IndexReader reader, boolean exact, boolean prefix) throws ParseException, IOException {
        Query returnQuery;
        String searchString = searchQuery.getSearchString();
        BooleanQuery.setMaxClauseCount((int)5000);
        Query exactQuery = this.createExactQuery(searchQuery);
        if (exact) {
            returnQuery = exactQuery;
        } else {
            Query query = this.parserSearchString(searchString, queryAnalyzer);
            exactQuery.setBoost(query.getBoost() * 2.0f);
            returnQuery = this.combineQueries(query, exactQuery);
        }
        returnQuery = this.rewriteQuery(searchQuery, prefix, returnQuery);
        returnQuery = returnQuery.rewrite(reader);
        return returnQuery;
    }

    private Query createExactQuery(SearchQuery searchQuery) throws ParseException {
        Query query = null;
        String searchString = searchQuery.getSearchString();
        if (searchString.contains(" ")) {
            query = this.parserSearchString(searchString, (Analyzer)new StandardAnalyzer(LUCENE_VERSION));
            query = Searcher.convertToPhraseQuery(query);
        } else {
            query = this.parserSearchString(searchString, (Analyzer)new KeywordAnalyzer());
        }
        VisitableQuery visitableQuery = new VisitableQuery(query);
        visitableQuery.accept(this.uppercaseNameExpander);
        visitableQuery.accept(this.fileNameSearcher);
        query = visitableQuery.getQuery();
        return query;
    }

    private static Query convertToPhraseQuery(Query query) {
        PhraseQuery phraseQuery = new PhraseQuery();
        LinkedHashSet terms = new LinkedHashSet();
        try {
            query.extractTerms(terms);
            for (Term term : terms) {
                Field field = Field.fromTerm(term);
                if (Field.CONTENTS == field) {
                    phraseQuery.add(term);
                    continue;
                }
                return query;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return query;
        }
        return phraseQuery;
    }

    private Query rewriteQuery(SearchQuery searchQuery, boolean prefix, Query query) {
        VisitableQuery visitableQuery = new VisitableQuery(query);
        visitableQuery.accept(this.uppercaseNameExpander);
        visitableQuery.accept(this.lowercaseConverter);
        if (searchQuery.isFuzzy()) {
            visitableQuery.accept(this.queryFuzzifier);
        }
        visitableQuery.accept(this.csvExpander);
        visitableQuery.accept(this.fieldAliasConverter);
        visitableQuery.accept(this.modifiedTimeConverter);
        visitableQuery.accept(this.folderSearcher);
        if (prefix && !searchQuery.isFuzzy()) {
            visitableQuery.accept(this.lastTermQueryPrefixer);
        }
        if (searchQuery.getFilter() != null) {
            this.filterSetter.setFilter(searchQuery.getFilter());
            visitableQuery.accept(this.filterSetter);
        }
        visitableQuery.accept(this.workingSetExpander);
        if (searchQuery.getCurrentProject() != null) {
            this.currentProjectSetter.setCurrentProject(searchQuery.getCurrentProject());
            visitableQuery.accept(this.currentProjectSetter);
        }
        return visitableQuery.getQuery();
    }

    private BooleanQuery combineQueries(Query query, Query exactQuery) {
        BooleanQuery topQuery = new BooleanQuery();
        topQuery.add(exactQuery, BooleanClause.Occur.SHOULD);
        topQuery.add(query, BooleanClause.Occur.SHOULD);
        return topQuery;
    }

    private Query parserSearchString(String searchString, Analyzer analyzer) throws ParseException {
        QueryParser queryParser = new QueryParser(LUCENE_VERSION, Field.CONTENTS.toString(), analyzer);
        queryParser.setDefaultOperator(QueryParser.Operator.AND);
        queryParser.setLowercaseExpandedTerms(false);
        queryParser.setPhraseSlop(0);
        queryParser.setAllowLeadingWildcard(true);
        Query parsedQuery = queryParser.parse(searchString);
        return parsedQuery;
    }

    private static Map<String, Float> extractTerms(Query query) {
        WeightedTerm[] weightedTerms = QueryTermExtractor.getTerms((Query)query, (boolean)false, (String)Field.CONTENTS.toString());
        HashMap<String, Float> terms = new HashMap<String, Float>(weightedTerms.length);
        WeightedTerm[] weightedTermArray = weightedTerms;
        int n = weightedTerms.length;
        int n2 = 0;
        while (n2 < n) {
            WeightedTerm weightedTerm = weightedTermArray[n2];
            terms.put(weightedTerm.getTerm(), Float.valueOf(weightedTerm.getWeight()));
            ++n2;
        }
        return terms;
    }

    protected void initPrefs() {
        this.fuzzySearchAuto = this.config.getBoolPref("fuzzySearchAuto");
        this.showMatchCounts = this.config.getBoolPref("showMatchCounts");
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ("showMatchCounts".equals(prop)) {
            this.showMatchCounts = this.config.getBoolPref("showMatchCounts");
        } else if ("fuzzySearchAuto".equals(prop)) {
            this.fuzzySearchAuto = this.config.getBoolPref("fuzzySearchAuto");
        }
    }

    public static interface SearcherConfig {
        public boolean getBoolPref(String var1);

        public void log(Exception var1);

        public Directory getIndexDir() throws IOException;
    }
}

